/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.world.biome;

import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.api.biome.EnumBiomeType;
import ru.liahim.mist.api.biome.MistBiomes;
import ru.liahim.mist.api.block.IWettable;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.block.MistClay;
import ru.liahim.mist.block.MistDirt;
import ru.liahim.mist.block.MistTreeTrunk;
import ru.liahim.mist.block.upperplant.MistMushroom;
import ru.liahim.mist.block.upperplant.MistMycelium;
import ru.liahim.mist.entity.EntityHulter;
import ru.liahim.mist.entity.EntityMomo;
import ru.liahim.mist.entity.EntitySniff;
import ru.liahim.mist.entity.EntityWoodlouse;
import ru.liahim.mist.world.MistWorld;
import ru.liahim.mist.world.biome.BiomeMistUp;

public class BiomeMistUpJungle
extends BiomeMistUp {
    protected final int mistTropicTreePerChunk;
    private IBlockState redSand = MistBlocks.SAND.func_176223_P().func_177226_a((IProperty)BlockSand.field_176504_a, (Comparable)BlockSand.EnumType.RED_SAND).func_177226_a((IProperty)IWettable.WET, (Comparable)Boolean.valueOf(true));

    public BiomeMistUpJungle(Biome.BiomeProperties properties, int treePerChunk) {
        super(properties);
        this.field_76752_A = MistBlocks.GRASS_T.func_176223_P().func_177226_a((IProperty)MistDirt.HUMUS, (Comparable)Integer.valueOf(2));
        this.secondTopBlock = MistBlocks.DIRT_T.func_176223_P().func_177226_a((IProperty)MistDirt.HUMUS, (Comparable)Integer.valueOf(1));
        this.field_76753_B = MistBlocks.DIRT_T.func_176223_P().func_177226_a((IProperty)MistDirt.HUMUS, (Comparable)Integer.valueOf(0));
        this.mistTropicTreePerChunk = treePerChunk;
        this.getMistBiomeDecorator().field_76803_B = 5;
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityMomo.class, 25, 2, 5));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntitySniff.class, 10, 1, 2));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityHulter.class, 5, 1, 3));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityWoodlouse.class, 20, 2, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntitySkeleton.class, 5, 0, 1));
    }

    @Override
    public float func_76741_f() {
        return 0.03f;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180627_b(BlockPos pos) {
        double d0 = field_180281_af.func_151601_a((double)pos.func_177958_n() * 0.2, (double)pos.func_177952_p() * 0.2);
        return d0 < -0.1 ? 6793287 : 5148476;
    }

    @Override
    public EnumBiomeType getBiomeType() {
        return EnumBiomeType.Jungle;
    }

    public void func_180624_a(World world, Random rand, BlockPos pos) {
        BlockPos randPos;
        int i;
        if (rand.nextFloat() < 0.02f) {
            int rx = rand.nextInt(16) + 8;
            int rz = rand.nextInt(16) + 8;
            BlockPos randPos2 = world.func_175645_m(pos.func_177982_a(rx, 0, rz));
            if (rand.nextFloat() < 0.01f) {
                ((MistTreeTrunk)MistBlocks.R_TREE_TRUNK).generateTrunk(world, randPos2, rand);
            } else {
                ((MistTreeTrunk)MistBlocks.T_TREE_TRUNK).generateTrunk(world, randPos2, rand);
            }
        }
        super.func_180624_a(world, rand, pos);
        if (this == MistBiomes.upJungle && TREE_NOISE.func_151601_a((double)pos.func_177958_n() * 0.005, (double)pos.func_177952_p() * 0.005) > 0.7) {
            int k = rand.nextInt(rand.nextInt(4) + 1) + 1;
            for (i = 0; i < k; ++i) {
                int rx = rand.nextInt(16) - 8;
                int rz = rand.nextInt(16) - 8;
                randPos = world.func_175645_m(pos.func_177982_a(rx, 0, rz));
                ((MistTreeTrunk)MistBlocks.R_TREE_TRUNK).generateTree(world, randPos, rand);
            }
            if (rand.nextFloat() < 0.02f) {
                int rx = rand.nextInt(16) + 8;
                int rz = rand.nextInt(16) + 8;
                BlockPos randPos3 = world.func_175645_m(pos.func_177982_a(rx, 0, rz));
                ((MistTreeTrunk)MistBlocks.R_TREE_TRUNK).generateTrunk(world, randPos3, rand);
            }
        }
        int j = this.mistTropicTreePerChunk;
        if (rand.nextFloat() < this.getMistBiomeDecorator().field_189870_A) {
            ++j;
        }
        for (i = 0; i < j; ++i) {
            int rx = rand.nextInt(16);
            int rz = rand.nextInt(16);
            randPos = world.func_175645_m(pos.func_177982_a(rx, 0, rz));
            if (rand.nextFloat() < 0.01f) {
                ((MistTreeTrunk)MistBlocks.R_TREE_TRUNK).generateTree(world, randPos, rand);
                continue;
            }
            ((MistTreeTrunk)MistBlocks.T_TREE_TRUNK).generateTree(world, randPos, rand);
        }
        if (this.mistTropicTreePerChunk > 0) {
            if (this == MistBiomes.upJungleEdge) {
                if (rand.nextInt(8) == 0) {
                    i = rand.nextInt(8);
                    if (i < 6) {
                        MistMycelium.generateMycelium(world, pos, MistBlocks.MUSHROOMS_1.func_176223_P().func_177226_a(MistMushroom.TYPE_1, (Comparable)((Object)MistMushroom.MushroomType_1.CUP)), rand);
                    } else if (i < 7) {
                        MistMycelium.generateMycelium(world, pos, MistBlocks.MUSHROOMS_1.func_176223_P().func_177226_a(MistMushroom.TYPE_1, (Comparable)((Object)MistMushroom.MushroomType_1.SILVER)), rand);
                    }
                }
                if (rand.nextInt(16) == 0) {
                    i = rand.nextInt(6);
                    if (i < 5) {
                        MistMycelium.generateMycelium(world, pos, MistBlocks.MUSHROOMS_0.func_176223_P().func_177226_a(MistMushroom.TYPE_0, (Comparable)((Object)MistMushroom.MushroomType_0.CORAL)), rand);
                    } else {
                        MistMycelium.generateMycelium(world, pos, MistBlocks.MUSHROOMS_0.func_176223_P().func_177226_a(MistMushroom.TYPE_0, (Comparable)((Object)MistMushroom.MushroomType_0.PURPLE)), rand);
                    }
                }
            } else {
                if (rand.nextInt(16) == 0) {
                    i = rand.nextInt(8);
                    if (i < 3) {
                        MistMycelium.generateMycelium(world, pos, MistBlocks.MUSHROOMS_1.func_176223_P().func_177226_a(MistMushroom.TYPE_1, (Comparable)((Object)MistMushroom.MushroomType_1.AZURE)), rand);
                    } else if (i < 5) {
                        MistMycelium.generateMycelium(world, pos, MistBlocks.MUSHROOMS_1.func_176223_P().func_177226_a(MistMushroom.TYPE_1, (Comparable)((Object)MistMushroom.MushroomType_1.SILVER)), rand);
                    } else if (i < 7) {
                        MistMycelium.generateMycelium(world, pos, MistBlocks.MUSHROOMS_1.func_176223_P().func_177226_a(MistMushroom.TYPE_1, (Comparable)((Object)MistMushroom.MushroomType_1.CUP)), rand);
                    } else {
                        MistMycelium.generateMycelium(world, pos, MistBlocks.MUSHROOMS_1.func_176223_P().func_177226_a(MistMushroom.TYPE_1, (Comparable)((Object)MistMushroom.MushroomType_1.GOLD)), rand, 130);
                    }
                }
                if (rand.nextInt(24) == 0) {
                    i = rand.nextInt(8);
                    if (i < 4) {
                        MistMycelium.generateMycelium(world, pos, MistBlocks.MUSHROOMS_0.func_176223_P().func_177226_a(MistMushroom.TYPE_0, (Comparable)((Object)MistMushroom.MushroomType_0.BLUE)), rand);
                    } else if (i < 7) {
                        MistMycelium.generateMycelium(world, pos, MistBlocks.MUSHROOMS_0.func_176223_P().func_177226_a(MistMushroom.TYPE_0, (Comparable)((Object)MistMushroom.MushroomType_0.CORAL)), rand);
                    } else {
                        MistMycelium.generateMycelium(world, pos, MistBlocks.MUSHROOMS_0.func_176223_P().func_177226_a(MistMushroom.TYPE_0, (Comparable)((Object)MistMushroom.MushroomType_0.PURPLE)), rand);
                    }
                }
            }
        }
    }

    @Override
    @Nullable
    public ArrayList<Double> getNoises(int x, int z) {
        ArrayList<Double> noises = new ArrayList<Double>();
        double sandNoise = SAND_NOISE.func_151601_a((double)x * 0.03, (double)z * 0.03);
        double clayNoise = CLAY_NOISE.func_151601_a((double)x * 0.01, (double)z * 0.01);
        noises.add(sandNoise += SAND_NOISE.func_151601_a((double)x * 0.2, (double)z * 0.2) * 0.2);
        noises.add(clayNoise += CLAY_NOISE.func_151601_a((double)x * 0.3, (double)z * 0.3) * 0.02);
        return noises;
    }

    @Override
    public IBlockState getTopBlock(Random rand, @Nullable ArrayList<Double> noises) {
        if (noises.get(1) > 0.6) {
            return this.field_76752_A;
        }
        return noises.get(0) > 0.5 ? MistBlocks.GRASS_T.func_176223_P().func_177226_a((IProperty)MistDirt.HUMUS, (Comparable)Integer.valueOf(1)) : this.field_76752_A;
    }

    @Override
    public IBlockState getSecondTopBlock(Random rand, @Nullable ArrayList<Double> noises) {
        if (noises.get(1) > 0.6) {
            return this.secondTopBlock;
        }
        double sandNoise = noises.get(0);
        return sandNoise > 0.5 ? this.redSand : (sandNoise > 0.4 ? MistBlocks.DIRT_T.func_176223_P().func_177226_a((IProperty)MistDirt.HUMUS, (Comparable)Integer.valueOf(0)) : this.secondTopBlock);
    }

    @Override
    public IBlockState getFillerBlock(Random rand, @Nullable ArrayList<Double> noises) {
        if (noises.get(1) > 0.6) {
            return MistBlocks.CLAY.func_176223_P().func_177226_a(MistClay.VARIANT, (Comparable)((Object)MistClay.EnumClayType.RED_CLAY));
        }
        return noises.get(0) > 0.4 ? this.redSand : this.field_76753_B;
    }

    @Override
    protected IBlockState getBottom(Random rand, @Nullable ArrayList<Double> noises) {
        if (noises.get(1) > 0.7) {
            return MistBlocks.CLAY.func_176223_P().func_177226_a(MistClay.VARIANT, (Comparable)((Object)MistClay.EnumClayType.RED_CLAY));
        }
        double sandNoise = noises.get(0);
        return sandNoise > 0.5 ? this.redSand : (sandNoise > 0.4 ? MistBlocks.DIRT_T.func_176223_P().func_177226_a((IProperty)MistDirt.HUMUS, (Comparable)Integer.valueOf(0)) : this.secondTopBlock);
    }

    @Override
    protected IBlockState getZeroBlock(Random rand, @Nullable ArrayList<Double> noises) {
        return noises.get(0) < -0.5 ? MistWorld.gravelBlock : null;
    }

    @Override
    public void addDefaultFlowers() {
        this.addFlower(Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)BlockTallGrass.EnumType.FERN), 20);
    }
}

