/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.world.biome;

import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenTallGrass;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.api.biome.EnumBiomeType;
import ru.liahim.mist.api.biome.MistBiomes;
import ru.liahim.mist.api.block.IWettable;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.block.MistDirt;
import ru.liahim.mist.block.MistTreeTrunk;
import ru.liahim.mist.block.upperplant.MistMushroom;
import ru.liahim.mist.block.upperplant.MistMycelium;
import ru.liahim.mist.entity.EntityForestRunner;
import ru.liahim.mist.entity.EntityForestSpider;
import ru.liahim.mist.entity.EntityHorb;
import ru.liahim.mist.entity.EntityMonk;
import ru.liahim.mist.world.MistWorld;
import ru.liahim.mist.world.biome.BiomeMistUp;

public class BiomeMistUpForest
extends BiomeMistUp {
    private IBlockState sand = MistBlocks.SAND.func_176223_P().func_177226_a((IProperty)IWettable.WET, (Comparable)Boolean.valueOf(true));
    public int treePerChunk;

    public BiomeMistUpForest(Biome.BiomeProperties properties, int treePerChunk) {
        super(properties);
        this.field_76752_A = MistBlocks.GRASS_F.func_176223_P().func_177226_a((IProperty)MistDirt.HUMUS, (Comparable)Integer.valueOf(2));
        this.secondTopBlock = MistBlocks.DIRT_F.func_176223_P().func_177226_a((IProperty)MistDirt.HUMUS, (Comparable)Integer.valueOf(1));
        this.field_76753_B = MistBlocks.DIRT_F.func_176223_P();
        this.treePerChunk = treePerChunk;
        this.getMistBiomeDecorator().field_76803_B = 5;
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityMonk.class, 8, 0, 2));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityForestRunner.class, 20, 1, 4));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityHorb.class, 10, 1, 3));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityForestSpider.class, 20, 2, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntitySkeleton.class, 5, 0, 1));
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180627_b(BlockPos pos) {
        return 9547560;
    }

    @Override
    public float func_76741_f() {
        return 0.025f;
    }

    @Override
    public EnumBiomeType getBiomeType() {
        return EnumBiomeType.Forest;
    }

    public void func_180624_a(World world, Random rand, BlockPos pos) {
        int rx;
        int i;
        int rz;
        int rx2;
        BlockPos randPos;
        int rz2;
        int i2;
        int j;
        double spruseNoise = 0.0;
        double birchNoise = 0.0;
        if (this.treePerChunk > 0) {
            spruseNoise = TREE_NOISE.func_151601_a((double)pos.func_177958_n() * 0.003, (double)pos.func_177952_p() * 0.003);
            birchNoise = TREE_NOISE.func_151601_a((double)pos.func_177958_n() * 0.002, (double)pos.func_177952_p() * 0.002);
        }
        if (birchNoise < -0.5) {
            j = (int)((-0.4 - birchNoise) * 10.0);
            for (i2 = 0; i2 < j; ++i2) {
                int rx3 = rand.nextInt(16) + 8;
                rz2 = rand.nextInt(16) + 8;
                randPos = world.func_175645_m(pos.func_177982_a(rx3, 0, rz2));
                int k = rand.nextInt(3);
                if (k == 0) {
                    minRockGen.func_180709_b(world, rand, randPos);
                    continue;
                }
                if (k == 1) {
                    medRockGen.func_180709_b(world, rand, randPos);
                    continue;
                }
                maxRockGen.func_180709_b(world, rand, randPos);
            }
        }
        if (spruseNoise < -0.6 && rand.nextFloat() < 0.1f || rand.nextFloat() < 0.01f) {
            rx2 = rand.nextInt(16) + 8;
            rz = rand.nextInt(16) + 8;
            BlockPos randPos2 = world.func_175645_m(pos.func_177982_a(rx2, 0, rz));
            ((MistTreeTrunk)MistBlocks.SPRUSE_TRUNK).generateTrunk(world, randPos2, rand);
        }
        if (spruseNoise > -0.6) {
            if (birchNoise > 0.65 && rand.nextFloat() < 0.03f || rand.nextFloat() < 0.02f) {
                rx2 = rand.nextInt(16) + 8;
                rz = rand.nextInt(16) + 8;
                BlockPos randPos3 = world.func_175645_m(pos.func_177982_a(rx2, 0, rz));
                ((MistTreeTrunk)MistBlocks.BIRCH_TRUNK).generateTrunk(world, randPos3, rand);
            }
            if (birchNoise < 0.65 && rand.nextFloat() < 0.02f) {
                rx2 = rand.nextInt(16) + 8;
                rz = rand.nextInt(16) + 8;
                BlockPos randPos4 = world.func_175645_m(pos.func_177982_a(rx2, 0, rz));
                ((MistTreeTrunk)MistBlocks.OAK_TRUNK).generateTrunk(world, randPos4, rand);
            }
        }
        super.func_180624_a(world, rand, pos);
        if (spruseNoise < -0.6) {
            for (i = 0; i < this.treePerChunk; ++i) {
                rx = rand.nextInt(16) + 8;
                int rz3 = rand.nextInt(16) + 8;
                BlockPos randPos5 = world.func_175645_m(pos.func_177982_a(rx, 0, rz3));
                if (rand.nextInt(32) == 0) {
                    if (rand.nextBoolean()) {
                        ((MistTreeTrunk)MistBlocks.OAK_TRUNK).generateTree(world, randPos5, rand);
                        continue;
                    }
                    ((MistTreeTrunk)MistBlocks.BIRCH_TRUNK).generateTree(world, randPos5, rand);
                    continue;
                }
                ((MistTreeTrunk)MistBlocks.SPRUSE_TRUNK).generateTree(world, randPos5, rand);
            }
            if (rand.nextInt(16) == 0) {
                if (rand.nextInt(4) == 0) {
                    MistMycelium.generateMycelium(world, pos, MistBlocks.MUSHROOMS_1.func_176223_P().func_177226_a(MistMushroom.TYPE_1, (Comparable)((Object)MistMushroom.MushroomType_1.BEIGE)), rand);
                } else {
                    MistMycelium.generateMycelium(world, pos, MistBlocks.MUSHROOMS_1.func_176223_P().func_177226_a(MistMushroom.TYPE_1, (Comparable)((Object)MistMushroom.MushroomType_1.SPOT)), rand);
                }
            }
            if (rand.nextInt(24) == 0) {
                if (rand.nextInt(4) == 0) {
                    MistMycelium.generateMycelium(world, pos, MistBlocks.MUSHROOMS_0.func_176223_P().func_177226_a(MistMushroom.TYPE_0, (Comparable)((Object)MistMushroom.MushroomType_0.ORANGE)), rand);
                } else {
                    MistMycelium.generateMycelium(world, pos, MistBlocks.MUSHROOMS_0.func_176223_P().func_177226_a(MistMushroom.TYPE_0, (Comparable)((Object)MistMushroom.MushroomType_0.BROWN)), rand);
                }
            }
        } else if (birchNoise > 0.65) {
            for (i = 0; i < this.treePerChunk; ++i) {
                rx = rand.nextInt(16) + 8;
                int rz4 = rand.nextInt(16) + 8;
                BlockPos randPos6 = world.func_175645_m(pos.func_177982_a(rx, 0, rz4));
                if (rand.nextInt(64) == 0) {
                    ((MistTreeTrunk)MistBlocks.OAK_TRUNK).generateTree(world, randPos6, rand);
                    continue;
                }
                ((MistTreeTrunk)MistBlocks.BIRCH_TRUNK).generateTree(world, randPos6, rand);
            }
            if (rand.nextInt(16) == 0) {
                if (rand.nextInt(3) == 0) {
                    MistMycelium.generateMycelium(world, pos, MistBlocks.MUSHROOMS_1.func_176223_P().func_177226_a(MistMushroom.TYPE_1, (Comparable)((Object)MistMushroom.MushroomType_1.SPOT)), rand);
                } else {
                    MistMycelium.generateMycelium(world, pos, MistBlocks.MUSHROOMS_1.func_176223_P().func_177226_a(MistMushroom.TYPE_1, (Comparable)((Object)MistMushroom.MushroomType_1.COPPER)), rand);
                }
            }
            if (rand.nextInt(24) == 0) {
                i = rand.nextInt(6);
                if (i < 3) {
                    MistMycelium.generateMycelium(world, pos, MistBlocks.MUSHROOMS_0.func_176223_P().func_177226_a(MistMushroom.TYPE_0, (Comparable)((Object)MistMushroom.MushroomType_0.RED)), rand);
                } else if (i < 5) {
                    MistMycelium.generateMycelium(world, pos, MistBlocks.MUSHROOMS_0.func_176223_P().func_177226_a(MistMushroom.TYPE_0, (Comparable)((Object)MistMushroom.MushroomType_0.ORANGE)), rand);
                } else {
                    MistMycelium.generateMycelium(world, pos, MistBlocks.MUSHROOMS_0.func_176223_P().func_177226_a(MistMushroom.TYPE_0, (Comparable)((Object)MistMushroom.MushroomType_0.PINK)), rand);
                }
            }
        } else {
            j = this.treePerChunk;
            if (rand.nextFloat() < this.getMistBiomeDecorator().field_189870_A) {
                ++j;
            }
            for (i2 = 0; i2 < j; ++i2) {
                int rx4 = rand.nextInt(16) + 8;
                rz2 = rand.nextInt(16) + 8;
                randPos = world.func_175645_m(pos.func_177982_a(rx4, 0, rz2));
                if (rand.nextInt(6) > 0) {
                    ((MistTreeTrunk)MistBlocks.OAK_TRUNK).generateTree(world, randPos, rand);
                    continue;
                }
                ((MistTreeTrunk)MistBlocks.BIRCH_TRUNK).generateTree(world, randPos, rand);
            }
            if (this.treePerChunk > 0 && (double)rand.nextFloat() < 0.03) {
                j = rand.nextInt(3);
                for (i2 = 0; i2 < j; ++i2) {
                    int rx5 = rand.nextInt(16) + 8;
                    rz2 = rand.nextInt(16) + 8;
                    randPos = world.func_175645_m(pos.func_177982_a(rx5, 0, rz2));
                    ((MistTreeTrunk)MistBlocks.SPRUSE_TRUNK).generateTree(world, randPos, rand);
                }
            }
            if (this.treePerChunk > 0) {
                boolean dense = this == MistBiomes.upDenseForest;
                if (rand.nextInt(dense ? 16 : 24) == 0) {
                    if (rand.nextBoolean()) {
                        MistMycelium.generateMycelium(world, pos, MistBlocks.MUSHROOMS_1.func_176223_P().func_177226_a(MistMushroom.TYPE_1, (Comparable)((Object)MistMushroom.MushroomType_1.SPOT)), rand);
                    } else {
                        MistMycelium.generateMycelium(world, pos, MistBlocks.MUSHROOMS_1.func_176223_P().func_177226_a(MistMushroom.TYPE_1, (Comparable)((Object)MistMushroom.MushroomType_1.BEIGE)), rand);
                    }
                }
                if (rand.nextInt(dense ? 24 : 32) == 0) {
                    int i3 = rand.nextInt(8);
                    if (i3 < 3) {
                        MistMycelium.generateMycelium(world, pos, MistBlocks.MUSHROOMS_0.func_176223_P().func_177226_a(MistMushroom.TYPE_0, (Comparable)((Object)MistMushroom.MushroomType_0.ORANGE)), rand);
                    } else if (i3 < 5) {
                        MistMycelium.generateMycelium(world, pos, MistBlocks.MUSHROOMS_0.func_176223_P().func_177226_a(MistMushroom.TYPE_0, (Comparable)((Object)MistMushroom.MushroomType_0.PINK)), rand);
                    } else {
                        MistMycelium.generateMycelium(world, pos, MistBlocks.MUSHROOMS_0.func_176223_P().func_177226_a(MistMushroom.TYPE_0, (Comparable)((Object)MistMushroom.MushroomType_0.RED)), rand);
                    }
                }
            }
        }
    }

    @Override
    @Nullable
    public ArrayList<Double> getNoises(int x, int z) {
        ArrayList<Double> noises = new ArrayList<Double>();
        double sandNoise = SAND_NOISE.func_151601_a((double)x * 0.02, (double)z * 0.02);
        double clayNoise = CLAY_NOISE.func_151601_a((double)x * 0.01, (double)z * 0.01);
        noises.add(sandNoise += SAND_NOISE.func_151601_a((double)x * 0.2, (double)z * 0.2) * 0.2);
        noises.add(clayNoise);
        double gravelNoise = GRAVEL_NOISE.func_151601_a((double)x * 0.05, (double)z * 0.05);
        noises.add(gravelNoise += GRAVEL_NOISE.func_151601_a((double)x * 0.3, (double)z * 0.3) * 0.3);
        return noises;
    }

    @Override
    public IBlockState getTopBlock(Random rand, @Nullable ArrayList<Double> noises) {
        if (noises.get(1) > 0.7) {
            return this.field_76752_A;
        }
        return noises.get(0) > 0.6 ? MistBlocks.GRASS_S.func_176223_P().func_177226_a((IProperty)MistDirt.HUMUS, (Comparable)Integer.valueOf(1)) : this.field_76752_A;
    }

    @Override
    public IBlockState getSecondTopBlock(Random rand, @Nullable ArrayList<Double> noises) {
        double sandNoise = noises.get(0);
        double clayNoise = noises.get(1);
        if (noises.get(2) > 0.7 && sandNoise <= 0.6) {
            return MistWorld.gravelBlock;
        }
        if (clayNoise > 0.7) {
            return sandNoise < 0.6 ? MistBlocks.DIRT_C.func_176223_P().func_177226_a((IProperty)MistDirt.HUMUS, (Comparable)Integer.valueOf(1)) : this.secondTopBlock;
        }
        return sandNoise > 0.6 ? this.sand : (sandNoise > 0.5 ? MistBlocks.DIRT_S.func_176223_P().func_177226_a((IProperty)MistDirt.HUMUS, (Comparable)Integer.valueOf(0)) : this.secondTopBlock);
    }

    @Override
    public IBlockState getFillerBlock(Random rand, @Nullable ArrayList<Double> noises) {
        double sandNoise = noises.get(0);
        double clayNoise = noises.get(1);
        if (noises.get(2) > 0.5 && sandNoise <= 0.5) {
            return MistWorld.gravelBlock;
        }
        if (clayNoise > 0.7) {
            return MistBlocks.CLAY.func_176223_P();
        }
        if (clayNoise > 0.6) {
            return clayNoise > 0.65 || sandNoise < 0.5 ? MistBlocks.DIRT_C.func_176223_P().func_177226_a((IProperty)MistDirt.HUMUS, (Comparable)Integer.valueOf(0)) : this.field_76753_B;
        }
        return sandNoise > 0.5 ? this.sand : (sandNoise > 0.4 ? MistBlocks.DIRT_S.func_176223_P().func_177226_a((IProperty)MistDirt.HUMUS, (Comparable)Integer.valueOf(0)) : this.field_76753_B);
    }

    @Override
    protected IBlockState getBottom(Random rand, @Nullable ArrayList<Double> noises) {
        IBlockState state = super.getBottom(rand, noises);
        return noises.get(2) > 0.6 && state.func_177230_c() != MistBlocks.SAND ? MistWorld.gravelBlock : state;
    }

    @Override
    protected IBlockState getSecondBottom(Random rand, @Nullable ArrayList<Double> noises) {
        IBlockState state = super.getBottom(rand, noises);
        return noises.get(2) > 0.5 && state.func_177230_c() != MistBlocks.SAND ? MistWorld.gravelBlock : state;
    }

    public WorldGenerator func_76730_b(Random rand) {
        if (this == MistBiomes.upDenseForest) {
            return new WorldGenTallGrass(rand.nextInt(4) == 0 ? BlockTallGrass.EnumType.FERN : BlockTallGrass.EnumType.GRASS);
        }
        return super.func_76730_b(rand);
    }

    @Override
    public void addDefaultFlowers() {
        this.addFlower(Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)BlockTallGrass.EnumType.FERN), 20);
    }
}

