/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.world.biome;

import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.api.biome.EnumBiomeType;
import ru.liahim.mist.api.block.IWettable;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.block.MistDirt;
import ru.liahim.mist.block.tree.MistTrunkATree;
import ru.liahim.mist.block.tree.MistTrunkAcacia;
import ru.liahim.mist.entity.EntityBarvog;
import ru.liahim.mist.entity.EntityCaravan;
import ru.liahim.mist.entity.EntityCyclops;
import ru.liahim.mist.world.biome.BiomeMistUp;

public class BiomeMistUpDesert
extends BiomeMistUp {
    private final boolean grow;
    private final IBlockState dirt0 = MistBlocks.DIRT_S.func_176223_P().func_177226_a((IProperty)IWettable.WET, (Comparable)Boolean.valueOf(false));
    private final IBlockState dirt1 = this.dirt0.func_177226_a((IProperty)MistDirt.HUMUS, (Comparable)Integer.valueOf(1));
    private final IBlockState dirt2 = this.dirt0.func_177226_a((IProperty)MistDirt.HUMUS, (Comparable)Integer.valueOf(2));

    public BiomeMistUpDesert(Biome.BiomeProperties properties, boolean grow) {
        super(properties);
        this.field_76752_A = MistBlocks.SAND.func_176223_P();
        this.field_76753_B = MistBlocks.SAND.func_176223_P();
        this.grow = grow;
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityCaravan.class, 20, 1, 4));
        if (grow) {
            this.field_76762_K.add(new Biome.SpawnListEntry(EntityBarvog.class, 10, 1, 4));
        }
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityCyclops.class, 20, 2, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntitySkeleton.class, 5, 0, 1));
    }

    @Override
    public EnumBiomeType getBiomeType() {
        return EnumBiomeType.Desert;
    }

    @Override
    public float func_76741_f() {
        return 0.01f;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180627_b(BlockPos pos) {
        return 12548153;
    }

    public void func_180624_a(World world, Random rand, BlockPos pos) {
        if (this.grow) {
            BlockPos randPos;
            int rz;
            int rx;
            if (rand.nextFloat() < 0.05f) {
                rx = rand.nextInt(16) + 8;
                rz = rand.nextInt(16) + 8;
                randPos = world.func_175645_m(pos.func_177982_a(rx, 0, rz));
                ((MistTrunkAcacia)MistBlocks.ACACIA_TRUNK).generateDunesTrunk(world, randPos, rand);
            }
            if (rand.nextFloat() < 0.05f) {
                rx = rand.nextInt(16) + 8;
                rz = rand.nextInt(16) + 8;
                randPos = world.func_175645_m(pos.func_177982_a(rx, 0, rz));
                ((MistTrunkATree)MistBlocks.A_TREE_TRUNK).generateDunesTrunk(world, randPos, rand);
            }
        }
        super.func_180624_a(world, rand, pos);
    }

    @Override
    @Nullable
    public ArrayList<Double> getNoises(int x, int z) {
        ArrayList<Double> noises = new ArrayList<Double>();
        double grassNoise = -SAND_NOISE.func_151601_a((double)x * 0.01, (double)z * 0.01);
        double minorGrassNoise = -SAND_NOISE.func_151601_a((double)x * 0.3, (double)z * 0.3);
        noises.add(grassNoise + minorGrassNoise * 0.3);
        return noises;
    }

    @Override
    protected void placeTopBlock(ChunkPrimer chunkPrimer, int x, int y, int z, IBlockState state, @Nullable ArrayList<Double> noises) {
        if (this.grow && y < 130) {
            double i = noises.get(0) + (double)(130 - y) * 0.3 - 1.0;
            if (i > 0.5) {
                chunkPrimer.func_177855_a(x, y, z, this.dirt2);
            } else if (i > 0.1) {
                chunkPrimer.func_177855_a(x, y, z, this.dirt1);
            } else if (i > -0.4) {
                chunkPrimer.func_177855_a(x, y, z, this.dirt0);
            } else {
                chunkPrimer.func_177855_a(x, y, z, state);
            }
        } else {
            chunkPrimer.func_177855_a(x, y, z, state);
        }
    }

    @Override
    protected void placeSecondTopBlock(ChunkPrimer chunkPrimer, int x, int y, int z, IBlockState state, @Nullable ArrayList<Double> noises) {
        if (this.grow && y < 130) {
            double i = noises.get(0) + (double)(130 - y) * 0.3 - 1.0;
            if (i > -0.0) {
                chunkPrimer.func_177855_a(x, y, z, this.dirt1);
            } else if (i > -0.5) {
                chunkPrimer.func_177855_a(x, y, z, this.dirt0);
            } else {
                chunkPrimer.func_177855_a(x, y, z, state);
            }
        } else {
            chunkPrimer.func_177855_a(x, y, z, state);
        }
    }

    @Override
    protected void placeFillerBlock(ChunkPrimer chunkPrimer, int x, int y, int z, IBlockState state, @Nullable ArrayList<Double> noises) {
        if (this.grow && y < 130 && noises.get(0) + (double)(130 - y) * 0.3 - 1.0 > -0.6) {
            chunkPrimer.func_177855_a(x, y, z, this.dirt0);
        } else {
            chunkPrimer.func_177855_a(x, y, z, state);
        }
    }
}

