/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.world.biome;

import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.api.biome.EnumBiomeType;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.block.MistDirt;
import ru.liahim.mist.block.MistTreeTrunk;
import ru.liahim.mist.block.upperplant.MistMushroom;
import ru.liahim.mist.block.upperplant.MistMycelium;
import ru.liahim.mist.entity.EntityBrachiodon;
import ru.liahim.mist.entity.EntityPrickler;
import ru.liahim.mist.entity.EntitySnowFlea;
import ru.liahim.mist.entity.EntityWulder;
import ru.liahim.mist.world.MistWorld;
import ru.liahim.mist.world.biome.BiomeMistUp;

public class BiomeMistUpColdBase
extends BiomeMistUp {
    protected final int pinePerChunk;
    protected final float snowTreeChance;
    protected final boolean genSTree;
    protected final double gravelOffset;

    public BiomeMistUpColdBase(Biome.BiomeProperties properties, int pinePerChunk, float snowTreeChance, boolean genSTree) {
        super(properties);
        this.field_76752_A = MistBlocks.GRASS_R.func_176223_P().func_177226_a((IProperty)MistDirt.HUMUS, (Comparable)Integer.valueOf(2));
        this.secondTopBlock = MistBlocks.DIRT_R.func_176223_P().func_177226_a((IProperty)MistDirt.HUMUS, (Comparable)Integer.valueOf(1));
        this.field_76753_B = MistBlocks.DIRT_R.func_176223_P();
        this.pinePerChunk = pinePerChunk;
        this.snowTreeChance = snowTreeChance;
        this.genSTree = genSTree;
        double d = this.gravelOffset = pinePerChunk > 0 ? 0.0 : 0.3;
        if (genSTree) {
            this.field_76762_K.add(new Biome.SpawnListEntry(EntityWulder.class, 10, 1, 4));
        }
        if (pinePerChunk <= 0) {
            this.field_76762_K.add(new Biome.SpawnListEntry(EntityBrachiodon.class, 5, 3, 5));
        } else {
            this.field_76762_K.add(new Biome.SpawnListEntry(EntityPrickler.class, 20, 1, 3));
        }
        this.field_76761_J.add(new Biome.SpawnListEntry(EntitySnowFlea.class, 20, 2, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntitySkeleton.class, 5, 0, 1));
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180627_b(BlockPos pos) {
        return 7567440;
    }

    @Override
    public float func_76741_f() {
        return this.pinePerChunk <= 0 ? 0.005f : 0.02f;
    }

    @Override
    public EnumBiomeType getBiomeType() {
        return EnumBiomeType.Cold;
    }

    public void func_180624_a(World world, Random rand, BlockPos pos) {
        int rz;
        int rx;
        BlockPos randPos;
        int rz2;
        int i;
        int j;
        double treeNoise = TREE_NOISE.func_151601_a((double)pos.func_177958_n() * 0.005, (double)pos.func_177952_p() * 0.005);
        if (this.pinePerChunk > 0 && treeNoise < -0.4 || treeNoise > 0.4) {
            j = (int)((Math.abs(treeNoise) - 0.3) * 10.0);
            for (i = 0; i < j; ++i) {
                int rx2 = rand.nextInt(16) + 8;
                rz2 = rand.nextInt(16) + 8;
                randPos = world.func_175645_m(pos.func_177982_a(rx2, 0, rz2));
                int k = rand.nextInt(3);
                if (k == 0) {
                    minRockGen.func_180709_b(world, rand, randPos);
                    continue;
                }
                if (k == 1) {
                    medRockGen.func_180709_b(world, rand, randPos);
                    continue;
                }
                maxRockGen.func_180709_b(world, rand, randPos);
            }
        }
        if (this.pinePerChunk > 0 || this.pinePerChunk == 0 && treeNoise > 0.6) {
            if ((double)this.snowTreeChance > 0.0 && treeNoise < -0.6) {
                if (rand.nextFloat() < 0.1f) {
                    rx = rand.nextInt(16) + 8;
                    rz = rand.nextInt(16) + 8;
                    BlockPos randPos2 = world.func_175645_m(pos.func_177982_a(rx, 0, rz));
                    ((MistTreeTrunk)MistBlocks.SPRUSE_TRUNK).generateTrunk(world, randPos2, rand, true);
                }
            } else if (rand.nextFloat() < 0.05f) {
                rx = rand.nextInt(16) + 8;
                rz = rand.nextInt(16) + 8;
                BlockPos randPos3 = world.func_175645_m(pos.func_177982_a(rx, 0, rz));
                ((MistTreeTrunk)MistBlocks.PINE_TRUNK).generateTrunk(world, randPos3, rand, true);
            }
        }
        if (this.pinePerChunk > 0 && this.snowTreeChance > 0.0f && rand.nextFloat() < 0.02f) {
            rx = rand.nextInt(16) + 8;
            rz = rand.nextInt(16) + 8;
            BlockPos randPos4 = world.func_175645_m(pos.func_177982_a(rx, 0, rz));
            ((MistTreeTrunk)MistBlocks.SNOW_TRUNK).generateTrunk(world, randPos4, rand, true);
        }
        super.func_180624_a(world, rand, pos);
        if (this.pinePerChunk > 0) {
            int i2;
            for (i2 = 0; i2 < this.pinePerChunk; ++i2) {
                int rx3 = rand.nextInt(16) + 8;
                int rz3 = rand.nextInt(16) + 8;
                BlockPos randPos5 = world.func_175645_m(pos.func_177982_a(rx3, 0, rz3));
                if ((double)this.snowTreeChance > 0.0 && treeNoise < -0.6 && (double)rand.nextFloat() > 1.0 + treeNoise) {
                    ((MistTreeTrunk)MistBlocks.SPRUSE_TRUNK).generateTree(world, randPos5, rand, true);
                    continue;
                }
                if (rand.nextFloat() < this.snowTreeChance) {
                    ((MistTreeTrunk)MistBlocks.SNOW_TRUNK).generateTree(world, randPos5, rand, true);
                    continue;
                }
                ((MistTreeTrunk)MistBlocks.PINE_TRUNK).generateTree(world, randPos5, rand, true);
            }
            if (treeNoise < -0.6) {
                if (rand.nextInt(16) == 0) {
                    MistMycelium.generateMycelium(world, pos, MistBlocks.MUSHROOMS_1.func_176223_P().func_177226_a(MistMushroom.TYPE_1, (Comparable)((Object)MistMushroom.MushroomType_1.SPOT)), rand);
                }
                if (rand.nextInt(32) == 0) {
                    if (rand.nextInt(4) == 0) {
                        MistMycelium.generateMycelium(world, pos, MistBlocks.MUSHROOMS_0.func_176223_P().func_177226_a(MistMushroom.TYPE_0, (Comparable)((Object)MistMushroom.MushroomType_0.ORANGE)), rand);
                    } else {
                        MistMycelium.generateMycelium(world, pos, MistBlocks.MUSHROOMS_0.func_176223_P().func_177226_a(MistMushroom.TYPE_0, (Comparable)((Object)MistMushroom.MushroomType_0.BROWN)), rand);
                    }
                }
            } else if (this.snowTreeChance > 0.0f) {
                if (rand.nextInt(24) == 0) {
                    if (rand.nextBoolean()) {
                        MistMycelium.generateMycelium(world, pos, MistBlocks.MUSHROOMS_1.func_176223_P().func_177226_a(MistMushroom.TYPE_1, (Comparable)((Object)MistMushroom.MushroomType_1.SPOT)), rand);
                    } else {
                        MistMycelium.generateMycelium(world, pos, MistBlocks.MUSHROOMS_1.func_176223_P().func_177226_a(MistMushroom.TYPE_1, (Comparable)((Object)MistMushroom.MushroomType_1.LILAC)), rand);
                    }
                }
                if (rand.nextInt(48) == 0) {
                    i2 = rand.nextInt(6);
                    if (i2 < 3) {
                        MistMycelium.generateMycelium(world, pos, MistBlocks.MUSHROOMS_0.func_176223_P().func_177226_a(MistMushroom.TYPE_0, (Comparable)((Object)MistMushroom.MushroomType_0.BLACK)), rand);
                    } else if (i2 < 5) {
                        MistMycelium.generateMycelium(world, pos, MistBlocks.MUSHROOMS_0.func_176223_P().func_177226_a(MistMushroom.TYPE_0, (Comparable)((Object)MistMushroom.MushroomType_0.ORANGE)), rand);
                    } else {
                        MistMycelium.generateMycelium(world, pos, MistBlocks.MUSHROOMS_0.func_176223_P().func_177226_a(MistMushroom.TYPE_0, (Comparable)((Object)MistMushroom.MushroomType_0.BROWN)), rand);
                    }
                }
            } else {
                if (rand.nextInt(24) == 0) {
                    if (rand.nextBoolean()) {
                        MistMycelium.generateMycelium(world, pos, MistBlocks.MUSHROOMS_1.func_176223_P().func_177226_a(MistMushroom.TYPE_1, (Comparable)((Object)MistMushroom.MushroomType_1.SPOT)), rand);
                    } else {
                        MistMycelium.generateMycelium(world, pos, MistBlocks.MUSHROOMS_1.func_176223_P().func_177226_a(MistMushroom.TYPE_1, (Comparable)((Object)MistMushroom.MushroomType_1.LILAC)), rand);
                    }
                }
                if (rand.nextInt(48) == 0) {
                    i2 = rand.nextInt(8);
                    if (i2 < 4) {
                        MistMycelium.generateMycelium(world, pos, MistBlocks.MUSHROOMS_0.func_176223_P().func_177226_a(MistMushroom.TYPE_0, (Comparable)((Object)MistMushroom.MushroomType_0.BLACK)), rand);
                    } else if (i2 < 7) {
                        MistMycelium.generateMycelium(world, pos, MistBlocks.MUSHROOMS_0.func_176223_P().func_177226_a(MistMushroom.TYPE_0, (Comparable)((Object)MistMushroom.MushroomType_0.ORANGE)), rand);
                    } else {
                        MistMycelium.generateMycelium(world, pos, MistBlocks.MUSHROOMS_0.func_176223_P().func_177226_a(MistMushroom.TYPE_0, (Comparable)((Object)MistMushroom.MushroomType_0.BROWN)), rand);
                    }
                }
            }
        } else if (this.pinePerChunk == 0 && treeNoise > 0.6) {
            j = rand.nextInt(3) + 2;
            for (i = 0; i < j; ++i) {
                int rx4 = rand.nextInt(16) - 8;
                rz2 = rand.nextInt(16) - 8;
                randPos = world.func_175645_m(pos.func_177982_a(rx4, 0, rz2));
                ((MistTreeTrunk)MistBlocks.PINE_TRUNK).generateTree(world, randPos, rand, true);
            }
            if (rand.nextInt(24) == 0) {
                if (rand.nextBoolean()) {
                    MistMycelium.generateMycelium(world, pos, MistBlocks.MUSHROOMS_1.func_176223_P().func_177226_a(MistMushroom.TYPE_1, (Comparable)((Object)MistMushroom.MushroomType_1.SPOT)), rand);
                } else {
                    MistMycelium.generateMycelium(world, pos, MistBlocks.MUSHROOMS_1.func_176223_P().func_177226_a(MistMushroom.TYPE_1, (Comparable)((Object)MistMushroom.MushroomType_1.LILAC)), rand);
                }
            }
            if (rand.nextInt(48) == 0) {
                i = rand.nextInt(12);
                if (i < 6) {
                    MistMycelium.generateMycelium(world, pos, MistBlocks.MUSHROOMS_0.func_176223_P().func_177226_a(MistMushroom.TYPE_0, (Comparable)((Object)MistMushroom.MushroomType_0.BLACK)), rand);
                } else if (i < 11) {
                    MistMycelium.generateMycelium(world, pos, MistBlocks.MUSHROOMS_0.func_176223_P().func_177226_a(MistMushroom.TYPE_0, (Comparable)((Object)MistMushroom.MushroomType_0.ORANGE)), rand);
                } else {
                    MistMycelium.generateMycelium(world, pos, MistBlocks.MUSHROOMS_0.func_176223_P().func_177226_a(MistMushroom.TYPE_0, (Comparable)((Object)MistMushroom.MushroomType_0.BROWN)), rand);
                }
            }
        }
        if (this.genSTree && treeNoise > 0.8) {
            j = rand.nextInt(rand.nextInt(4) + 1) + 1;
            for (i = 0; i < j; ++i) {
                int rx5 = rand.nextInt(16) - 8;
                int rz4 = rand.nextInt(16) - 8;
                randPos = world.func_175645_m(pos.func_177982_a(rx5, 0, rz4));
                ((MistTreeTrunk)MistBlocks.S_TREE_TRUNK).generateTree(world, randPos, rand, true);
            }
        }
    }

    @Override
    @Nullable
    public ArrayList<Double> getNoises(int x, int z) {
        ArrayList<Double> noises = new ArrayList<Double>();
        double clayNoise = CLAY_NOISE.func_151601_a((double)x * 0.01, (double)z * 0.01);
        noises.add(clayNoise + CLAY_NOISE.func_151601_a((double)x * 0.3, (double)z * 0.3) * 0.02);
        double gravelNoise = GRAVEL_NOISE.func_151601_a((double)x * 0.05, (double)z * 0.05);
        noises.add(gravelNoise + GRAVEL_NOISE.func_151601_a((double)x * 0.3, (double)z * 0.3) * 0.3);
        return noises;
    }

    @Override
    public IBlockState getTopBlock(Random rand, @Nullable ArrayList<Double> noises) {
        return this.gravelOffset > 0.0 && noises.get(1) > 0.6 ? MistWorld.gravelBlock : this.field_76752_A;
    }

    @Override
    public IBlockState getSecondTopBlock(Random rand, @Nullable ArrayList<Double> noises) {
        if (noises.get(1) > 0.7 - this.gravelOffset) {
            return MistWorld.gravelBlock;
        }
        return noises.get(0) > 0.9 ? MistBlocks.CLAY.func_176223_P() : this.secondTopBlock;
    }

    @Override
    public IBlockState getFillerBlock(Random rand, @Nullable ArrayList<Double> noises) {
        if (noises.get(1) > 0.5 - this.gravelOffset) {
            return MistWorld.gravelBlock;
        }
        return noises.get(0) > 0.8 ? MistBlocks.CLAY.func_176223_P() : this.secondTopBlock;
    }

    @Override
    public IBlockState getZeroBlock(Random rand, @Nullable ArrayList<Double> noises) {
        return noises.get(1) > 0.2 - this.gravelOffset ? MistWorld.gravelBlock : null;
    }
}

