/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.world.biome;

import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.api.biome.EnumBiomeType;
import ru.liahim.mist.api.biome.MistBiomes;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.block.MistDirt;
import ru.liahim.mist.world.MistWorld;
import ru.liahim.mist.world.biome.BiomeMistUp;
import ru.liahim.mist.world.biome.BiomeMistUpDesert;
import ru.liahim.mist.world.biome.MistBiomeDecorator;
import ru.liahim.mist.world.generators.BigRockGenerator;
import ru.liahim.mist.world.generators.LooseRockGenerator;

public abstract class BiomeMist
extends Biome {
    public IBlockState secondTopBlock;
    public IBlockState zeroBlock;
    public IBlockState topBlockOuter;
    public IBlockState secondTopBlockOuter;
    public IBlockState fillerBlockOuter;
    public IBlockState zeroBlockOuter;
    protected int biomeColor;
    protected static final WorldGenerator minRockGen = new BigRockGenerator(0);
    protected static final WorldGenerator medRockGen = new BigRockGenerator(1);
    protected static final WorldGenerator maxRockGen = new BigRockGenerator(2);
    public static final WorldGenerator looseRockGen = new LooseRockGenerator();
    protected static final NoiseGeneratorPerlin TREE_NOISE = new NoiseGeneratorPerlin(new Random(1234L), 1);
    protected static final NoiseGeneratorPerlin SAND_NOISE = new NoiseGeneratorPerlin(new Random(2345L), 1);
    protected static final NoiseGeneratorPerlin CLAY_NOISE = new NoiseGeneratorPerlin(new Random(3456L), 1);
    protected static final NoiseGeneratorPerlin PEAT_NOISE = new NoiseGeneratorPerlin(new Random(4567L), 1);
    protected static final NoiseGeneratorPerlin GRAVEL_NOISE = new NoiseGeneratorPerlin(new Random(5678L), 1);
    protected static final NoiseGeneratorPerlin SAPROPEL_NOISE = new NoiseGeneratorPerlin(new Random(6789L), 1);
    protected static final NoiseGeneratorPerlin FLOATING_MAT_NOISE = new NoiseGeneratorPerlin(new Random(7890L), 1);
    protected final IBlockState grass = Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)BlockTallGrass.EnumType.GRASS);
    protected final IBlockState fern = Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)BlockTallGrass.EnumType.FERN);
    protected final IBlockState grassDown = Blocks.field_150398_cm.func_176223_P().func_177226_a((IProperty)BlockDoublePlant.field_176493_a, (Comparable)BlockDoublePlant.EnumPlantType.GRASS);
    protected final IBlockState grassUp = Blocks.field_150398_cm.func_176223_P().func_177226_a((IProperty)BlockDoublePlant.field_176493_a, (Comparable)BlockDoublePlant.EnumPlantType.GRASS).func_177226_a((IProperty)BlockDoublePlant.field_176492_b, (Comparable)BlockDoublePlant.EnumBlockHalf.UPPER);

    public BiomeMist(Biome.BiomeProperties properties) {
        super(properties);
        this.field_76761_J.clear();
        this.field_76762_K.clear();
        this.field_76755_L.clear();
        this.field_82914_M.clear();
        this.field_76752_A = MistBlocks.GRASS_F.func_176223_P().func_177226_a((IProperty)MistDirt.HUMUS, (Comparable)Integer.valueOf(2));
        this.field_76753_B = MistBlocks.DIRT_F.func_176223_P();
    }

    public abstract boolean isUpBiome();

    public abstract EnumBiomeType getBiomeType();

    public int getBiomeColor() {
        return this.biomeColor;
    }

    public int getDownGrassColor() {
        return -1;
    }

    public BiomeMist setBiomeColor(int c) {
        this.biomeColor = c;
        return this;
    }

    public float func_76741_f() {
        return 0.02f;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_76731_a(float currentTemperature) {
        currentTemperature = MathHelper.func_76131_a((float)Math.abs(1.25f - currentTemperature), (float)0.0f, (float)1.0f);
        int r = 140;
        int g = (int)(185.0f + currentTemperature * 15.0f);
        int b = (int)(215.0f - currentTemperature * 5.0f);
        return r << 16 | g << 8 | b;
    }

    public void genMistWorldBiomeTerrain(World worldIn, Random rand, ChunkPrimer chunkPrimer, int xIn, int zIn, double noiseVal) {
        int x = zIn & 0xF;
        int z = xIn & 0xF;
        int noiseX = (xIn >> 4 << 4) + x;
        int noiseZ = (zIn >> 4 << 4) + z;
        ArrayList<Double> noises = this.getNoises(noiseX, noiseZ);
        IBlockState topState = this.getTopBlock(rand, noises);
        IBlockState fillerState = this.getFillerBlock(rand, noises);
        IBlockState secondTopState = this.getSecondTopBlock(rand, noises);
        secondTopState = secondTopState == null ? fillerState : secondTopState;
        IBlockState zeroState = this.getZeroBlock(rand, noises);
        int currentFillerDepth = -1;
        int gravelFillerDepth = -1;
        int maxFillerDepth = (int)(noiseVal / 3.0 + 3.0 + rand.nextDouble() * 0.25);
        boolean dunes = this == MistBiomes.upDunes;
        for (int y = 255; y >= 0; --y) {
            boolean notErosion;
            boolean bl = notErosion = y > 108 - rand.nextInt(3) + 1;
            if (y <= rand.nextInt(5)) {
                chunkPrimer.func_177855_a(x, y, z, field_185367_c);
                continue;
            }
            if (y <= 26 + rand.nextInt(3)) {
                chunkPrimer.func_177855_a(x, y, z, MistWorld.stoneBlockLower);
                continue;
            }
            if (gravelFillerDepth >= 0) {
                --gravelFillerDepth;
                chunkPrimer.func_177855_a(x, y, z, MistWorld.gravelBlock);
                continue;
            }
            IBlockState iblockstateCurrent = chunkPrimer.func_177856_a(x, y, z);
            if (iblockstateCurrent.func_185904_a() == Material.field_151579_a) {
                if (this instanceof BiomeMistUp && !(this instanceof BiomeMistUpDesert)) {
                    if (y == 125) {
                        chunkPrimer.func_177855_a(x, y, z, Blocks.field_150359_w.func_176223_P());
                    } else if (y <= 125 && y > 112) {
                        chunkPrimer.func_177855_a(x, y, z, MistWorld.waterBlockUpper);
                    }
                }
                currentFillerDepth = -1;
                continue;
            }
            if (iblockstateCurrent.func_177230_c() != MistWorld.worldStone.func_177230_c()) continue;
            if (currentFillerDepth == -1) {
                if (maxFillerDepth <= 0) {
                    topState = field_185366_b;
                    fillerState = notErosion ? MistWorld.stoneBlockUpper : MistWorld.stoneBlockMedium;
                } else if (!this.isUpBiome() && y > 112 || this.isUpBiome() && y < 96) {
                    topState = this.topBlockOuter != null ? this.topBlockOuter : MistWorld.gravelBlock;
                } else if (y >= 96 && y <= 112) {
                    topState = MistWorld.gravelBlock;
                } else if (y < 125 && this.isUpBiome() && this.getBiomeType() != EnumBiomeType.Border) {
                    topState = this.getBottom(rand, noises);
                    secondTopState = this.getSecondBottom(rand, noises);
                }
                if (dunes && y > 126) {
                    maxFillerDepth += (y - 126) / 3;
                }
                currentFillerDepth = maxFillerDepth;
                if (y >= 35) {
                    this.placeTopBlock(chunkPrimer, x, y, z, topState, noises);
                    continue;
                }
                this.placeBottomBlock(chunkPrimer, x, y, z, this.getBottom(rand, noises), noises);
                continue;
            }
            if (currentFillerDepth > 0) {
                --currentFillerDepth;
                if (!this.isUpBiome() && y > 112 || this.isUpBiome() && y <= 96) {
                    if (this.secondTopBlockOuter != null) {
                        secondTopState = this.secondTopBlockOuter;
                    } else {
                        IBlockState iBlockState = secondTopState = notErosion ? MistWorld.stoneBlockUpper : MistWorld.stoneBlockMedium;
                    }
                    if (this.fillerBlockOuter != null) {
                        fillerState = this.fillerBlockOuter;
                    } else {
                        IBlockState iBlockState = fillerState = notErosion ? MistWorld.stoneBlockUpper : MistWorld.stoneBlockMedium;
                    }
                    zeroState = this.zeroBlockOuter != null ? this.zeroBlockOuter : (notErosion ? MistWorld.stoneBlockUpper : MistWorld.stoneBlockMedium);
                } else if (y >= 96 && y <= 112) {
                    zeroState = notErosion ? MistWorld.stoneBlockUpper : MistWorld.stoneBlockMedium;
                    fillerState = zeroState;
                    secondTopState = zeroState;
                }
                if (fillerState == MistWorld.stoneBlockMedium || fillerState == MistWorld.stoneBlockUpper) {
                    chunkPrimer.func_177855_a(x, y, z, notErosion ? MistWorld.stoneBlockUpper : MistWorld.stoneBlockMedium);
                } else if (currentFillerDepth == 0 && zeroState != null) {
                    chunkPrimer.func_177855_a(x, y, z, zeroState);
                } else if (maxFillerDepth - currentFillerDepth == 1) {
                    this.placeSecondTopBlock(chunkPrimer, x, y, z, secondTopState, noises);
                } else {
                    this.placeFillerBlock(chunkPrimer, x, y, z, fillerState, noises);
                }
                if (currentFillerDepth != 0 || y > 38) continue;
                gravelFillerDepth = 38 - y;
                continue;
            }
            if (!notErosion) continue;
            chunkPrimer.func_177855_a(x, y, z, MistWorld.stoneBlockUpper);
        }
    }

    @Nullable
    public ArrayList<Double> getNoises(int x, int z) {
        return null;
    }

    public IBlockState getTopBlock(Random rand, @Nullable ArrayList<Double> noises) {
        return this.field_76752_A;
    }

    public IBlockState getSecondTopBlock(Random rand, @Nullable ArrayList<Double> noises) {
        return this.secondTopBlock;
    }

    public IBlockState getFillerBlock(Random rand, @Nullable ArrayList<Double> noises) {
        return this.field_76753_B;
    }

    protected IBlockState getZeroBlock(Random rand, @Nullable ArrayList<Double> noises) {
        return this.zeroBlock;
    }

    protected IBlockState getBottom(Random rand, @Nullable ArrayList<Double> noises) {
        IBlockState state = this.getSecondTopBlock(rand, noises);
        return state != null ? state : this.getFillerBlock(rand, noises);
    }

    protected IBlockState getSecondBottom(Random rand, ArrayList<Double> noises) {
        return this.getFillerBlock(rand, noises);
    }

    protected void placeTopBlock(ChunkPrimer chunkPrimer, int x, int y, int z, IBlockState state, @Nullable ArrayList<Double> noises) {
        chunkPrimer.func_177855_a(x, y, z, state);
    }

    protected void placeSecondTopBlock(ChunkPrimer chunkPrimer, int x, int y, int z, IBlockState state, @Nullable ArrayList<Double> noises) {
        chunkPrimer.func_177855_a(x, y, z, state);
    }

    protected void placeFillerBlock(ChunkPrimer chunkPrimer, int x, int y, int z, IBlockState state, @Nullable ArrayList<Double> noises) {
        chunkPrimer.func_177855_a(x, y, z, state);
    }

    protected void placeBottomBlock(ChunkPrimer chunkPrimer, int x, int y, int z, IBlockState state, @Nullable ArrayList<Double> noises) {
        chunkPrimer.func_177855_a(x, y, z, state);
    }

    public void func_180622_a(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        this.genMistWorldBiomeTerrain(worldIn, rand, chunkPrimerIn, x, z, noiseVal);
    }

    public BiomeDecorator func_76729_a() {
        return new MistBiomeDecorator();
    }

    protected MistBiomeDecorator getMistBiomeDecorator() {
        return (MistBiomeDecorator)this.field_76760_I;
    }

    public boolean placePlant(World world, BlockPos pos, Random rand) {
        if (rand.nextInt(10) == 0 && Blocks.field_150329_H.func_180671_f(world, pos, this.grass)) {
            return world.func_180501_a(pos, this.grass, 2);
        }
        if (this.func_150559_j() && world.func_175678_i(pos.func_177982_a(0, 125 - pos.func_177956_o(), 0))) {
            return world.func_180501_a(pos, Blocks.field_150431_aC.func_176223_P(), 2);
        }
        return false;
    }

    public void addDefaultFlowers() {
        this.addFlower(null, 100);
    }

    public NoiseGeneratorPerlin getGrassNoise() {
        return Biome.field_180281_af;
    }
}

