/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.world;

import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.MusicTicker;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.common.ClientProxy;
import ru.liahim.mist.common.Mist;
import ru.liahim.mist.handlers.ClientEventHandler;
import ru.liahim.mist.handlers.FogRenderer;
import ru.liahim.mist.init.ModConfig;
import ru.liahim.mist.world.BiomeProviderMist;
import ru.liahim.mist.world.ChunkProviderMist;
import ru.liahim.mist.world.MistWorld;

public class WorldProviderMist
extends WorldProvider {
    private static MusicTicker.MusicType currentMusic;
    private static MistMusicType mistMusic;
    private static float volume;

    public DimensionType func_186058_p() {
        return Mist.dimensionType;
    }

    protected void func_76572_b() {
        this.field_191067_f = true;
        this.field_76578_c = new BiomeProviderMist(ModConfig.getCustomSeed(this.field_76579_a.func_72905_C()), this.field_76579_a.func_72912_H());
    }

    public IChunkGenerator func_186060_c() {
        long seed = ModConfig.getCustomSeed(this.field_76579_a.func_72905_C());
        return new ChunkProviderMist(this.field_76579_a, seed, true);
    }

    public int getRespawnDimension(EntityPlayerMP player) {
        return Mist.getID();
    }

    public long getSeed() {
        return MistWorld.getCustomSeed() == 0L ? super.getSeed() : MistWorld.getCustomSeed();
    }

    @SideOnly(value=Side.CLIENT)
    public float func_76571_f() {
        return 192.0f;
    }

    public double getHorizon() {
        return 36.0;
    }

    public boolean isBlockHighHumidity(BlockPos pos) {
        return MistWorld.isPosInFog(this.field_76579_a, pos) ? true : this.field_76579_a.func_180494_b(pos).func_76736_e();
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d getSkyColor(Entity cameraEntity, float partialTicks) {
        Vec3d vec3d = cameraEntity.field_70163_u > (double)(FogRenderer.fogHeight - 8.0f) ? this.getSkyColorBody(this.field_76579_a, cameraEntity, partialTicks) : new Vec3d((double)FogRenderer.red, (double)FogRenderer.green, (double)FogRenderer.blue);
        return vec3d;
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getCloudRenderer() {
        return ClientProxy.CloudRendererMist;
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getSkyRenderer() {
        return ClientProxy.SkyRendererMist;
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getWeatherRenderer() {
        return ClientProxy.WeatherRendererMist;
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public MusicTicker.MusicType getMusicType() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (WorldProviderMist.canPlayMusic(player)) {
            if (ClientEventHandler.currentSound == null || !Minecraft.func_71410_x().func_147118_V().func_147692_c(ClientEventHandler.currentSound)) {
                WorldProviderMist.checkSound();
                long time = player.field_70170_p.func_72820_D() % 24000L;
                if (FogRenderer.depth > 4.0f) {
                    if (time == 12000L && player.func_70681_au().nextInt(3) > 0) {
                        mistMusic = MistMusicType.SUNSET_DOWN;
                        currentMusic = ClientProxy.MIST_SUNSET_DOWN_MUSIC;
                    } else if (mistMusic != MistMusicType.DOWN) {
                        mistMusic = MistMusicType.DOWN;
                        currentMusic = ClientProxy.MIST_DOWN_MUSIC;
                    }
                } else if (time == 11000L && player.func_70681_au().nextInt(3) > 0) {
                    mistMusic = MistMusicType.SUNSET_UP;
                    currentMusic = ClientProxy.MIST_SUNSET_UP_MUSIC;
                } else if (time < 1000L || time > 10000L) {
                    if (mistMusic != MistMusicType.UP_NIGHT) {
                        mistMusic = MistMusicType.UP_NIGHT;
                        currentMusic = ClientProxy.MIST_UP_NIGHT_MUSIC;
                    }
                } else if (mistMusic != MistMusicType.UP_DAY) {
                    mistMusic = MistMusicType.UP_DAY;
                    currentMusic = ClientProxy.MIST_UP_DAY_MUSIC;
                }
            } else if (FogRenderer.depth > 4.0f) {
                if (mistMusic.isUp) {
                    ClientEventHandler.fadeOut = 300;
                }
            } else if (!mistMusic.isUp) {
                ClientEventHandler.fadeOut = 1000;
            }
            return currentMusic;
        }
        if (ClientEventHandler.fadeOut > 0) {
            ClientEventHandler.fadeOut = 0;
        }
        WorldProviderMist.checkSound();
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean canPlayMusic(EntityPlayerSP player) {
        return player != null && !player.field_71075_bZ.field_75098_d && !player.field_71075_bZ.field_75101_c && player.field_70170_p.field_73011_w.getDimension() == Mist.getID();
    }

    @SideOnly(value=Side.CLIENT)
    private static void checkSound() {
        if (ClientEventHandler.currentSound != null) {
            Minecraft.func_71410_x().func_147118_V().func_147683_b(ClientEventHandler.currentSound);
            ClientEventHandler.currentSound = null;
            ClientEventHandler.fadeOut = 0;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d getSkyColorBody(World world, Entity entity, float partialTicks) {
        float Thunder;
        float f = world.func_72826_c(partialTicks);
        float fs = MathHelper.func_76134_b((float)(f * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        float fc = MathHelper.func_76134_b((float)(f * ((float)Math.PI * 2))) * 2.0f + 0.2f;
        fs = MathHelper.func_76131_a((float)fs, (float)0.0f, (float)1.0f);
        fc = MathHelper.func_76131_a((float)fc, (float)0.0f, (float)1.0f);
        int i = MathHelper.func_76128_c((double)entity.field_70165_t);
        int j = MathHelper.func_76128_c((double)entity.field_70163_u);
        int k = MathHelper.func_76128_c((double)entity.field_70161_v);
        BlockPos blockpos = new BlockPos(i, j, k);
        int l = ForgeHooksClient.getSkyBlendColour((World)world, (BlockPos)blockpos);
        float r = (float)MathHelper.func_76125_a((int)((int)(120.0f + fc * (float)((l >> 16 & 0xFF) - 120))), (int)0, (int)255) / 255.0f;
        float g = (float)MathHelper.func_76125_a((int)((int)(210.0f - fc * (float)(210 - (l >> 8 & 0xFF)))), (int)0, (int)255) / 255.0f;
        float b = (float)MathHelper.func_76125_a((int)((int)(185.0f + fc * (float)((l & 0xFF) - 185))), (int)0, (int)255) / 255.0f;
        r *= fs;
        g *= fs;
        b *= fs;
        float rain = world.func_72867_j(partialTicks);
        if (rain > 0.0f) {
            float f1 = (r * 0.3f + g * 0.59f + b * 0.11f) * 0.55f;
            float f2 = 1.0f - rain * 0.75f;
            r = MathHelper.func_76131_a((float)(r * f2 + (f1 - 0.02f) * (1.0f - f2)), (float)0.0f, (float)1.0f);
            g = MathHelper.func_76131_a((float)(g * f2 + (f1 + 0.02f) * (1.0f - f2)), (float)0.0f, (float)1.0f);
            b = MathHelper.func_76131_a((float)(b * f2 + (f1 + 0.01f) * (1.0f - f2)), (float)0.0f, (float)1.0f);
        }
        if ((Thunder = world.func_72819_i(partialTicks)) > 0.0f) {
            float f3 = (r * 0.3f + g * 0.59f + b * 0.11f) * 0.3f;
            float f4 = 1.0f - Thunder * 0.75f;
            r = MathHelper.func_76131_a((float)(r * f4 + (f3 - 0.02f) * (1.0f - f4)), (float)0.0f, (float)1.0f);
            g = MathHelper.func_76131_a((float)(g * f4 + (f3 + 0.01f) * (1.0f - f4)), (float)0.0f, (float)1.0f);
            b = MathHelper.func_76131_a((float)(b * f4 + (f3 + 0.02f) * (1.0f - f4)), (float)0.0f, (float)1.0f);
        }
        if (world.func_175658_ac() > 0) {
            float f5 = (float)world.func_175658_ac() - partialTicks;
            if (f5 > 1.0f) {
                f5 = 1.0f;
            }
            r = r * (1.0f - (f5 *= 0.45f)) + 0.8f * f5;
            g = g * (1.0f - f5) + 0.8f * f5;
            b = b * (1.0f - f5) + 1.0f * f5;
        }
        return new Vec3d((double)r, (double)g, (double)b);
    }

    static {
        volume = 1.0f;
    }

    private static enum MistMusicType {
        UP_DAY(true),
        UP_NIGHT(true),
        DOWN(false),
        SUNSET_UP(true),
        SUNSET_DOWN(false);

        private final boolean isUp;

        private MistMusicType(boolean isUp) {
            this.isUp = isUp;
        }
    }
}

