/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.world;

import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.api.block.ISeasonalChanges;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.common.Mist;
import ru.liahim.mist.common.MistTime;
import ru.liahim.mist.handlers.FogRenderer;
import ru.liahim.mist.handlers.ServerEventHandler;

public class MistWorld {
    public static final float baseHeightUp = 3.6f;
    public static final float baseHeightDown = -1.7f;
    public static final byte seaLevelUp = 125;
    public static final byte seaLevelDown = 36;
    public static final byte lowerStoneHight = 26;
    public static final int fogMinHight_S = 100;
    public static final int fogMaxHight_S = 108;
    private static float fogDelta = 0.0f;
    public static IBlockState stoneBlockUpper;
    public static IBlockState stoneBlockMedium;
    public static IBlockState stoneBlockLower;
    public static IBlockState gravelBlock;
    public static IBlockState worldStone;
    public static IBlockState waterBlockUpper;
    public static IBlockState waterBlockLower;
    public static final DamageSource IN_FOG;
    public static final DamageSource DISSOLUTION;
    private static final int fogHumi = 160;
    private static long customSeed;
    @SideOnly(value=Side.CLIENT)
    private static long clientSeed;

    public static void setCustomSeed(long seed) {
        customSeed = seed;
    }

    public static long getCustomSeed() {
        return customSeed;
    }

    @SideOnly(value=Side.CLIENT)
    public static void setClientSeed(long seed) {
        clientSeed = seed;
    }

    @SideOnly(value=Side.CLIENT)
    public static long getClientSeed() {
        return clientSeed;
    }

    public static void setWorldBlocks() {
        stoneBlockUpper = MistBlocks.STONE.func_176223_P();
        stoneBlockMedium = MistBlocks.STONE_POROUS.func_176223_P();
        stoneBlockLower = MistBlocks.STONE_BASIC.func_176223_P();
        gravelBlock = MistBlocks.GRAVEL.func_176223_P();
        worldStone = stoneBlockMedium;
        waterBlockUpper = Blocks.field_150355_j.func_176223_P();
        waterBlockLower = MistBlocks.ACID_BLOCK.func_176223_P();
    }

    public static float getFogHight(World world, float tick) {
        float f = MathHelper.func_76134_b((float)(world.func_72826_c(tick) * ((float)Math.PI * 2) - 0.35f)) * 16.0f + 4.0f;
        f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)8.0f);
        float rain = world.func_72867_j(tick);
        return (float)MistWorld.getFogMinHight() + f - rain;
    }

    public static float getHumi(World world, BlockPos pos, float tick) {
        Material mat = world.func_180495_p(pos).func_185904_a();
        if (mat == Material.field_151586_h) {
            return 200.0f;
        }
        int dim = world.field_73011_w.getDimension();
        if (dim == -1 || dim == 1 || mat == Material.field_151587_i || mat == Material.field_151581_o) {
            return 0.0f;
        }
        float H = 0.0f;
        if (dim == Mist.getID()) {
            int Y = pos.func_177956_o();
            if (Y < MistWorld.getFogMinHight()) {
                return 160.0f;
            }
            if ((float)Y < (float)MistWorld.getFogMaxHight() + 4.0f) {
                float fogHight = world.field_72995_K ? FogRenderer.fogHeight : MistWorld.getFogHight(world, tick) + 4.0f;
                H = Math.max(fogHight - (float)Y, 0.0f);
            }
        }
        Biome biome = world.func_180494_b(pos);
        float cel = world.func_72826_c(tick) * ((float)Math.PI * 2);
        float light = Math.max((float)world.func_175642_b(EnumSkyBlock.BLOCK, pos) * 0.625f, (float)world.func_175642_b(EnumSkyBlock.SKY, pos) * MistWorld.getSunBrightnessBody(world, cel, 0.0f));
        float temp = MathHelper.func_76131_a((float)(biome.func_180626_a(pos) * 0.4f + 0.2f), (float)0.0f, (float)1.0f);
        float humi = MathHelper.func_76131_a((float)biome.func_76727_i(), (float)0.0f, (float)1.0f);
        float delta = (temp * 0.4f + 0.4f) * MathHelper.func_76134_b((float)(cel - 0.35f));
        float percent = 100.0f - (temp - humi + delta) / 1.8f * 100.0f - light + world.func_72867_j(tick) * 15.0f;
        return H == 0.0f || percent > 160.0f ? percent : (H >= 4.0f ? 160.0f : percent + (160.0f - percent) / 4.0f * H);
    }

    private static float getSunBrightnessBody(World world, float cel, float tick) {
        float f1 = 1.0f - (MathHelper.func_76134_b((float)cel) * 2.0f + 0.2f);
        f1 = 1.0f - MathHelper.func_76131_a((float)f1, (float)0.0f, (float)1.0f);
        return f1 * 0.8f + 0.2f;
    }

    public static long getPosRandom(World world, BlockPos pos, int range) {
        long l = (long)pos.func_177958_n() * 3129871L ^ (long)pos.func_177952_p() * 116129781L ^ (long)pos.func_177956_o() * world.func_72905_C();
        l = l * l * 42317861L + l * 11L;
        return Math.abs(range == 0 ? l : l % (long)(range + 3) % (long)range);
    }

    private static BlockPos getCenterPos(long seed, BlockPos pos, boolean main) {
        int deltaX = (int)(seed >> 8 & 0xFL) * 1024;
        int deltaZ = (int)(seed >> 16 & 0xFL) * 1024;
        if (main) {
            deltaZ -= pos.func_177952_p() & 0x3FFF;
            if (Math.abs(deltaX -= pos.func_177958_n() & 0x3FFF) >= 8192) {
                int n = deltaX = deltaX > 0 ? (deltaX = deltaX - 16384) : (deltaX = deltaX + 16384);
            }
            if (Math.abs(deltaZ) >= 8192) {
                deltaZ = deltaZ > 0 ? (deltaZ = deltaZ - 16384) : (deltaZ = deltaZ + 16384);
            }
        } else {
            deltaX = deltaX + 2048 & 0xFFF;
            deltaZ = deltaZ + 2048 & 0xFFF;
            deltaZ -= pos.func_177952_p() & 0xFFF;
            if (Math.abs(deltaX -= pos.func_177958_n() & 0xFFF) >= 2048) {
                int n = deltaX = deltaX > 0 ? (deltaX = deltaX - 4096) : (deltaX = deltaX + 4096);
            }
            if (Math.abs(deltaZ) >= 2048) {
                deltaZ = deltaZ > 0 ? (deltaZ = deltaZ - 4096) : (deltaZ = deltaZ + 4096);
            }
        }
        return new BlockPos(pos.func_177958_n() + deltaX, 36, pos.func_177952_p() + deltaZ);
    }

    @SideOnly(value=Side.CLIENT)
    public static BlockPos getCenterPos(BlockPos pos, boolean main) {
        return MistWorld.getCenterPos(Mist.proxy.getClientSeed(), pos, main);
    }

    public static BlockPos getCenterPos(World world, BlockPos pos, boolean main) {
        return MistWorld.getCenterPos(world.func_72905_C(), pos, main);
    }

    public static boolean isPosInFog(World world, BlockPos pos) {
        return MistWorld.isPosInFog(world, pos.func_177956_o());
    }

    public static boolean isPosInFog(World world, float y) {
        if (world.field_73011_w.getDimension() == Mist.getID()) {
            if (y >= (float)MistWorld.getFogMaxHight() + 4.0f) {
                return false;
            }
            if (y >= (float)MistWorld.getFogMinHight() + 4.0f) {
                if (world.field_72995_K) {
                    return y < FogRenderer.fogHeight;
                }
                return y < MistWorld.getFogHight(world, 0.0f) + 4.0f;
            }
            return true;
        }
        return false;
    }

    public static int getFogMinHight() {
        return 100 + (int)fogDelta;
    }

    public static int getFogMaxHight() {
        return 108 + (int)fogDelta;
    }

    public static void setFogDelta(float fogDelta) {
        MistWorld.fogDelta = fogDelta;
    }

    public static void seasonalTest(Chunk chunk) {
        int x = chunk.field_76635_g * 16;
        int z = chunk.field_76647_h * 16;
        int h = 0;
        long tick = MistTime.getTickOfMonth(chunk.func_177412_p());
        for (int ii = 0; ii < 16; ++ii) {
            ExtendedBlockStorage ebs = chunk.func_76587_i()[ii];
            if (ebs != Chunk.field_186036_a && !ebs.func_76663_a()) {
                for (int i = 0; i < 16; ++i) {
                    for (int j = 0; j < 16; ++j) {
                        for (int k = 0; k < 16; ++k) {
                            IBlockState newState;
                            IBlockState state = ebs.func_177485_a(i, j, k);
                            if (!(state.func_177230_c() instanceof ISeasonalChanges) || (newState = ((ISeasonalChanges)state.func_177230_c()).getSeasonState(chunk.func_177412_p(), new BlockPos(x + i, h + j, z + k), state, tick)) == null) continue;
                            ebs.func_177484_a(i, j, k, newState);
                        }
                    }
                }
            }
            h += 16;
        }
    }

    public static boolean canPlayAmbiendSounds(World world, BlockPos pos) {
        return ServerEventHandler.ambientSoundsTimer <= 0 && !world.func_72896_J() && pos.func_177956_o() > MistWorld.getFogMaxHight();
    }

    static {
        IN_FOG = new DamageSource("mist.in_fog").func_76348_h();
        DISSOLUTION = new DamageSource("mist.dissolution").func_76348_h();
    }
}

