/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.world;

import java.util.UUID;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntitySkeletonHorse;
import net.minecraft.entity.passive.EntityZombieHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import ru.liahim.mist.api.advancement.FogDamagePredicate;
import ru.liahim.mist.api.block.IMistAdsorbent;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.api.event.PollutionEvent;
import ru.liahim.mist.api.item.IMask;
import ru.liahim.mist.api.item.ISuit;
import ru.liahim.mist.capability.handler.IMistCapaHandler;
import ru.liahim.mist.common.Mist;
import ru.liahim.mist.init.ModAdvancements;
import ru.liahim.mist.world.MistWorld;

public class FogDamage {
    private static final UUID healthUUID = UUID.fromString("4e65bedc-27d8-44da-8d8e-4493874517ab");
    private static final boolean ambient = true;
    private static final int pollutiomDamageBorder = 80;

    public static void calculateFogDamage(EntityLivingBase entity) {
        if (!entity.field_70170_p.field_72995_K && !entity.field_70128_L) {
            EntityPlayer player;
            boolean mist;
            boolean bl = mist = entity.field_70170_p.field_73011_w.getDimension() == Mist.getID();
            if (!FogDamage.isDamageTick(entity.field_70173_aa) || entity.field_70173_aa == 0) {
                return;
            }
            boolean isPlayer = entity instanceof EntityPlayer;
            EntityPlayer entityPlayer = player = isPlayer ? (EntityPlayer)entity : null;
            if (!isPlayer) {
                if (!mist) {
                    return;
                }
                if (entity instanceof EntityZombie) {
                    return;
                }
                if (entity instanceof EntitySkeleton) {
                    return;
                }
                if (entity instanceof EntitySkeletonHorse) {
                    return;
                }
                if (entity instanceof EntityZombieHorse) {
                    return;
                }
                if (entity instanceof EntityGolem) {
                    return;
                }
                if (entity instanceof EntityBlaze) {
                    return;
                }
                if (entity instanceof EntityMagmaCube) {
                    return;
                }
            } else if (player.func_184812_l_() || player.func_175149_v() || player.func_110143_aJ() == 0.0f) {
                return;
            }
            IMistCapaHandler mistCapa = isPlayer ? IMistCapaHandler.getHandler(player) : null;
            float eyeHeight = entity.func_70047_e();
            BlockPos.PooledMutableBlockPos pos = BlockPos.PooledMutableBlockPos.func_185346_s();
            pos.func_189532_c(Math.floor(entity.field_70165_t), Math.floor(entity.field_70163_u + (double)eyeHeight), Math.floor(entity.field_70161_v));
            float depth = 0.0f;
            if (entity.field_70163_u + (double)eyeHeight <= (double)((float)MistWorld.getFogMaxHight() + 4.0f)) {
                depth = entity.field_70163_u + (double)eyeHeight < (double)MistWorld.getFogMinHight() ? 4.0f : (float)Math.min(4.0, (double)(MistWorld.getFogHight(entity.field_70170_p, 0.0f) + 4.0f) - entity.field_70163_u - (double)eyeHeight);
            }
            if (mist && depth > 0.0f) {
                boolean adsorbentTick;
                float concentration = FogDamage.getConcentration(entity.field_70170_p, (BlockPos)pos);
                boolean rain = depth >= 4.0f && FogDamage.isRainTick(entity.field_70173_aa) && entity.field_70170_p.func_72896_J() && entity.field_70170_p.func_175710_j((BlockPos)pos);
                boolean adsorbent = FogDamage.isAdsorbentNear(entity.field_70170_p, (BlockPos)pos);
                boolean bl2 = adsorbentTick = adsorbent && FogDamage.isAdsorbentTick(entity.field_70173_aa);
                float adsorbentFactor = adsorbent ? 1.0f - FogDamage.getFinalEfficiency(adsorbentTick ? 90.0f : 30.0f, concentration) : 1.0f;
                float rainDamage = rain ? FogDamage.getRainDamage(concentration) * depth / 4.0f : 0.0f;
                float fogDamage = FogDamage.getFogDamage(concentration) * depth / 4.0f;
                float toxic = FogDamage.getFogToxic(concentration) * depth / 4.0f;
                boolean pollutionTick = FogDamage.isPollutionTick(entity.field_70173_aa);
                boolean isMask = false;
                boolean pollutionProtection = false;
                float pollutionFactor = 1.0f;
                boolean suit = false;
                if (isPlayer) {
                    float[] suitFactor;
                    ItemStack mask = entity.func_184582_a(EntityEquipmentSlot.HEAD);
                    if (!IMask.isMask(mask) && mistCapa != null) {
                        mask = mistCapa.getMask();
                    }
                    if (IMask.isMask(mask) && !IMask.getFilter(mask).func_190926_b()) {
                        isMask = true;
                        float filteringDepth = IMask.damageFilter(mask, Math.round(FogDamage.getFilterDamage(concentration) * adsorbentFactor), mistCapa);
                        filteringDepth = 1.0f - FogDamage.getFinalEfficiency(filteringDepth, concentration);
                        fogDamage *= filteringDepth;
                        toxic *= filteringDepth;
                    }
                    if ((rainDamage > 0.0f || pollutionTick) && (suitFactor = FogDamage.getPollutionProtection(player))[0] > 0.0f) {
                        suit = suitFactor[0] == 4.0f;
                        pollutionProtection = true;
                        pollutionFactor -= FogDamage.getFinalEfficiency(suitFactor[1], concentration);
                        if (FogDamage.isPollutionProtectionTick(entity.field_70173_aa, (int)suitFactor[0], true)) {
                            rainDamage *= pollutionFactor;
                        }
                        boolean bl3 = rain = rainDamage >= 0.5f;
                        if (!FogDamage.isPollutionProtectionTick(entity.field_70173_aa, (int)suitFactor[0], false)) {
                            pollutionFactor = 1.0f;
                        }
                    }
                }
                float pollution = pollutionTick ? FogDamage.getPollution(concentration, rain) * depth / 4.0f : 0.0f;
                fogDamage *= adsorbentFactor;
                toxic *= adsorbentFactor;
                if (!rain) {
                    pollution *= adsorbentFactor;
                    pollution *= pollutionFactor;
                }
                PollutionEvent event = new PollutionEvent(entity, pollution, toxic, fogDamage, rainDamage);
                MinecraftForge.EVENT_BUS.post((Event)event);
                pollution = event.getPollution();
                toxic = event.getToxic();
                fogDamage = event.getFogDamage();
                rainDamage = event.getRainDamage();
                boolean damage = false;
                if (fogDamage > 0.0f) {
                    if (entity instanceof EntityPlayerMP) {
                        ModAdvancements.FOG_DAMAGE.trigger((EntityPlayerMP)entity, entity.field_70170_p, entity.func_180425_c(), FogDamagePredicate.FogDamageType.BY_FOG, concentration, isMask, suit, adsorbent);
                    }
                    if (!isMask && !adsorbentTick) {
                        entity.func_70097_a(MistWorld.IN_FOG, fogDamage);
                        damage = true;
                    } else if ((double)fogDamage >= 0.5) {
                        entity.func_70097_a(MistWorld.IN_FOG, fogDamage);
                        damage = true;
                    }
                }
                if (rainDamage > 0.0f) {
                    if (entity instanceof EntityPlayerMP) {
                        ModAdvancements.FOG_DAMAGE.trigger((EntityPlayerMP)entity, entity.field_70170_p, entity.func_180425_c(), FogDamagePredicate.FogDamageType.BY_RAIN, concentration, isMask, suit, adsorbent);
                    }
                    if (!pollutionProtection) {
                        entity.func_70097_a(MistWorld.DISSOLUTION, rainDamage);
                        damage = true;
                    } else if ((double)rainDamage >= 0.5) {
                        entity.func_70097_a(MistWorld.DISSOLUTION, rainDamage);
                        damage = true;
                    }
                }
                if (damage) {
                    entity.func_70604_c(entity);
                }
                if (mistCapa != null) {
                    if (toxic > 0.0f) {
                        mistCapa.addToxic(Math.round(toxic));
                    }
                    if (pollution > 0.0f) {
                        mistCapa.addPollution(Math.round(pollution));
                    }
                }
            } else if (mistCapa != null) {
                int clear;
                int n = !FogDamage.isRainTick(entity.field_70173_aa) ? 0 : (entity.field_70170_p.func_175727_C((BlockPos)pos) ? -10 : (clear = entity.field_70173_aa % 800 == 0 ? -1 : 0));
                if (!(entity.func_184187_bx() instanceof EntityBoat)) {
                    pos.func_189532_c(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                    AxisAlignedBB bb = entity.func_174813_aQ().func_72314_b(-0.1, -0.4, -0.1);
                    int minX = MathHelper.func_76128_c((double)bb.field_72340_a);
                    int maxX = MathHelper.func_76143_f((double)bb.field_72336_d);
                    int minY = MathHelper.func_76128_c((double)bb.field_72338_b);
                    int maxY = MathHelper.func_76143_f((double)bb.field_72337_e);
                    int minZ = MathHelper.func_76128_c((double)bb.field_72339_c);
                    int maxZ = MathHelper.func_76143_f((double)bb.field_72334_f);
                    block0: for (int x = minX; x < maxX; ++x) {
                        for (int y = minY; y < maxY; ++y) {
                            for (int z = minZ; z < maxZ; ++z) {
                                IBlockState state = entity.field_70170_p.func_180495_p((BlockPos)pos.func_181079_c(x, y, z));
                                if (state.func_185904_a() != Material.field_151586_h || state.func_177230_c() == MistBlocks.ACID_BLOCK) continue;
                                clear = -20;
                                break block0;
                            }
                        }
                    }
                }
                mistCapa.addPollution(clear);
                if (entity.field_70173_aa % 1000 == 0) {
                    mistCapa.addToxic(-1);
                }
            }
            if (isPlayer) {
                FogDamage.makeEffects(player, mistCapa.getToxic(), mistCapa.getPollution());
            }
            pos.func_185344_t();
        }
    }

    public static void makeEffects(EntityPlayer player, int toxic, int pollution) {
        int p;
        if (player instanceof EntityPlayerMP) {
            ModAdvancements.FOG_EFFECT.trigger((EntityPlayerMP)player, Float.valueOf(toxic), Float.valueOf(pollution));
        }
        IAttributeInstance boost = player.func_110148_a(SharedMonsterAttributes.field_111267_a);
        int t = toxic - 2000;
        if (t < 0) {
            t = 0;
        }
        t = t / 500 - 1;
        int healthDamage = -(t + 1);
        boost.func_188479_b(healthUUID);
        boost.func_111121_a(new AttributeModifier(healthUUID, "toxicDamage", (double)healthDamage, 0));
        if (player.func_110143_aJ() > player.func_110138_aP()) {
            player.func_70606_j(player.func_110138_aP());
        }
        if (player.field_70173_aa % 80 == 0 && toxic > 7500) {
            int a = (toxic - 7500) / 500;
            player.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 100, a, true, false));
            player.func_70690_d(new PotionEffect(MobEffects.field_76419_f, 100, a, true, false));
            player.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 100, a, true, false));
            if (toxic > 9000) {
                if (player.func_70681_au().nextInt(10) == 0) {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, player.func_70681_au().nextInt(200) + 100, 0, true, false));
                }
                if (toxic > 9900) {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 100, 0, true, false));
                }
            }
        }
        if ((p = Math.max((10000 - pollution) / 100, 1)) < 80 && player.field_70173_aa % (p * 20) == 0 && player.func_110143_aJ() > 1.0f) {
            player.func_70097_a(MistWorld.DISSOLUTION, 1.0f);
        }
    }

    public static float getFogDamage(float concentration) {
        return 1.0f + 4.0f * concentration;
    }

    public static float getFogToxic(float concentration) {
        return 40.0f + 60.0f * concentration;
    }

    public static float getFilterDamage(float concentration) {
        return 1.0f + 20.0f * concentration;
    }

    public static float getRainDamage(float concentration) {
        return 1.0f + 2.0f * concentration;
    }

    public static float getPollution(float concentration, boolean rain) {
        return (1.0f + 20.0f * concentration) * (float)(rain ? 100 : 1);
    }

    public static float getAcidDamage(float concentration) {
        if (concentration < 0.5f) {
            return 2.0f;
        }
        return 4.0f * concentration;
    }

    public static float getAcidPollution(float concentration) {
        if (concentration < 0.5f) {
            return 128.0f;
        }
        return 256.0f * concentration;
    }

    public static float getConcentration(World world, BlockPos pos) {
        return FogDamage.getConcentration(world, pos, false);
    }

    public static float getConcentration(World world, BlockPos pos, boolean client) {
        double dist = client ? pos.func_177951_i((Vec3i)MistWorld.getCenterPos(pos, false)) : pos.func_177951_i((Vec3i)MistWorld.getCenterPos(world, pos, false));
        boolean main = false;
        if (dist > 160000.0) {
            dist = client ? pos.func_177951_i((Vec3i)MistWorld.getCenterPos(pos, true)) : pos.func_177951_i((Vec3i)MistWorld.getCenterPos(world, pos, true));
            main = true;
        }
        if (dist > 640000.0) {
            dist = -1.0;
        }
        if (dist > 0.0) {
            dist = Math.sqrt(dist);
        }
        return dist < 0.0 ? 0.0f : (main ? (float)Math.min(400.0, 800.0 - dist) / 400.0f : (float)Math.min(200.0, 400.0 - dist) / 400.0f);
    }

    public static float getFinalEfficiency(float quality, float concentration) {
        concentration = MathHelper.func_76131_a((float)concentration, (float)0.0f, (float)1.0f);
        concentration = (float)Math.pow(concentration, 2.0) / 2.0f + 0.03f;
        quality = MathHelper.func_76131_a((float)quality, (float)0.0f, (float)100.0f);
        return (float)Math.pow(Math.pow(MathHelper.func_76134_b((float)concentration), Math.pow(100.0f - quality, 2.0)) - 1.0, 3.0) + 1.0f;
    }

    public static float[] getPollutionProtection(EntityPlayer player) {
        float protection = 0.0f;
        int count = 0;
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            if (slot.func_188453_a() != EntityEquipmentSlot.Type.ARMOR) continue;
            ItemStack armor = player.func_184582_a(slot);
            if (armor.func_77973_b() instanceof ISuit) {
                protection += ((ISuit)armor.func_77973_b()).getPollutionProtection();
                ++count;
                continue;
            }
            NBTTagCompound tag = armor.func_179543_a("MistInnerSuit");
            if (tag == null) continue;
            armor = new ItemStack(tag);
            if (armor.func_77973_b() instanceof ISuit) {
                protection += ((ISuit)armor.func_77973_b()).getPollutionProtection();
            }
            ++count;
        }
        if (count != 0) {
            protection /= (float)count;
        }
        return new float[]{count, protection};
    }

    public static boolean isAdsorbentNear(World world, BlockPos pos) {
        BlockPos.PooledMutableBlockPos pmPos = BlockPos.PooledMutableBlockPos.func_185346_s();
        for (int x = -1; x < 2; ++x) {
            for (int y = -1; y < 2; ++y) {
                for (int z = -1; z < 2; ++z) {
                    pmPos.func_181079_c(pos.func_177958_n() + x, pos.func_177956_o() + y, pos.func_177952_p() + z);
                    IBlockState state = world.func_180495_p((BlockPos)pmPos);
                    if (!(state.func_177230_c() instanceof IMistAdsorbent) || !((IMistAdsorbent)state.func_177230_c()).isMistAdsorbent(world, (BlockPos)pmPos, state)) continue;
                    return true;
                }
            }
        }
        pmPos.func_185344_t();
        return false;
    }

    public static boolean isDamageTick(int ticksExisted) {
        return ticksExisted % 20 == 0;
    }

    public static boolean isRainTick(int ticksExisted) {
        return ticksExisted % 80 == 0;
    }

    public static boolean isPollutionTick(int ticksExisted) {
        return ticksExisted % 40 == 0;
    }

    public static boolean isPollutionProtectionTick(int ticksExisted, int count, boolean rain) {
        if (count == 0) {
            return false;
        }
        if (count > 4) {
            count = 4;
        }
        return rain ? ticksExisted % (400 - 80 * count) == 0 : ticksExisted % (200 - 40 * count) == 0;
    }

    public static boolean isAdsorbentTick(int ticksExisted) {
        return (ticksExisted + 40) % 80 != 0;
    }
}

