/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.world;

import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.terraingen.InitNoiseGensEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import ru.liahim.mist.api.biome.MistBiomes;
import ru.liahim.mist.init.ModConfig;
import ru.liahim.mist.world.MistWorld;
import ru.liahim.mist.world.biome.BiomeMistBorder;
import ru.liahim.mist.world.biome.BiomeMistBorderDown;
import ru.liahim.mist.world.biome.BiomeMistBorderUp;
import ru.liahim.mist.world.biome.BiomeMistUp;
import ru.liahim.mist.world.mapgen.MistCavesGen;
import ru.liahim.mist.world.mapgen.MistRavineGen;

public class ChunkProviderMist
implements IChunkGenerator {
    private final Random rand;
    private NoiseGeneratorOctaves minLimitPerlinNoise;
    private NoiseGeneratorOctaves maxLimitPerlinNoise;
    private NoiseGeneratorOctaves mainPerlinNoise;
    private NoiseGeneratorPerlin surfaceNoise;
    public NoiseGeneratorOctaves scaleNoise;
    public NoiseGeneratorOctaves depthNoise;
    public NoiseGeneratorOctaves forestNoise;
    private final World world;
    private final double[] heightMap;
    private final float[] biomeWeights;
    private double[] depthBuffer = new double[256];
    private MistCavesGen caveGenerator;
    private MistRavineGen ravineGenerator;
    private Biome[] biomesForGeneration;
    double[] mainNoiseRegion;
    double[] swampNoiseRegion;
    double[] minLimitRegion;
    double[] maxLimitRegion;
    double[] depthRegion;
    double[] swampDepthRegion;
    private float mainNoiseScaleX = 80.0f;
    private float mainNoiseScaleY = 160.0f;
    private float mainNoiseScaleZ = 80.0f;
    private float swampNoiseScaleX = 20.0f;
    private float swampNoiseScaleY = 80.0f;
    private float swampNoiseScaleZ = 20.0f;
    private double depthNoiseScaleX = 200.0;
    private double depthNoiseScaleZ = 200.0;
    private double depthNoiseScaleExponent = 0.5;
    private float coordinateScale = 684.412f;
    private float heightScale = 684.412f;
    private float baseSize = 8.5f;
    private float stretchY = 12.0f;
    private float upperLimitScale = 512.0f;
    private float lowerLimitScale = 512.0f;
    private boolean useCaves = true;
    private boolean useRavines = true;

    public ChunkProviderMist(World worldIn, long seed, boolean mapFeaturesEnabledIn) {
        this.world = worldIn;
        this.rand = new Random(seed);
        this.caveGenerator = new MistCavesGen();
        this.ravineGenerator = new MistRavineGen();
        this.minLimitPerlinNoise = new NoiseGeneratorOctaves(this.rand, 16);
        this.maxLimitPerlinNoise = new NoiseGeneratorOctaves(this.rand, 16);
        this.mainPerlinNoise = new NoiseGeneratorOctaves(this.rand, 8);
        this.surfaceNoise = new NoiseGeneratorPerlin(this.rand, 4);
        this.scaleNoise = new NoiseGeneratorOctaves(this.rand, 10);
        this.depthNoise = new NoiseGeneratorOctaves(this.rand, 16);
        this.forestNoise = new NoiseGeneratorOctaves(this.rand, 8);
        this.heightMap = new double[825];
        this.biomeWeights = new float[25];
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                float f;
                this.biomeWeights[i + 2 + (j + 2) * 5] = f = 10.0f / MathHelper.func_76129_c((float)((float)(i * i + j * j) + 0.2f));
            }
        }
        InitNoiseGensEvent.ContextOverworld ctx = new InitNoiseGensEvent.ContextOverworld(this.minLimitPerlinNoise, this.maxLimitPerlinNoise, this.mainPerlinNoise, this.surfaceNoise, this.scaleNoise, this.depthNoise, this.forestNoise);
        this.minLimitPerlinNoise = ctx.getLPerlin1();
        this.maxLimitPerlinNoise = ctx.getLPerlin2();
        this.mainPerlinNoise = ctx.getPerlin();
        this.surfaceNoise = ctx.getHeight();
        this.scaleNoise = ctx.getScale();
        this.depthNoise = ctx.getDepth();
        this.forestNoise = ctx.getForest();
    }

    public Chunk func_185932_a(int chunkX, int chunkZ) {
        this.rand.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        ChunkPrimer chunkprimer = new ChunkPrimer();
        this.setBlocksInChunk(chunkX, chunkZ, chunkprimer);
        this.biomesForGeneration = this.world.func_72959_q().func_76933_b(this.biomesForGeneration, chunkX * 16, chunkZ * 16, 16, 16);
        this.replaceBiomeBlocks(chunkX, chunkZ, chunkprimer, this.biomesForGeneration);
        boolean check = false;
        for (int i = 0; i < this.biomesForGeneration.length; ++i) {
            if (!(this.biomesForGeneration[i] instanceof BiomeMistBorder)) continue;
            check = true;
        }
        if (check) {
            this.erosionBorder(chunkX, chunkZ, chunkprimer);
        }
        if (this.useCaves) {
            this.caveGenerator.func_186125_a(this.world, chunkX, chunkZ, chunkprimer);
        }
        if (this.useRavines) {
            this.ravineGenerator.func_186125_a(this.world, chunkX, chunkZ, chunkprimer);
        }
        Chunk chunk = new Chunk(this.world, chunkprimer, chunkX, chunkZ);
        byte[] abyte = chunk.func_76605_m();
        for (int i = 0; i < abyte.length; ++i) {
            abyte[i] = (byte)Biome.func_185362_a((Biome)this.biomesForGeneration[i]);
        }
        chunk.func_76603_b();
        return chunk;
    }

    public void setBlocksInChunk(int chunkX, int chunkZ, ChunkPrimer primer) {
        this.biomesForGeneration = this.world.func_72959_q().func_76937_a(this.biomesForGeneration, chunkX * 4 - 2, chunkZ * 4 - 2, 10, 10);
        this.generateHeightmap(chunkX * 4, 0, chunkZ * 4);
        for (int i = 0; i < 4; ++i) {
            int j = i * 5;
            int k = (i + 1) * 5;
            for (int l = 0; l < 4; ++l) {
                int i1 = (j + l) * 33;
                int j1 = (j + l + 1) * 33;
                int k1 = (k + l) * 33;
                int l1 = (k + l + 1) * 33;
                for (int i2 = 0; i2 < 32; ++i2) {
                    double d0 = 0.125;
                    double d1 = this.heightMap[i1 + i2];
                    double d2 = this.heightMap[j1 + i2];
                    double d3 = this.heightMap[k1 + i2];
                    double d4 = this.heightMap[l1 + i2];
                    double d5 = (this.heightMap[i1 + i2 + 1] - d1) * 0.125;
                    double d6 = (this.heightMap[j1 + i2 + 1] - d2) * 0.125;
                    double d7 = (this.heightMap[k1 + i2 + 1] - d3) * 0.125;
                    double d8 = (this.heightMap[l1 + i2 + 1] - d4) * 0.125;
                    for (int j2 = 0; j2 < 8; ++j2) {
                        double d9 = 0.25;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * 0.25;
                        double d13 = (d4 - d2) * 0.25;
                        for (int k2 = 0; k2 < 4; ++k2) {
                            double d14 = 0.25;
                            double d16 = (d11 - d10) * 0.25;
                            double lvt_45_1_ = d10 - d16;
                            for (int l2 = 0; l2 < 4; ++l2) {
                                double d;
                                lvt_45_1_ += d16;
                                if (d > 0.0) {
                                    primer.func_177855_a(i * 4 + k2, i2 * 8 + j2, l * 4 + l2, MistWorld.worldStone);
                                    continue;
                                }
                                if (i2 * 8 + j2 >= 36) continue;
                                primer.func_177855_a(i * 4 + k2, i2 * 8 + j2, l * 4 + l2, MistWorld.waterBlockLower);
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    private void generateHeightmap(int chunkX, int zero, int chunkZ) {
        this.depthRegion = this.depthNoise.func_76305_a(this.depthRegion, chunkX, chunkZ, 5, 5, this.depthNoiseScaleX, this.depthNoiseScaleZ, this.depthNoiseScaleExponent);
        float f = this.coordinateScale;
        float f1 = this.heightScale;
        this.mainNoiseRegion = this.mainPerlinNoise.func_76304_a(this.mainNoiseRegion, chunkX, zero, chunkZ, 5, 33, 5, (double)(f / this.mainNoiseScaleX), (double)(f1 / this.mainNoiseScaleY), (double)(f / this.mainNoiseScaleZ));
        this.swampNoiseRegion = this.mainPerlinNoise.func_76304_a(this.swampNoiseRegion, chunkX, zero, chunkZ, 5, 33, 5, (double)(f / this.swampNoiseScaleX), (double)(f1 / this.swampNoiseScaleY), (double)(f / this.swampNoiseScaleZ));
        this.minLimitRegion = this.minLimitPerlinNoise.func_76304_a(this.minLimitRegion, chunkX, zero, chunkZ, 5, 33, 5, (double)f, (double)f1, (double)f);
        this.maxLimitRegion = this.maxLimitPerlinNoise.func_76304_a(this.maxLimitRegion, chunkX, zero, chunkZ, 5, 33, 5, (double)f, (double)f1, (double)f);
        int i = 0;
        int j = 0;
        for (int k = 0; k < 5; ++k) {
            for (int l = 0; l < 5; ++l) {
                double depth;
                float heightVar = 0.0f;
                float baseHeight = 0.0f;
                float biomeWeight = 0.0f;
                Biome biome = this.biomesForGeneration[k + 2 + (l + 2) * 10];
                boolean swampUp = biome == MistBiomes.upSwamp;
                boolean swampDown = biome == MistBiomes.downSwamp;
                boolean borderUp = biome instanceof BiomeMistBorderUp;
                boolean borderDown = biome instanceof BiomeMistBorderDown;
                boolean upBiome = biome instanceof BiomeMistUp;
                boolean dunes = biome == MistBiomes.upDunes;
                float swampDownWeight = 0.0f;
                float swampUpWeight = 0.0f;
                float dunesWeight = 0.0f;
                int smoothRadius = borderUp ? 1 : 2;
                for (int k1 = -smoothRadius; k1 <= smoothRadius; ++k1) {
                    for (int l1 = -smoothRadius; l1 <= smoothRadius; ++l1) {
                        Biome biome1 = this.biomesForGeneration[k + k1 + 2 + (l + l1 + 2) * 10];
                        float baseHeight1 = biome1.func_185355_j();
                        float heightVar1 = biome1.func_185360_m();
                        float biomeWeight1 = this.biomeWeights[k1 + 2 + (l1 + 2) * 5] / (baseHeight1 + 2.0f);
                        if (borderUp) {
                            if (biome1.func_185355_j() < biome.func_185355_j()) {
                                biomeWeight1 /= 3.0f;
                            }
                        } else if (borderDown) {
                            if (biome1.func_185355_j() > biome.func_185355_j()) {
                                biomeWeight1 *= 2.0f;
                            }
                        } else if (upBiome) {
                            if (biome1 instanceof BiomeMistBorderUp) {
                                biomeWeight1 *= 4.0f;
                            }
                        } else if (biome1.func_185355_j() > biome.func_185355_j()) {
                            biomeWeight1 /= 2.0f;
                        }
                        if (!swampDown && biome1 == MistBiomes.downSwamp) {
                            swampDownWeight = Math.max(swampDownWeight, biomeWeight1);
                        } else if (swampDown && biome1 != MistBiomes.downSwamp) {
                            swampDownWeight = Math.min(swampDownWeight, -biomeWeight1);
                        }
                        if (!swampUp && biome1 == MistBiomes.upSwamp) {
                            swampUpWeight = Math.max(swampUpWeight, biomeWeight1);
                        } else if (swampUp && biome1 != MistBiomes.upSwamp) {
                            swampUpWeight = Math.min(swampUpWeight, -biomeWeight1);
                        }
                        if (!dunes && biome1 == MistBiomes.upDunes) {
                            dunesWeight = Math.max(dunesWeight, biomeWeight1);
                        } else if (dunes && biome1 != MistBiomes.upDunes) {
                            dunesWeight = Math.min(dunesWeight, -biomeWeight1);
                        }
                        heightVar += heightVar1 * biomeWeight1;
                        baseHeight += baseHeight1 * biomeWeight1;
                        biomeWeight += biomeWeight1;
                    }
                }
                heightVar /= biomeWeight;
                baseHeight /= biomeWeight;
                heightVar = heightVar * 0.9f + 0.1f;
                baseHeight = (baseHeight * 4.0f - 1.0f) / 8.0f;
                if (swampUp || swampDown || dunes) {
                    depth = 0.0;
                } else {
                    depth = this.depthRegion[j] / 8000.0;
                    if (depth < 0.0) {
                        depth = -depth * 0.3;
                    }
                    if ((depth = depth * 3.0 - 2.0) < 0.0) {
                        if ((depth /= 2.0) < -1.0) {
                            depth = -1.0;
                        }
                        depth /= 1.4;
                        depth /= 2.0;
                    } else {
                        if (depth > 1.0) {
                            depth = 1.0;
                        }
                        depth /= 8.0;
                    }
                }
                ++j;
                double d8 = baseHeight;
                double d9 = heightVar;
                d8 += depth * 0.2;
                d8 = d8 * (double)this.baseSize / 8.0;
                double d0 = (double)this.baseSize + d8 * 4.0;
                for (int l2 = 0; l2 < 33; ++l2) {
                    double d1 = ((double)l2 - d0) * (double)this.stretchY * 128.0 / 256.0 / d9;
                    if (d1 < 0.0) {
                        d1 *= 4.0;
                    }
                    double d2 = this.minLimitRegion[i] / (double)this.lowerLimitScale;
                    double d3 = this.maxLimitRegion[i] / (double)this.upperLimitScale;
                    double d4 = ((swampUp || swampDown ? this.swampNoiseRegion[i] + (double)(swampUp ? 30 : 10) : this.mainNoiseRegion[i]) / 10.0 + 1.0) / 2.0;
                    double d2_X = d2;
                    double d3_X = d3;
                    double d4_X = d4;
                    if (borderUp) {
                        if (d2 < 0.0) {
                            d2 /= 2.0;
                        }
                        if (d2 < -50.0) {
                            d2 = -50.0;
                        }
                    }
                    if (swampDown || swampDownWeight > 0.0f) {
                        if ((d2_X *= 4.0) > -60.0) {
                            d2_X = -60.0;
                        }
                        if (d3_X > 20.0) {
                            d3_X = 10.0;
                        }
                        if (d4_X > 0.0) {
                            d4_X /= 4.0;
                        }
                        if (swampDownWeight > 0.0f) {
                            d2_X = (d2_X * (double)swampDownWeight + d2 * (double)(100.0f - swampDownWeight)) / 100.0;
                            d3_X = (d3_X * (double)swampDownWeight + d3 * (double)(100.0f - swampDownWeight)) / 100.0;
                            d4_X = (d4_X * (double)swampDownWeight + d4 * (double)(100.0f - swampDownWeight)) / 100.0;
                        } else if (swampDownWeight < 0.0f) {
                            d2_X = (d2_X * (double)(100.0f + swampDownWeight) + d2 * (double)(-swampDownWeight)) / 100.0;
                            d3_X = (d3_X * (double)(100.0f + swampDownWeight) + d3 * (double)(-swampDownWeight)) / 100.0;
                            d4_X = (d4_X * (double)(100.0f + swampDownWeight) + d4 * (double)(-swampDownWeight)) / 100.0;
                        }
                        d2 = d2_X;
                        d3 = d3_X;
                        d4 = d4_X;
                    } else if (swampUp || swampUpWeight > 0.0f) {
                        d2_X = -100.0;
                        d3_X = d3_X > 20.0 ? 20.0 : (d3_X < -20.0 ? -20.0 : 0.0);
                        if (swampUpWeight > 0.0f) {
                            d2_X = (d2_X * (double)swampUpWeight + d2 * (double)(5.0f - swampUpWeight)) / 5.0;
                            d3_X = (d3_X * (double)swampUpWeight + d3 * (double)(5.0f - swampUpWeight)) / 5.0;
                        } else if (swampUpWeight < 0.0f) {
                            d2_X = (d2_X * (double)(10.0f + swampUpWeight) + d2 * (double)(-swampUpWeight)) / 10.0;
                            d3_X = (d3_X * (double)(10.0f + swampUpWeight) + d3 * (double)(-swampUpWeight)) / 10.0;
                        }
                        d2 = d2_X;
                        d3 = d3_X;
                    } else if (dunes || dunesWeight > 0.0f) {
                        if (d4_X < 0.0) {
                            d4_X = -d4_X;
                        }
                        d3_X = (d3_X + d4_X + 160.0) / 4.0 + 20.0;
                        d4_X /= 7.0;
                        if (dunesWeight > 0.0f) {
                            d3_X = (d3_X * (double)dunesWeight + d3 * (double)(2.0f - dunesWeight)) / 2.0;
                            d4_X = (d4_X * (double)dunesWeight + d4 * (double)(2.0f - dunesWeight)) / 2.0;
                        } else if (dunesWeight < 0.0f) {
                            d3_X = (d3_X * (double)(20.0f + dunesWeight) + d3 * (double)(-dunesWeight)) / 20.0;
                            d4_X = (d4_X * (double)(20.0f + dunesWeight) + d4 * (double)(-dunesWeight)) / 20.0;
                        }
                        d3 = d3_X;
                        d4 = d4_X;
                    }
                    double d5 = MathHelper.func_151238_b((double)d2, (double)d3, (double)d4) - d1;
                    if (l2 > 29) {
                        double d6 = (float)(l2 - 29) / 3.0f;
                        d5 = d5 * (1.0 - d6) + -10.0 * d6;
                    }
                    this.heightMap[i] = d5;
                    ++i;
                }
            }
        }
    }

    public void replaceBiomeBlocks(int chunkX, int chunkZ, ChunkPrimer primer, Biome[] biomesIn) {
        if (!ForgeEventFactory.onReplaceBiomeBlocks((IChunkGenerator)this, (int)chunkX, (int)chunkZ, (ChunkPrimer)primer, (World)this.world)) {
            return;
        }
        double d0 = 0.03125;
        this.depthBuffer = this.surfaceNoise.func_151599_a(this.depthBuffer, (double)(chunkX * 16), (double)(chunkZ * 16), 16, 16, d0 * 2.0, d0 * 2.0, 1.0);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                Biome biome = biomesIn[z + x * 16];
                biome.func_180622_a(this.world, this.rand, primer, chunkX * 16 + x, chunkZ * 16 + z, this.depthBuffer[z + x * 16]);
            }
        }
    }

    public void erosionBorder(int chunkX, int chunkZ, ChunkPrimer primer) {
        IBlockState block;
        int y;
        int z;
        int x;
        for (x = 0; x < 16; ++x) {
            for (z = 0; z < 16; ++z) {
                for (y = 26; y <= 108; ++y) {
                    block = primer.func_177856_a(x, y, z);
                    if (block != MistWorld.worldStone && block != MistWorld.gravelBlock || !(x > 0 && primer.func_177856_a(x - 1, y, z) == Blocks.field_150350_a.func_176223_P() || x < 15 && primer.func_177856_a(x + 1, y, z) == Blocks.field_150350_a.func_176223_P() || z > 0 && primer.func_177856_a(x, y, z - 1) == Blocks.field_150350_a.func_176223_P()) && (z >= 15 || primer.func_177856_a(x, y, z + 1) != Blocks.field_150350_a.func_176223_P())) continue;
                    if (this.rand.nextInt(3) == 0) {
                        primer.func_177855_a(x, y, z, Blocks.field_150426_aN.func_176223_P());
                        continue;
                    }
                    if (this.rand.nextInt(3) != 0) continue;
                    primer.func_177855_a(x, y, z, MistWorld.gravelBlock);
                }
            }
        }
        for (x = 0; x < 16; ++x) {
            for (z = 0; z < 16; ++z) {
                for (y = 26; y <= 108; ++y) {
                    block = primer.func_177856_a(x, y, z);
                    if (block != Blocks.field_150426_aN.func_176223_P()) continue;
                    primer.func_177855_a(x, y, z, Blocks.field_150350_a.func_176223_P());
                }
            }
        }
    }

    public void func_185931_b(int x, int z) {
        if (ModConfig.dimension.disableCascadingLog) {
            ForgeModContainer.logCascadingWorldGeneration = false;
        }
        BlockFalling.field_149832_M = true;
        int i = x * 16;
        int j = z * 16;
        BlockPos blockpos = new BlockPos(i, 0, j);
        Biome biome = this.world.func_180494_b(blockpos.func_177982_a(16, 0, 16));
        this.rand.setSeed(this.world.func_72905_C());
        long k = this.rand.nextLong() / 2L * 2L + 1L;
        long l = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)x * k + (long)z * l ^ this.world.func_72905_C());
        boolean flag = false;
        ForgeEventFactory.onChunkPopulate((boolean)true, (IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)flag);
        biome.func_180624_a(this.world, this.rand, new BlockPos(i, 0, j));
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ANIMALS)) {
            WorldEntitySpawner.func_77191_a((World)this.world, (Biome)biome, (int)(i + 8), (int)(j + 8), (int)16, (int)16, (Random)this.rand);
        }
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ICE)) {
            for (int x1 = 0; x1 < 16; ++x1) {
                for (int z1 = 0; z1 < 16; ++z1) {
                    BlockPos blockpos1 = this.world.func_175725_q(blockpos.func_177982_a(x1, 0, z1));
                    BlockPos blockpos2 = blockpos1.func_177977_b();
                    if (this.world.func_175675_v(blockpos2)) {
                        this.world.func_180501_a(blockpos2, Blocks.field_150432_aD.func_176223_P(), 18);
                    }
                    if (!this.world.func_175708_f(blockpos1, true)) continue;
                    this.world.func_180501_a(blockpos1, Blocks.field_150431_aC.func_176223_P(), 18);
                }
            }
        }
        MistWorld.seasonalTest(this.world.func_72964_e(x, z));
        ForgeEventFactory.onChunkPopulate((boolean)false, (IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)flag);
        BlockFalling.field_149832_M = false;
    }

    public boolean func_185933_a(Chunk chunk, int x, int z) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        Biome biome = this.world.func_180494_b(pos);
        if (pos.func_177956_o() > MistWorld.getFogMaxHight()) {
            return biome.func_76747_a(creatureType);
        }
        return null;
    }

    public void func_180514_a(Chunk chunk, int x, int z) {
    }

    public BlockPos func_180513_a(World world, String structureName, BlockPos position, boolean findUnexplored) {
        return null;
    }

    public boolean func_193414_a(World world, String structureName, BlockPos pos) {
        return false;
    }
}

