/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.world;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.init.Biomes;
import net.minecraft.util.ReportedException;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeCache;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;
import net.minecraft.world.storage.WorldInfo;
import ru.liahim.mist.api.biome.MistBiomes;
import ru.liahim.mist.world.layer.GenLayerMist;

public class BiomeProviderMist
extends BiomeProvider {
    public static List<Biome> allowedBiomes = Lists.newArrayList((Object[])new Biome[]{MistBiomes.upMeadow, MistBiomes.upForest, MistBiomes.upDenseForest, MistBiomes.upSavanna, MistBiomes.upDesert, MistBiomes.upDunes, MistBiomes.upSnowfields, MistBiomes.upTaiga, MistBiomes.upHillyTaiga, MistBiomes.upSwamp, MistBiomes.upSwampyMeadow, MistBiomes.upSwampyForest, MistBiomes.upJungle, MistBiomes.upJungleEdge, MistBiomes.upJungleHills, MistBiomes.upTaiga});
    private GenLayer genBiomes;
    private GenLayer biomeIndexLayer;
    private final BiomeCache biomeCache = new BiomeCache((BiomeProvider)this);
    private final List<Biome> biomesToSpawnIn = Lists.newArrayList(allowedBiomes);

    protected BiomeProviderMist() {
    }

    private BiomeProviderMist(long seed, WorldType worldType, String options) {
        this();
        GenLayer[] agenlayer = GenLayerMist.initializeAllBiomeGenerators(seed, worldType, options);
        this.genBiomes = agenlayer[0];
        this.biomeIndexLayer = agenlayer[1];
    }

    public BiomeProviderMist(long seed, WorldInfo info) {
        this(seed, info.func_76067_t(), info.func_82571_y());
    }

    public List<Biome> func_76932_a() {
        return this.biomesToSpawnIn;
    }

    public Biome func_180300_a(BlockPos pos, Biome defaultBiome) {
        return this.biomeCache.func_180284_a(pos.func_177958_n(), pos.func_177952_p(), defaultBiome);
    }

    public Biome[] func_76937_a(Biome[] biomes, int x, int z, int width, int height) {
        IntCache.func_76446_a();
        if (biomes == null || biomes.length < width * height) {
            biomes = new Biome[width * height];
        }
        int[] aint = this.genBiomes.func_75904_a(x, z, width, height);
        try {
            for (int i = 0; i < width * height; ++i) {
                biomes[i] = Biome.func_180276_a((int)aint[i], (Biome)Biomes.field_180279_ad);
            }
            return biomes;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Invalid Biome id");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("RawBiomeBlock");
            crashreportcategory.func_71507_a("biomes[] size", (Object)biomes.length);
            crashreportcategory.func_71507_a("x", (Object)x);
            crashreportcategory.func_71507_a("z", (Object)z);
            crashreportcategory.func_71507_a("w", (Object)width);
            crashreportcategory.func_71507_a("h", (Object)height);
            throw new ReportedException(crashreport);
        }
    }

    public Biome[] func_76931_a(@Nullable Biome[] listToReuse, int x, int z, int width, int length, boolean cacheFlag) {
        IntCache.func_76446_a();
        if (listToReuse == null || listToReuse.length < width * length) {
            listToReuse = new Biome[width * length];
        }
        if (cacheFlag && width == 16 && length == 16 && (x & 0xF) == 0 && (z & 0xF) == 0) {
            Biome[] abiome = this.biomeCache.func_76839_e(x, z);
            System.arraycopy(abiome, 0, listToReuse, 0, width * length);
            return listToReuse;
        }
        int[] aint = this.biomeIndexLayer.func_75904_a(x, z, width, length);
        for (int i = 0; i < width * length; ++i) {
            listToReuse[i] = Biome.func_180276_a((int)aint[i], (Biome)MistBiomes.down);
        }
        return listToReuse;
    }

    public boolean func_76940_a(int x, int z, int radius, List<Biome> allowed) {
        IntCache.func_76446_a();
        int i = x - radius >> 2;
        int j = z - radius >> 2;
        int k = x + radius >> 2;
        int l = z + radius >> 2;
        int i1 = k - i + 1;
        int j1 = l - j + 1;
        int[] aint = this.genBiomes.func_75904_a(i, j, i1, j1);
        try {
            for (int k1 = 0; k1 < i1 * j1; ++k1) {
                Biome biome = Biome.func_150568_d((int)aint[k1]);
                if (allowed.contains(biome)) continue;
                return false;
            }
            return true;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Invalid Biome id");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Layer");
            crashreportcategory.func_71507_a("Layer", (Object)this.genBiomes.toString());
            crashreportcategory.func_71507_a("x", (Object)x);
            crashreportcategory.func_71507_a("z", (Object)z);
            crashreportcategory.func_71507_a("radius", (Object)radius);
            crashreportcategory.func_71507_a("allowed", allowed);
            throw new ReportedException(crashreport);
        }
    }

    @Nullable
    public BlockPos func_180630_a(int x, int z, int range, List<Biome> biomes, Random random) {
        IntCache.func_76446_a();
        int i = x - range >> 2;
        int j = z - range >> 2;
        int k = x + range >> 2;
        int l = z + range >> 2;
        int i1 = k - i + 1;
        int j1 = l - j + 1;
        int[] aint = this.genBiomes.func_75904_a(i, j, i1, j1);
        BlockPos blockpos = null;
        int k1 = 0;
        for (int l1 = 0; l1 < i1 * j1; ++l1) {
            int i2 = i + l1 % i1 << 2;
            int j2 = j + l1 / i1 << 2;
            Biome biome = Biome.func_150568_d((int)aint[l1]);
            if (!biomes.contains(biome) || blockpos != null && random.nextInt(k1 + 1) != 0) continue;
            blockpos = new BlockPos(i2, 0, j2);
            ++k1;
        }
        return blockpos;
    }

    public void func_76938_b() {
        this.biomeCache.func_76838_a();
    }
}

