/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.util;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;
import ru.liahim.mist.common.MistTime;
import ru.liahim.mist.handlers.ServerEventHandler;

public class TimeData
extends WorldSavedData {
    private static final String DATA_NAME = "MistTime";
    private static NBTTagCompound tag = new NBTTagCompound();

    public TimeData(String identifier) {
        super(identifier);
    }

    public void func_76184_a(NBTTagCompound nbt) {
        if (nbt.func_74764_b(DATA_NAME)) {
            tag = nbt.func_74775_l(DATA_NAME);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        nbt.func_74782_a(DATA_NAME, (NBTBase)tag);
        return nbt;
    }

    public void setTime(int day, int month, int year, long offset) {
        tag.func_74768_a("Day", day);
        tag.func_74768_a("Month", month);
        tag.func_74768_a("Year", year);
        tag.func_74772_a("Offset", offset);
        this.func_76185_a();
    }

    public void loadTime() {
        if (tag.func_74764_b("Year")) {
            int day = tag.func_74762_e("Day");
            int month = tag.func_74762_e("Month");
            int year = tag.func_74762_e("Year");
            long offset = tag.func_74763_f("Offset");
            if (day >= MistTime.getDayInMonth()) {
                day = MistTime.getDayInMonth() - 1;
                this.setTime(day, month, year, offset);
            }
            MistTime.setTime(day, month, year, offset);
        } else {
            MistTime.setTime(0, 0, 0, 0L);
            this.setTime(0, 0, 0, 0L);
        }
    }

    public void setSoundsTime(long sky_last, long sky_interval, long boom_last, long boom_interval) {
        tag.func_74772_a("SkySoundLastTime", sky_last);
        tag.func_74772_a("SkySoundInterval", sky_interval);
        tag.func_74772_a("SkyBoomLastTime", boom_last);
        tag.func_74772_a("SkyBoomInterval", boom_interval);
        this.func_76185_a();
    }

    public void getSoundsTime() {
        ServerEventHandler.setSoundsTime(tag.func_74763_f("SkySoundLastTime"), tag.func_74763_f("SkySoundInterval"), tag.func_74763_f("SkyBoomLastTime"), tag.func_74763_f("SkyBoomInterval"));
    }

    public static TimeData get(World world) {
        MapStorage storage = world.func_175693_T();
        TimeData instance = (TimeData)storage.func_75742_a(TimeData.class, DATA_NAME);
        if (instance == null) {
            instance = new TimeData(DATA_NAME);
            storage.func_75745_a(DATA_NAME, (WorldSavedData)instance);
        }
        return instance;
    }
}

