/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.HashMap;
import javax.vecmath.Vector4f;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;
import ru.liahim.mist.common.Mist;

public class PortalCoordData
extends WorldSavedData {
    private static final String DATA_NAME = "MistPortalCoords";
    private static NBTTagCompound tag = new NBTTagCompound();
    private static HashMap<String, String> portalCoord = new HashMap();
    private static Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public PortalCoordData(String identifier) {
        super(identifier);
    }

    public void func_76184_a(NBTTagCompound nbt) {
        if (nbt.func_74764_b(DATA_NAME)) {
            tag = nbt.func_74775_l(DATA_NAME);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        nbt.func_74782_a(DATA_NAME, (NBTBase)tag);
        return nbt;
    }

    public void addCoords(int dimIn, BlockPos in, int dimOut, BlockPos out) {
        portalCoord.clear();
        if (tag.func_74764_b(String.valueOf(dimIn))) {
            portalCoord = (HashMap)gson.fromJson(tag.func_74779_i(String.valueOf(dimIn)), HashMap.class);
        }
        portalCoord.put(gson.toJson((Object)in), gson.toJson((Object)new Vector4f((float)out.func_177958_n(), (float)out.func_177956_o(), (float)out.func_177952_p(), (float)dimOut)));
        tag.func_74778_a(String.valueOf(dimIn), gson.toJson(portalCoord));
        this.func_76185_a();
    }

    public BlockPos getCoords(int dimIn, BlockPos in) {
        if (tag.func_74764_b(String.valueOf(dimIn))) {
            portalCoord = (HashMap)gson.fromJson(tag.func_74779_i(String.valueOf(dimIn)), HashMap.class);
            return (BlockPos)gson.fromJson(portalCoord.get(gson.toJson((Object)in)), BlockPos.class);
        }
        return null;
    }

    public int getDim(int dimIn, BlockPos in) {
        if (tag.func_74764_b(String.valueOf(dimIn))) {
            portalCoord = (HashMap)gson.fromJson(tag.func_74779_i(String.valueOf(dimIn)), HashMap.class);
            try {
                Vector4f vec = (Vector4f)gson.fromJson(portalCoord.get(gson.toJson((Object)in)), Vector4f.class);
                if (vec != null) {
                    return (int)vec.w;
                }
            }
            catch (Exception e) {
                return dimIn == Mist.getID() ? 0 : Mist.getID();
            }
        }
        return dimIn == Mist.getID() ? 0 : Mist.getID();
    }

    public void removeCoords(int dimIn, BlockPos in) {
        if (tag.func_74764_b(String.valueOf(dimIn))) {
            portalCoord = (HashMap)gson.fromJson(tag.func_74779_i(String.valueOf(dimIn)), HashMap.class);
            portalCoord.remove(gson.toJson((Object)in));
            if (portalCoord.size() == 0) {
                tag.func_82580_o(String.valueOf(dimIn));
            } else {
                tag.func_74778_a(String.valueOf(dimIn), gson.toJson(portalCoord));
            }
            this.func_76185_a();
        }
    }

    public static PortalCoordData get(World world) {
        MapStorage storage = world.func_175693_T();
        PortalCoordData instance = (PortalCoordData)storage.func_75742_a(PortalCoordData.class, DATA_NAME);
        if (instance == null) {
            instance = new PortalCoordData(DATA_NAME);
            storage.func_75745_a(DATA_NAME, (WorldSavedData)instance);
        }
        return instance;
    }
}

