/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.util;

import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class GenUtil {
    public final World world;
    public final GenSet set;

    public GenUtil(World world, GenSet set) {
        this.world = world;
        this.set = set;
    }

    public BlockPos getPos(BlockPos pos) {
        return GenUtil.transformedBlockPos(pos, this.set);
    }

    public IBlockState getBlockState(BlockPos pos) {
        return GenUtil.getBlockState(this.world, pos, this.set);
    }

    public TileEntity getTileEntity(BlockPos pos) {
        return GenUtil.getTileEntity(this.world, pos, this.set);
    }

    public boolean setBlockState(BlockPos pos, IBlockState state) {
        return GenUtil.setBlockState(this.world, pos, state, this.set, 18);
    }

    public boolean setBlockState(BlockPos pos, IBlockState state, int flag) {
        return GenUtil.setBlockState(this.world, pos, state, this.set, flag);
    }

    public static boolean setBlockState(World world, BlockPos pos, IBlockState state, GenSet set) {
        return GenUtil.setBlockState(world, pos, state, set, 18);
    }

    public static IBlockState getBlockState(World world, BlockPos pos, GenSet set) {
        pos = GenUtil.transformedBlockPos(pos, set);
        return world.func_180495_p(pos);
    }

    public static TileEntity getTileEntity(World world, BlockPos pos, GenSet set) {
        pos = GenUtil.transformedBlockPos(pos, set);
        return world.func_175625_s(pos);
    }

    public static boolean setBlockState(World world, BlockPos pos, IBlockState state, GenSet set, int flag) {
        pos = GenUtil.transformedBlockPos(pos, set);
        state = state.func_185902_a(set.mirror);
        state = state.func_185907_a(set.rotation);
        return world.func_180501_a(pos, state, flag);
    }

    public static BlockPos transformedBlockPos(BlockPos pos, BlockPos center, Rotation rotation, Mirror mirror) {
        int centerX = center.func_177958_n();
        int centerZ = center.func_177952_p();
        int x = pos.func_177958_n() - centerX;
        int z = pos.func_177952_p() - centerZ;
        boolean flag = true;
        switch (mirror) {
            case LEFT_RIGHT: {
                z = -z;
                break;
            }
            case FRONT_BACK: {
                x = -x;
                break;
            }
            default: {
                flag = false;
            }
        }
        switch (rotation) {
            case COUNTERCLOCKWISE_90: {
                return new BlockPos(z + centerX, pos.func_177956_o(), -x + centerZ);
            }
            case CLOCKWISE_90: {
                return new BlockPos(-z + centerX, pos.func_177956_o(), x + centerZ);
            }
            case CLOCKWISE_180: {
                return new BlockPos(-x + centerX, pos.func_177956_o(), -z + centerZ);
            }
        }
        return flag ? new BlockPos(x + centerX, pos.func_177956_o(), z + centerZ) : pos;
    }

    public static BlockPos transformedBlockPos(BlockPos pos, GenSet set) {
        return GenUtil.transformedBlockPos(pos, set.center, set.rotation, set.mirror);
    }

    public GenUtil add(BlockPos center, Rotation rotation, Mirror mirror) {
        Mirror mirrorOut;
        Rotation rotationOut = rotation;
        if (this.set.mirror == Mirror.NONE) {
            mirrorOut = mirror;
        } else if (rotation == Rotation.NONE || rotation == Rotation.CLOCKWISE_180) {
            if (mirror == Mirror.NONE) {
                mirrorOut = this.set.mirror;
            } else if (mirror == this.set.mirror) {
                mirrorOut = Mirror.NONE;
            } else {
                rotationOut = rotation.func_185830_a(Rotation.CLOCKWISE_180);
                mirrorOut = Mirror.NONE;
            }
        } else if (mirror == Mirror.NONE) {
            mirrorOut = this.set.mirror == Mirror.FRONT_BACK ? Mirror.LEFT_RIGHT : Mirror.FRONT_BACK;
        } else if (mirror != this.set.mirror) {
            mirrorOut = Mirror.NONE;
        } else {
            rotationOut = rotation.func_185830_a(Rotation.CLOCKWISE_180);
            mirrorOut = Mirror.NONE;
        }
        return new GenUtil(this.world, new GenSet(this.getPos(center), this.set.rotation.func_185830_a(rotationOut), mirrorOut));
    }

    public static class GenSet {
        public final BlockPos center;
        public final Rotation rotation;
        public final Mirror mirror;

        public GenSet(BlockPos center, Rotation rotation, Mirror mirror) {
            this.center = center;
            this.rotation = rotation;
            this.mirror = mirror;
        }

        public GenSet(BlockPos center, EnumFacing face, Mirror mirror) {
            this(center, Rotation.values()[face.func_176736_b()], mirror);
        }
    }
}

