/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.util;

import java.nio.IntBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import ru.liahim.mist.handlers.FogRenderer;

@SideOnly(value=Side.CLIENT)
public class FogTexture {
    private static int textureId;
    public static int offset;
    private static int size;
    private static IntBuffer buf;
    public static int chunkX;
    public static int chunkZ;
    public static int fogHeight;
    private static boolean empty;

    public static void initFogTexture() {
        textureId = TextureUtil.func_110996_a();
        FogTexture.allocateTexture();
    }

    public static int getTextureSize() {
        return size;
    }

    public static void allocateTexture() {
        size = offset * 2 + 1 << 4;
        buf = BufferUtils.createIntBuffer((int)(size * size));
        TextureUtil.func_110991_a((int)textureId, (int)size, (int)size);
    }

    public static void bindTexture() {
        GlStateManager.func_179144_i((int)textureId);
    }

    public static void createFogTexture(World world, int chunkX, int chunkZ) {
        chunkX -= offset;
        chunkZ -= offset;
        for (int x = 0; x < size >> 4; ++x) {
            for (int z = 0; z < size >> 4; ++z) {
                FogTexture.createTextureForChunk(world, chunkX + x, chunkZ + z, x << 4, z << 4);
            }
        }
        FogTexture.upload(0, 0, size, size);
    }

    public static void createBlockTexture(World world, BlockPos pos) {
        if (pos.func_177956_o() > fogHeight - 16) {
            int chunkX = (pos.func_177958_n() >> 4) - 1;
            int chunkZ = (pos.func_177952_p() >> 4) - 1;
            int minX = Integer.MAX_VALUE;
            int minZ = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            int maxZ = Integer.MIN_VALUE;
            for (int x = 0; x < 3; ++x) {
                for (int z = 0; z < 3; ++z) {
                    if (MathHelper.func_76130_a((int)(chunkX + x - FogTexture.chunkX)) > offset || MathHelper.func_76130_a((int)(chunkZ + z - FogTexture.chunkZ)) > offset) continue;
                    int xOffset = chunkX + x - FogTexture.chunkX + offset << 4;
                    int zOffset = chunkZ + z - FogTexture.chunkZ + offset << 4;
                    if (xOffset < minX) {
                        minX = xOffset;
                    }
                    if (zOffset < minZ) {
                        minZ = zOffset;
                    }
                    if (xOffset > maxX) {
                        maxX = xOffset;
                    }
                    if (zOffset > maxZ) {
                        maxZ = zOffset;
                    }
                    FogTexture.createTextureForChunk(world, chunkX + x, chunkZ + z, xOffset, zOffset);
                }
            }
            if (minX < maxX && minZ < maxZ) {
                FogTexture.upload(minX, minZ, maxX - minX + 16, maxZ - minZ + 16);
            }
        }
    }

    public static void createChunkTexture(World world, int chunkX, int chunkZ) {
        if (MathHelper.func_76130_a((int)(chunkX - FogTexture.chunkX)) <= offset && MathHelper.func_76130_a((int)(chunkZ - FogTexture.chunkZ)) <= offset) {
            int xOffset = chunkX - FogTexture.chunkX + offset << 4;
            int zOffset = chunkZ - FogTexture.chunkZ + offset << 4;
            FogTexture.createTextureForChunk(world, chunkX, chunkZ, xOffset, zOffset);
            FogTexture.upload(xOffset, zOffset, 16, 16);
        }
    }

    private static void createTextureForChunk(World world, int chunkX, int chunkZ, int offsetX, int offsetZ) {
        empty = true;
        if (!world.func_72863_F().func_186025_d(chunkX, chunkZ).func_76621_g()) {
            boolean e;
            int i = FogRenderer.depth < 4.0f ? -1 : 1;
            ExtendedBlockStorage ebs = world.func_72964_e(chunkX, chunkZ).func_76587_i()[fogHeight >> 4];
            ExtendedBlockStorage ebs1 = fogHeight >> 4 != fogHeight + i >> 4 ? world.func_72964_e(chunkX, chunkZ).func_76587_i()[fogHeight + i >> 4] : ebs;
            boolean bl = e = ebs1 == Chunk.field_186036_a;
            if (ebs != Chunk.field_186036_a) {
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        int s = ebs.func_76670_c(x, fogHeight & 0xF, z) * 17;
                        int b = ebs.func_76674_d(x, fogHeight & 0xF, z) * 17;
                        int s1 = e ? 255 : ebs1.func_76670_c(x, fogHeight + i & 0xF, z) * 17;
                        int b1 = e ? 0 : ebs1.func_76674_d(x, fogHeight + i & 0xF, z) * 17;
                        b = b * b / 255;
                        b1 = b1 * b1 / 255;
                        FogTexture.putToBuffer(x + offsetX, z + offsetZ, b1 << 24 | s << 16 | b << 8 | s1);
                    }
                }
                empty = false;
            }
        }
        if (empty) {
            int l = 0xFF00FF;
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    FogTexture.putToBuffer(x + offsetX, z + offsetZ, l);
                }
            }
        }
    }

    private static void putToBuffer(int x, int y, int color) {
        buf.put(y * size + x, color);
    }

    private static void setPosition(int x, int y) {
        buf.position(y * size + x);
    }

    private static void upload(int xOffset, int yOffset, int width, int height) {
        boolean offset;
        GlStateManager.func_179144_i((int)textureId);
        boolean bl = offset = xOffset > 0 || yOffset > 0;
        if (offset) {
            FogTexture.setPosition(xOffset, yOffset);
            GL11.glPixelStorei((int)3314, (int)size);
        }
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GL11.glTexSubImage2D((int)3553, (int)0, (int)xOffset, (int)yOffset, (int)width, (int)height, (int)32993, (int)33639, (IntBuffer)buf);
        if (offset) {
            FogTexture.setPosition(0, 0);
            GL11.glPixelStorei((int)3314, (int)0);
        }
    }

    static {
        offset = Minecraft.func_71410_x().field_71474_y.field_151451_c;
        size = offset * 2 + 1 << 4;
        buf = BufferUtils.createIntBuffer((int)(size * size));
        chunkX = Integer.MAX_VALUE;
        chunkZ = Integer.MAX_VALUE;
        fogHeight = 0;
        empty = true;
    }
}

