/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.tileentity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.oredict.OreDictionary;
import ru.liahim.mist.api.biome.EnumBiomeType;
import ru.liahim.mist.api.loottable.LootTables;
import ru.liahim.mist.api.sound.MistSounds;
import ru.liahim.mist.block.gizmos.MistUrn;
import ru.liahim.mist.init.ModConfig;
import ru.liahim.mist.inventory.container.ContainerUrn;
import ru.liahim.mist.util.ColorHelper;
import ru.liahim.mist.util.InventoryUtil;

public class TileEntityUrn
extends TileEntityLockableLoot
implements ITickable {
    private final int size = 9;
    private NonNullList<ItemStack> urnContents = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
    public float lidAngle;
    public float prevLidAngle;
    public int numPlayersUsing;
    private int ticksSinceSync;
    public EnumFacing openSide;
    public static final int clayColor = 12613979;
    public static final int rawColor = 12503253;
    private UrnType urnType = UrnType.NORMAL;
    private int tintColor = -1;
    private int patina = -1;
    private String tooltip = "";
    private String location = "";
    public boolean bug;
    private static final String urnLocation = "textures/entity/urn/";
    private static final ResourceLocation[] SWAMP_TOMB_LOOT = new ResourceLocation[]{LootTables.URN_FUNERARY_LOOT, LootTables.URN_FUNERARY_LOOT, LootTables.URN_MIXED_LOOT, LootTables.URN_MIXED_LOOT, LootTables.URN_RICHES_LOOT};
    private static final ResourceLocation[] FOREST_TOMB_LOOT = new ResourceLocation[]{LootTables.URN_RICHES_LOOT, LootTables.URN_RICHES_LOOT, LootTables.URN_MIXED_LOOT};
    private static final ResourceLocation[] DESERT_TOMB_LOOT = new ResourceLocation[]{LootTables.URN_FUNERARY_LOOT, LootTables.URN_MIXED_LOOT};
    private static final ResourceLocation[] JUNGLE_TOMB_LOOT = new ResourceLocation[]{LootTables.URN_FUNERARY_LOOT, LootTables.URN_MIXED_LOOT, LootTables.URN_RICHES_LOOT};
    private static final ResourceLocation[] SNOW_TOMB_LOOT = new ResourceLocation[]{LootTables.URN_RICHES_LOOT, LootTables.URN_MIXED_LOOT, LootTables.URN_FUNERARY_LOOT};
    private static final int forestColor_1 = ColorHelper.mixColor(EnumDyeColor.ORANGE.field_193351_w, EnumDyeColor.YELLOW.field_193351_w, EnumDyeColor.SILVER.field_193351_w, EnumDyeColor.SILVER.field_193351_w, EnumDyeColor.SILVER.field_193351_w);
    private static final int forestColor_2 = EnumDyeColor.BROWN.field_193351_w;
    private static final int desertColor_1 = ColorHelper.mixColor(EnumDyeColor.YELLOW.field_193351_w, EnumDyeColor.YELLOW.field_193351_w, EnumDyeColor.YELLOW.field_193351_w, EnumDyeColor.ORANGE.field_193351_w, EnumDyeColor.LIME.field_193351_w, EnumDyeColor.SILVER.field_193351_w);
    private static final int desertColor_2 = ColorHelper.mixColor(EnumDyeColor.BROWN.field_193351_w, EnumDyeColor.ORANGE.field_193351_w, EnumDyeColor.SILVER.field_193351_w);
    private static final int desertColor_3 = ColorHelper.mixColor(EnumDyeColor.YELLOW.field_193351_w, EnumDyeColor.SILVER.field_193351_w, EnumDyeColor.SILVER.field_193351_w, EnumDyeColor.WHITE.field_193351_w);
    private static final int desertColor_4 = ColorHelper.mixColor(EnumDyeColor.BLUE.field_193351_w, EnumDyeColor.BLUE.field_193351_w, EnumDyeColor.BLUE.field_193351_w, EnumDyeColor.CYAN.field_193351_w, EnumDyeColor.YELLOW.field_193351_w);
    private static final int jungleColor_1 = ColorHelper.mixColor(EnumDyeColor.BLACK.field_193351_w, EnumDyeColor.RED.field_193351_w);
    private static final int jungleColor_2 = ColorHelper.mixColor(EnumDyeColor.ORANGE.field_193351_w, EnumDyeColor.RED.field_193351_w);
    private static final int snowColor_1 = ColorHelper.mixColor(EnumDyeColor.BLACK.field_193351_w, EnumDyeColor.SILVER.field_193351_w, EnumDyeColor.BROWN.field_193351_w);
    private static final int snowColor_2 = ColorHelper.mixColor(EnumDyeColor.SILVER.field_193351_w, EnumDyeColor.SILVER.field_193351_w, EnumDyeColor.BROWN.field_193351_w);
    private static final int snowColor_3 = ColorHelper.mixColor(EnumDyeColor.ORANGE.field_193351_w, EnumDyeColor.SILVER.field_193351_w, EnumDyeColor.SILVER.field_193351_w);
    private static final int swampColor_1 = ColorHelper.mixColor(EnumDyeColor.GREEN.field_193351_w, EnumDyeColor.LIGHT_BLUE.field_193351_w, EnumDyeColor.ORANGE.field_193351_w);
    private static final int swampColor_2 = ColorHelper.mixColor(EnumDyeColor.GREEN.field_193351_w, EnumDyeColor.BROWN.field_193351_w);

    public UrnType getUrnType() {
        return this.urnType;
    }

    public int getTintColor() {
        return this.tintColor < 0 ? 12613979 : this.tintColor;
    }

    public int getPatina() {
        return this.patina < 0 ? this.getTintColor() : this.patina;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public String getLocation() {
        return this.location;
    }

    public int func_70302_i_() {
        return 9;
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.urnContents) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public int func_70297_j_() {
        return this.getUrnType().isRare() ? 64 : 16;
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.field_190577_o : (this.getUrnType().isRare() ? "item.mist.urn_rare" : "item.mist.urn");
    }

    public boolean func_145818_k_() {
        return this.field_190577_o != null && !this.field_190577_o.isEmpty();
    }

    public void func_190575_a(String name) {
        this.field_190577_o = name;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_150297_b("CustomName", 8)) {
            this.field_190577_o = compound.func_74779_i("CustomName");
        }
        this.readFromNBTUrn(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.field_190577_o);
        }
        return this.writeToNBTUrn(compound, true);
    }

    public void readFromNBTUrn(NBTTagCompound compound) {
        this.urnContents = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        if (!this.func_184283_b(compound)) {
            ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.urnContents);
        }
        this.urnType = UrnType.byId(compound.func_74762_e("UrnType"));
        if (compound.func_74764_b("TintColor")) {
            this.tintColor = compound.func_74762_e("TintColor");
        }
        if (compound.func_74764_b("PatinaColor")) {
            this.patina = compound.func_74762_e("PatinaColor");
        }
        this.tooltip = compound.func_74779_i("UrnTooltip");
        this.location = compound.func_74779_i("UrnLocation");
        this.bug = compound.func_74767_n("Bug");
    }

    public NBTTagCompound writeToNBTUrn(NBTTagCompound compound, boolean checkLoot) {
        if (!checkLoot || !this.func_184282_c(compound)) {
            ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.urnContents);
        }
        compound.func_74768_a("UrnType", this.getUrnType().getId());
        compound.func_74768_a("TintColor", this.tintColor);
        compound.func_74768_a("PatinaColor", this.patina);
        compound.func_74778_a("UrnTooltip", this.getTooltip());
        compound.func_74778_a("UrnLocation", this.getLocation());
        compound.func_74757_a("Bug", this.bug);
        return compound;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void updateStatus() {
        this.updateStatus(this.field_145850_b.func_180495_p(this.field_174879_c));
    }

    public void updateStatus(IBlockState state) {
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), state, 3);
    }

    public void func_73660_a() {
        int x = this.field_174879_c.func_177958_n();
        int y = this.field_174879_c.func_177956_o();
        int z = this.field_174879_c.func_177952_p();
        ++this.ticksSinceSync;
        if (!this.field_145850_b.field_72995_K && this.numPlayersUsing != 0 && (this.ticksSinceSync + x + y + z) % 200 == 0) {
            this.numPlayersUsing = 0;
            float f = 5.0f;
            for (EntityPlayer player : this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)((float)x - f), (double)((float)y - f), (double)((float)z - f), (double)((float)(x + 1) + f), (double)((float)(y + 1) + f), (double)((float)(z + 1) + f)))) {
                if (!(player.field_71070_bA instanceof ContainerUrn) || ((ContainerUrn)player.field_71070_bA).getUrnInventory() != this) continue;
                ++this.numPlayersUsing;
            }
        }
        this.prevLidAngle = this.lidAngle;
        if (this.numPlayersUsing > 0 && this.lidAngle == 0.0f) {
            this.field_145850_b.func_184148_a((EntityPlayer)null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, MistSounds.BLOCK_URN_OPEN, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.numPlayersUsing == 0 && this.lidAngle > 0.0f || this.numPlayersUsing > 0 && this.lidAngle < 1.0f) {
            float speed = 0.1f;
            this.lidAngle = this.numPlayersUsing > 0 ? (this.lidAngle += speed) : (this.lidAngle -= speed);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < 0.5f && this.prevLidAngle >= 0.5f) {
                this.field_145850_b.func_184148_a((EntityPlayer)null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, MistSounds.BLOCK_URN_CLOSE, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.numPlayersUsing = type;
            return true;
        }
        if (id == 2) {
            this.openSide = EnumFacing.func_82600_a((int)type);
            return true;
        }
        return super.func_145842_c(id, type);
    }

    public void func_174889_b(EntityPlayer player) {
        if (!player.func_175149_v()) {
            if (this.numPlayersUsing < 0) {
                this.numPlayersUsing = 0;
            }
            ++this.numPlayersUsing;
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, this.numPlayersUsing);
            if (!this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 2, this.openSide.func_176745_a());
            }
        }
    }

    public void func_174886_c(EntityPlayer player) {
        if (!player.func_175149_v() && this.func_145838_q() instanceof MistUrn) {
            --this.numPlayersUsing;
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, this.numPlayersUsing);
        }
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer player) {
        this.func_184281_d(player);
        return new ContainerUrn((IInventory)this, player);
    }

    public void func_184281_d(@Nullable EntityPlayer player) {
        if (this.field_184284_m != null && this.field_145850_b instanceof WorldServer) {
            LootTable loottable = this.field_145850_b.func_184146_ak().func_186521_a(this.field_184284_m);
            this.field_184284_m = null;
            this.bug = false;
            Random random = this.field_184285_n == 0L ? new Random() : new Random(this.field_184285_n);
            LootContext.Builder builder = new LootContext.Builder((WorldServer)this.field_145850_b);
            if (player != null) {
                builder.func_186469_a(player.func_184817_da()).func_186470_a(player);
            }
            InventoryUtil.optimizeAndFillInventory((IInventory)this, loottable.func_186462_a(random, builder.func_186471_a()), random);
        }
    }

    public boolean isBug() {
        return this.bug && this.field_184284_m != null && !this.urnType.rare;
    }

    public String func_174875_k() {
        return "mist:urn";
    }

    protected NonNullList<ItemStack> func_190576_q() {
        return this.urnContents;
    }

    static /* synthetic */ int access$100() {
        return swampColor_1;
    }

    static /* synthetic */ int access$200() {
        return swampColor_2;
    }

    static /* synthetic */ ResourceLocation[] access$300() {
        return SWAMP_TOMB_LOOT;
    }

    static /* synthetic */ int access$400() {
        return desertColor_3;
    }

    static /* synthetic */ int access$500() {
        return desertColor_4;
    }

    static /* synthetic */ int access$600() {
        return desertColor_1;
    }

    static /* synthetic */ int access$700() {
        return desertColor_2;
    }

    static /* synthetic */ ResourceLocation[] access$800() {
        return DESERT_TOMB_LOOT;
    }

    static /* synthetic */ int access$900() {
        return jungleColor_1;
    }

    static /* synthetic */ int access$1000() {
        return jungleColor_2;
    }

    static /* synthetic */ ResourceLocation[] access$1100() {
        return JUNGLE_TOMB_LOOT;
    }

    static /* synthetic */ int access$1200() {
        return snowColor_1;
    }

    static /* synthetic */ ResourceLocation[] access$1300() {
        return SNOW_TOMB_LOOT;
    }

    static /* synthetic */ int access$1400() {
        return snowColor_2;
    }

    static /* synthetic */ int access$1500() {
        return snowColor_3;
    }

    static /* synthetic */ int access$1600() {
        return forestColor_1;
    }

    static /* synthetic */ ResourceLocation[] access$1700() {
        return FOREST_TOMB_LOOT;
    }

    static /* synthetic */ int access$1800() {
        return forestColor_2;
    }

    public static enum UrnLocation {
        ALTARS,
        BASEMENTS,
        WELLS,
        TOMBS,
        CLIFF;

    }

    public static enum UrnLootType {
        SWAMP_BASEMENTS_1(UrnType.ZONE, ColorHelper.mixColor(EnumDyeColor.LIME.field_193351_w, EnumDyeColor.LIME.field_193351_w, EnumDyeColor.BROWN.field_193351_w), ColorHelper.mixColor(EnumDyeColor.LIME.field_193351_w, EnumDyeColor.GREEN.field_193351_w, EnumDyeColor.BROWN.field_193351_w), "basement", "swamp", LootTables.URN_BASEMENTS_SWAMP_LOOT),
        SWAMP_BASEMENTS_2(UrnType.PATINA, ColorHelper.mixColor(EnumDyeColor.BROWN.field_193351_w, EnumDyeColor.BROWN.field_193351_w, EnumDyeColor.LIME.field_193351_w, EnumDyeColor.CYAN.field_193351_w, EnumDyeColor.WHITE.field_193351_w), ColorHelper.mixColor(EnumDyeColor.BROWN.field_193351_w, EnumDyeColor.BLUE.field_193351_w, EnumDyeColor.WHITE.field_193351_w), "basement", "swamp", LootTables.URN_BASEMENTS_SWAMP_LOOT),
        SWAMP_BASEMENTS_3(UrnType.STARS, ColorHelper.mixColor(EnumDyeColor.BROWN.field_193351_w, EnumDyeColor.LIME.field_193351_w, EnumDyeColor.SILVER.field_193351_w), ColorHelper.mixColor(EnumDyeColor.BROWN.field_193351_w, EnumDyeColor.GREEN.field_193351_w, EnumDyeColor.GREEN.field_193351_w), "basement", "swamp", LootTables.URN_BASEMENTS_SWAMP_LOOT),
        SWAMP_WELLS_1(UrnType.PATINA, ColorHelper.mixColor(EnumDyeColor.YELLOW.field_193351_w, EnumDyeColor.YELLOW.field_193351_w, EnumDyeColor.SILVER.field_193351_w, EnumDyeColor.SILVER.field_193351_w, EnumDyeColor.SILVER.field_193351_w, EnumDyeColor.LIGHT_BLUE.field_193351_w), EnumDyeColor.GREEN.field_193351_w, "well", "swamp", LootTables.URN_WELLS_LOOT),
        SWAMP_WELLS_2(UrnType.PATINA, ColorHelper.mixColor(EnumDyeColor.LIGHT_BLUE.field_193351_w, EnumDyeColor.LIGHT_BLUE.field_193351_w, EnumDyeColor.LIGHT_BLUE.field_193351_w, EnumDyeColor.SILVER.field_193351_w, EnumDyeColor.SILVER.field_193351_w, EnumDyeColor.SILVER.field_193351_w, EnumDyeColor.ORANGE.field_193351_w, EnumDyeColor.BROWN.field_193351_w), EnumDyeColor.GREEN.field_193351_w, "well", "swamp", LootTables.URN_WELLS_LOOT),
        SWAMP_TOMB_1(UrnType.STRIPE, TileEntityUrn.access$100(), TileEntityUrn.access$200(), "burial", "swamp", TileEntityUrn.access$300()),
        SWAMP_TOMB_2(UrnType.ZONE, TileEntityUrn.access$100(), TileEntityUrn.access$200(), "burial", "swamp", TileEntityUrn.access$300()),
        SWAMP_TOMB_3(UrnType.PATINA, TileEntityUrn.access$100(), TileEntityUrn.access$200(), "burial", "swamp", TileEntityUrn.access$300()),
        SWAMP_TOMB_4(UrnType.STARS, TileEntityUrn.access$100(), TileEntityUrn.access$200(), "burial", "swamp", TileEntityUrn.access$300()),
        SWAMP_TOMB_5(UrnType.CLOTH, TileEntityUrn.access$100(), TileEntityUrn.access$200(), "burial", "swamp", TileEntityUrn.access$300()),
        DESERT_ALTAR_1(UrnType.STARS, ColorHelper.mixColor(EnumDyeColor.BLUE.field_193351_w, EnumDyeColor.CYAN.field_193351_w, EnumDyeColor.WHITE.field_193351_w), ColorHelper.mixColor(EnumDyeColor.BLUE.field_193351_w, EnumDyeColor.LIGHT_BLUE.field_193351_w, EnumDyeColor.BROWN.field_193351_w), "altar", "desert", LootTables.URN_ALTARS_DESERT_LOOT),
        DESERT_BASEMENTS_1(UrnType.STRIPE, TileEntityUrn.access$400(), TileEntityUrn.access$500(), "basement", "desert", LootTables.URN_BASEMENTS_DESERT_LOOT),
        DESERT_BASEMENTS_2(UrnType.PATINA, TileEntityUrn.access$400(), TileEntityUrn.access$500(), "basement", "desert", LootTables.URN_BASEMENTS_DESERT_LOOT),
        DESERT_BASEMENTS_3(UrnType.LINE, TileEntityUrn.access$400(), TileEntityUrn.access$500(), "basement", "desert", LootTables.URN_BASEMENTS_DESERT_LOOT),
        DESERT_WELLS_1(UrnType.PATINA, ColorHelper.mixColor(EnumDyeColor.BLUE.field_193351_w, EnumDyeColor.LIGHT_BLUE.field_193351_w, EnumDyeColor.YELLOW.field_193351_w), ColorHelper.mixColor(EnumDyeColor.BLUE.field_193351_w, EnumDyeColor.LIGHT_BLUE.field_193351_w, EnumDyeColor.BROWN.field_193351_w), "well", "desert", LootTables.URN_WELLS_LOOT),
        DESERT_WELLS_2(UrnType.STARS, ColorHelper.mixColor(EnumDyeColor.LIGHT_BLUE.field_193351_w, EnumDyeColor.LIGHT_BLUE.field_193351_w, EnumDyeColor.YELLOW.field_193351_w, EnumDyeColor.ORANGE.field_193351_w, EnumDyeColor.SILVER.field_193351_w), ColorHelper.mixColor(EnumDyeColor.BLUE.field_193351_w, EnumDyeColor.CYAN.field_193351_w, EnumDyeColor.SILVER.field_193351_w, EnumDyeColor.SILVER.field_193351_w), "well", "desert", LootTables.URN_WELLS_LOOT),
        DESERT_TOMB_1(UrnType.ZONE, TileEntityUrn.access$600(), TileEntityUrn.access$700(), "burial", "desert", TileEntityUrn.access$800()),
        DESERT_TOMB_2(UrnType.ZONE, TileEntityUrn.access$700(), TileEntityUrn.access$600(), "burial", "desert", TileEntityUrn.access$800()),
        DESERT_TOMB_3(UrnType.LINE, TileEntityUrn.access$600(), TileEntityUrn.access$700(), "burial", "desert", TileEntityUrn.access$800()),
        DESERT_TOMB_4(UrnType.STARS, TileEntityUrn.access$700(), TileEntityUrn.access$600(), "burial", "desert", TileEntityUrn.access$800()),
        DESERT_TOMB_5(UrnType.NORMAL, TileEntityUrn.access$600(), TileEntityUrn.access$700(), "burial", "desert", TileEntityUrn.access$800()),
        JUNGLE_BASEMENTS_1(UrnType.PATINA, ColorHelper.mixColor(EnumDyeColor.ORANGE.field_193351_w, EnumDyeColor.RED.field_193351_w, EnumDyeColor.SILVER.field_193351_w, EnumDyeColor.YELLOW.field_193351_w), ColorHelper.mixColor(EnumDyeColor.ORANGE.field_193351_w, EnumDyeColor.CYAN.field_193351_w), "basement", "jungle", LootTables.URN_BASEMENTS_JUNGLE_LOOT),
        JUNGLE_BASEMENTS_2(UrnType.PATINA, ColorHelper.mixColor(EnumDyeColor.ORANGE.field_193351_w), ColorHelper.mixColor(EnumDyeColor.ORANGE.field_193351_w, EnumDyeColor.RED.field_193351_w), "basement", "jungle", LootTables.URN_BASEMENTS_JUNGLE_LOOT),
        JUNGLE_BASEMENTS_3(UrnType.PATINA, -1, ColorHelper.mixColor(EnumDyeColor.ORANGE.field_193351_w, EnumDyeColor.CYAN.field_193351_w, EnumDyeColor.CYAN.field_193351_w), "basement", "jungle", LootTables.URN_BASEMENTS_JUNGLE_LOOT),
        JUNGLE_WELLS_1(UrnType.PATINA, ColorHelper.mixColor(EnumDyeColor.YELLOW.field_193351_w, EnumDyeColor.ORANGE.field_193351_w, EnumDyeColor.SILVER.field_193351_w), ColorHelper.mixColor(EnumDyeColor.GREEN.field_193351_w, EnumDyeColor.LIME.field_193351_w), "well", "jungle", LootTables.URN_WELLS_LOOT),
        JUNGLE_WELLS_2(UrnType.PATINA, ColorHelper.mixColor(EnumDyeColor.RED.field_193351_w, EnumDyeColor.ORANGE.field_193351_w, EnumDyeColor.SILVER.field_193351_w, EnumDyeColor.SILVER.field_193351_w, EnumDyeColor.SILVER.field_193351_w), ColorHelper.mixColor(EnumDyeColor.GREEN.field_193351_w, EnumDyeColor.GREEN.field_193351_w, EnumDyeColor.SILVER.field_193351_w), "well", "jungle", LootTables.URN_WELLS_LOOT),
        JUNGLE_TOMB_1(UrnType.CLOTH, TileEntityUrn.access$900(), TileEntityUrn.access$1000(), "burial", "jungle", TileEntityUrn.access$1100()),
        JUNGLE_TOMB_2(UrnType.STRIPE, TileEntityUrn.access$900(), TileEntityUrn.access$1000(), "burial", "jungle", TileEntityUrn.access$1100()),
        JUNGLE_TOMB_3(UrnType.ZONE, TileEntityUrn.access$900(), TileEntityUrn.access$1000(), "burial", "jungle", TileEntityUrn.access$1100()),
        JUNGLE_TOMB_4(UrnType.NORMAL, TileEntityUrn.access$1000(), TileEntityUrn.access$900(), "burial", "jungle", TileEntityUrn.access$1100()),
        SNOW_BASEMENTS_1(UrnType.NORMAL, ColorHelper.mixColor(EnumDyeColor.YELLOW.field_193351_w, EnumDyeColor.ORANGE.field_193351_w, EnumDyeColor.SILVER.field_193351_w), -1, "basement", "taiga", LootTables.URN_BASEMENTS_COLD_LOOT),
        SNOW_BASEMENTS_2(UrnType.NORMAL, ColorHelper.mixColor(EnumDyeColor.BLUE.field_193351_w, EnumDyeColor.RED.field_193351_w, EnumDyeColor.LIME.field_193351_w, EnumDyeColor.WHITE.field_193351_w), -1, "basement", "taiga", LootTables.URN_BASEMENTS_COLD_LOOT),
        SNOW_BASEMENTS_3(UrnType.NORMAL, ColorHelper.mixColor(EnumDyeColor.BROWN.field_193351_w, EnumDyeColor.ORANGE.field_193351_w, EnumDyeColor.WHITE.field_193351_w, EnumDyeColor.LIGHT_BLUE.field_193351_w), -1, "basement", "taiga", LootTables.URN_BASEMENTS_COLD_LOOT),
        SNOW_BASEMENTS_4(UrnType.NORMAL, ColorHelper.mixColor(EnumDyeColor.GRAY.field_193351_w, EnumDyeColor.ORANGE.field_193351_w, EnumDyeColor.WHITE.field_193351_w), -1, "basement", "taiga", LootTables.URN_BASEMENTS_COLD_LOOT),
        SNOW_BASEMENTS_5(UrnType.NORMAL, ColorHelper.mixColor(EnumDyeColor.YELLOW.field_193351_w, EnumDyeColor.BROWN.field_193351_w, EnumDyeColor.CYAN.field_193351_w, EnumDyeColor.WHITE.field_193351_w), -1, "basement", "taiga", LootTables.URN_BASEMENTS_COLD_LOOT),
        SNOW_WELLS_1(UrnType.NORMAL, ColorHelper.mixColor(EnumDyeColor.BROWN.field_193351_w, EnumDyeColor.LIGHT_BLUE.field_193351_w, EnumDyeColor.SILVER.field_193351_w, EnumDyeColor.SILVER.field_193351_w), -1, "well", "taiga", LootTables.URN_WELLS_LOOT),
        SNOW_WELLS_2(UrnType.STARS, ColorHelper.mixColor(EnumDyeColor.BROWN.field_193351_w, EnumDyeColor.LIGHT_BLUE.field_193351_w, EnumDyeColor.SILVER.field_193351_w, EnumDyeColor.SILVER.field_193351_w), ColorHelper.mixColor(EnumDyeColor.BROWN.field_193351_w, EnumDyeColor.BROWN.field_193351_w, EnumDyeColor.LIGHT_BLUE.field_193351_w, EnumDyeColor.SILVER.field_193351_w), "well", "taiga", LootTables.URN_WELLS_LOOT),
        SNOW_WELLS_3(UrnType.STARS, ColorHelper.mixColor(EnumDyeColor.BROWN.field_193351_w, EnumDyeColor.LIGHT_BLUE.field_193351_w, EnumDyeColor.SILVER.field_193351_w, EnumDyeColor.SILVER.field_193351_w), ColorHelper.mixColor(EnumDyeColor.BROWN.field_193351_w, EnumDyeColor.BROWN.field_193351_w, EnumDyeColor.BROWN.field_193351_w, EnumDyeColor.LIGHT_BLUE.field_193351_w, EnumDyeColor.SILVER.field_193351_w), "well", "taiga", LootTables.URN_WELLS_LOOT),
        SNOW_TOMB_1(UrnType.NORMAL, TileEntityUrn.access$1200(), -1, "burial", "taiga", TileEntityUrn.access$1300()),
        SNOW_TOMB_2(UrnType.LINE, TileEntityUrn.access$1200(), TileEntityUrn.access$1400(), "burial", "taiga", TileEntityUrn.access$1300()),
        SNOW_TOMB_3(UrnType.LINE, TileEntityUrn.access$1200(), TileEntityUrn.access$1500(), "burial", "taiga", TileEntityUrn.access$1300()),
        SNOW_TOMB_4(UrnType.ZONE, TileEntityUrn.access$1200(), TileEntityUrn.access$1400(), "burial", "taiga", TileEntityUrn.access$1300()),
        SNOW_TOMB_5(UrnType.ZONE, TileEntityUrn.access$1200(), TileEntityUrn.access$1500(), "burial", "taiga", TileEntityUrn.access$1300()),
        FOREST_BASEMENTS_1(UrnType.ZONE, ColorHelper.mixColor(EnumDyeColor.WHITE.field_193351_w), ColorHelper.mixColor(EnumDyeColor.RED.field_193351_w, EnumDyeColor.ORANGE.field_193351_w, EnumDyeColor.WHITE.field_193351_w), "basement", "forest", LootTables.URN_BASEMENTS_FOREST_LOOT),
        FOREST_BASEMENTS_2(UrnType.CLOTH, ColorHelper.mixColor(EnumDyeColor.WHITE.field_193351_w, EnumDyeColor.SILVER.field_193351_w), ColorHelper.mixColor(EnumDyeColor.BROWN.field_193351_w, EnumDyeColor.ORANGE.field_193351_w, EnumDyeColor.LIME.field_193351_w), "basement", "forest", LootTables.URN_BASEMENTS_FOREST_LOOT),
        FOREST_BASEMENTS_3(UrnType.STRIPE, ColorHelper.mixColor(EnumDyeColor.WHITE.field_193351_w, EnumDyeColor.SILVER.field_193351_w, EnumDyeColor.BROWN.field_193351_w), ColorHelper.mixColor(EnumDyeColor.WHITE.field_193351_w, EnumDyeColor.BROWN.field_193351_w), "basement", "forest", LootTables.URN_BASEMENTS_FOREST_LOOT),
        FOREST_WELLS_1(UrnType.PATINA, ColorHelper.mixColor(EnumDyeColor.YELLOW.field_193351_w, EnumDyeColor.ORANGE.field_193351_w, EnumDyeColor.GREEN.field_193351_w), ColorHelper.mixColor(EnumDyeColor.BROWN.field_193351_w, EnumDyeColor.BROWN.field_193351_w, EnumDyeColor.BROWN.field_193351_w, EnumDyeColor.WHITE.field_193351_w), "well", "forest", LootTables.URN_WELLS_LOOT),
        FOREST_WELLS_2(UrnType.PATINA, ColorHelper.mixColor(EnumDyeColor.BROWN.field_193351_w, EnumDyeColor.WHITE.field_193351_w), ColorHelper.mixColor(EnumDyeColor.RED.field_193351_w, EnumDyeColor.SILVER.field_193351_w, EnumDyeColor.SILVER.field_193351_w, EnumDyeColor.SILVER.field_193351_w), "well", "forest", LootTables.URN_WELLS_LOOT),
        FOREST_TOMB_1(UrnType.NORMAL, TileEntityUrn.access$1600(), -1, "burial", "forest", TileEntityUrn.access$1700()),
        FOREST_TOMB_2(UrnType.PATINA, TileEntityUrn.access$1600(), TileEntityUrn.access$1800(), "burial", "forest", TileEntityUrn.access$1700()),
        FOREST_TOMB_3(UrnType.STRIPE, TileEntityUrn.access$1600(), TileEntityUrn.access$1800(), "burial", "forest", TileEntityUrn.access$1700()),
        FOREST_TOMB_4(UrnType.ZONE, TileEntityUrn.access$1600(), TileEntityUrn.access$1800(), "burial", "forest", TileEntityUrn.access$1700());

        private final UrnType type;
        private final int tintColor;
        private final int patina;
        private final String tooltip;
        private final String location;
        public final ResourceLocation[] loot;
        private static final UrnLootType[] forest_basements;
        private static final UrnLootType[] forest_wells;
        private static final UrnLootType[] forest_tombs;
        private static final UrnLootType[] forest_cliffs;
        private static final UrnLootType[] swamp_basements;
        private static final UrnLootType[] swamp_wells;
        private static final UrnLootType[] swamp_tombs;
        private static final UrnLootType[] swamp_cliffs;
        private static final UrnLootType[] cold_basements;
        private static final UrnLootType[] cold_wells;
        private static final UrnLootType[] cold_tombs;
        private static final UrnLootType[] cold_cliffs;
        private static final UrnLootType[] desert_altars;
        private static final UrnLootType[] desert_basements;
        private static final UrnLootType[] desert_wells;
        private static final UrnLootType[] desert_tombs;
        private static final UrnLootType[] desert_cliffs;
        private static final UrnLootType[] jungle_basements;
        private static final UrnLootType[] jungle_wells;
        private static final UrnLootType[] jungle_tombs;
        private static final UrnLootType[] jungle_cliffs;

        private UrnLootType(UrnType type, int tintColor, int patina, String tooltip, String location, ResourceLocation ... loot) {
            this.type = type;
            this.tintColor = tintColor;
            this.patina = patina;
            this.tooltip = tooltip;
            this.location = location;
            this.loot = loot;
        }

        public void initializeType(TileEntity tile, Random rand) {
            this.initializeType(tile, 1.0f, -1, rand);
        }

        public void initializeType(TileEntity tile, float chance, Random rand) {
            this.initializeType(tile, chance, -1, rand);
        }

        public void initializeType(TileEntity tile, float chance, int bug, Random rand) {
            if (tile instanceof TileEntityUrn) {
                TileEntityUrn urn = (TileEntityUrn)tile;
                if ((double)rand.nextFloat() < ModConfig.generation.rareUrnGenerationChance * (double)chance) {
                    urn.urnType = UrnType.RARE_LOOKUP.get(rand.nextInt(UrnType.RARE_LOOKUP.size()));
                    urn.tintColor = -1;
                    urn.patina = -1;
                } else {
                    urn.urnType = this.type;
                    urn.tintColor = this.tintColor;
                    urn.patina = this.patina;
                }
                urn.tooltip = this.tooltip;
                urn.location = this.location;
                urn.bug = bug > 0 || bug == 0 && rand.nextInt(8) == 0;
                urn.func_189404_a(this.loot[rand.nextInt(this.loot.length)], rand.nextLong());
                urn.updateStatus();
            }
        }

        public static void initializeType(TileEntity tile, EnumBiomeType biomeType, UrnLocation loc, Random rand) {
            switch (biomeType) {
                case Forest: {
                    switch (loc) {
                        case ALTARS: {
                            break;
                        }
                        case BASEMENTS: {
                            if (forest_basements.length <= 0) break;
                            forest_basements[rand.nextInt(forest_basements.length)].initializeType(tile, rand);
                            break;
                        }
                        case WELLS: {
                            if (forest_wells.length <= 0) break;
                            forest_wells[rand.nextInt(forest_wells.length)].initializeType(tile, rand);
                            break;
                        }
                        case TOMBS: {
                            if (forest_tombs.length <= 0) break;
                            forest_tombs[rand.nextInt(forest_tombs.length)].initializeType(tile, 1.0f, 0, rand);
                            break;
                        }
                        case CLIFF: {
                            if (forest_cliffs.length <= 0) break;
                            forest_cliffs[rand.nextInt(forest_cliffs.length)].initializeType(tile, 1.0f, 0, rand);
                        }
                    }
                    break;
                }
                case Swamp: {
                    switch (loc) {
                        case ALTARS: {
                            break;
                        }
                        case BASEMENTS: {
                            if (swamp_basements.length <= 0) break;
                            swamp_basements[rand.nextInt(swamp_basements.length)].initializeType(tile, rand);
                            break;
                        }
                        case WELLS: {
                            if (swamp_wells.length <= 0) break;
                            swamp_wells[rand.nextInt(swamp_wells.length)].initializeType(tile, rand);
                            break;
                        }
                        case TOMBS: {
                            if (swamp_tombs.length <= 0) break;
                            swamp_tombs[rand.nextInt(swamp_tombs.length)].initializeType(tile, 0.7f, 0, rand);
                            break;
                        }
                        case CLIFF: {
                            if (swamp_cliffs.length <= 0) break;
                            swamp_cliffs[rand.nextInt(swamp_cliffs.length)].initializeType(tile, 1.0f, 0, rand);
                        }
                    }
                    break;
                }
                case Cold: {
                    switch (loc) {
                        case ALTARS: {
                            break;
                        }
                        case BASEMENTS: {
                            if (cold_basements.length <= 0) break;
                            cold_basements[rand.nextInt(cold_basements.length)].initializeType(tile, rand);
                            break;
                        }
                        case WELLS: {
                            if (cold_wells.length <= 0) break;
                            cold_wells[rand.nextInt(cold_wells.length)].initializeType(tile, rand);
                            break;
                        }
                        case TOMBS: {
                            if (cold_tombs.length <= 0) break;
                            cold_tombs[rand.nextInt(cold_tombs.length)].initializeType(tile, 1.0f, 0, rand);
                            break;
                        }
                        case CLIFF: {
                            if (cold_cliffs.length <= 0) break;
                            cold_cliffs[rand.nextInt(cold_cliffs.length)].initializeType(tile, 1.0f, 0, rand);
                        }
                    }
                    break;
                }
                case Desert: {
                    switch (loc) {
                        case ALTARS: {
                            if (desert_altars.length <= 0) break;
                            desert_altars[rand.nextInt(desert_altars.length)].initializeType(tile, rand);
                            break;
                        }
                        case BASEMENTS: {
                            if (desert_basements.length <= 0) break;
                            desert_basements[rand.nextInt(desert_basements.length)].initializeType(tile, rand);
                            break;
                        }
                        case WELLS: {
                            if (desert_wells.length <= 0) break;
                            desert_wells[rand.nextInt(desert_wells.length)].initializeType(tile, rand);
                            break;
                        }
                        case TOMBS: {
                            if (desert_tombs.length <= 0) break;
                            desert_tombs[rand.nextInt(desert_tombs.length)].initializeType(tile, 0.2f, 1, rand);
                            break;
                        }
                        case CLIFF: {
                            if (desert_cliffs.length <= 0) break;
                            desert_cliffs[rand.nextInt(desert_cliffs.length)].initializeType(tile, 1.0f, 1, rand);
                        }
                    }
                    break;
                }
                case Jungle: {
                    switch (loc) {
                        case ALTARS: {
                            break;
                        }
                        case BASEMENTS: {
                            if (jungle_basements.length <= 0) break;
                            jungle_basements[rand.nextInt(jungle_basements.length)].initializeType(tile, rand);
                            break;
                        }
                        case WELLS: {
                            if (jungle_wells.length <= 0) break;
                            jungle_wells[rand.nextInt(jungle_wells.length)].initializeType(tile, rand);
                            break;
                        }
                        case TOMBS: {
                            if (jungle_tombs.length <= 0) break;
                            jungle_tombs[rand.nextInt(jungle_tombs.length)].initializeType(tile, 0.7f, 0, rand);
                            break;
                        }
                        case CLIFF: {
                            if (jungle_cliffs.length <= 0) break;
                            jungle_cliffs[rand.nextInt(jungle_cliffs.length)].initializeType(tile, 1.0f, 1, rand);
                        }
                    }
                    break;
                }
                case Border: {
                    break;
                }
            }
        }

        static {
            forest_basements = new UrnLootType[]{FOREST_BASEMENTS_1, FOREST_BASEMENTS_2, FOREST_BASEMENTS_3};
            forest_wells = new UrnLootType[]{FOREST_WELLS_1, FOREST_WELLS_2};
            forest_tombs = new UrnLootType[]{FOREST_TOMB_1, FOREST_TOMB_2, FOREST_TOMB_3, FOREST_TOMB_4};
            forest_cliffs = new UrnLootType[]{FOREST_TOMB_1, FOREST_TOMB_2, FOREST_TOMB_3, FOREST_TOMB_4};
            swamp_basements = new UrnLootType[]{SWAMP_BASEMENTS_1, SWAMP_BASEMENTS_2, SWAMP_BASEMENTS_3};
            swamp_wells = new UrnLootType[]{SWAMP_WELLS_1, SWAMP_WELLS_2};
            swamp_tombs = new UrnLootType[]{SWAMP_TOMB_1, SWAMP_TOMB_2, SWAMP_TOMB_3, SWAMP_TOMB_4, SWAMP_TOMB_5};
            swamp_cliffs = new UrnLootType[]{SWAMP_TOMB_1, SWAMP_TOMB_2, SWAMP_TOMB_3, SWAMP_TOMB_4, SWAMP_TOMB_5};
            cold_basements = new UrnLootType[]{SNOW_BASEMENTS_1, SNOW_BASEMENTS_2, SNOW_BASEMENTS_3, SNOW_BASEMENTS_4, SNOW_BASEMENTS_5};
            cold_wells = new UrnLootType[]{SNOW_WELLS_1, SNOW_WELLS_2};
            cold_tombs = new UrnLootType[]{SNOW_TOMB_1, SNOW_TOMB_2, SNOW_TOMB_3, SNOW_TOMB_4, SNOW_TOMB_5};
            cold_cliffs = new UrnLootType[]{SNOW_TOMB_1, SNOW_TOMB_2, SNOW_TOMB_3, SNOW_TOMB_4, SNOW_TOMB_5};
            desert_altars = new UrnLootType[]{DESERT_ALTAR_1};
            desert_basements = new UrnLootType[]{DESERT_BASEMENTS_1, DESERT_BASEMENTS_2, DESERT_BASEMENTS_3};
            desert_wells = new UrnLootType[]{DESERT_WELLS_1, DESERT_WELLS_2};
            desert_tombs = new UrnLootType[]{DESERT_TOMB_1, DESERT_TOMB_2, DESERT_TOMB_3, DESERT_TOMB_4, DESERT_TOMB_5};
            desert_cliffs = new UrnLootType[]{DESERT_TOMB_1, DESERT_TOMB_2, DESERT_TOMB_3, DESERT_TOMB_4, DESERT_TOMB_5};
            jungle_basements = new UrnLootType[]{JUNGLE_BASEMENTS_1, JUNGLE_BASEMENTS_2, JUNGLE_BASEMENTS_3};
            jungle_wells = new UrnLootType[]{JUNGLE_WELLS_1, JUNGLE_WELLS_2};
            jungle_tombs = new UrnLootType[]{JUNGLE_TOMB_1, JUNGLE_TOMB_2, JUNGLE_TOMB_3, JUNGLE_TOMB_4};
            jungle_cliffs = new UrnLootType[]{JUNGLE_TOMB_1, JUNGLE_TOMB_2, JUNGLE_TOMB_3, JUNGLE_TOMB_4};
        }
    }

    public static enum UrnType {
        NORMAL(0, "textures/entity/urn/urn_normal.png", false, "paper"),
        PATINA(1, "textures/entity/urn/urn_patina.png", false, "mulch"),
        LINE(2, "textures/entity/urn/urn_line.png", false, "string"),
        STRIPE(3, "textures/entity/urn/urn_stripe.png", false, "stickWood"),
        STARS(4, "textures/entity/urn/urn_stars.png", false, "dustSalt", "dustSaltpeter"),
        CLOTH(5, "textures/entity/urn/urn_cloth.png", false, "feather"),
        ZONE(6, "textures/entity/urn/urn_zone.png", false, "bone"),
        RARE_1(16, "textures/entity/urn/urn_rare_1.png", true, new String[0]),
        RARE_2(17, "textures/entity/urn/urn_rare_2.png", true, new String[0]),
        RARE_3(18, "textures/entity/urn/urn_rare_3.png", true, new String[0]),
        RARE_4(19, "textures/entity/urn/urn_rare_4.png", true, new String[0]),
        RARE_5(20, "textures/entity/urn/urn_rare_5.png", true, new String[0]),
        RARE_6(21, "textures/entity/urn/urn_rare_6.png", true, new String[0]),
        RARE_7(22, "textures/entity/urn/urn_rare_7.png", true, new String[0]),
        RARE_8(23, "textures/entity/urn/urn_rare_8.png", true, new String[0]),
        RARE_9(24, "textures/entity/urn/urn_rare_9.png", true, new String[0]),
        RARE_10(25, "textures/entity/urn/urn_rare_10.png", true, new String[0]),
        RARE_11(26, "textures/entity/urn/urn_rare_11.png", true, new String[0]),
        RARE_12(27, "textures/entity/urn/urn_rare_12.png", true, new String[0]);

        private final int id;
        private final ResourceLocation res;
        private final boolean rare;
        private final String[] tool;
        private static final HashMap<Integer, UrnType> ID_LOOKUP;
        public static final HashMap<String[], UrnType> TOOL_LOOKUP;
        public static final ArrayList<UrnType> RARE_LOOKUP;

        private UrnType(int id, String textureLocation, boolean rare, String ... tool) {
            this.id = id;
            this.res = new ResourceLocation("mist", textureLocation);
            this.rare = rare;
            this.tool = tool;
        }

        public int getId() {
            return this.id;
        }

        public ResourceLocation getTexture() {
            return this.res;
        }

        public boolean isRare() {
            return this.rare;
        }

        public String[] getTool() {
            return this.tool;
        }

        public static UrnType byId(int id) {
            if (ID_LOOKUP.containsKey(id)) {
                return ID_LOOKUP.get(id);
            }
            return NORMAL;
        }

        public static UrnType byTool(ItemStack stack) {
            for (String[] tools : TOOL_LOOKUP.keySet()) {
                for (String tool : tools) {
                    if (!OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)tool), (ItemStack[])new ItemStack[]{stack})) continue;
                    return TOOL_LOOKUP.get(tools);
                }
            }
            return NORMAL;
        }

        public static boolean isTool(ItemStack stack) {
            for (String[] tools : TOOL_LOOKUP.keySet()) {
                for (String tool : tools) {
                    if (!OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)tool), (ItemStack[])new ItemStack[]{stack})) continue;
                    return true;
                }
            }
            return false;
        }

        public static NBTTagCompound getTag(ItemStack urn) {
            return urn.func_179543_a("Urn");
        }

        public static UrnType getType(ItemStack urn, NBTTagCompound tag) {
            if (tag == null) {
                tag = UrnType.getTag(urn);
            }
            return tag != null && tag.func_74764_b("UrnType") ? UrnType.byId(tag.func_74762_e("UrnType")) : NORMAL;
        }

        public static int getTintColor(ItemStack urn, NBTTagCompound tag) {
            if (tag == null) {
                tag = UrnType.getTag(urn);
            }
            return tag != null && tag.func_74764_b("TintColor") ? tag.func_74762_e("TintColor") : -1;
        }

        public static int getPatinaColor(ItemStack urn, NBTTagCompound tag) {
            if (tag == null) {
                tag = UrnType.getTag(urn);
            }
            return tag != null && tag.func_74764_b("PatinaColor") ? tag.func_74762_e("PatinaColor") : -1;
        }

        public static String getTooltip(ItemStack urn, NBTTagCompound tag) {
            String tooltip;
            if (tag == null) {
                tag = UrnType.getTag(urn);
            }
            if (tag != null && !(tooltip = tag.func_74779_i("UrnTooltip")).isEmpty()) {
                tooltip = I18n.func_135052_a((String)("item.mist.urn.tooltip." + tooltip), (Object[])new Object[0]);
                String location = tag.func_74779_i("UrnLocation");
                if (!location.isEmpty()) {
                    location = I18n.func_135052_a((String)("item.mist.urn.location." + location), (Object[])new Object[0]);
                }
                return tooltip + " (" + location + ")";
            }
            return "";
        }

        static {
            ID_LOOKUP = new HashMap();
            TOOL_LOOKUP = new HashMap();
            RARE_LOOKUP = new ArrayList();
            for (UrnType type : UrnType.values()) {
                ID_LOOKUP.put(type.getId(), type);
            }
            for (UrnType type : UrnType.values()) {
                if (type.getTool() == null) continue;
                TOOL_LOOKUP.put(type.getTool(), type);
            }
            for (UrnType type : UrnType.values()) {
                if (!type.rare) continue;
                RARE_LOOKUP.add(type);
            }
        }
    }
}

