/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.tileentity;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import ru.liahim.mist.util.InventoryUtil;

public class TileEntityRemains
extends TileEntityLockableLoot
implements ISidedInventory {
    private int size;
    private NonNullList<ItemStack> contents;
    private int[] slots;
    public int cooldown = -1;

    public int func_70302_i_() {
        return this.contents == null ? 0 : this.contents.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.contents) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    private boolean isFull() {
        if (this.contents == null) {
            return true;
        }
        for (ItemStack stack : this.contents) {
            if (!stack.func_190926_b() && stack.func_190916_E() >= Math.min(stack.func_77976_d(), this.func_70297_j_())) continue;
            return false;
        }
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public String func_70005_c_() {
        return null;
    }

    public void init(int size) {
        this.size = size;
        this.contents = NonNullList.func_191197_a((int)this.size, (Object)ItemStack.field_190927_a);
        this.slots = new int[size];
        for (int i = 0; i < size; ++i) {
            this.slots[i] = i;
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.init(compound.func_74762_e("Size"));
        this.readItems(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("Size", this.size);
        return this.writeItems(compound);
    }

    public void readItems(NBTTagCompound compound) {
        if (!this.func_184283_b(compound)) {
            ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.contents);
        }
    }

    public NBTTagCompound writeItems(NBTTagCompound compound) {
        if (!this.func_184282_c(compound)) {
            ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.contents);
        }
        return compound;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer player) {
        this.func_184281_d(player);
        return null;
    }

    public void func_184281_d(@Nullable EntityPlayer player) {
        if (this.field_184284_m != null && this.field_145850_b instanceof WorldServer) {
            LootTable loottable = this.field_145850_b.func_184146_ak().func_186521_a(this.field_184284_m);
            this.field_184284_m = null;
            Random random = this.field_184285_n == 0L ? new Random() : new Random(this.field_184285_n);
            LootContext.Builder builder = new LootContext.Builder((WorldServer)this.field_145850_b);
            if (player != null) {
                builder.func_186469_a(player.func_184817_da()).func_186470_a(player);
            }
            loottable.func_186460_a((IInventory)this, random, builder.func_186471_a());
        }
    }

    public boolean putStack(ItemStack heldItem) {
        if (this.isFull()) {
            return false;
        }
        boolean put = false;
        for (int i = 0; i < this.contents.size(); ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack.func_190926_b()) {
                stack = heldItem.func_77979_a(Math.min(heldItem.func_190916_E(), this.func_70297_j_()));
                if (!stack.func_190926_b()) {
                    this.func_70299_a(i, stack);
                    if (!put) {
                        put = true;
                    }
                }
                if (heldItem.func_190916_E() != 0) continue;
                break;
            }
            if (!InventoryUtil.canCombineStack(stack, heldItem)) continue;
            int j = Math.min(heldItem.func_190916_E(), Math.min(heldItem.func_77976_d(), this.func_70297_j_()) - stack.func_190916_E());
            heldItem.func_190918_g(j);
            stack.func_190917_f(j);
            if (!put) {
                boolean bl = put = j > 0;
            }
            if (heldItem.func_190916_E() == 0) break;
        }
        if (put) {
            this.func_70296_d();
        }
        return put;
    }

    public void pullStack(EntityItem entity) {
        ItemStack stack = entity.func_92059_d().func_77946_l();
        this.putStack(stack);
        if (stack.func_190926_b()) {
            entity.func_70106_y();
        } else {
            entity.func_92058_a(stack);
        }
    }

    public String func_174875_k() {
        return null;
    }

    protected NonNullList<ItemStack> func_190576_q() {
        return this.contents;
    }

    public int[] func_180463_a(EnumFacing side) {
        return this.slots;
    }

    public boolean func_180462_a(int index, ItemStack stack, EnumFacing direction) {
        if (direction == EnumFacing.DOWN) {
            return false;
        }
        return index >= 0 && index < this.size;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return direction == EnumFacing.DOWN && index >= 0 && index < this.size;
    }
}

