/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.tileentity;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import ru.liahim.mist.block.upperplant.MistMushroom;

public class TileEntityMycelium
extends TileEntity {
    private IBlockState mushroom;
    private int[] faceSize = new int[4];
    private int deadTime = 0;

    public IBlockState getMushroomState() {
        return this.mushroom;
    }

    public void setMushroomState(IBlockState state, boolean isNature) {
        if (state.func_177230_c() instanceof MistMushroom) {
            this.mushroom = state;
            if (isNature) {
                this.faceSize = new int[]{32, 32, 32, 32};
            }
        } else {
            this.mushroom = null;
        }
        this.func_70296_d();
    }

    public int[] getFaceSize() {
        return this.faceSize;
    }

    public int getFaceSize(EnumFacing face) {
        return this.faceSize[face.func_176736_b()];
    }

    public int getMaxSize() {
        int size = 0;
        for (int i : this.faceSize) {
            if (i <= size) continue;
            size = i;
        }
        return size;
    }

    public void setFaceSize(EnumFacing face, int size) {
        this.faceSize[face.func_176736_b()] = size;
        this.func_70296_d();
    }

    public int getDeadTime() {
        return this.deadTime;
    }

    public void setDeadTime(int deadTime) {
        this.deadTime = deadTime;
        this.func_70296_d();
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("Mushroom")) {
            NBTTagCompound tag = compound.func_74775_l("Mushroom");
            Block block = tag.func_150297_b("id", 8) ? Block.func_149684_b((String)tag.func_74779_i("id")) : Blocks.field_150350_a;
            this.setMushroomState(block.func_176203_a((int)tag.func_74771_c("Damage")), false);
            this.faceSize = tag.func_74759_k("FaceSize");
            this.deadTime = tag.func_74762_e("DeadTime");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74783_a("FaceSize", this.faceSize);
        tag.func_74768_a("DeadTime", this.deadTime);
        compound.func_74782_a("Mushroom", (NBTBase)tag);
        return this.getMushroomNBT(compound);
    }

    public NBTTagCompound getMushroomNBT(NBTTagCompound compound) {
        if (this.mushroom != null) {
            NBTTagCompound tag = compound.func_74764_b("Mushroom") ? compound.func_74775_l("Mushroom") : new NBTTagCompound();
            ResourceLocation res = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.mushroom.func_177230_c());
            tag.func_74778_a("id", res == null ? "minecraft:air" : res.toString());
            tag.func_74777_a("Damage", (short)this.mushroom.func_177230_c().func_176201_c(this.mushroom));
            compound.func_74782_a("Mushroom", (NBTBase)tag);
        }
        return compound;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = this.func_189517_E_();
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return tag;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }
}

