/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.tileentity;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.SlotFurnaceFuel;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import ru.liahim.mist.api.item.MistItems;
import ru.liahim.mist.api.loottable.LootTables;
import ru.liahim.mist.block.gizmos.MistFurnace;
import ru.liahim.mist.inventory.container.ContainerMistFurnace;

public class TileEntityMistFurnace
extends TileEntityLockableLoot
implements ITickable,
ISidedInventory {
    private static final int[] SLOTS_INPUT = new int[]{0, 1};
    private static final int[] SLOTS_OUTPUT = new int[]{0, 1, 2, 3};
    private static final int[] SLOTS_LEFT = new int[]{0};
    private static final int[] SLOTS_RIGHT = new int[]{1};
    private NonNullList<ItemStack> furnaceItemStacks = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    private int[] furnaceBurnTime = new int[]{0, 0};
    private int[] currentItemBurnTime = new int[]{0, 0};
    private float[] cookTime = new float[]{0.0f, 0.0f};
    private int[] totalCookTime = new int[]{0, 0};
    public int[] ashProgress = new int[]{0, 0};
    private boolean close = false;
    private boolean signal = false;
    protected ResourceLocation lootTableInput;
    protected ResourceLocation lootTableOutput;
    private float[] temperature = new float[11];
    private static final float[] leftFactor = new float[]{0.84f, 0.91f, 0.96f, 0.99f, 1.0f, 0.99f, 0.96f, 0.91f, 0.84f, 0.74f, 0.63f};
    private static final float[] rightFactor = new float[]{0.63f, 0.74f, 0.84f, 0.91f, 0.96f, 0.99f, 1.0f, 0.99f, 0.96f, 0.91f, 0.84f};
    private static final int[] leftLimit = new int[]{2700, 2850, 2950, 3000, 3000, 3000, 2950, 2850, 2700, 2500, 2250};
    private static final int[] rightLimit = new int[]{2250, 2500, 2700, 2850, 2950, 3000, 3000, 3000, 2950, 2850, 2700};
    private static final int[] mainLimit = new int[]{2700, 2850, 2950, 3000, 3000, 3000, 3000, 3000, 2950, 2850, 2700};
    private static final int radius = 8;
    public static final int ashTime = 1200;
    public static final int burnTemp = 300;
    private boolean stateCheck = false;
    IItemHandler[] handler = new SidedInvWrapper[]{new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN), new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP), new SidedInvWrapper((ISidedInventory)this, EnumFacing.NORTH), new SidedInvWrapper((ISidedInventory)this, EnumFacing.SOUTH), new SidedInvWrapper((ISidedInventory)this, EnumFacing.WEST), new SidedInvWrapper((ISidedInventory)this, EnumFacing.EAST)};

    public void fire() {
        this.temperature[2] = Math.max(100.0f, this.temperature[2]);
        this.temperature[3] = Math.max(150.0f, this.temperature[3]);
        this.temperature[4] = Math.max(250.0f, this.temperature[4]);
        this.temperature[5] = Math.max(300.0f, this.temperature[5]);
        this.temperature[6] = Math.max(250.0f, this.temperature[6]);
        this.temperature[7] = Math.max(150.0f, this.temperature[7]);
        this.temperature[8] = Math.max(100.0f, this.temperature[8]);
    }

    public float getMaxTemperature() {
        float t = 0.0f;
        for (int i = 4; i <= 6; ++i) {
            if (!(this.temperature[i] > t)) continue;
            t = this.temperature[i];
        }
        return t;
    }

    private float getNormalTemperature() {
        return 2500.0f;
    }

    private float getTemperature(int index) {
        return index == 0 ? this.getLeftTemperature() : this.getRightTemperature();
    }

    private float getLeftTemperature() {
        float t = 0.0f;
        for (int i = 0; i < 8; ++i) {
            t += this.temperature[i];
        }
        return t / 8.0f;
    }

    private float getRightTemperature() {
        float t = 0.0f;
        for (int i = this.temperature.length - 8; i < this.temperature.length; ++i) {
            t += this.temperature[i];
        }
        return t / 8.0f;
    }

    private void heatLeft(float amount) {
        for (int i = 0; i < this.temperature.length; ++i) {
            int limit;
            int n = i;
            this.temperature[n] = this.temperature[n] + amount * leftFactor[i];
            int n2 = limit = this.currentItemBurnTime[1] > 0 ? mainLimit[i] : leftLimit[i];
            if (!(this.temperature[i] > (float)limit)) continue;
            this.temperature[i] = limit;
        }
    }

    private void heatRight(float amount) {
        for (int i = 0; i < this.temperature.length; ++i) {
            int limit;
            int n = i;
            this.temperature[n] = this.temperature[n] + amount * rightFactor[i];
            int n2 = limit = this.currentItemBurnTime[0] > 0 ? mainLimit[i] : rightLimit[i];
            if (!(this.temperature[i] > (float)limit)) continue;
            this.temperature[i] = limit;
        }
    }

    private void heat(int index, float amount) {
        if (index == 0) {
            this.heatLeft(amount);
        } else {
            this.heatRight(amount);
        }
    }

    private void cool(float amount) {
        for (int i = 0; i < this.temperature.length; ++i) {
            int n = i;
            this.temperature[n] = this.temperature[n] - amount;
            if (!(this.temperature[i] < 0.0f)) continue;
            this.temperature[i] = 0.0f;
        }
    }

    public int func_70302_i_() {
        return this.furnaceItemStacks.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.furnaceItemStacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.func_184281_d(null);
        ItemStack itemstack = (ItemStack)this.func_190576_q().get(index);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        this.func_190576_q().set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index < 2 && !flag) {
            this.totalCookTime[index] = this.getCookTime(stack);
            this.cookTime[index] = 0.0f;
            this.func_70296_d();
        }
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.field_190577_o : "container.furnace";
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.furnaceItemStacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        if (!this.func_184283_b(compound)) {
            ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.furnaceItemStacks);
        }
        for (int i : SLOTS_INPUT) {
            this.furnaceBurnTime[i] = compound.func_74762_e("BurnTime_" + i);
            this.currentItemBurnTime[i] = compound.func_74762_e("ItemBurnTime_" + i);
            this.cookTime[i] = compound.func_74760_g("CookTime_" + i);
            this.totalCookTime[i] = compound.func_74762_e("CookTimeTotal_" + i);
            this.ashProgress[i] = compound.func_74762_e("AshProgress_" + i);
            this.close = compound.func_74767_n("Close");
            this.signal = compound.func_74767_n("Signal");
        }
        for (int i = 0; i < this.temperature.length; ++i) {
            this.temperature[i] = compound.func_74760_g("Temperature_" + i);
        }
        if (compound.func_150297_b("CustomName", 8)) {
            this.field_190577_o = compound.func_74779_i("CustomName");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        for (int i : SLOTS_INPUT) {
            compound.func_74768_a("BurnTime_" + i, this.furnaceBurnTime[i]);
            compound.func_74768_a("ItemBurnTime_" + i, this.currentItemBurnTime[i]);
            compound.func_74776_a("CookTime_" + i, this.cookTime[i]);
            compound.func_74768_a("CookTimeTotal_" + i, this.totalCookTime[i]);
            compound.func_74768_a("AshProgress_" + i, this.ashProgress[i]);
            compound.func_74757_a("Close", this.close);
            compound.func_74757_a("Signal", this.signal);
        }
        for (int i = 0; i < this.temperature.length; ++i) {
            compound.func_74776_a("Temperature_" + i, this.temperature[i]);
        }
        if (!this.func_184282_c(compound)) {
            ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.furnaceItemStacks);
        }
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.field_190577_o);
        }
        return compound;
    }

    protected boolean func_184283_b(NBTTagCompound compound) {
        if (compound.func_150297_b("LootTableInput", 8) && compound.func_150297_b("LootTableOutput", 8)) {
            this.lootTableInput = new ResourceLocation(compound.func_74779_i("LootTableInput"));
            this.lootTableOutput = new ResourceLocation(compound.func_74779_i("LootTableOutput"));
            this.field_184285_n = compound.func_74763_f("LootTableSeed");
            return true;
        }
        return false;
    }

    protected boolean func_184282_c(NBTTagCompound compound) {
        if (this.lootTableInput != null && this.lootTableOutput != null) {
            compound.func_74778_a("LootTableInput", this.lootTableInput.toString());
            compound.func_74778_a("LootTableOutput", this.lootTableOutput.toString());
            if (this.field_184285_n != 0L) {
                compound.func_74772_a("LootTableSeed", this.field_184285_n);
            }
            return true;
        }
        return false;
    }

    public ResourceLocation func_184276_b() {
        return this.lootTableInput;
    }

    public void func_189404_a(ResourceLocation res, long seed) {
        this.lootTableInput = res;
        this.field_184285_n = seed;
    }

    public void setLootTable(ResourceLocation input, ResourceLocation output, long seed) {
        this.func_189404_a(input, seed);
        this.lootTableOutput = output;
    }

    public static void initializeLoot(TileEntity tile, Random rand) {
        if (tile instanceof TileEntityMistFurnace) {
            ((TileEntityMistFurnace)tile).setLootTable(LootTables.FURNACE_INPUT_LOOT, LootTables.FURNACE_OUTPUT_LOOT, rand.nextLong());
            ((TileEntityMistFurnace)tile).setClose(rand.nextBoolean());
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public boolean hasSignal() {
        return this.signal;
    }

    public void setSignal(boolean signal) {
        this.signal = signal;
    }

    public int func_70297_j_() {
        return 64;
    }

    private boolean isLeftBurning() {
        return this.furnaceBurnTime[0] > 0;
    }

    private boolean isRightBurning() {
        return this.furnaceBurnTime[1] > 0;
    }

    public boolean isBurning(int index) {
        return index == 0 ? this.isLeftBurning() : this.isRightBurning();
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isBurning(IInventory inventory) {
        return inventory.func_174887_a_(0) > 0 || inventory.func_174887_a_(1) > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isBurning(IInventory inventory, int index) {
        return inventory.func_174887_a_(index) > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public static int getTemp(IInventory inventory) {
        float t = 0.0f;
        for (int i = 4; i <= 6; ++i) {
            if (!((float)inventory.func_174887_a_(i + 10) > t)) continue;
            t = inventory.func_174887_a_(i + 10);
        }
        return (int)t;
    }

    @SideOnly(value=Side.CLIENT)
    public int getClientComparatorOutput(IInventory inventory) {
        float t = 0.0f;
        for (int i = 0; i < this.temperature.length; ++i) {
            t += (float)inventory.func_174887_a_(i + 10);
        }
        return this.comparatorMath(t);
    }

    @SideOnly(value=Side.CLIENT)
    public static int getTemp(IInventory inventory, int index) {
        return inventory.func_174887_a_(index + 10);
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isClose(IInventory inventory) {
        return inventory.func_174887_a_(21) == 0;
    }

    public boolean isClose() {
        return this.close;
    }

    public void setClose(boolean close) {
        this.close = close;
    }

    public int getComparatorOutput() {
        float t = 0.0f;
        for (int i = 0; i < this.temperature.length; ++i) {
            t += this.temperature[i];
        }
        return this.comparatorMath(t);
    }

    private int comparatorMath(float temp) {
        return Math.max((int)Math.ceil((temp -= 2000.0f) * 16.0f / 30000.0f), 0);
    }

    public void func_73660_a() {
        if (!this.stateCheck) {
            this.updateStatus();
            this.stateCheck = true;
        }
        if (!this.field_145850_b.field_72995_K) {
            boolean burnCheck = this.isLeftBurning() || this.isRightBurning();
            boolean tempCheck = this.getMaxTemperature() >= 300.0f;
            boolean change = false;
            int comp = this.getComparatorOutput();
            for (int i : SLOTS_INPUT) {
                if (this.isBurning(i)) {
                    int n = i;
                    this.furnaceBurnTime[n] = this.furnaceBurnTime[n] - (!this.close && this.ashProgress[i] < 1200 ? 1 : this.currentItemBurnTime[i] / 100);
                    int n2 = i;
                    this.ashProgress[n2] = this.ashProgress[n2] + 1;
                    this.heat(i, 3.0f);
                }
                if (this.ashProgress[i] < 1200) continue;
                this.putAsh(i);
            }
            if (this.getMaxTemperature() >= 300.0f) {
                if (!this.close) {
                    for (int i : SLOTS_INPUT) {
                        if (this.isBurning(i) || this.ashProgress[i] >= 1200) continue;
                        ItemStack fuelStack = (ItemStack)this.furnaceItemStacks.get(i);
                        this.furnaceBurnTime[i] = TileEntityFurnace.func_145952_a((ItemStack)fuelStack);
                        this.currentItemBurnTime[i] = this.furnaceBurnTime[i];
                        if (!this.isBurning(i)) continue;
                        change = true;
                        if (fuelStack.func_190926_b()) continue;
                        Item fuel = fuelStack.func_77973_b();
                        fuelStack.func_190918_g(1);
                        if (!fuelStack.func_190926_b()) continue;
                        this.furnaceItemStacks.set(i, (Object)fuel.getContainerItem(fuelStack));
                    }
                }
                for (int i : SLOTS_INPUT) {
                    if ((this.close || this.currentItemBurnTime[i] == 0) && this.canSmelt(i)) {
                        float t = this.getTemperature(i);
                        if (!(t > 310.0f)) continue;
                        int n = i;
                        this.cookTime[n] = this.cookTime[n] + t / this.getNormalTemperature();
                        if (!(this.cookTime[i] >= (float)this.totalCookTime[i])) continue;
                        this.cookTime[i] = 0.0f;
                        this.totalCookTime[i] = this.getCookTime((ItemStack)this.furnaceItemStacks.get(i));
                        this.smeltItem(i);
                        change = true;
                        continue;
                    }
                    this.cookTime[i] = 0.0f;
                }
            } else {
                for (int i : SLOTS_INPUT) {
                    if (!(this.cookTime[i] > 0.0f)) continue;
                    this.cookTime[i] = MathHelper.func_76131_a((float)(this.cookTime[i] - 2.0f), (float)0.0f, (float)this.totalCookTime[i]);
                }
            }
            this.cool(this.close || this.isLeftBurning() || this.isRightBurning() ? 1.0f : 2.0f);
            if (burnCheck != this.isLeftBurning() || this.isRightBurning() || tempCheck != this.getMaxTemperature() >= 300.0f) {
                change = true;
                this.updateStatus();
            }
            if (comp != this.getComparatorOutput()) {
                change = true;
                MistFurnace.checkSingal(this.field_145850_b, this.field_174879_c, this);
            }
            if (change) {
                this.func_70296_d();
            }
        }
    }

    public void updateStatus() {
        boolean burn;
        boolean bl = burn = this.getMaxTemperature() >= 300.0f;
        int status = this.close ? (burn ? 4 : 0) : (this.isLeftBurning() || this.isRightBurning() ? 3 : (burn ? 2 : 1));
        MistFurnace.setState(status, this.field_145850_b, this.field_174879_c);
    }

    @SideOnly(value=Side.CLIENT)
    public static int getStatus(IInventory inventory) {
        boolean burn;
        boolean bl = burn = TileEntityMistFurnace.getTemp(inventory) >= 300;
        return !TileEntityMistFurnace.isClose(inventory) ? (burn ? 4 : 0) : (TileEntityMistFurnace.isBurning(inventory) ? 3 : (burn ? 2 : 1));
    }

    public int getCookTime(ItemStack stack) {
        return 200;
    }

    private boolean canSmelt(int index) {
        if (((ItemStack)this.furnaceItemStacks.get(index)).func_190926_b()) {
            return false;
        }
        ItemStack stack = FurnaceRecipes.func_77602_a().func_151395_a((ItemStack)this.furnaceItemStacks.get(index));
        if (stack.func_190926_b()) {
            return false;
        }
        ItemStack outStack = (ItemStack)this.furnaceItemStacks.get(index + 2);
        if (outStack.func_190926_b()) {
            return true;
        }
        if (!outStack.func_77969_a(stack)) {
            return false;
        }
        if (outStack.func_190916_E() + stack.func_190916_E() <= this.func_70297_j_() && outStack.func_190916_E() + stack.func_190916_E() <= outStack.func_77976_d()) {
            return true;
        }
        return outStack.func_190916_E() + stack.func_190916_E() <= stack.func_77976_d();
    }

    public void smeltItem(int index) {
        if (this.canSmelt(index)) {
            ItemStack itemstack = (ItemStack)this.furnaceItemStacks.get(index);
            ItemStack itemstack1 = FurnaceRecipes.func_77602_a().func_151395_a(itemstack);
            ItemStack itemstack2 = (ItemStack)this.furnaceItemStacks.get(index + 2);
            if (itemstack2.func_190926_b()) {
                this.furnaceItemStacks.set(index + 2, (Object)itemstack1.func_77946_l());
            } else if (itemstack2.func_77973_b() == itemstack1.func_77973_b()) {
                itemstack2.func_190917_f(itemstack1.func_190916_E());
            }
            itemstack.func_190918_g(1);
        }
    }

    public void putAsh(int index) {
        ItemStack out = (ItemStack)this.furnaceItemStacks.get(index + 2);
        if (out.func_190926_b()) {
            this.furnaceItemStacks.set(index + 2, (Object)new ItemStack(MistItems.ASH));
            this.ashProgress[index] = 0;
        } else if (out.func_77973_b() == MistItems.ASH && out.func_190916_E() < 16) {
            out.func_190917_f(1);
            this.ashProgress[index] = 0;
        } else {
            this.ashProgress[index] = 1200;
        }
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
        this.updateStatus();
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index > 1) {
            return false;
        }
        ItemStack itemstack = (ItemStack)this.furnaceItemStacks.get(1);
        return !FurnaceRecipes.func_77602_a().func_151395_a(stack).func_190926_b() || TileEntityFurnace.func_145954_b((ItemStack)stack);
    }

    public int[] func_180463_a(EnumFacing side) {
        if (side == EnumFacing.DOWN) {
            return SLOTS_OUTPUT;
        }
        if (side == EnumFacing.UP) {
            return SLOTS_INPUT;
        }
        EnumFacing face = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)MistFurnace.FACING);
        if (side == face.func_176746_e()) {
            return SLOTS_LEFT;
        }
        if (side == face.func_176735_f()) {
            return SLOTS_RIGHT;
        }
        return SLOTS_INPUT;
    }

    public boolean func_180462_a(int index, ItemStack stack, EnumFacing direction) {
        return this.func_94041_b(index, stack);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return direction == EnumFacing.DOWN && index > 1 || SlotFurnaceFuel.func_178173_c_((ItemStack)stack);
    }

    public String func_174875_k() {
        return "mist:furnace";
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer player) {
        this.func_184281_d(player);
        return new ContainerMistFurnace(playerInventory, (IInventory)this);
    }

    public void func_184281_d(@Nullable EntityPlayer player) {
        if (this.lootTableInput != null && this.lootTableOutput != null && this.field_145850_b instanceof WorldServer) {
            LootTable inputTable = this.field_145850_b.func_184146_ak().func_186521_a(this.lootTableInput);
            LootTable outputTable = this.field_145850_b.func_184146_ak().func_186521_a(this.lootTableOutput);
            this.lootTableInput = null;
            this.lootTableOutput = null;
            Random random = this.field_184285_n == 0L ? new Random() : new Random(this.field_184285_n);
            LootContext.Builder builder = new LootContext.Builder((WorldServer)this.field_145850_b);
            if (player != null) {
                builder.func_186469_a(player.func_184817_da()).func_186470_a(player);
            }
            List inputList = inputTable.func_186462_a(random, builder.func_186471_a());
            List outputList = outputTable.func_186462_a(random, builder.func_186471_a());
            if (inputList.size() > 0) {
                if (inputList.size() < 2) {
                    inputList.add(this.field_145850_b.field_73012_v.nextInt(2), ItemStack.field_190927_a);
                }
                for (int i : SLOTS_INPUT) {
                    this.func_70299_a(i, (ItemStack)inputList.get(i));
                }
            }
            if (outputList.size() > 0) {
                if (outputList.size() < 2) {
                    outputList.add(this.field_145850_b.field_73012_v.nextInt(2), ItemStack.field_190927_a);
                }
                for (int i : SLOTS_INPUT) {
                    this.func_70299_a(i + 2, (ItemStack)outputList.get(i));
                }
            }
        }
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.furnaceBurnTime[0];
            }
            case 1: {
                return this.furnaceBurnTime[1];
            }
            case 2: {
                return this.currentItemBurnTime[0];
            }
            case 3: {
                return this.currentItemBurnTime[1];
            }
            case 4: {
                return (int)this.cookTime[0];
            }
            case 5: {
                return (int)this.cookTime[1];
            }
            case 6: {
                return this.totalCookTime[0];
            }
            case 7: {
                return this.totalCookTime[1];
            }
            case 8: {
                return this.ashProgress[0];
            }
            case 9: {
                return this.ashProgress[1];
            }
            case 10: {
                return (int)this.temperature[0];
            }
            case 11: {
                return (int)this.temperature[1];
            }
            case 12: {
                return (int)this.temperature[2];
            }
            case 13: {
                return (int)this.temperature[3];
            }
            case 14: {
                return (int)this.temperature[4];
            }
            case 15: {
                return (int)this.temperature[5];
            }
            case 16: {
                return (int)this.temperature[6];
            }
            case 17: {
                return (int)this.temperature[7];
            }
            case 18: {
                return (int)this.temperature[8];
            }
            case 19: {
                return (int)this.temperature[9];
            }
            case 20: {
                return (int)this.temperature[10];
            }
            case 21: {
                return this.close ? 0 : 1;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.furnaceBurnTime[0] = value;
                break;
            }
            case 1: {
                this.furnaceBurnTime[1] = value;
                break;
            }
            case 2: {
                this.currentItemBurnTime[0] = value;
                break;
            }
            case 3: {
                this.currentItemBurnTime[1] = value;
                break;
            }
            case 4: {
                this.cookTime[0] = value;
                break;
            }
            case 5: {
                this.cookTime[1] = value;
                break;
            }
            case 6: {
                this.totalCookTime[0] = value;
                break;
            }
            case 7: {
                this.totalCookTime[1] = value;
                break;
            }
            case 8: {
                this.ashProgress[0] = value;
                break;
            }
            case 9: {
                this.ashProgress[1] = value;
                break;
            }
            case 10: {
                this.temperature[0] = value;
                break;
            }
            case 11: {
                this.temperature[1] = value;
                break;
            }
            case 12: {
                this.temperature[2] = value;
                break;
            }
            case 13: {
                this.temperature[3] = value;
                break;
            }
            case 14: {
                this.temperature[4] = value;
                break;
            }
            case 15: {
                this.temperature[5] = value;
                break;
            }
            case 16: {
                this.temperature[6] = value;
                break;
            }
            case 17: {
                this.temperature[7] = value;
                break;
            }
            case 18: {
                this.temperature[8] = value;
                break;
            }
            case 19: {
                this.temperature[9] = value;
                break;
            }
            case 20: {
                this.temperature[10] = value;
                break;
            }
            case 21: {
                this.close = value == 0;
            }
        }
    }

    public int func_174890_g() {
        return 22;
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.handler[facing.func_176745_a()];
        }
        return (T)super.getCapability(capability, facing);
    }

    protected NonNullList<ItemStack> func_190576_q() {
        return this.furnaceItemStacks;
    }
}

