/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.tileentity;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import ru.liahim.mist.api.biome.EnumBiomeType;
import ru.liahim.mist.api.loottable.LootTables;
import ru.liahim.mist.block.gizmos.MistChest;
import ru.liahim.mist.util.InventoryUtil;

public class TileEntityMistChest
extends TileEntityChest {
    private MistChest.ChestType cachedChestType;

    public TileEntityMistChest() {
    }

    public TileEntityMistChest(MistChest.ChestType type) {
        this.cachedChestType = type;
    }

    public String func_174875_k() {
        return "mist:chest";
    }

    @Nullable
    protected TileEntityChest func_174911_a(EnumFacing side) {
        TileEntity te;
        BlockPos blockpos = this.field_174879_c.func_177972_a(side);
        if (this.isChestAt(blockpos) && (te = this.field_145850_b.func_175625_s(blockpos)) instanceof TileEntityMistChest) {
            TileEntityMistChest chest = (TileEntityMistChest)te;
            chest.setNeighbor(this, side.func_176734_d());
            return chest;
        }
        return null;
    }

    private boolean isChestAt(BlockPos pos) {
        if (this.field_145850_b == null) {
            return false;
        }
        Block block = this.field_145850_b.func_180495_p(pos).func_177230_c();
        return block instanceof MistChest && ((MistChest)block).type == this.getType();
    }

    public void func_174889_b(EntityPlayer player) {
        if (!player.func_175149_v()) {
            if (this.field_145987_o < 0) {
                this.field_145987_o = 0;
            }
            ++this.field_145987_o;
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, this.field_145987_o);
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), false);
            if (this.getType().isTrapped()) {
                this.field_145850_b.func_175685_c(this.field_174879_c.func_177977_b(), this.func_145838_q(), false);
            }
        }
    }

    public void func_174886_c(EntityPlayer player) {
        if (!player.func_175149_v() && this.func_145838_q() instanceof BlockChest) {
            --this.field_145987_o;
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, this.field_145987_o);
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), false);
            if (this.getType().isTrapped()) {
                this.field_145850_b.func_175685_c(this.field_174879_c.func_177977_b(), this.func_145838_q(), false);
            }
        }
    }

    public void func_184281_d(@Nullable EntityPlayer player) {
        if (this.field_184284_m != null && this.field_145850_b instanceof WorldServer) {
            LootTable loottable = this.field_145850_b.func_184146_ak().func_186521_a(this.field_184284_m);
            this.field_184284_m = null;
            Random random = this.field_184285_n == 0L ? new Random() : new Random(this.field_184285_n);
            LootContext.Builder builder = new LootContext.Builder((WorldServer)this.field_145850_b);
            if (player != null) {
                builder.func_186469_a(player.func_184817_da()).func_186470_a(player);
            }
            InventoryUtil.optimizeAndFillInventory((IInventory)this, loottable.func_186462_a(random, builder.func_186471_a()), random);
        }
    }

    public MistChest.ChestType getType() {
        if (this.cachedChestType == null) {
            if (this.field_145850_b == null || !(this.func_145838_q() instanceof MistChest)) {
                return MistChest.ChestType.NIOBIUM_BASIC;
            }
            this.cachedChestType = ((MistChest)this.func_145838_q()).type;
        }
        return this.cachedChestType;
    }

    private void setNeighbor(TileEntityChest chest, EnumFacing side) {
        if (chest.func_145837_r()) {
            this.field_145984_a = false;
        } else if (this.field_145984_a) {
            switch (side) {
                case NORTH: {
                    if (this.field_145992_i == chest) break;
                    this.field_145984_a = false;
                    break;
                }
                case SOUTH: {
                    if (this.field_145988_l == chest) break;
                    this.field_145984_a = false;
                    break;
                }
                case EAST: {
                    if (this.field_145990_j == chest) break;
                    this.field_145984_a = false;
                    break;
                }
                case WEST: {
                    if (this.field_145991_k == chest) break;
                    this.field_145984_a = false;
                }
            }
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c.func_177982_a(-1, 0, -1), this.field_174879_c.func_177982_a(2, 2, 2));
    }

    public static void initializeType(TileEntity tile, EnumBiomeType biomeType, Random rand) {
        if (tile instanceof TileEntityMistChest) {
            TileEntityMistChest chest = (TileEntityMistChest)tile;
            switch (biomeType) {
                case Forest: {
                    chest.func_189404_a(LootTables.CHEST_BASEMENTS_FOREST_LOOT, rand.nextLong());
                    break;
                }
                case Desert: {
                    chest.func_189404_a(LootTables.CHEST_BASEMENTS_DESERT_LOOT, rand.nextLong());
                    break;
                }
                case Cold: {
                    chest.func_189404_a(LootTables.CHEST_BASEMENTS_COLD_LOOT, rand.nextLong());
                    break;
                }
                case Jungle: {
                    chest.func_189404_a(LootTables.CHEST_BASEMENTS_JUNGLE_LOOT, rand.nextLong());
                    break;
                }
                case Swamp: {
                    chest.func_189404_a(LootTables.CHEST_BASEMENTS_SWAMP_LOOT, rand.nextLong());
                    break;
                }
            }
        }
    }
}

