/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.tileentity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector3f;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemFishFood;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemSoup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.api.item.IMistFood;
import ru.liahim.mist.api.item.MistItems;
import ru.liahim.mist.block.MistStoneMined;
import ru.liahim.mist.block.gizmos.MistCampfire;
import ru.liahim.mist.common.Mist;
import ru.liahim.mist.init.ItemColoring;
import ru.liahim.mist.item.food.ItemMistSoup;
import ru.liahim.mist.network.PacketFirePitUpdate;
import ru.liahim.mist.network.PacketHandler;
import ru.liahim.mist.util.ItemStackMapKey;
import ru.liahim.mist.util.MapUtil;
import ru.liahim.mist.world.FogDamage;
import ru.liahim.mist.world.MistWorld;

public class TileEntityCampfire
extends TileEntity
implements ITickable,
ISidedInventory,
IFluidTank {
    private MistCampfire.CookingTool cookingTool = MistCampfire.CookingTool.NONE;
    private EnumFacing facing = EnumFacing.NORTH;
    public int toxicY = -2;
    @SideOnly(value=Side.CLIENT)
    private static final int RADIUS = 40;
    @SideOnly(value=Side.CLIENT)
    private static final int ANIMATION_TICKS = 320;
    @SideOnly(value=Side.CLIENT)
    private static int animationTicks;
    private static final HashMap<ItemStack, Vector2f> stoneAndColor;
    private ItemStack stone = ItemStack.field_190927_a;
    private int stoneColor = 0;
    private int minedTimer = -1;
    private final int maxMinedTimer = 500;
    private byte volume;
    private float milk = 0.0f;
    private float finalHealAmaunt = 0.0f;
    private float finalSaturation = 0.0f;
    private float toxic = 0.0f;
    private int toxicTimer;
    private int[] foodColors = new int[4];
    private float[] foodPercent = new float[4];
    private ItemStack[] mainFood = new ItemStack[]{ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a};
    private LinkedHashMap<Integer, Float> foodMap = new LinkedHashMap();
    private LinkedHashMap<ItemStackMapKey, Float> mainFoodMap = new LinkedHashMap();
    private LinkedHashMap<Integer, Float> colorHelper = new LinkedHashMap();
    private HashMap<Potion, Vector3f> potions = new HashMap();
    private HashMap<Potion, Vector3f> rawPotionsHelper = new HashMap();
    private HashMap<Potion, Vector3f> cookPotionsHelper = new HashMap();
    private static final int[] SLOTS_FUEL;
    private static final int[] SLOTS_FOOD;
    private static final int[] SLOTS_GRILL;
    private static final int SLOTS_FUEL_SIZE = 16;
    private static final int SLOTS_FOOD_SIZE = 64;
    private static final int SLOTS_GRILL_SIZE = 4;
    private NonNullList<ItemStack> stacks = NonNullList.func_191197_a((int)80, (Object)ItemStack.field_190927_a);
    private int totalBurningTime = 0;
    private int currentBurningTime = 0;
    private int temperature = 0;
    private float totalProgress = 0.0f;
    private float clientProgress = 0.0f;
    private final float[][] progress = new float[64][2];
    private int ashTimer = 0;

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.toxicY == -2) {
                int n = this.toxicY = this.field_145850_b.field_73011_w.getDimension() == Mist.getID() ? this.field_174879_c.func_177956_o() : -1;
            }
            if (this.temperature > 0) {
                if (this.currentBurningTime == 0) {
                    if (this.totalBurningTime > 0) {
                        for (int i = 0; i < 16; ++i) {
                            ItemStack fuel = this.func_70301_a(i);
                            int time = TileEntityFurnace.func_145952_a((ItemStack)fuel);
                            if (time <= 0) continue;
                            fuel.func_190918_g(1);
                            this.currentBurningTime += time;
                            this.totalBurningTime -= time;
                            this.updateStatus();
                            break;
                        }
                    } else {
                        --this.temperature;
                        if (this.temperature == 0) {
                            this.extinguish(false);
                        }
                    }
                }
                if (this.currentBurningTime > 0) {
                    --this.currentBurningTime;
                    if (this.ashTimer < 16000) {
                        ++this.ashTimer;
                    }
                    if (this.currentBurningTime >= 20 && this.temperature < 1000) {
                        ++this.temperature;
                    }
                    if (this.currentBurningTime == 0 && this.totalBurningTime <= 0) {
                        this.extinguish(true);
                    }
                }
                if (this.temperature > 20) {
                    this.updateFoodProgress(true);
                } else if (this.minedTimer > 0 && this.minedTimer != this.maxMinedTimer) {
                    this.minedTimer = this.maxMinedTimer;
                }
            }
            if (this.toxicY >= 0 && ++this.toxicTimer > 100 && this.getCookingTool() == MistCampfire.CookingTool.POT && this.volume > 0) {
                this.toxicTimer = 0;
                if (MistWorld.isPosInFog(this.field_145850_b, this.toxicY)) {
                    boolean rain = this.field_145850_b.func_72896_J() && this.field_145850_b.func_175678_i(this.field_174879_c);
                    float conc = FogDamage.getConcentration(this.field_145850_b, this.field_174879_c);
                    this.toxic += rain ? 5.0f + 100.0f * conc : 1.0f + 20.0f * conc;
                    if (this.toxic > 10000.0f) {
                        this.toxic = 10000.0f;
                    }
                }
            }
        }
    }

    private void updateFoodProgress(boolean plus) {
        if (this.getCookingTool() == MistCampfire.CookingTool.POT) {
            if (this.volume > 0) {
                float totalProgress = 0.0f;
                float currentProgress = 0.0f;
                for (int i = 0; i < 64; ++i) {
                    if (this.func_70301_a(i + 16).func_190926_b()) continue;
                    if (plus && this.progress[i][0] < (float)this.getPotCookTime()) {
                        float[] fArray = this.progress[i];
                        fArray[0] = fArray[0] + 1.0f;
                    }
                    totalProgress += 1.0f;
                    currentProgress += this.progress[i][0];
                }
                if (totalProgress > 0.0f) {
                    totalProgress = currentProgress / (totalProgress * (float)this.getPotCookTime());
                }
                this.totalProgress = totalProgress;
                if (!plus) {
                    this.clientProgress = this.totalProgress;
                }
                if (this.totalProgress > 0.0f && this.totalProgress < 1.0f) {
                    if (this.totalProgress - this.clientProgress > 0.1f) {
                        this.clientProgress = this.totalProgress;
                        this.updateStatus();
                    }
                } else if (this.totalProgress == 1.0f && this.clientProgress < 1.0f) {
                    this.clientProgress = this.totalProgress;
                    this.updateStatus();
                }
            }
        } else if (this.getCookingTool() == MistCampfire.CookingTool.GRILL) {
            for (int i = 0; i < 4; ++i) {
                if (!(this.progress[i][0] >= 0.0f) || this.func_70301_a(i + 16).func_190926_b()) continue;
                if (this.progress[i][0] < (float)TileEntityCampfire.getGrillCookTime()) {
                    float[] fArray = this.progress[i];
                    fArray[0] = fArray[0] + 1.0f;
                    continue;
                }
                this.func_70299_a(i + 16, FurnaceRecipes.func_77602_a().func_151395_a(this.func_70301_a(i + 16)).func_77946_l());
                this.progress[i][0] = -1.0f;
                this.updateStatus();
            }
        } else if (this.minedTimer > 0) {
            --this.minedTimer;
            if (this.minedTimer == 0) {
                this.minedTimer = this.maxMinedTimer;
                IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a());
                if (state.func_177230_c() == MistBlocks.STONE_MINED) {
                    MistStoneMined.EnumStoneStage type = MistStoneMined.updateHotStatus(this.field_145850_b, this.field_174879_c.func_177984_a(), state);
                    if (type != null) {
                        this.field_145850_b.func_175656_a(this.field_174879_c.func_177984_a(), state.func_177226_a(MistStoneMined.STAGE, (Comparable)((Object)type)));
                    }
                } else {
                    this.minedTimer = -1;
                }
            }
        }
    }

    private int getPotCookTime() {
        return this.volume * 400;
    }

    public static final int getGrillCookTime() {
        return 800;
    }

    private void extinguish(boolean wasFuel) {
        ((MistCampfire)this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c()).extinguish(this.field_145850_b, this.field_174879_c, wasFuel);
    }

    private void updateMainFood() {
        int i;
        this.mainFoodMap.clear();
        for (i = 16; i < this.func_70302_i_(); ++i) {
            ItemStack stack = this.func_70301_a(i).func_77946_l();
            if (stack.func_190926_b()) continue;
            ItemStack cooked = FurnaceRecipes.func_77602_a().func_151395_a(stack);
            float amount = !cooked.func_190926_b() && cooked.func_77973_b() instanceof ItemFood ? (float)((ItemFood)cooked.func_77973_b()).func_150905_g(cooked) : (float)((ItemFood)stack.func_77973_b()).func_150905_g(stack) * TileEntityCampfire.getHealBonus();
            amount = amount * this.progress[i - 16][1] / (float)TileEntityCampfire.foodSize();
            boolean check = false;
            ItemStackMapKey key = new ItemStackMapKey(stack);
            if (this.mainFoodMap.containsKey(key)) {
                this.mainFoodMap.replace(key, Float.valueOf(this.mainFoodMap.get(key).floatValue() + amount));
                check = true;
            }
            if (check) continue;
            this.mainFoodMap.put(key, Float.valueOf(amount));
        }
        if (!this.mainFoodMap.isEmpty()) {
            this.mainFoodMap = (LinkedHashMap)MapUtil.sortByValue(this.mainFoodMap, true);
            i = 0;
            for (ItemStackMapKey finalStack : this.mainFoodMap.keySet()) {
                if (i < 4) {
                    if (this.mainFoodMap.get(finalStack).floatValue() >= (float)this.getVolum() * 0.25f) {
                        this.mainFood[i] = finalStack.itemStack;
                        this.foodPercent[i] = this.mainFoodMap.get(finalStack).floatValue();
                    } else {
                        this.mainFood[i] = ItemStack.field_190927_a;
                        this.foodPercent[i] = 0.0f;
                    }
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            this.mainFood = new ItemStack[]{ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a};
            this.foodPercent = new float[4];
        }
    }

    public float getFinalAmount() {
        return this.finalHealAmaunt;
    }

    public void setMinedStone(boolean stone) {
        this.minedTimer = stone ? this.maxMinedTimer : -1;
    }

    @SideOnly(value=Side.CLIENT)
    public static void updateFrame() {
        animationTicks = (animationTicks + 1) % 320;
    }

    @SideOnly(value=Side.CLIENT)
    private float getInterpolatedFrame(float tick) {
        if (tick > 1.0f) {
            tick = 1.0f;
        }
        return (float)animationTicks + tick;
    }

    @SideOnly(value=Side.CLIENT)
    public double getAnimationPhase(int center, float tick) {
        double i = this.getInterpolatedFrame(tick);
        if (i < (double)(center - 40)) {
            i += 320.0;
        } else if (i >= (double)(center + 40)) {
            i -= 320.0;
        }
        i = 40.0 - Math.abs((double)center - i);
        if (i < 0.0) {
            return 0.0;
        }
        return (1.0 - Math.cos(i / 40.0 * Math.PI)) / 2.0;
    }

    @SideOnly(value=Side.CLIENT)
    public float getCookProgress() {
        return this.totalProgress;
    }

    @SideOnly(value=Side.CLIENT)
    public int[] getFoodColors() {
        return this.foodColors;
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack[] getMainFood() {
        return this.mainFood;
    }

    @SideOnly(value=Side.CLIENT)
    public float[] getFoodPercent() {
        return this.foodPercent;
    }

    public int getTemperature() {
        return this.temperature;
    }

    public void updateFoodColors() {
        int i = 0;
        int count = 0;
        float total = 0.0f;
        this.foodColors = new int[4];
        for (ItemStack stack : this.mainFood) {
            if (!stack.func_190926_b()) {
                int amount;
                ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(stack);
                if (!result.func_190926_b() && result.func_77973_b() instanceof ItemFood) {
                    amount = ((ItemFood)result.func_77973_b()).func_150905_g(result);
                    int start = ItemColoring.getFoodColor(stack);
                    int end = ItemColoring.getFoodColor(result);
                    int red = (int)((float)(start >> 16 & 0xFF) * (1.0f - this.getCookProgress()) + (float)(end >> 16 & 0xFF) * this.getCookProgress());
                    int green = (int)((float)(start >> 8 & 0xFF) * (1.0f - this.getCookProgress()) + (float)(end >> 8 & 0xFF) * this.getCookProgress());
                    int blue = (int)((float)(start & 0xFF) * (1.0f - this.getCookProgress()) + (float)(end & 0xFF) * this.getCookProgress());
                    this.foodColors[i] = red << 16 | green << 8 | blue;
                } else {
                    amount = ((ItemFood)stack.func_77973_b()).func_150905_g(stack);
                    this.foodColors[i] = ItemColoring.getFoodColor(stack);
                }
                total += this.foodPercent[i] / (float)amount;
                ++count;
            } else {
                this.foodColors[i] = 0;
            }
            ++i;
        }
        if (count > 0 && count < 4 && (i = (int)((total = (float)Math.min(4.0, Math.ceil(total / 4.0f))) - (float)count)) > 0) {
            if (i == 3 || count == 1) {
                int j = 1;
                while ((float)j < total) {
                    this.foodColors[j] = this.foodColors[0];
                    ++j;
                }
            } else {
                int j;
                for (j = 0; j < count; ++j) {
                    this.colorHelper.put(this.foodColors[j], Float.valueOf(this.foodPercent[j]));
                }
                this.colorHelper = (LinkedHashMap)MapUtil.sortByValue(this.colorHelper, true);
                if (i == 1) {
                    this.foodColors[0] = (Integer)this.colorHelper.keySet().toArray()[0];
                    for (j = 0; j < count; ++j) {
                        this.foodColors[j + 1] = (Integer)this.colorHelper.keySet().toArray()[j];
                    }
                } else if (i == 2) {
                    if (((Float)this.colorHelper.values().toArray()[0]).floatValue() >= ((Float)this.colorHelper.values().toArray()[1]).floatValue() * 2.0f) {
                        for (j = 0; j < 3; ++j) {
                            this.foodColors[j] = (Integer)this.colorHelper.keySet().toArray()[0];
                        }
                        this.foodColors[3] = (Integer)this.colorHelper.keySet().toArray()[1];
                    } else {
                        for (j = 0; j < 2; ++j) {
                            this.foodColors[j] = (Integer)this.colorHelper.keySet().toArray()[0];
                        }
                        for (j = 2; j < 4; ++j) {
                            this.foodColors[j] = (Integer)this.colorHelper.keySet().toArray()[1];
                        }
                    }
                }
                this.colorHelper.clear();
            }
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.stacks = NonNullList.func_191197_a((int)80, (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.stacks);
        this.totalBurningTime = 0;
        for (int i = 0; i < 16; ++i) {
            int time = TileEntityFurnace.func_145952_a((ItemStack)this.func_70301_a(i));
            if (time <= 0) continue;
            this.totalBurningTime += time;
        }
        this.currentBurningTime = compound.func_74762_e("BurnTime");
        this.setStone(new ItemStack(compound.func_74775_l("Stone")));
        this.setFacing(EnumFacing.func_176731_b((int)compound.func_74771_c("Facing")));
        this.setCookingTool(MistCampfire.CookingTool.fromIndex(compound.func_74771_c("Tool")));
        this.temperature = compound.func_74762_e("Temperature");
        this.ashTimer = compound.func_74762_e("AshTimer");
        this.minedTimer = compound.func_74762_e("MinedTimer");
        NBTTagList list = compound.func_150295_c("Progress", 10);
        for (int i = 0; i < this.progress.length; ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            if (tag.func_74764_b("Par_0") && tag.func_74764_b("Par_1")) {
                this.progress[i][0] = tag.func_74760_g("Par_0");
                this.progress[i][1] = tag.func_74760_g("Par_1");
                continue;
            }
            this.progress[i] = new float[2];
        }
        if (this.getCookingTool() == MistCampfire.CookingTool.POT) {
            this.clientProgress = this.totalProgress = compound.func_74760_g("TotalProgress");
            this.volume = compound.func_74771_c("Volum");
            this.milk = compound.func_74760_g("Milk");
            this.finalHealAmaunt = compound.func_74760_g("Heal");
            this.finalSaturation = compound.func_74760_g("Saturation");
            this.toxic = compound.func_74760_g("Toxic");
            this.updateMainFood();
            if (this.func_145830_o() && this.field_145850_b.field_72995_K) {
                this.updateFoodColors();
            }
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("Stone", (NBTBase)this.getStone().serializeNBT());
        compound.func_74774_a("Facing", (byte)this.getFacing().func_176736_b());
        compound.func_74774_a("Tool", (byte)this.getCookingTool().getIndex());
        compound.func_74768_a("BurnTime", (int)((short)this.currentBurningTime));
        compound.func_74768_a("Temperature", (int)((short)this.temperature));
        compound.func_74768_a("AshTimer", this.ashTimer);
        compound.func_74768_a("MinedTimer", this.minedTimer);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.progress.length; ++i) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74776_a("Par_0", this.progress[i][0]);
            tag.func_74776_a("Par_1", this.progress[i][1]);
            list.func_74742_a((NBTBase)tag);
        }
        compound.func_74782_a("Progress", (NBTBase)list);
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.stacks);
        if (this.getCookingTool() == MistCampfire.CookingTool.POT) {
            compound.func_74776_a("TotalProgress", this.totalProgress);
            compound.func_74774_a("Volum", this.volume);
            compound.func_74776_a("Milk", this.milk);
            compound.func_74776_a("Heal", this.finalHealAmaunt);
            compound.func_74776_a("Saturation", this.finalSaturation);
            compound.func_74776_a("Toxic", this.toxic);
        }
        return compound;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void updateStatus() {
        this.updateStatus(this.field_145850_b.func_180495_p(this.field_174879_c));
    }

    public void updateStatus(IBlockState state) {
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), state, 3);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public void setFire() {
        if (this.temperature < 20) {
            this.temperature = 20;
        } else if (this.currentBurningTime < 20) {
            this.currentBurningTime = 20;
        }
    }

    public void addMilk(int i) {
        this.milk += (float)i;
    }

    public int getVolum() {
        return this.volume;
    }

    public void setVolum(int volume, boolean get) {
        if (this.getCookingTool() == MistCampfire.CookingTool.POT && this.volume > 0) {
            if (volume == 0) {
                if (!get) {
                    NonNullList<ItemStack> list = NonNullList.func_191196_a();
                    list = this.getFoodDrops(list);
                    for (ItemStack stack : list) {
                        if (stack.func_190926_b()) continue;
                        InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)((double)this.field_174879_c.func_177956_o() + 1.0), (double)this.field_174879_c.func_177952_p(), (ItemStack)stack);
                    }
                }
                this.resetFood();
            } else if (volume > this.volume) {
                for (int i = 0; i < this.progress.length; ++i) {
                    this.progress[i][0] = (int)this.progress[i][0] * volume / this.volume;
                }
            } else {
                this.finalHealAmaunt = this.finalHealAmaunt * (float)volume / (float)this.volume;
                if (this.finalHealAmaunt < 1.0f) {
                    this.resetFood();
                } else {
                    for (int i = 0; i < this.progress.length; ++i) {
                        this.progress[i][1] = this.progress[i][1] * (float)volume / (float)this.volume;
                        if (this.progress[i][1] < 1.0f) {
                            this.func_70299_a(i + 16, ItemStack.field_190927_a);
                            continue;
                        }
                        this.progress[i][0] = this.progress[i][0] * (float)volume / (float)this.volume;
                    }
                    this.finalSaturation = this.finalSaturation * (float)volume / (float)this.volume;
                    this.toxic = this.toxic * (float)volume / (float)this.volume;
                    this.milk = this.milk * (float)volume / (float)this.volume;
                    if ((double)this.milk < 0.25) {
                        this.milk = 0.0f;
                    }
                }
            }
        }
        this.volume = (byte)volume;
        this.updateStatus();
    }

    public void fillWithRain() {
        if (this.getCookingTool() == MistCampfire.CookingTool.POT && this.getVolum() < 4) {
            this.setVolum(this.getVolum() + 1, false);
        }
    }

    private void resetFood() {
        int i;
        for (i = 16; i < this.func_70302_i_(); ++i) {
            this.func_70299_a(i, ItemStack.field_190927_a);
        }
        for (i = 0; i < this.progress.length; ++i) {
            this.progress[i] = new float[2];
        }
        this.mainFood = new ItemStack[]{ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a};
        this.foodColors = new int[4];
        this.foodPercent = new float[4];
        this.totalProgress = 0.0f;
        this.clientProgress = 0.0f;
        this.milk = 0.0f;
        this.finalHealAmaunt = 0.0f;
        this.finalSaturation = 0.0f;
        this.toxic = 0.0f;
    }

    public ItemStack getSoup(ItemStack stack, int portion) {
        ItemStack soup = ItemMistSoup.getSoupStack(stack);
        if (!soup.func_190926_b() && this.getCookingTool() == MistCampfire.CookingTool.POT && this.getVolum() > 0 && this.finalHealAmaunt > 0.0f) {
            Vector3f cook3f;
            Vector3f raw3f;
            ItemStack result;
            float finalAmount = 0.0f;
            float finalSaturation = 0.0f;
            float toxic = 0.0f;
            for (int i = 16; i < this.func_70302_i_(); ++i) {
                PotionEffect[] pf_1;
                float prob;
                PotionEffect[] potionEffects;
                boolean pufferfish;
                float resultSaturation;
                float resultAmount;
                boolean resFood;
                ItemStack food = this.func_70301_a(i);
                if (food.func_190926_b()) continue;
                float[] progress = this.progress[i - 16];
                float foodAmount = ((ItemFood)food.func_77973_b()).func_150905_g(food);
                float foodSaturation = ((ItemFood)food.func_77973_b()).func_150906_h(food);
                result = FurnaceRecipes.func_77602_a().func_151395_a(food);
                boolean bl = resFood = !result.func_190926_b() && result.func_77973_b() instanceof ItemFood;
                if (resFood) {
                    resultAmount = ((ItemFood)result.func_77973_b()).func_150905_g(result);
                    resultSaturation = ((ItemFood)result.func_77973_b()).func_150906_h(result);
                } else {
                    resultAmount = foodAmount * TileEntityCampfire.getHealBonus();
                    resultSaturation = foodSaturation * TileEntityCampfire.getHealBonus();
                }
                foodAmount += (resultAmount - foodAmount) * progress[0] / (float)this.getPotCookTime();
                foodSaturation += (resultSaturation - foodSaturation) * progress[0] / (float)this.getPotCookTime();
                foodAmount = foodAmount * progress[1] / (float)TileEntityCampfire.foodSize();
                foodSaturation = foodSaturation * progress[1] / (float)TileEntityCampfire.foodSize();
                finalAmount += foodAmount;
                finalSaturation += foodSaturation;
                boolean bl2 = pufferfish = ItemFishFood.FishType.func_150978_a((ItemStack)food) == ItemFishFood.FishType.PUFFERFISH;
                if (food.func_77973_b() instanceof IMistFood) {
                    potionEffects = ((IMistFood)food.func_77973_b()).getPotions(food);
                    if (potionEffects != null) {
                        prob = ((IMistFood)food.func_77973_b()).getProbability(food);
                        for (PotionEffect pf_2 : potionEffects) {
                            this.rawPotionsHelper.put(pf_2.func_188419_a(), new Vector3f((float)pf_2.func_76459_b() * prob, (float)pf_2.func_76458_c(), 0.0f));
                        }
                    }
                } else {
                    pf_1 = pufferfish ? new PotionEffect[]{new PotionEffect(MobEffects.field_76436_u, 1200, 3), new PotionEffect(MobEffects.field_76438_s, 300, 2), new PotionEffect(MobEffects.field_76431_k, 300, 1)} : new PotionEffect[]{((ItemFood)food.func_77973_b()).field_77851_ca};
                    float prob2 = pufferfish ? 1.0f : ((ItemFood)food.func_77973_b()).field_77858_cd;
                    for (PotionEffect pf_3 : pf_1) {
                        if (pf_3 == null) continue;
                        this.rawPotionsHelper.put(pf_3.func_188419_a(), new Vector3f((float)pf_3.func_76459_b() * prob2, (float)pf_3.func_76458_c(), 0.0f));
                    }
                }
                if (resFood) {
                    if (result.func_77973_b() instanceof IMistFood) {
                        potionEffects = ((IMistFood)result.func_77973_b()).getPotions(result);
                        if (potionEffects != null) {
                            prob = ((IMistFood)result.func_77973_b()).getProbability(result);
                            for (PotionEffect pf_2 : potionEffects) {
                                this.cookPotionsHelper.put(pf_2.func_188419_a(), new Vector3f((float)pf_2.func_76459_b() * prob, (float)pf_2.func_76458_c(), 0.0f));
                            }
                        }
                    } else {
                        pf_1 = pufferfish ? new PotionEffect[]{new PotionEffect(MobEffects.field_76436_u, 600, 2), new PotionEffect(MobEffects.field_76438_s, 300, 1), new PotionEffect(MobEffects.field_76431_k, 300, 1)} : new PotionEffect[]{((ItemFood)result.func_77973_b()).field_77851_ca};
                        prob = pufferfish ? 1.0f : ((ItemFood)result.func_77973_b()).field_77858_cd;
                        for (PotionEffect pf_3 : pf_1) {
                            if (pf_3 == null) continue;
                            this.cookPotionsHelper.put(pf_3.func_188419_a(), new Vector3f((float)pf_3.func_76459_b() * prob, (float)pf_3.func_76458_c(), 0.0f));
                        }
                    }
                    if (!this.rawPotionsHelper.isEmpty()) {
                        for (Potion po : this.rawPotionsHelper.keySet()) {
                            raw3f = this.rawPotionsHelper.get(po);
                            if (this.cookPotionsHelper.containsKey(po)) {
                                cook3f = this.cookPotionsHelper.get(po);
                                raw3f.x += (cook3f.x - raw3f.x) * progress[0] / (float)this.getPotCookTime();
                                raw3f.y += (cook3f.y - raw3f.y) * progress[0] / (float)this.getPotCookTime();
                            } else {
                                raw3f.x -= raw3f.x * progress[0] / (float)this.getPotCookTime();
                                raw3f.y -= raw3f.y * progress[0] / (float)this.getPotCookTime();
                            }
                            this.rawPotionsHelper.replace(po, raw3f);
                        }
                    }
                    if (!this.cookPotionsHelper.isEmpty()) {
                        for (Potion po : this.cookPotionsHelper.keySet()) {
                            cook3f = this.cookPotionsHelper.get(po);
                            if (!this.rawPotionsHelper.containsKey(po)) {
                                cook3f.x = cook3f.x * progress[0] / (float)this.getPotCookTime();
                                cook3f.y = cook3f.y * progress[0] / (float)this.getPotCookTime();
                            }
                            this.rawPotionsHelper.put(po, cook3f);
                        }
                    }
                }
                if (!this.rawPotionsHelper.isEmpty()) {
                    for (Potion po : this.rawPotionsHelper.keySet()) {
                        raw3f = this.rawPotionsHelper.get(po);
                        if (this.potions.containsKey(po)) {
                            cook3f = this.potions.get(po);
                            cook3f.x += raw3f.x * progress[1] / (float)TileEntityCampfire.foodSize();
                            cook3f.y += raw3f.y * progress[1] / (float)TileEntityCampfire.foodSize();
                            cook3f.z += progress[1] / (float)TileEntityCampfire.foodSize();
                            this.potions.replace(po, cook3f);
                            continue;
                        }
                        raw3f.x = raw3f.x * progress[1] / (float)TileEntityCampfire.foodSize();
                        raw3f.y = raw3f.y * progress[1] / (float)TileEntityCampfire.foodSize();
                        raw3f.z = progress[1] / (float)TileEntityCampfire.foodSize();
                        this.potions.put(po, raw3f);
                    }
                }
                this.rawPotionsHelper.clear();
                this.cookPotionsHelper.clear();
            }
            if (portion > this.getVolum()) {
                portion = this.getVolum();
            }
            finalAmount = Math.min(finalAmount / (float)this.getVolum(), 20.0f);
            finalSaturation = Math.min(finalSaturation / (float)this.getVolum(), 1.0f);
            toxic = Math.min(this.toxic / (float)this.getVolum(), 5000.0f);
            if (finalAmount >= 1.0f) {
                this.updateMainFood();
                if (!soup.func_77942_o()) {
                    soup.func_77982_d(new NBTTagCompound());
                }
                int soupPortion = soup.func_77978_p().func_74762_e("SoupPortion");
                soup.func_77978_p().func_74768_a("SoupPortion", soupPortion + portion);
                if (soupPortion > 0) {
                    finalAmount = (finalAmount * (float)portion + soup.func_77978_p().func_74760_g("SoupHealAmount") * (float)soupPortion) / (float)(soupPortion + portion);
                    finalSaturation = (finalSaturation * (float)portion + soup.func_77978_p().func_74760_g("SoupSaturation") * (float)soupPortion) / (float)(soupPortion + portion);
                    toxic = (toxic * (float)portion + soup.func_77978_p().func_74760_g("SoupToxic") * (float)soupPortion) / (float)(soupPortion + portion);
                }
                soup.func_77978_p().func_74776_a("SoupHealAmount", finalAmount);
                soup.func_77978_p().func_74776_a("SoupSaturation", finalSaturation);
                soup.func_77978_p().func_74776_a("SoupToxic", toxic);
                NBTTagList potionList = soup.func_77978_p().func_150295_c("Potions", 10);
                if (potionList.func_74745_c() > 0) {
                    for (int i = 0; i < potionList.func_74745_c(); ++i) {
                        PotionEffect pe = PotionEffect.func_82722_b((NBTTagCompound)potionList.func_150305_b(i));
                        this.rawPotionsHelper.put(pe.func_188419_a(), new Vector3f((float)pe.func_76459_b(), (float)pe.func_76458_c(), 0.0f));
                    }
                }
                for (Potion po : this.potions.keySet()) {
                    cook3f = this.potions.get(po);
                    cook3f.x /= (float)this.getVolum();
                    cook3f.y /= cook3f.z;
                    this.cookPotionsHelper.put(po, cook3f);
                }
                for (Potion po : this.rawPotionsHelper.keySet()) {
                    raw3f = this.rawPotionsHelper.get(po);
                    if (this.cookPotionsHelper.containsKey(po)) {
                        cook3f = this.cookPotionsHelper.get(po);
                        cook3f.x = (raw3f.x * (float)soupPortion + cook3f.x * (float)portion) / (float)(soupPortion + portion);
                        cook3f.y = (raw3f.y * (float)soupPortion + cook3f.y * (float)portion) / (float)(soupPortion + portion);
                        this.cookPotionsHelper.put(po, cook3f);
                        continue;
                    }
                    raw3f.x = raw3f.x * (float)soupPortion / (float)(soupPortion + portion);
                    raw3f.y = raw3f.y * (float)soupPortion / (float)(soupPortion + portion);
                    this.cookPotionsHelper.put(po, raw3f);
                }
                potionList = new NBTTagList();
                for (Potion po : this.cookPotionsHelper.keySet()) {
                    cook3f = this.cookPotionsHelper.get(po);
                    if (!(cook3f.x >= 10.0f)) continue;
                    potionList.func_74742_a((NBTBase)new PotionEffect(po, (int)cook3f.x, (int)cook3f.y).func_82719_a(new NBTTagCompound()));
                }
                this.rawPotionsHelper.clear();
                this.cookPotionsHelper.clear();
                this.potions.clear();
                soup.func_77978_p().func_74782_a("Potions", (NBTBase)potionList);
                NBTTagList tagList = new NBTTagList();
                NBTTagList colorList = new NBTTagList();
                NBTTagList percentList = new NBTTagList();
                NBTTagList currentItems = soup.func_77978_p().func_150295_c("MainFood", 10);
                NBTTagList currentPercents = soup.func_77978_p().func_150295_c("FoodPercent", 10);
                this.mainFoodMap.clear();
                if (currentItems.func_74745_c() > 0) {
                    for (int i = 0; i < currentItems.func_74745_c(); ++i) {
                        float p = 0.0f;
                        if (i < currentPercents.func_74745_c()) {
                            p = currentPercents.func_150305_b(i).func_74760_g("Percent");
                        }
                        this.mainFoodMap.put(new ItemStackMapKey(new ItemStack(currentItems.func_150305_b(i))), Float.valueOf(p));
                    }
                }
                for (int i = 0; i < 4; ++i) {
                    ItemStackMapKey st = new ItemStackMapKey(this.mainFood[i]);
                    if (this.mainFoodMap.containsKey(st)) {
                        float p = this.mainFoodMap.get(st).floatValue();
                        p = (p * (float)soupPortion + this.foodPercent[i] * (float)portion) / (float)(soupPortion + portion);
                        this.mainFoodMap.put(st, Float.valueOf(p));
                        continue;
                    }
                    this.mainFoodMap.put(st, Float.valueOf(this.foodPercent[i]));
                }
                this.mainFoodMap = (LinkedHashMap)MapUtil.sortByValue(this.mainFoodMap, true);
                for (ItemStackMapKey key : this.mainFoodMap.keySet()) {
                    ItemStack st = key.itemStack;
                    if (st.func_190926_b()) break;
                    result = FurnaceRecipes.func_77602_a().func_151395_a(st);
                    if (!result.func_190926_b() && result.func_77973_b() instanceof ItemFood) {
                        colorList.func_74742_a((NBTBase)result.func_77955_b(new NBTTagCompound()));
                    } else {
                        colorList.func_74742_a((NBTBase)st.func_77955_b(new NBTTagCompound()));
                    }
                    tagList.func_74742_a((NBTBase)st.func_77955_b(new NBTTagCompound()));
                    NBTTagCompound tag = new NBTTagCompound();
                    tag.func_74776_a("Percent", this.mainFoodMap.get(key).floatValue());
                    percentList.func_74742_a((NBTBase)tag);
                }
                if (!tagList.func_82582_d()) {
                    soup.func_77978_p().func_74782_a("MainFood", (NBTBase)tagList);
                    soup.func_77978_p().func_74782_a("FoodColors", (NBTBase)colorList);
                    soup.func_77978_p().func_74782_a("FoodPercent", (NBTBase)percentList);
                }
                this.setVolum(this.getVolum() - portion, true);
                return soup;
            }
            this.potions.clear();
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack addFuel(ItemStack stack) {
        int time = TileEntityFurnace.func_145952_a((ItemStack)stack);
        if (time <= 0 || time > 2000 || !this.canSetBurningTime(time)) {
            return stack;
        }
        for (int i = 0; !stack.func_190926_b() && i < 16; ++i) {
            if (!this.func_70301_a(i).func_190926_b()) continue;
            if (!this.addToBurningTime(time)) break;
            this.func_70299_a(i, stack.func_77979_a(1));
        }
        return stack;
    }

    private int getBurningTime() {
        return this.totalBurningTime;
    }

    private static final int getMaxBurningTime() {
        return 10000;
    }

    private boolean addToBurningTime(int time) {
        if (this.canSetBurningTime(time)) {
            this.totalBurningTime += time;
            return true;
        }
        return false;
    }

    private boolean canSetBurningTime(int time) {
        return this.totalBurningTime + time < TileEntityCampfire.getMaxBurningTime();
    }

    public ArrayList<ItemStack> addFood(ItemStack stack, int slot) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        if (!this.hasCookingTool() || stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemFood) || stack.func_77973_b() instanceof IMistFood && !((IMistFood)stack.func_77973_b()).isFood(stack)) {
            list.add(stack);
            return list;
        }
        ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(stack);
        if (this.getCookingTool() == MistCampfire.CookingTool.POT) {
            int i;
            float toxic;
            float saturation;
            float amount;
            ItemStack container;
            if (this.volume == 0) {
                list.add(stack);
                return list;
            }
            ItemStack itemStack = container = stack.func_77973_b() instanceof ItemSoup ? new ItemStack(Items.field_151054_z) : TileEntityCampfire.getFoodContainer(stack);
            if (!result.func_190926_b() && result.func_77973_b() instanceof ItemFood) {
                amount = ((ItemFood)result.func_77973_b()).func_150905_g(result);
                saturation = ((ItemFood)result.func_77973_b()).func_150906_h(result);
            } else {
                amount = (float)((ItemFood)stack.func_77973_b()).func_150905_g(stack) * TileEntityCampfire.getHealBonus();
                saturation = ((ItemFood)stack.func_77973_b()).func_150906_h(stack) * TileEntityCampfire.getHealBonus();
            }
            int count = stack.func_190916_E();
            boolean check = false;
            float f = toxic = stack.func_77973_b() instanceof IMistFood ? ((IMistFood)stack.func_77973_b()).getToxic(stack) : 0.0f;
            for (i = 16; !stack.func_190926_b() && i < this.func_70302_i_(); ++i) {
                if (!this.func_70301_a(i).func_190926_b()) continue;
                check = true;
                if (!this.addToHealAmount(amount, saturation, toxic)) break;
                this.func_70299_a(i, stack.func_77979_a(1));
            }
            if (!check) {
                int j;
                float[] aa = new float[64];
                float[] ss = new float[64];
                float foodAmount = 0.0f;
                this.foodMap.clear();
                for (i = 16; i < this.func_70302_i_(); ++i) {
                    ItemStack food = this.func_70301_a(i);
                    if (!food.func_190926_b()) {
                        float foodSaturation;
                        result = FurnaceRecipes.func_77602_a().func_151395_a(food);
                        if (!result.func_190926_b() && result.func_77973_b() instanceof ItemFood) {
                            foodAmount = ((ItemFood)result.func_77973_b()).func_150905_g(result);
                            foodSaturation = ((ItemFood)result.func_77973_b()).func_150906_h(result);
                        } else {
                            foodAmount = (float)((ItemFood)food.func_77973_b()).func_150905_g(food) * TileEntityCampfire.getHealBonus();
                            foodSaturation = ((ItemFood)food.func_77973_b()).func_150906_h(food) * TileEntityCampfire.getHealBonus();
                        }
                        foodAmount = foodAmount * this.progress[i - 16][1] / (float)TileEntityCampfire.foodSize();
                        foodSaturation = foodSaturation * this.progress[i - 16][1] / (float)TileEntityCampfire.foodSize();
                        aa[i - 16] = foodAmount;
                        ss[i - 16] = foodSaturation;
                    }
                    this.foodMap.put(i - 16, Float.valueOf(foodAmount));
                }
                this.foodMap = (LinkedHashMap)MapUtil.sortByValue(this.foodMap, false);
                Iterator<Integer> iterator = this.foodMap.keySet().iterator();
                while (iterator.hasNext() && aa[j = iterator.next().intValue()] < 0.25f && this.canSetHealAmount(amount - aa[j])) {
                    this.finalHealAmaunt += amount - aa[j];
                    this.finalSaturation += saturation - ss[j];
                    this.toxic += toxic;
                    if (this.toxic > 10000.0f) {
                        this.toxic = 10000.0f;
                    }
                    this.func_70299_a(j + 16, stack.func_77979_a(1));
                }
            }
            this.updateFoodProgress(false);
            list.add(stack);
            if (!container.func_190926_b()) {
                count -= stack.func_190916_E();
                if (container.func_77985_e()) {
                    container.func_190920_e(count);
                    list.add(container);
                } else {
                    for (int l = 0; l < count; ++l) {
                        list.add(container);
                    }
                }
            }
        } else if (this.getCookingTool() == MistCampfire.CookingTool.GRILL) {
            if (slot >= 0 && slot < 4 && !result.func_190926_b() && this.func_70301_a(16 + slot).func_190926_b()) {
                this.func_70299_a(16 + slot, stack.func_77979_a(1));
                this.updateStatus();
            }
            list.add(stack);
        }
        return list;
    }

    private static ItemStack getFoodContainer(ItemStack stack) {
        return stack.func_77973_b().getContainerItem(stack);
    }

    public ItemStack getGrillStack(int slot) {
        if (slot >= 0 && slot < 4) {
            return this.func_70301_a(16 + slot);
        }
        return ItemStack.field_190927_a;
    }

    public void setGrillStack(int slot, ItemStack stack) {
        if (slot >= 0 && slot < 4) {
            this.func_70299_a(16 + slot, stack);
        }
    }

    public boolean isGrillEmpty() {
        if (this.getCookingTool() != MistCampfire.CookingTool.GRILL) {
            return true;
        }
        for (int i = 16; i < 20; ++i) {
            if (this.func_70301_a(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    private int getMaxHealAmaunt() {
        return this.volume * 20;
    }

    private static final float getHealBonus() {
        return 1.25f;
    }

    private static final int foodSize() {
        return 256;
    }

    public int getAshTimer() {
        return this.ashTimer;
    }

    public void setAshTimer(int timer) {
        this.ashTimer = timer;
    }

    private boolean addToHealAmount(float amount, float saturation, float toxic) {
        if (this.canSetHealAmount(amount)) {
            this.finalHealAmaunt += amount;
            this.finalSaturation += saturation;
            this.toxic += toxic;
            if (this.toxic > 10000.0f) {
                this.toxic = 10000.0f;
            }
            return true;
        }
        return false;
    }

    private boolean canSetHealAmount(float amount) {
        return this.finalHealAmaunt + amount < (float)this.getMaxHealAmaunt();
    }

    public void setStone(ItemStack stack) {
        if (!stack.func_190926_b()) {
            for (ItemStack stones : stoneAndColor.keySet()) {
                if (!stones.func_77969_a(stack)) continue;
                this.stone = stones.func_77946_l();
                this.stoneColor = (int)TileEntityCampfire.stoneAndColor.get((Object)stones).y;
                return;
            }
        }
        this.stone = new ItemStack(MistItems.ROCKS);
        this.stoneColor = 10204847;
    }

    public static void putStoneAndColorList(Map<ItemStack, Vector2f> stoneAndColor) {
        TileEntityCampfire.stoneAndColor.clear();
        TileEntityCampfire.stoneAndColor.putAll(stoneAndColor);
    }

    public static void updateColorsToClient(EntityPlayerMP player) {
        PacketHandler.INSTANCE.sendTo((IMessage)new PacketFirePitUpdate(stoneAndColor), player);
    }

    @SideOnly(value=Side.CLIENT)
    public static void updateColorsFromServer(Map<ItemStack, Vector2f> stoneAndColor) {
        HashMap<ItemStack, Vector2f> checkMap = new HashMap<ItemStack, Vector2f>();
        for (ItemStack stonesS : stoneAndColor.keySet()) {
            boolean check = false;
            for (ItemStack stonesC : TileEntityCampfire.stoneAndColor.keySet()) {
                if (!stonesS.func_77969_a(stonesC)) continue;
                checkMap.put(stonesC, new Vector2f(stoneAndColor.get((Object)stonesS).x, TileEntityCampfire.stoneAndColor.get((Object)stonesC).y));
                check = true;
                break;
            }
            if (check) continue;
            checkMap.put(stonesS, TileEntityCampfire.stoneAndColor.get(stonesS));
        }
        TileEntityCampfire.stoneAndColor.clear();
        TileEntityCampfire.stoneAndColor.putAll(checkMap);
    }

    public static int getStoneCount(ItemStack stack) {
        if (!stack.func_190926_b()) {
            for (ItemStack stones : stoneAndColor.keySet()) {
                if (!stones.func_77969_a(stack)) continue;
                return (int)TileEntityCampfire.stoneAndColor.get((Object)stones).x;
            }
        }
        return 0;
    }

    public int getStoneColor() {
        return this.stoneColor;
    }

    public ItemStack getStone() {
        return this.stone;
    }

    public List<ItemStack> getDrops(IBlockState state) {
        NonNullList<ItemStack> ret = NonNullList.func_191196_a();
        ItemStack stones = this.getStone();
        int count = TileEntityCampfire.getStoneCount(stones);
        int stage = Math.min((Integer)state.func_177229_b((IProperty)MistCampfire.STAGE), 3) + 1;
        count = Math.round((float)(stage * count) / 4.0f);
        stones.func_190920_e(count);
        ret.add((Object)stones);
        for (int i = 0; i < 16; ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            ret.add((Object)stack);
        }
        if (this.hasCookingTool()) {
            ret.add((Object)this.getCookingTool().getItem());
        }
        if (this.ashTimer / 1000 > 0) {
            ret.add((Object)new ItemStack(MistItems.ASH, this.ashTimer / 1000));
        }
        ret = this.getFoodDrops(ret);
        return ret;
    }

    private NonNullList<ItemStack> getFoodDrops(NonNullList<ItemStack> list) {
        block3: {
            block2: {
                if (this.getCookingTool() != MistCampfire.CookingTool.POT) break block2;
                for (int i = 16; i < this.func_70302_i_(); ++i) {
                    ItemStack stack = this.func_70301_a(i);
                    if (stack.func_190926_b() || this.progress[i - 16][1] != (float)TileEntityCampfire.foodSize() || !(this.progress[i - 16][0] < (float)this.getPotCookTime()) || TileEntityCampfire.getFoodContainer(stack) != ItemStack.field_190927_a || stack.func_77973_b() instanceof ItemSoup) continue;
                    list.add((Object)stack);
                }
                break block3;
            }
            if (this.getCookingTool() != MistCampfire.CookingTool.GRILL) break block3;
            for (int i = 16; i < this.func_70302_i_(); ++i) {
                ItemStack stack = this.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                list.add((Object)stack);
            }
        }
        return list;
    }

    public void setFacing(EnumFacing face) {
        if (face != EnumFacing.UP && face != EnumFacing.DOWN) {
            this.facing = face;
        }
    }

    public EnumFacing getFacing() {
        return this.facing;
    }

    public void setCookingTool(MistCampfire.CookingTool tool) {
        this.cookingTool = tool;
    }

    public MistCampfire.CookingTool getCookingTool() {
        return this.cookingTool;
    }

    public boolean hasCookingTool() {
        return this.cookingTool != MistCampfire.CookingTool.NONE;
    }

    public int func_70302_i_() {
        if (this.hasCookingTool()) {
            if (this.getCookingTool() == MistCampfire.CookingTool.POT) {
                return 80;
            }
            if (this.getCookingTool() == MistCampfire.CookingTool.GRILL) {
                return 20;
            }
        }
        return 16;
    }

    public boolean func_191420_l() {
        block5: {
            block3: {
                block4: {
                    if (!this.hasCookingTool()) break block3;
                    if (this.getCookingTool() != MistCampfire.CookingTool.POT) break block4;
                    for (ItemStack stack : this.stacks) {
                        if (stack.func_190926_b()) continue;
                        return false;
                    }
                    break block5;
                }
                if (this.getCookingTool() != MistCampfire.CookingTool.GRILL) break block5;
                for (int i = 0; i < 20; ++i) {
                    if (((ItemStack)this.stacks.get(i)).func_190926_b()) continue;
                    return false;
                }
                break block5;
            }
            for (int i = 0; i < 16; ++i) {
                if (((ItemStack)this.stacks.get(i)).func_190926_b()) continue;
                return false;
            }
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        if (index < 16 || this.getCookingTool() == MistCampfire.CookingTool.POT || this.getCookingTool() == MistCampfire.CookingTool.GRILL && index < 20) {
            return (ItemStack)this.stacks.get(index);
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.stacks, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.stacks, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.stacks.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index >= 16) {
            if (stack.func_190926_b()) {
                this.progress[index - 16] = new float[2];
            } else if (this.getCookingTool() == MistCampfire.CookingTool.POT) {
                this.progress[index - 16][1] = TileEntityCampfire.foodSize();
            }
        }
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index < 16) {
            int time = TileEntityFurnace.func_145952_a((ItemStack)stack);
            return time > 0 && time <= 2000;
        }
        return stack.func_77973_b() instanceof ItemFood;
    }

    public int func_174887_a_(int id) {
        if (id == 0) {
            return (int)(this.totalProgress * 10000.0f);
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        if (id == 0) {
            this.totalProgress = (float)value / 10000.0f;
        }
    }

    public int func_174890_g() {
        return 1;
    }

    public void func_174888_l() {
        this.stacks.clear();
    }

    public String func_70005_c_() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int[] func_180463_a(EnumFacing side) {
        if (side != EnumFacing.DOWN) {
            if (side != EnumFacing.UP) {
                if (this.hasCookingTool()) {
                    if (this.getCookingTool() == MistCampfire.CookingTool.POT) {
                        return SLOTS_FOOD;
                    }
                    if (this.getCookingTool() == MistCampfire.CookingTool.GRILL) {
                        return SLOTS_GRILL;
                    }
                }
            } else {
                return SLOTS_FUEL;
            }
        }
        return null;
    }

    public boolean func_180462_a(int index, ItemStack stack, EnumFacing direction) {
        return this.func_94041_b(index, stack);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return false;
    }

    public FluidStack getFluid() {
        if (this.getCookingTool() == MistCampfire.CookingTool.POT && this.getVolum() > 0 && this.finalHealAmaunt == 0.0f) {
            if (this.milk == (float)this.getVolum()) {
                return new FluidStack(FluidRegistry.getFluid((String)"milk"), this.volume * 250);
            }
            if (this.milk == 0.0f) {
                return new FluidStack(FluidRegistry.WATER, this.volume * 250);
            }
        }
        return null;
    }

    public int getFluidAmount() {
        return this.volume * 250;
    }

    public int getCapacity() {
        return 1000;
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo(this.getFluid(), this.getCapacity());
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.getCookingTool() == MistCampfire.CookingTool.POT) {
            int i = 4 - this.volume;
            boolean milk = resource.getFluid().getName().equals("milk");
            if (i > 0 && resource.amount >= 250 && (resource.getFluid() == FluidRegistry.WATER || milk)) {
                i = Math.min(i, resource.amount / 250);
                if (doFill) {
                    this.setVolum(this.getVolum() + i, false);
                    if (milk) {
                        this.addMilk(i);
                    }
                }
                return i * 250;
            }
        }
        return 0;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.getCookingTool() == MistCampfire.CookingTool.POT && maxDrain > 250 && this.volume > 0 && this.totalProgress == 0.0f) {
            boolean milk;
            boolean bl = milk = this.milk == (float)this.getVolum();
            if (this.milk == 0.0f || milk) {
                int i = Math.min(this.volume, maxDrain / 250);
                if (doDrain) {
                    this.setVolum(this.volume - i, false);
                }
                if (milk) {
                    return new FluidStack(FluidRegistry.getFluid((String)"milk"), this.volume * 250);
                }
                return new FluidStack(FluidRegistry.WATER, this.volume * 250);
            }
        }
        return null;
    }

    static {
        stoneAndColor = new HashMap();
        SLOTS_FUEL = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        SLOTS_FOOD = new int[]{16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79};
        SLOTS_GRILL = new int[]{16, 17, 18, 19};
    }
}

