/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.shader;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL20;
import ru.liahim.mist.handlers.FogRenderer;
import ru.liahim.mist.init.ModConfig;
import ru.liahim.mist.util.FogTexture;

public class ShaderProgram {
    private static int current = 0;
    public static int fog = 0;

    public static void initShaders() {
        if (!ShaderProgram.useShaders()) {
            return;
        }
        fog = ShaderProgram.createProgram("fog", "fog");
    }

    public static void useShader(int shader) {
        if (!ShaderProgram.useShaders()) {
            return;
        }
        GL20.glUseProgram((int)shader);
        current = shader;
        if (shader != 0) {
            int mode = GL20.glGetUniformLocation((int)shader, (CharSequence)"fog_mode");
            GL20.glUniform1i((int)mode, (int)(FogRenderer.depth < 0.0f ? 1 : 0));
            int density = GL20.glGetUniformLocation((int)shader, (CharSequence)"fog_density");
            GL20.glUniform1f((int)density, (float)FogRenderer.density);
            int fog_color = GL20.glGetUniformLocation((int)shader, (CharSequence)"fog_color");
            GL20.glUniform3f((int)fog_color, (float)FogRenderer.red, (float)FogRenderer.green, (float)FogRenderer.blue);
            int tex_size = GL20.glGetUniformLocation((int)shader, (CharSequence)"tex_size");
            GL20.glUniform2f((int)tex_size, (float)FogTexture.getTextureSize(), (float)FogTexture.getTextureSize());
        }
    }

    public static void setUniform1f(String name, float v) {
        if (current != 0) {
            int id = GL20.glGetUniformLocation((int)current, (CharSequence)name);
            GL20.glUniform1f((int)id, (float)v);
        }
    }

    public static void setUniform2f(String name, float v0, float v1) {
        if (current != 0) {
            int id = GL20.glGetUniformLocation((int)current, (CharSequence)name);
            GL20.glUniform2f((int)id, (float)v0, (float)v1);
        }
    }

    public static void setUniform3f(String name, float v0, float v1, float v2) {
        if (current != 0) {
            int id = GL20.glGetUniformLocation((int)current, (CharSequence)name);
            GL20.glUniform3f((int)id, (float)v0, (float)v1, (float)v2);
        }
    }

    public static void releaseShader() {
        ShaderProgram.useShader(0);
    }

    private static boolean useShaders() {
        return ModConfig.graphic.advancedFogRenderer && OpenGlHelper.field_148824_g;
    }

    private static int createProgram(String vert, String frag) {
        int vertId = 0;
        int fragId = 0;
        int program = 0;
        if (vert != null) {
            vertId = ShaderProgram.createShader(vert + ".vert", 35633);
        }
        if (frag != null) {
            fragId = ShaderProgram.createShader(frag + ".frag", 35632);
        }
        if ((program = GL20.glCreateProgram()) == 0) {
            return 0;
        }
        if (vert != null) {
            GL20.glAttachShader((int)program, (int)vertId);
        }
        if (frag != null) {
            GL20.glAttachShader((int)program, (int)fragId);
        }
        GL20.glLinkProgram((int)program);
        if (GL20.glGetProgrami((int)program, (int)35714) == 0) {
            System.err.println("Link program error: " + GL20.glGetProgramInfoLog((int)program, (int)35716));
            return 0;
        }
        GL20.glValidateProgram((int)program);
        if (GL20.glGetProgrami((int)program, (int)35715) == 0) {
            System.err.println("Validate program error: " + GL20.glGetProgramInfoLog((int)program, (int)35716));
            return 0;
        }
        return program;
    }

    private static int createShader(String filename, int shaderType) {
        int shader = 0;
        try {
            shader = GL20.glCreateShader((int)shaderType);
            if (shader == 0) {
                return 0;
            }
            GL20.glShaderSource((int)shader, (CharSequence)ShaderProgram.readFileAsString(filename));
            GL20.glCompileShader((int)shader);
            if (GL20.glGetShaderi((int)shader, (int)35713) == 0) {
                throw new RuntimeException("Error creating shader: " + GL20.glGetShaderInfoLog((int)shader, (int)35716));
            }
            return shader;
        }
        catch (Exception e) {
            GL20.glDeleteShader((int)shader);
            e.printStackTrace();
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFileAsString(String filename) throws Exception {
        StringBuilder source;
        block28: {
            source = new StringBuilder();
            ResourceLocation rs = new ResourceLocation("mist", "shaders/" + filename);
            InputStream in = Minecraft.func_71410_x().func_110442_L().func_110536_a(rs).func_110527_b();
            Exception exception = null;
            if (in == null) {
                return "";
            }
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
                Exception innerExc = null;
                try {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        source.append(line).append('\n');
                    }
                }
                catch (Exception exc) {
                    exception = exc;
                }
                finally {
                    try {
                        reader.close();
                    }
                    catch (Exception exc) {
                        if (innerExc == null) {
                            innerExc = exc;
                        }
                        exc.printStackTrace();
                    }
                }
                if (innerExc != null) {
                    throw innerExc;
                }
            }
            catch (Exception exc) {
                exception = exc;
                return exception;
            }
            finally {
                try {
                    in.close();
                }
                catch (Exception exc) {
                    if (exception == null) {
                        exception = exc;
                    }
                    exc.printStackTrace();
                }
                if (exception == null) break block28;
                throw exception;
            }
        }
        return source.toString();
    }
}

