/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.init.ModParticle;

public class PacketSpawnParticle
implements IMessage {
    double x;
    double y;
    double z;
    ParticleType type;

    public PacketSpawnParticle() {
    }

    public PacketSpawnParticle(ParticleType type, double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.type = type;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.type = ParticleType.values()[buf.readInt()];
    }

    public void toBytes(ByteBuf buf) {
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeInt(this.type.ordinal());
    }

    public static enum ParticleType {
        SOAP,
        CLOUD;

    }

    public static class Handler
    implements IMessageHandler<PacketSpawnParticle, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(final PacketSpawnParticle message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    World world = Minecraft.func_71410_x().field_71439_g.field_70170_p;
                    if (message.type == ParticleType.SOAP) {
                        float size = 0.5f;
                        double x = message.x + world.field_73012_v.nextDouble() * (double)size - (double)(size / 2.0f);
                        double y = message.y + world.field_73012_v.nextDouble() * 0.2 + 0.1;
                        double z = message.z + world.field_73012_v.nextDouble() * (double)size - (double)(size / 2.0f);
                        world.func_175682_a(ModParticle.MIST_BUBBLE, false, x, y, z, 0.0, (double)(-world.field_73012_v.nextFloat() * 0.2f), 0.0, new int[0]);
                    } else if (message.type == ParticleType.CLOUD) {
                        for (int i = 0; i < 8; ++i) {
                            double d0 = message.x + world.field_73012_v.nextDouble() * 0.8 + 0.1;
                            double d1 = message.y + world.field_73012_v.nextDouble() * 0.8 + 0.1;
                            double d2 = message.z + world.field_73012_v.nextDouble() * 0.8 + 0.1;
                            world.func_175682_a(EnumParticleTypes.CLOUD, false, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
                        }
                    }
                }
            });
            return null;
        }
    }
}

