/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.api.sound.MistSounds;
import ru.liahim.mist.handlers.ClientEventHandler;
import ru.liahim.mist.world.WorldProviderMist;

public class PacketSkySound
implements IMessage {
    SkySoundType type;
    float volume;

    public PacketSkySound() {
    }

    public PacketSkySound(SkySoundType type, float volume) {
        this.type = type;
        this.volume = volume;
    }

    public void fromBytes(ByteBuf buf) {
        this.type = SkySoundType.values()[buf.readInt()];
        this.volume = buf.readFloat();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.type.ordinal());
        buf.writeFloat(this.volume);
    }

    public static enum SkySoundType {
        AMBIENT(MistSounds.SKY_SOUND),
        BOOM(MistSounds.SKY_BOOM);

        private final SoundEvent event;

        private SkySoundType(SoundEvent event) {
            this.event = event;
        }
    }

    public static class Handler
    implements IMessageHandler<PacketSkySound, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(final PacketSkySound message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    Minecraft.func_71410_x().field_71439_g.func_184185_a(message.type.event, message.volume, 1.0f);
                    if (message.type == SkySoundType.AMBIENT && WorldProviderMist.canPlayMusic(Minecraft.func_71410_x().field_71439_g)) {
                        ClientEventHandler.fadeOut = 1000;
                    }
                }
            });
            return null;
        }
    }
}

