/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.network;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import javax.vecmath.Vector2f;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.tileentity.TileEntityCampfire;

public class PacketFirePitUpdate
implements IMessage {
    Map<ItemStack, Vector2f> stoneAndColor = new HashMap<ItemStack, Vector2f>();

    public PacketFirePitUpdate() {
    }

    public PacketFirePitUpdate(Map<ItemStack, Vector2f> stoneAndColor) {
        this.stoneAndColor.putAll(stoneAndColor);
    }

    public void toBytes(ByteBuf buffer) {
        NBTTagList tagList = new NBTTagList();
        for (ItemStack stones : this.stoneAndColor.keySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("Color", (int)this.stoneAndColor.get((Object)stones).y);
            new ItemStack(stones.func_77973_b(), (int)this.stoneAndColor.get((Object)stones).x, stones.func_77952_i()).func_77955_b(tag);
            tagList.func_74742_a((NBTBase)tag);
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("Stones", (NBTBase)tagList);
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)nbt);
    }

    public void fromBytes(ByteBuf buffer) {
        NBTTagCompound nbt = ByteBufUtils.readTag((ByteBuf)buffer);
        NBTTagList tagList = nbt.func_150295_c("Stones", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            ItemStack stack = new ItemStack(tag);
            this.stoneAndColor.put(new ItemStack(stack.func_77973_b(), 1, stack.func_77952_i()), new Vector2f((float)stack.func_190916_E(), (float)tag.func_74762_e("Color")));
        }
    }

    public static class Handler
    implements IMessageHandler<PacketFirePitUpdate, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(final PacketFirePitUpdate message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    TileEntityCampfire.updateColorsFromServer(message.stoneAndColor);
                }
            });
            return null;
        }
    }
}

