/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.item.food;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.api.item.IMistFood;
import ru.liahim.mist.api.item.MistItems;
import ru.liahim.mist.capability.handler.IFoodHandler;
import ru.liahim.mist.capability.handler.IMistCapaHandler;
import ru.liahim.mist.init.ModAdvancements;

public class ItemToxicFood
extends ItemFood
implements IMistFood {
    private final int toxic;

    public ItemToxicFood(int amount, float saturation, boolean isWolfFood, int toxic) {
        super(amount, saturation, isWolfFood);
        this.toxic = toxic;
    }

    public String func_77658_a() {
        return "item.mist." + super.func_77658_a().substring(5);
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            IFoodHandler mCapa = IFoodHandler.getHandler((EntityPlayer)player);
            if (this.isFood(stack) && mCapa.isFoodStudy(stack)) {
                float toxic = this.getToxic(stack);
                if (toxic > 0.0f) {
                    tooltip.add(TextFormatting.DARK_RED + I18n.func_135052_a((String)"item.mist.food_toxic.tooltip", (Object[])new Object[0]));
                } else if (toxic < 0.0f) {
                    tooltip.add(TextFormatting.DARK_GREEN + I18n.func_135052_a((String)"item.mist.food_antitoxic.tooltip", (Object[])new Object[0]));
                }
                if (!this.isEdible(stack)) {
                    tooltip.add(TextFormatting.DARK_RED + I18n.func_135052_a((String)"item.mist.food_inedible.tooltip", (Object[])new Object[0]));
                } else {
                    tooltip.add(TextFormatting.DARK_GREEN + I18n.func_135052_a((String)"item.mist.food_edible.tooltip", (Object[])new Object[0]));
                }
            }
        }
    }

    public void func_77849_c(ItemStack stack, World world, EntityPlayer player) {
        if (stack.func_77973_b() == this) {
            if (this.getToxic(stack) != 0.0f) {
                IMistCapaHandler.getHandler(player).addToxic(this.toxic);
                if (player instanceof EntityPlayerMP) {
                    ModAdvancements.CONSUME_TOXIC.trigger((EntityPlayerMP)player, stack, Float.valueOf(this.toxic));
                }
            }
            IFoodHandler.getHandler(player).setFoodStudy(stack);
        }
        super.func_77849_c(stack, world, player);
    }

    @Override
    public float getToxic(ItemStack stack) {
        return this.toxic;
    }

    @Override
    public PotionEffect[] getPotions(ItemStack stack) {
        return null;
    }

    @Override
    public float getProbability(ItemStack stack) {
        return 0.0f;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return this == MistItems.PILLS_BITTER ? EnumRarity.UNCOMMON : EnumRarity.COMMON;
    }
}

