/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.item.food;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemSoup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.api.item.IColoredItem;
import ru.liahim.mist.api.item.IMask;
import ru.liahim.mist.api.item.IMistFood;
import ru.liahim.mist.api.item.MistItems;
import ru.liahim.mist.capability.handler.IMistCapaHandler;
import ru.liahim.mist.init.ItemColoring;
import ru.liahim.mist.init.ModAdvancements;
import ru.liahim.mist.init.ModConfig;
import ru.liahim.mist.util.RomanNumber;

public class ItemMistSoup
extends ItemSoup
implements IColoredItem,
IMistFood {
    private final int portion;
    private final boolean drink;

    @Override
    public IItemColor getItemColor() {
        return ItemColoring.ITEM_SOUP_COLORING;
    }

    public ItemMistSoup(int portion, boolean drink) {
        super(0);
        this.portion = portion;
        this.drink = drink;
        this.func_185043_a(new ResourceLocation("portion"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                return ItemMistSoup.this.getCurrentPortion(stack);
            }
        });
    }

    public ItemMistSoup(int portion) {
        this(portion, false);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        if (GuiScreen.func_146272_n()) {
            ItemStack[] ingredients = this.getMainFood(stack);
            if (ingredients != null) {
                for (ItemStack food : ingredients) {
                    if (food.func_190926_b()) continue;
                    tooltip.add("-" + food.func_82833_r());
                }
                if (ModConfig.campfire.showSoupEffects) {
                    PotionEffect[] potions;
                    float toxic = this.getToxic(stack) / 100.0f;
                    if (toxic != 0.0f) {
                        StringBuilder sb = new StringBuilder();
                        sb.append(I18n.func_135052_a((String)"item.mist.soup_toxic.name", (Object[])new Object[0]));
                        sb.append(": ");
                        sb.append(toxic > 0.0f ? TextFormatting.RED : TextFormatting.GREEN);
                        sb.append(String.format("%.2f", Float.valueOf(toxic)));
                        sb.append("%");
                        tooltip.add(sb.toString());
                    }
                    if ((potions = this.getPotions(stack)) != null) {
                        for (PotionEffect potion : potions) {
                            String mess = "";
                            mess = mess + (potion.func_188419_a().func_76398_f() ? TextFormatting.RED : TextFormatting.GRAY);
                            mess = mess + I18n.func_135052_a((String)potion.func_76453_d(), (Object[])new Object[0]).trim();
                            mess = mess + RomanNumber.toRoman(potion.func_76458_c() + 1);
                            if (potion.func_76459_b() > 20) {
                                mess = mess + " (" + Potion.func_188410_a((PotionEffect)potion, (float)1.0f) + ")";
                            }
                            mess = mess + TextFormatting.RESET;
                            tooltip.add(mess);
                        }
                    }
                }
            }
        } else if (this.getCurrentPortion(stack) > 0) {
            tooltip.add(I18n.func_135052_a((String)"item.mist.more_info.tooltip", (Object[])new Object[0]));
        }
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entity) {
        int i;
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            int toxic = (int)this.getToxic(stack);
            if (toxic != 0) {
                IMistCapaHandler capa = IMistCapaHandler.getHandler(player);
                if (capa != null) {
                    capa.addToxic(toxic);
                }
                if (player instanceof EntityPlayerMP) {
                    ModAdvancements.CONSUME_TOXIC.trigger((EntityPlayerMP)player, stack, Float.valueOf(toxic));
                }
            }
            player.func_71024_bL().func_151686_a((ItemFood)this, stack);
            if (player instanceof EntityPlayerMP) {
                IMistCapaHandler capa;
                ItemStack mask = player.func_184582_a(EntityEquipmentSlot.HEAD);
                if (!IMask.isMask(mask) && (capa = IMistCapaHandler.getHandler(player)) != null) {
                    mask = capa.getMask();
                }
                if (!IMask.canEat(mask)) {
                    ModAdvancements.GLASS_CONTAINER.trigger((EntityPlayerMP)player, stack, Float.valueOf(this.getToxic(stack)));
                }
            }
            world.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
            this.func_77849_c(stack, world, player);
            player.func_71029_a(StatList.func_188057_b((Item)this));
            if (player instanceof EntityPlayerMP) {
                CriteriaTriggers.field_193138_y.func_193148_a((EntityPlayerMP)player, stack);
            }
        }
        if ((i = this.getCurrentPortion(stack) - 1) <= 0) {
            return this.getContainerItem(stack);
        }
        this.setPortion(stack, i);
        return stack;
    }

    public String func_77658_a() {
        return "item.mist." + super.func_77658_a().substring(5);
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a();
    }

    public String func_77653_i(ItemStack stack) {
        String heal = "";
        int h = this.func_150905_g(stack);
        if (h > 0) {
            if (this != MistItems.SOUP) {
                return MistItems.SOUP.func_77653_i(stack);
            }
            for (int i = 0; i < 10; ++i) {
                if (h > 1) {
                    heal = "\u25cf" + heal;
                    h -= 2;
                    continue;
                }
                if (h == 1) {
                    heal = "\u25d1" + heal;
                    h = 0;
                    continue;
                }
                heal = "\u25cb" + heal;
            }
        }
        return super.func_77653_i(stack) + " " + heal;
    }

    protected void func_77849_c(ItemStack stack, World world, EntityPlayer player) {
        PotionEffect[] potions;
        if (!world.field_72995_K && (potions = this.getPotions(stack)) != null) {
            for (PotionEffect po : potions) {
                player.func_70690_d(po);
            }
        }
    }

    public int func_150905_g(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("SoupHealAmount")) {
            return (int)stack.func_77978_p().func_74760_g("SoupHealAmount");
        }
        return super.func_150905_g(stack);
    }

    public float func_150906_h(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("SoupSaturation")) {
            return stack.func_77978_p().func_74760_g("SoupSaturation");
        }
        return super.func_150906_h(stack);
    }

    public ItemStack[] getMainFood(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("MainFood")) {
            NBTTagList tagList = stack.func_77978_p().func_150295_c("MainFood", 10);
            ItemStack[] mainFood = new ItemStack[4];
            for (int i = 0; i < 4; ++i) {
                mainFood[i] = i < tagList.func_74745_c() ? new ItemStack(tagList.func_150305_b(i)) : ItemStack.field_190927_a;
            }
            return mainFood;
        }
        return null;
    }

    public ItemStack[] getFoodColors(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("FoodColors")) {
            NBTTagList tagList = stack.func_77978_p().func_150295_c("FoodColors", 10);
            ItemStack[] mainFood = new ItemStack[4];
            for (int i = 0; i < 4; ++i) {
                mainFood[i] = i < tagList.func_74745_c() ? new ItemStack(tagList.func_150305_b(i)) : ItemStack.field_190927_a;
            }
            return mainFood;
        }
        return null;
    }

    public float[] getFoodPercent(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("FoodPercent")) {
            NBTTagList tagList = stack.func_77978_p().func_150295_c("FoodPercent", 10);
            float[] mainFood = new float[4];
            for (int i = 0; i < 4; ++i) {
                mainFood[i] = i < tagList.func_74745_c() ? tagList.func_150305_b(i).func_74760_g("Percent") : 0.0f;
            }
            return mainFood;
        }
        return null;
    }

    @Override
    public PotionEffect[] getPotions(ItemStack stack) {
        NBTTagList tagList;
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Potions") && (tagList = stack.func_77978_p().func_150295_c("Potions", 10)).func_74745_c() > 0) {
            PotionEffect[] potions = new PotionEffect[tagList.func_74745_c()];
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                potions[i] = PotionEffect.func_82722_b((NBTTagCompound)tagList.func_150305_b(i));
            }
            return potions;
        }
        return null;
    }

    @Override
    public float getToxic(ItemStack stack) {
        return stack.func_77942_o() ? (float)((int)stack.func_77978_p().func_74760_g("SoupToxic")) : 0.0f;
    }

    @Override
    public float getProbability(ItemStack stack) {
        return 1.0f;
    }

    public int getCurrentPortion(ItemStack stack) {
        return stack.func_77942_o() ? stack.func_77978_p().func_74762_e("SoupPortion") : 0;
    }

    public void setPortion(ItemStack stack, int portion) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("SoupPortion", portion);
    }

    public int getMaxPortion() {
        return this.portion;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return this.getCurrentPortion(stack) == 0 ? EnumAction.NONE : (this.drink ? EnumAction.DRINK : EnumAction.EAT);
    }

    public static ItemStack getSoupStack(ItemStack stack) {
        if (stack.func_77973_b() == Items.field_151054_z) {
            return new ItemStack((Item)MistItems.SOUP);
        }
        if (stack.func_77973_b() == MistItems.GLASS_CONTAINER) {
            return stack.func_77946_l();
        }
        return ItemStack.field_190927_a;
    }
}

