/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.item.food;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.api.block.IWettable;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.api.item.IMistFood;
import ru.liahim.mist.block.upperplant.MistMushroom;
import ru.liahim.mist.block.upperplant.MistMycelium;
import ru.liahim.mist.capability.handler.IFoodHandler;
import ru.liahim.mist.capability.handler.IMistCapaHandler;
import ru.liahim.mist.init.ModAdvancements;
import ru.liahim.mist.tileentity.TileEntityMycelium;
import ru.liahim.mist.util.SoilHelper;
import ru.liahim.mist.world.MistWorld;

public class ItemMistMushroom
extends ItemFood
implements IMistFood {
    public static final MistMushroom[] MUSHROOMS = new MistMushroom[]{MistBlocks.MUSHROOMS_0, MistBlocks.MUSHROOMS_1};
    private final boolean isCook;

    public ItemMistMushroom(boolean isCook) {
        super(0, 0.0f, false);
        this.isCook = isCook;
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_185043_a(new ResourceLocation("mist:salt"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                return IMistFood.hasSalt(stack) ? 1.0f : 0.0f;
            }
        });
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            IFoodHandler mCapa = IFoodHandler.getHandler((EntityPlayer)player);
            int i = mCapa.getMushroomStudy(stack.func_77960_j(), this.isCook);
            float toxic = this.getToxic(stack);
            if (toxic != 0.0f && mCapa.isFoodStudy(stack)) {
                if (toxic > 0.0f) {
                    tooltip.add(TextFormatting.DARK_RED + I18n.func_74838_a((String)"item.mist.food_toxic.tooltip"));
                } else {
                    tooltip.add(TextFormatting.DARK_GREEN + I18n.func_74838_a((String)"item.mist.food_antitoxic.tooltip"));
                }
            }
            if (i != 0) {
                if (i == -1) {
                    tooltip.add(TextFormatting.DARK_RED + I18n.func_74838_a((String)"item.mist.food_inedible.tooltip"));
                } else if (i == 1) {
                    tooltip.add(I18n.func_74838_a((String)"item.mist.food_unknown.tooltip"));
                } else if (i == 2) {
                    tooltip.add(TextFormatting.DARK_GREEN + I18n.func_74838_a((String)"item.mist.food_edible.tooltip"));
                }
            }
            if (!this.isCook && player != null && player.func_184812_l_()) {
                tooltip.add(I18n.func_74838_a((String)"tile.mist.mushroom.tooltip"));
            }
        }
    }

    public String func_77667_c(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77973_b() == this) {
            int i = MathHelper.func_76125_a((int)stack.func_77960_j(), (int)0, (int)(MUSHROOMS.length * 16 - 1));
            return "tile.mist.mushroom_" + MUSHROOMS[i / 16].getTypeName(i % 16) + (this.isCook ? "_c" : "");
        }
        return "";
    }

    public String func_77653_i(ItemStack stack) {
        String salt = IMistFood.hasSalt(stack) ? " " + I18n.func_74838_a((String)"item.mist.food_salt.tooltip") : "";
        return super.func_77653_i(stack) + salt;
    }

    public int func_150905_g(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77973_b() == this) {
            int salt = IMistFood.hasSalt(stack) ? 1 : 0;
            int i = MathHelper.func_76125_a((int)stack.func_77960_j(), (int)0, (int)(MUSHROOMS.length * 16 - 1));
            return MUSHROOMS[i / 16].getFoodProperty(i % 16).getHealAmount(this.isCook) + salt;
        }
        return 0;
    }

    public float func_150906_h(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77973_b() == this) {
            float salt = IMistFood.hasSalt(stack) ? 0.1f : 0.0f;
            int i = MathHelper.func_76125_a((int)stack.func_77960_j(), (int)0, (int)(MUSHROOMS.length * 16 - 1));
            return MUSHROOMS[i / 16].getFoodProperty(i % 16).getSaturationModifier(this.isCook) + salt;
        }
        return 0.0f;
    }

    protected void func_77849_c(ItemStack stack, World world, EntityPlayer player) {
        if (stack.func_77973_b() == this) {
            int toxic;
            int i = MathHelper.func_76125_a((int)stack.func_77960_j(), (int)0, (int)(MUSHROOMS.length * 16 - 1));
            MistMushroom.IFoodProperty prop = MUSHROOMS[i / 16].getFoodProperty(i % 16);
            PotionEffect[] pes = prop.getPotionEffect(this.isCook);
            IFoodHandler mCapa = IFoodHandler.getHandler(player);
            if (pes != null && world.field_73012_v.nextFloat() < prop.getProbability(this.isCook)) {
                for (PotionEffect pe : pes) {
                    player.func_70690_d(new PotionEffect(pe));
                }
                if (prop.isEdable(this.isCook) ? mCapa.getMushroomStudy(i, this.isCook) != 2 : mCapa.getMushroomStudy(i, this.isCook) != -1) {
                    mCapa.setMushroomStudy(i, prop.isEdable(this.isCook) ? 1 : -1, this.isCook);
                }
            } else if (mCapa.getMushroomStudy(i, this.isCook) != 2) {
                mCapa.setMushroomStudy(i, 2, this.isCook);
            }
            if ((toxic = (int)this.getToxic(stack)) != 0) {
                IMistCapaHandler.getHandler(player).addToxic(toxic);
                IFoodHandler.getHandler(player).setFoodStudy(stack);
                if (player instanceof EntityPlayerMP) {
                    ModAdvancements.CONSUME_TOXIC.trigger((EntityPlayerMP)player, stack, Float.valueOf(toxic));
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (int i = 0; i < MUSHROOMS.length; ++i) {
                for (int j = 0; j < MUSHROOMS[i].getTypeProperty().func_177700_c().size(); ++j) {
                    items.add((Object)new ItemStack((Item)this, 1, j + i * 16));
                }
            }
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!this.isCook) {
            MistMycelium.SoilType type;
            IBlockState state;
            if (player.func_70093_af()) {
                if (facing == EnumFacing.UP) {
                    if (!world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos)) {
                        pos = pos.func_177972_a(facing);
                    }
                    ItemStack stack = player.func_184586_b(hand);
                    int meta = this.func_77647_b(stack.func_77960_j());
                    if (!stack.func_190926_b() && player.func_175151_a(pos, facing, stack) && world.func_190527_a((Block)MUSHROOMS[meta / 16], pos, false, facing, (Entity)null)) {
                        IBlockState mushroom = MUSHROOMS[meta / 16].getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta % 16, (EntityLivingBase)player, hand);
                        IBlockState soil = world.func_180495_p(pos.func_177977_b());
                        if (soil.func_177230_c() instanceof IWettable && !((IWettable)soil.func_177230_c()).isAcid() && !MistWorld.isPosInFog(world, pos) && (SoilHelper.getHumus(soil) >= 2 || MistMushroom.isPair(mushroom, world.func_175625_s(pos.func_177977_b())))) {
                            if (this.placeBlockAt(stack, player, world, pos, facing, hitX, hitY, hitZ, mushroom, meta)) {
                                mushroom = world.func_180495_p(pos);
                                SoundType soundtype = mushroom.func_177230_c().getSoundType(mushroom, world, pos, (Entity)player);
                                world.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                                stack.func_190918_g(1);
                            }
                            return EnumActionResult.SUCCESS;
                        }
                    }
                }
            } else if (player.func_184812_l_() && (state = world.func_180495_p(pos)).func_177230_c() instanceof IWettable && (type = MistMycelium.SoilType.bySoil((IWettable)state.func_177230_c())) != null) {
                world.func_175656_a(pos, MistBlocks.MYCELIUM.func_176223_P().func_177226_a(MistMycelium.SOIL, (Comparable)((Object)type)).func_177226_a((IProperty)IWettable.WET, state.func_177229_b((IProperty)IWettable.WET)));
                int meta = this.func_77647_b(player.func_184586_b(hand).func_77960_j());
                IBlockState state1 = MUSHROOMS[meta / 16].getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta % 16, (EntityLivingBase)player, hand);
                ((TileEntityMycelium)world.func_175625_s(pos)).setMushroomState(state1, false);
            }
        }
        return EnumActionResult.FAIL;
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState, int meta) {
        if (!world.func_180501_a(pos, newState, 11)) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == MUSHROOMS[meta / 16]) {
            MUSHROOMS[meta / 16].func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
            if (player instanceof EntityPlayerMP) {
                CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
            }
        }
        return true;
    }

    @Override
    public PotionEffect[] getPotions(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77973_b() == this) {
            int i = MathHelper.func_76125_a((int)stack.func_77960_j(), (int)0, (int)(MUSHROOMS.length * 16 - 1));
            if (IMistFood.hasSalt(stack)) {
                PotionEffect[] list = MUSHROOMS[i / 16].getFoodProperty(i % 16).getPotionEffect(this.isCook);
                PotionEffect[] temp = new PotionEffect[list.length];
                int j = 0;
                for (PotionEffect pe : list) {
                    temp[j] = pe.func_188419_a().func_76398_f() ? new PotionEffect(pe.func_188419_a(), pe.func_76459_b() / 2, Math.max(pe.func_76458_c() - 1, 0), false, false) : pe;
                    ++j;
                }
                return temp;
            }
            return MUSHROOMS[i / 16].getFoodProperty(i % 16).getPotionEffect(this.isCook);
        }
        return null;
    }

    @Override
    public float getProbability(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77973_b() == this) {
            int i = MathHelper.func_76125_a((int)stack.func_77960_j(), (int)0, (int)(MUSHROOMS.length * 16 - 1));
            return MUSHROOMS[i / 16].getFoodProperty(i % 16).getProbability(this.isCook);
        }
        return 0.0f;
    }

    @Override
    public boolean isEdible(ItemStack stack) {
        int i = MathHelper.func_76125_a((int)stack.func_77960_j(), (int)0, (int)(MUSHROOMS.length * 16 - 1));
        return MUSHROOMS[i / 16].getFoodProperty(i % 16).isEdable(this.isCook);
    }

    @Override
    public float getToxic(ItemStack stack) {
        if (!this.isCook) {
            int i = stack.func_77960_j();
            if (i == 21) {
                return -350.0f;
            }
            if (i == 23) {
                return -200.0f;
            }
            if (i == 25) {
                return -350.0f;
            }
        }
        return 0.0f;
    }
}

