/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.item.food;

import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.api.item.IMistFood;
import ru.liahim.mist.api.item.MistItems;

public class ItemMistMeat
extends ItemFood
implements IMistFood {
    private final boolean isCook;

    public ItemMistMeat(boolean isCook) {
        super(0, 0.0f, true);
        this.isCook = isCook;
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_185043_a(new ResourceLocation("mist:salt"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                return IMistFood.hasSalt(stack) ? 1.0f : 0.0f;
            }
        });
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    protected void func_77849_c(ItemStack stack, World world, EntityPlayer player) {
        PotionEffect[] potions;
        if (!world.field_72995_K && world.field_73012_v.nextFloat() < this.getProbability(stack) && (potions = this.getPotions(stack)) != null) {
            for (PotionEffect po : potions) {
                player.func_70690_d(po);
            }
        }
    }

    public String func_77667_c(ItemStack stack) {
        String name = MeatType.byMetadata(stack.func_77952_i()).func_176610_l();
        return "item.mist.meat_" + name + (this.isCook ? "_c" : "");
    }

    public String func_77653_i(ItemStack stack) {
        String salt = IMistFood.hasSalt(stack) ? I18n.func_74838_a((String)"item.mist.food_salt.tooltip") : "";
        return super.func_77653_i(stack) + " " + salt;
    }

    public int func_150905_g(ItemStack stack) {
        int salt = IMistFood.hasSalt(stack) ? 1 : 0;
        return Math.min(MeatType.byMetadata(stack.func_77952_i()).getAmount(this.isCook) + salt, 20);
    }

    public float func_150906_h(ItemStack stack) {
        float salt = IMistFood.hasSalt(stack) ? 0.1f : 0.0f;
        return MeatType.byMetadata(stack.func_77952_i()).getSaturation(this.isCook) + salt;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this == MistItems.MEAT_COOK && this.func_194125_a(tab)) {
            for (int i = 0; i < MeatType.values().length; ++i) {
                items.add((Object)new ItemStack((Item)MistItems.MEAT_FOOD, 1, i));
                ItemStack stack = new ItemStack((Item)this, 1, i);
                items.add((Object)stack);
            }
        }
    }

    @Override
    public PotionEffect[] getPotions(ItemStack stack) {
        if (IMistFood.hasSalt(stack)) {
            PotionEffect[] list = MeatType.byMetadata(stack.func_77952_i()).getEffects(this.isCook);
            PotionEffect[] temp = new PotionEffect[list.length];
            int i = 0;
            for (PotionEffect pe : list) {
                temp[i] = pe.func_188419_a().func_76398_f() ? new PotionEffect(pe.func_188419_a(), pe.func_76459_b() / 2, Math.max(pe.func_76458_c() - 1, 0), false, false) : pe;
                ++i;
            }
            return temp;
        }
        return MeatType.byMetadata(stack.func_77952_i()).getEffects(this.isCook);
    }

    @Override
    public float getProbability(ItemStack stack) {
        return MeatType.byMetadata(stack.func_77952_i()).getProbability(this.isCook);
    }

    @Override
    public float getToxic(ItemStack stack) {
        return 0.0f;
    }

    public static enum MeatType implements IStringSerializable
    {
        MOSSLING(0, "mossling", 2, 0.3f, 5, 0.7f, 0.3f, new PotionEffect(MobEffects.field_76438_s, 600, 0, false, false), new PotionEffect(MobEffects.field_76431_k, 300, 0, false, false)),
        FOREST_RUNNER(1, "forest_runner", 3, 0.2f, 6, 0.8f),
        MOMO(2, "momo", 3, 0.3f, 6, 0.8f),
        BARVOG(3, "barvog", 3, 0.3f, 6, 0.8f, 0.3f, new PotionEffect(MobEffects.field_76438_s, 600, 0, false, false), new PotionEffect(MobEffects.field_76421_d, 400, 0, false, false)),
        PRICKLER(4, "prickler", 2, 0.3f, 5, 0.7f, 0.1f, new PotionEffect(MobEffects.field_76438_s, 400, 0, false, false)),
        CARAVAN(5, "caravan", 3, 0.3f, 7, 0.8f, 0.5f, new PotionEffect(MobEffects.field_76421_d, 600, 1, false, false)),
        WULDER(6, "wulder", 3, 0.3f, 8, 0.8f),
        HORB(7, "horb", 2, 0.3f, 6, 0.9f, 0.2f, new PotionEffect(MobEffects.field_76438_s, 400, 0, false, false), new PotionEffect(MobEffects.field_76421_d, 400, 0, false, false)),
        SNIFF(8, "sniff", 2, 0.5f, 7, 0.8f),
        SLOTH(9, "sloth", 2, 0.2f, 5, 0.8f, 0.4f, new PotionEffect(MobEffects.field_76438_s, 600, 0, false, false), new PotionEffect(MobEffects.field_76436_u, 80, 0, false, false), new PotionEffect(MobEffects.field_76431_k, 200, 0, false, false)),
        MONK(10, "monk", 3, 0.4f, 8, 0.8f),
        GALAGA(11, "galaga", 2, 0.3f, 6, 0.8f, 0.2f, new PotionEffect(MobEffects.field_76438_s, 400, 0, false, false), new PotionEffect(MobEffects.field_76431_k, 300, 0, false, false)),
        HULTER(12, "hulter", 2, 0.2f, 5, 0.7f, 0.3f, new PotionEffect(MobEffects.field_76438_s, 600, 0, false, false)),
        BRACHIODON(13, "brachiodon", 4, 0.3f, 9, 0.8f, 0.1f, new PotionEffect(MobEffects.field_76421_d, 400, 0, false, false));

        private final int meta;
        private final String name;
        private final int amount;
        private final float saturation;
        private final int cookAmount;
        private final float cookSaturation;
        private final float probability;
        private final PotionEffect[] effects;
        private static final MeatType[] META_LOOKUP;

        private MeatType(int meta, String name, int amount, float saturation, int cookAmount, float cookSaturation, float probability, PotionEffect ... effects) {
            this.meta = meta;
            this.name = name;
            this.amount = amount;
            this.saturation = saturation;
            this.cookAmount = cookAmount;
            this.cookSaturation = cookSaturation;
            this.probability = probability;
            this.effects = effects;
        }

        private MeatType(int meta, String name, int amount, float saturation, int cookAmount, float cookSaturation) {
            this(meta, name, amount, saturation, cookAmount, cookSaturation, 0.0f, null);
        }

        public int getMetadata() {
            return this.meta;
        }

        public static MeatType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getAmount(boolean isCook) {
            return isCook ? this.cookAmount : this.amount;
        }

        public float getSaturation(boolean isCook) {
            return isCook ? this.cookSaturation : this.saturation;
        }

        public float getProbability(boolean isCook) {
            return isCook ? 0.0f : this.probability;
        }

        public PotionEffect[] getEffects(boolean isCook) {
            return isCook ? null : this.effects;
        }

        static {
            META_LOOKUP = new MeatType[MeatType.values().length];
            MeatType[] meatTypeArray = MeatType.values();
            int n = meatTypeArray.length;
            for (int i = 0; i < n; ++i) {
                MeatType type;
                MeatType.META_LOOKUP[type.getMetadata()] = type = meatTypeArray[i];
            }
        }
    }
}

