/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.api.item.IColoredItem;
import ru.liahim.mist.api.item.ISuit;
import ru.liahim.mist.api.item.MistItems;
import ru.liahim.mist.client.model.ModelSuit;
import ru.liahim.mist.init.ItemColoring;
import ru.liahim.mist.init.ModItems;
import ru.liahim.mist.item.ItemMistArmor;

public class ItemMistSuit
extends ItemMistArmor
implements ISuit,
IColoredItem {
    private final String thinTex = "mist:textures/models/armor/rubber_layer_1_a.png";
    private final String thickTex = "mist:textures/models/armor/rubber_layer_1.png";
    private final String legginsTex = "mist:textures/models/armor/rubber_layer_2.png";
    private final String overlay_1 = "mist:textures/models/armor/rubber_layer_1_overlay.png";
    private final String overlay_2 = "mist:textures/models/armor/rubber_layer_2_overlay.png";
    private final float protection;

    @Override
    @SideOnly(value=Side.CLIENT)
    public IItemColor getItemColor() {
        return ItemColoring.ITEM_ARMOR_COLORING;
    }

    public ItemMistSuit(ItemArmor.ArmorMaterial material, int renderIndex, EntityEquipmentSlot equipmentSlot, float protection) {
        super(material, renderIndex, equipmentSlot);
        this.protection = protection;
    }

    @Override
    public float getPollutionProtection() {
        return this.protection;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        if (stack.func_77973_b() instanceof ISuit) {
            StringBuilder sb = new StringBuilder();
            sb.append(I18n.func_135052_a((String)"item.mist.suit_protection.tooltip", (Object[])new Object[0]));
            sb.append(": ");
            sb.append(TextFormatting.GREEN);
            sb.append(String.format("%.2f", Float.valueOf(((ISuit)stack.func_77973_b()).getPollutionProtection())));
            sb.append("%");
            tooltip.add(sb.toString());
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        int level;
        IBlockState state;
        ItemStack stack = player.func_184586_b(hand);
        if (this.func_82816_b_(stack) && (state = world.func_180495_p(pos)).func_177230_c() instanceof BlockCauldron && (level = ((Integer)state.func_177229_b((IProperty)BlockCauldron.field_176591_a)).intValue()) > 0) {
            if (!world.field_72995_K) {
                this.func_82815_c(stack);
                Blocks.field_150383_bp.func_176590_a(world, pos, state, level - 1);
                player.func_71029_a(StatList.field_188079_M);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack material) {
        return material.func_77973_b() == MistItems.RUBBER || super.func_82789_a(toRepair, material);
    }

    public boolean hasOverlay(ItemStack stack) {
        return this.func_82812_d() == ModItems.RUBBER_MATERIAL || this.func_82814_b(stack) != 0xFFFFFF;
    }

    public boolean func_82816_b_(ItemStack stack) {
        if (this.func_82812_d() != ModItems.RUBBER_MATERIAL) {
            return false;
        }
        NBTTagCompound tag = stack.func_77978_p();
        return tag != null && tag.func_150297_b("display", 10) ? tag.func_74775_l("display").func_150297_b("color", 3) : false;
    }

    public int func_82814_b(ItemStack stack) {
        NBTTagCompound tag1;
        if (this.func_82812_d() != ModItems.RUBBER_MATERIAL) {
            return 0xFFFFFF;
        }
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null && (tag1 = tag.func_74775_l("display")) != null && tag1.func_150297_b("color", 3)) {
            return tag1.func_74762_e("color");
        }
        return 7499105;
    }

    public void func_82815_c(ItemStack stack) {
        NBTTagCompound tag1;
        NBTTagCompound tag;
        if (this.func_82812_d() == ModItems.RUBBER_MATERIAL && (tag = stack.func_77978_p()) != null && (tag1 = tag.func_74775_l("display")).func_74764_b("color")) {
            tag1.func_82580_o("color");
        }
    }

    public void func_82813_b(ItemStack stack, int color) {
        if (this.func_82812_d() != ModItems.RUBBER_MATERIAL) {
            throw new UnsupportedOperationException("Can't dye non-leather!");
        }
        NBTTagCompound tab = stack.func_77978_p();
        if (tab == null) {
            tab = new NBTTagCompound();
            stack.func_77982_d(tab);
        }
        NBTTagCompound tab1 = tab.func_74775_l("display");
        if (!tab.func_150297_b("display", 10)) {
            tab.func_74782_a("display", (NBTBase)tab1);
        }
        tab1.func_74768_a("color", color);
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        if (entity instanceof AbstractClientPlayer) {
            boolean legs;
            boolean bl = legs = slot == EntityEquipmentSlot.LEGS;
            if (type != null) {
                return legs ? "mist:textures/models/armor/rubber_layer_2_overlay.png" : "mist:textures/models/armor/rubber_layer_1_overlay.png";
            }
            boolean alex = ((AbstractClientPlayer)entity).func_175154_l().equals("slim");
            return legs ? "mist:textures/models/armor/rubber_layer_2.png" : (alex ? "mist:textures/models/armor/rubber_layer_1_a.png" : "mist:textures/models/armor/rubber_layer_1.png");
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entity, ItemStack stack, EntityEquipmentSlot slot, ModelBiped model) {
        if (entity instanceof AbstractClientPlayer) {
            boolean legs;
            boolean alex = ((AbstractClientPlayer)entity).func_175154_l().equals("slim");
            boolean bl = legs = slot == EntityEquipmentSlot.LEGS;
            return legs ? ModelSuit.leggins : (alex ? ModelSuit.thin : ModelSuit.thick);
        }
        return null;
    }
}

