/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.api.item.IMistFood;
import ru.liahim.mist.block.MistTreeSapling;
import ru.liahim.mist.capability.handler.IFoodHandler;
import ru.liahim.mist.capability.handler.IMistCapaHandler;
import ru.liahim.mist.init.ModAdvancements;

public class ItemMistSeedTree
extends ItemFood
implements IMistFood {
    public ItemMistSeedTree() {
        super(0, 0.0f, false);
        this.func_77656_e(0);
        this.func_77627_a(true);
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    public String func_77667_c(ItemStack stack) {
        String name = MistTreeSapling.EnumType.byMeta(stack.func_77952_i()).func_176610_l();
        return "item.mist." + name + "_seed";
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            IFoodHandler mCapa = IFoodHandler.getHandler((EntityPlayer)player);
            if (this.isFood(stack) && mCapa.isFoodStudy(stack)) {
                float toxic = this.getToxic(stack);
                if (toxic > 0.0f) {
                    tooltip.add(TextFormatting.DARK_RED + I18n.func_135052_a((String)"item.mist.food_toxic.tooltip", (Object[])new Object[0]));
                } else if (toxic < 0.0f) {
                    tooltip.add(TextFormatting.DARK_GREEN + I18n.func_135052_a((String)"item.mist.food_antitoxic.tooltip", (Object[])new Object[0]));
                }
                if (!this.isEdible(stack)) {
                    tooltip.add(TextFormatting.DARK_RED + I18n.func_135052_a((String)"item.mist.food_inedible.tooltip", (Object[])new Object[0]));
                } else {
                    tooltip.add(TextFormatting.DARK_GREEN + I18n.func_135052_a((String)"item.mist.food_edible.tooltip", (Object[])new Object[0]));
                }
            }
        }
    }

    public int func_150905_g(ItemStack stack) {
        MistTreeSapling.EnumType type = MistTreeSapling.EnumType.byMeta(stack.func_77952_i());
        if (type == MistTreeSapling.EnumType.OAK) {
            return 1;
        }
        if (type == MistTreeSapling.EnumType.STREE) {
            return 1;
        }
        if (type == MistTreeSapling.EnumType.TTREE) {
            return 1;
        }
        if (type == MistTreeSapling.EnumType.RTREE) {
            return 3;
        }
        return 0;
    }

    public float func_150906_h(ItemStack stack) {
        MistTreeSapling.EnumType type = MistTreeSapling.EnumType.byMeta(stack.func_77952_i());
        if (type == MistTreeSapling.EnumType.OAK) {
            return 0.3f;
        }
        if (type == MistTreeSapling.EnumType.STREE) {
            return 0.3f;
        }
        if (type == MistTreeSapling.EnumType.TTREE) {
            return 0.3f;
        }
        if (type == MistTreeSapling.EnumType.RTREE) {
            return 0.6f;
        }
        return 0.0f;
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entity) {
        if (!this.isFood(stack)) {
            return stack;
        }
        return super.func_77654_b(stack, world, entity);
    }

    protected void func_77849_c(ItemStack stack, World world, EntityPlayer player) {
        int toxic;
        PotionEffect[] potions;
        if (!world.field_72995_K && world.field_73012_v.nextFloat() < this.getProbability(stack) && (potions = this.getPotions(stack)) != null) {
            for (PotionEffect po : potions) {
                player.func_70690_d(po);
            }
        }
        if ((toxic = (int)this.getToxic(stack)) != 0) {
            IMistCapaHandler.getHandler(player).addToxic(toxic);
            if (player instanceof EntityPlayerMP) {
                ModAdvancements.CONSUME_TOXIC.trigger((EntityPlayerMP)player, stack, Float.valueOf(toxic));
            }
        }
        IFoodHandler.getHandler(player).setFoodStudy(stack);
    }

    public int func_77626_a(ItemStack stack) {
        return this.isFood(stack) ? 32 : 0;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return this.isFood(stack) ? EnumAction.EAT : EnumAction.NONE;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (!this.isFood(player.func_184586_b(hand))) {
            return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
        }
        return super.func_77659_a(world, player, hand);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)new ItemStack((Item)this, 1, MistTreeSapling.EnumType.POPLAR.getMeta()));
            for (MistTreeSapling.EnumType type : MistTreeSapling.EnumType.values()) {
                if (type == MistTreeSapling.EnumType.ASPEN || type == MistTreeSapling.EnumType.BIRCH || type == MistTreeSapling.EnumType.POPLAR || type == MistTreeSapling.EnumType.SPRUCE || type == MistTreeSapling.EnumType.WILLOW) continue;
                items.add((Object)new ItemStack((Item)this, 1, type.getMeta()));
                if (type != MistTreeSapling.EnumType.PINE) continue;
                items.add((Object)new ItemStack((Item)this, 1, MistTreeSapling.EnumType.SPRUCE.getMeta()));
            }
            items.add((Object)new ItemStack((Item)this, 1, MistTreeSapling.EnumType.WILLOW.getMeta()));
            items.add((Object)new ItemStack((Item)this, 1, MistTreeSapling.EnumType.BIRCH.getMeta()));
            items.add((Object)new ItemStack((Item)this, 1, MistTreeSapling.EnumType.ASPEN.getMeta()));
        }
    }

    @Override
    public boolean isEdible(ItemStack stack) {
        MistTreeSapling.EnumType type = MistTreeSapling.EnumType.byMeta(stack.func_77952_i());
        return type != MistTreeSapling.EnumType.TTREE;
    }

    @Override
    public PotionEffect[] getPotions(ItemStack stack) {
        PotionEffect[] potionEffectArray;
        if (MistTreeSapling.EnumType.byMeta(stack.func_77952_i()) == MistTreeSapling.EnumType.TTREE) {
            PotionEffect[] potionEffectArray2 = new PotionEffect[1];
            potionEffectArray = potionEffectArray2;
            potionEffectArray2[0] = new PotionEffect(MobEffects.field_76436_u, 50, 1, false, false);
        } else {
            potionEffectArray = null;
        }
        return potionEffectArray;
    }

    @Override
    public float getProbability(ItemStack stack) {
        return MistTreeSapling.EnumType.byMeta(stack.func_77952_i()) == MistTreeSapling.EnumType.TTREE ? 0.6f : 0.0f;
    }

    @Override
    public float getToxic(ItemStack stack) {
        return MistTreeSapling.EnumType.byMeta(stack.func_77952_i()) == MistTreeSapling.EnumType.STREE ? -150.0f : 0.0f;
    }

    @Override
    public boolean isFood(ItemStack stack) {
        MistTreeSapling.EnumType type = MistTreeSapling.EnumType.byMeta(stack.func_77952_i());
        return type == MistTreeSapling.EnumType.OAK || type == MistTreeSapling.EnumType.RTREE || type == MistTreeSapling.EnumType.STREE || type == MistTreeSapling.EnumType.TTREE;
    }
}

