/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.api.item.IColoredItem;
import ru.liahim.mist.api.item.IFilter;
import ru.liahim.mist.api.item.IMask;
import ru.liahim.mist.capability.handler.IMistCapaHandler;
import ru.liahim.mist.client.model.ModelRespirator;
import ru.liahim.mist.common.Mist;
import ru.liahim.mist.init.ItemColoring;
import ru.liahim.mist.init.ModItems;
import ru.liahim.mist.item.ItemMistArmor;

public class ItemMistMask
extends ItemMistArmor
implements IMask,
IColoredItem {
    private final boolean isRespirator;
    private final boolean canEat;
    private final float impermeability;
    private final String texture;
    private final String overlay;

    @Override
    @SideOnly(value=Side.CLIENT)
    public IItemColor getItemColor() {
        return ItemColoring.ITEM_ARMOR_COLORING;
    }

    public ItemMistMask(ItemArmor.ArmorMaterial material, boolean isRespirator, float impermeability, boolean canEat) {
        super(material, 0, EntityEquipmentSlot.HEAD);
        this.isRespirator = isRespirator;
        this.canEat = canEat;
        this.impermeability = impermeability;
        this.texture = canEat ? "mist:textures/models/armor/respirator_open.png" : "mist:textures/models/armor/respirator.png";
        this.overlay = "mist:textures/models/armor/respirator_overlay.png";
    }

    public ItemMistMask(ItemArmor.ArmorMaterial material, float impermeability, boolean canEat) {
        this(material, true, impermeability, canEat);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        if (stack.func_77973_b() instanceof IMask && ((IMask)stack.func_77973_b()).isRespirator()) {
            ItemStack filter = IMask.getFilter(stack);
            StringBuilder sb = new StringBuilder();
            if (!filter.func_190926_b()) {
                sb.append(filter.func_77973_b().func_77658_a());
                sb.append(".name");
                String name = sb.toString();
                sb.delete(0, sb.length());
                sb.append(I18n.func_135052_a((String)"item.mist.filter.tooltip", (Object[])new Object[0]));
                sb.append(": ");
                sb.append(I18n.func_135052_a((String)name, (Object[])new Object[0]));
                tooltip.add(sb.toString());
                sb.delete(0, sb.length());
                sb.append(I18n.func_135052_a((String)"item.mist.respirator_efficiency.tooltip", (Object[])new Object[0]));
                sb.append(": ");
                sb.append(TextFormatting.GREEN);
                sb.append(String.format("%.2f", Float.valueOf(IMask.getImpermeability(stack) * IFilter.getDepthOfFilteration(filter) / 100.0f)));
                sb.append("%");
                tooltip.add(sb.toString());
                sb.delete(0, sb.length());
                float d = (float)filter.func_77952_i() / (float)filter.func_77958_k() * 100.0f;
                sb.append(I18n.func_135052_a((String)"item.mist.filter_damage.tooltip", (Object[])new Object[0]));
                sb.append(": ");
                if (d >= 25.0f) {
                    sb.append(d < 50.0f ? TextFormatting.YELLOW : (d < 75.0f ? TextFormatting.GOLD : TextFormatting.RED));
                }
                sb.append(String.format("%.2f", Float.valueOf(d)));
                sb.append("%");
                tooltip.add(sb.toString());
            } else {
                sb.append(I18n.func_135052_a((String)"item.mist.respirator_impermeability.tooltip", (Object[])new Object[0]));
                sb.append(": ");
                sb.append(TextFormatting.GREEN);
                sb.append(String.format("%.2f", Float.valueOf(IMask.getImpermeability(stack))));
                sb.append("%");
                tooltip.add(sb.toString());
                sb.delete(0, sb.length());
                tooltip.add(I18n.func_135052_a((String)"item.mist.filter_empty.tooltip", (Object[])new Object[0]));
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            if (!world.field_72995_K && hand == EnumHand.MAIN_HAND) {
                player.openGui((Object)Mist.instance, 1, world, MathHelper.func_76128_c((double)player.field_70165_t), MathHelper.func_76128_c((double)player.field_70163_u), MathHelper.func_76128_c((double)player.field_70161_v));
            }
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        IMistCapaHandler mistCapa = IMistCapaHandler.getHandler(player);
        if (mistCapa == null || mistCapa.getMask().func_190926_b()) {
            ItemStack armor = player.func_184582_a(EntityEquipmentSlot.HEAD);
            if (armor.func_190926_b()) {
                player.func_184201_a(EntityEquipmentSlot.HEAD, stack.func_77946_l());
                stack.func_190920_e(0);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
            if (mistCapa != null && !(armor.func_77973_b() instanceof IMask)) {
                mistCapa.setStackInSlot(0, stack.func_77946_l());
                stack.func_190920_e(0);
                player.func_184185_a(this.func_82812_d().func_185017_b(), 1.0f, 1.0f);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        int level;
        IBlockState state;
        ItemStack stack = player.func_184586_b(hand);
        if (this.func_82816_b_(stack) && (state = world.func_180495_p(pos)).func_177230_c() instanceof BlockCauldron && (level = ((Integer)state.func_177229_b((IProperty)BlockCauldron.field_176591_a)).intValue()) > 0) {
            if (!world.field_72995_K) {
                this.func_82815_c(stack);
                Blocks.field_150383_bp.func_176590_a(world, pos, state, level - 1);
                player.func_71029_a(StatList.field_188079_M);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public boolean isValidArmor(ItemStack stack, EntityEquipmentSlot armorType, Entity entity) {
        if (IMask.isMaskInSlot(entity)) {
            return false;
        }
        return super.isValidArmor(stack, armorType, entity);
    }

    @Override
    public boolean isRespirator() {
        return this.isRespirator;
    }

    @Override
    public boolean canEat() {
        return this.canEat;
    }

    @Override
    public float getImpermeability() {
        return this.impermeability;
    }

    public boolean hasOverlay(ItemStack stack) {
        return this.func_82812_d() == ModItems.LEATHER_MASK_MATERIAL || this.func_82812_d() == ModItems.RUBBER_MATERIAL || this.func_82814_b(stack) != 0xFFFFFF;
    }

    public boolean func_82816_b_(ItemStack stack) {
        if (this.func_82812_d() != ModItems.LEATHER_MASK_MATERIAL && this.func_82812_d() != ModItems.RUBBER_MATERIAL) {
            return false;
        }
        NBTTagCompound tag = stack.func_77978_p();
        return tag != null && tag.func_150297_b("display", 10) ? tag.func_74775_l("display").func_150297_b("color", 3) : false;
    }

    public int func_82814_b(ItemStack stack) {
        if (!this.func_82816_b_(stack)) {
            if (this.func_82812_d() == ModItems.LEATHER_MASK_MATERIAL) {
                return 10511680;
            }
            if (this.func_82812_d() == ModItems.RUBBER_MATERIAL) {
                return 7499105;
            }
            return 0xFFFFFF;
        }
        return stack.func_77978_p().func_74775_l("display").func_74762_e("color");
    }

    public void func_82815_c(ItemStack stack) {
        NBTTagCompound tag1;
        NBTTagCompound tag;
        if ((this.func_82812_d() == ModItems.LEATHER_MASK_MATERIAL || this.func_82812_d() == ModItems.RUBBER_MATERIAL) && (tag = stack.func_77978_p()) != null && (tag1 = tag.func_74775_l("display")).func_74764_b("color")) {
            tag1.func_82580_o("color");
        }
    }

    public void func_82813_b(ItemStack stack, int color) {
        if (this.func_82812_d() != ModItems.LEATHER_MASK_MATERIAL && this.func_82812_d() != ModItems.RUBBER_MATERIAL) {
            throw new UnsupportedOperationException("Can't dye non-leather or non-rubber!");
        }
        NBTTagCompound tab = stack.func_77978_p();
        if (tab == null) {
            tab = new NBTTagCompound();
            stack.func_77982_d(tab);
        }
        NBTTagCompound tab1 = tab.func_74775_l("display");
        if (!tab.func_150297_b("display", 10)) {
            tab.func_74782_a("display", (NBTBase)tab1);
        }
        tab1.func_74768_a("color", color);
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        if (entity instanceof AbstractClientPlayer && slot == EntityEquipmentSlot.HEAD) {
            return type == null ? this.texture : this.overlay;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped model) {
        if (armorSlot == EntityEquipmentSlot.HEAD) {
            return ModelRespirator.respirator;
        }
        return null;
    }
}

