/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.item;

import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.api.sound.MistSounds;
import ru.liahim.mist.common.Mist;
import ru.liahim.mist.item.ItemMist;
import ru.liahim.mist.world.FogDamage;
import ru.liahim.mist.world.MistWorld;

public class ItemMistGasAnalyzer
extends ItemMist {
    public ItemMistGasAnalyzer() {
        this.func_77625_d(1);
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_185043_a(new ResourceLocation("mist:value"), new IItemPropertyGetter(){
            private float lastToxic = -1.0f;

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entityIn) {
                boolean frame = stack.func_82839_y();
                if (entityIn != null || frame) {
                    EntityLivingBase entity;
                    float toxic = 0.0f;
                    boolean flag = entityIn != null;
                    Object object = entity = flag ? entityIn : stack.func_82836_z();
                    if (world == null) {
                        world = entity.field_70170_p;
                    }
                    if (world.field_73011_w.getDimension() == Mist.getID()) {
                        float y = (float)(entity.field_70163_u + (double)(flag ? 1 : 0));
                        BlockPos.PooledMutableBlockPos pos = BlockPos.PooledMutableBlockPos.func_185346_s();
                        pos.func_189532_c((double)MathHelper.func_76128_c((double)entity.field_70165_t), (double)y, (double)MathHelper.func_76128_c((double)entity.field_70161_v));
                        if (MistWorld.isPosInFog(world, (BlockPos)pos)) {
                            float depth = 0.0f;
                            depth = y < (float)MistWorld.getFogMinHight() ? 4.0f : Math.min(4.0f, MistWorld.getFogHight(world, 0.0f) + 4.0f - y);
                            if (depth > 0.0f) {
                                float concentration = FogDamage.getConcentration(world, (BlockPos)pos, true);
                                toxic = FogDamage.getFogToxic(concentration);
                                if (FogDamage.isAdsorbentNear(world, (BlockPos)pos)) {
                                    toxic *= 1.0f - FogDamage.getFinalEfficiency(60.0f, concentration);
                                }
                                toxic = (toxic = toxic * depth / 4.0f) <= 40.0f ? toxic * 10.0f / 40.0f : (toxic <= 70.0f ? (toxic - 40.0f) * 10.0f / 30.0f + 10.0f : (toxic - 70.0f) * 10.0f / 30.0f + 20.0f);
                            }
                        }
                        pos.func_185344_t();
                    }
                    if (frame) {
                        return toxic;
                    }
                    if (this.lastToxic < 0.0f) {
                        this.lastToxic = toxic;
                    } else {
                        int last = Math.round(this.lastToxic);
                        this.lastToxic += (toxic - this.lastToxic) * 0.003f;
                        if (last != Math.round(this.lastToxic) && entityIn instanceof EntityPlayer) {
                            world.func_184133_a((EntityPlayer)entityIn, entityIn.func_180425_c(), MistSounds.PLAYER_GAS_ANALYZER, SoundCategory.PLAYERS, 1.0f, 1.0f);
                        }
                    }
                    return Math.round(this.lastToxic);
                }
                return 0.0f;
            }
        });
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.RARE;
    }
}

