/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.api.item.IFilter;
import ru.liahim.mist.item.ItemMist;

public class ItemMistFilter
extends ItemMist
implements IFilter {
    private final float filteringDepth;

    public ItemMistFilter(int maxDamage, float filteringDepth) {
        this.func_77656_e(maxDamage);
        this.filteringDepth = filteringDepth;
    }

    @Override
    public float getFilteringDepth() {
        return this.filteringDepth;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flagIn) {
        float d = (float)stack.func_77952_i() / (float)stack.func_77958_k() * 100.0f;
        StringBuilder sb = new StringBuilder();
        sb.append(I18n.func_135052_a((String)"item.mist.filter_depth.tooltip", (Object[])new Object[0]));
        sb.append(": ");
        sb.append(TextFormatting.GREEN);
        sb.append(String.format("%.2f", Float.valueOf(this.filteringDepth)));
        sb.append("%");
        tooltip.add(sb.toString());
        sb.delete(0, sb.length());
        sb.append(I18n.func_135052_a((String)"item.mist.filter_damage.tooltip", (Object[])new Object[0]));
        sb.append(": ");
        if (d >= 25.0f) {
            sb.append(d < 50.0f ? TextFormatting.YELLOW : (d < 75.0f ? TextFormatting.GOLD : TextFormatting.RED));
        }
        sb.append(String.format("%.2f", Float.valueOf(d)));
        sb.append("%");
        tooltip.add(sb.toString());
    }

    public int getItemStackLimit(ItemStack stack) {
        return !stack.func_77951_h() ? this.field_77777_bU : 1;
    }

    public void setDamage(ItemStack stack, int damage) {
        stack = ItemMistFilter.setDamageNBT(stack, true);
        super.setDamage(stack, damage);
    }

    public static ItemStack setDamageNBT(ItemStack stack, boolean checkDamage) {
        if (!checkDamage || !stack.func_77951_h()) {
            stack.func_77982_d(new NBTTagCompound());
            stack.func_77978_p().func_74757_a("MistDamage", true);
        }
        return stack;
    }

    public static ItemStack removeDamageNBT(ItemStack stack) {
        if (stack.func_77978_p() != null) {
            stack.func_77978_p().func_82580_o("MistDamage");
        }
        return stack;
    }

    public boolean isRepairable() {
        return false;
    }
}

