/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.item;

import com.google.common.collect.Multimap;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.api.block.IDividable;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.api.item.MistItems;
import ru.liahim.mist.block.MistStoneMined;
import ru.liahim.mist.capability.handler.ISkillCapaHandler;
import ru.liahim.mist.init.ModAdvancements;
import ru.liahim.mist.item.ItemMist;

public class ItemMistChisel
extends ItemMist {
    private final float speed;
    protected Item.ToolMaterial toolMaterial;

    public ItemMistChisel(Item.ToolMaterial material) {
        this.toolMaterial = material;
        this.field_77777_bU = 1;
        this.func_77656_e(material.func_77997_a());
        this.speed = material.func_78000_c() + 1.0f;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (!player.func_175151_a(pos.func_177972_a(facing), facing, stack)) {
            return EnumActionResult.FAIL;
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block == MistBlocks.STONE_MINED) {
            if (state.func_177229_b(MistStoneMined.TYPE) == MistStoneMined.EnumStoneType.MINED && ISkillCapaHandler.Skill.getLevel(player, ISkillCapaHandler.Skill.MASON) > 1) {
                ISkillCapaHandler.getHandler(player).addSkill(ISkillCapaHandler.Skill.MASON, 1);
                if (state.func_177229_b(MistStoneMined.STAGE) == MistStoneMined.EnumStoneStage.MOSS) {
                    state = state.func_177226_a(MistStoneMined.STAGE, (Comparable)((Object)MistStoneMined.EnumStoneStage.NORMAL));
                }
                this.setBlock(stack, player, world, pos, state.func_177226_a(MistStoneMined.TYPE, (Comparable)((Object)MistStoneMined.EnumStoneType.CHISELED)));
                if (player instanceof EntityPlayerMP) {
                    ModAdvancements.STONE_MINED.trigger((EntityPlayerMP)player, new ItemStack(MistItems.NIOBIUM_CHISEL));
                }
                return EnumActionResult.SUCCESS;
            }
        } else if (block instanceof IDividable) {
            return ((IDividable)block).chiselBlock(player, stack, world, pos, state, hand, facing, hitX, hitY, hitZ);
        }
        return EnumActionResult.PASS;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        stack.func_77972_a(1, attacker);
        return true;
    }

    protected void setBlock(ItemStack stack, EntityPlayer player, World world, BlockPos pos, IBlockState state) {
        world.func_184133_a(player, pos, SoundEvents.field_187843_fX, SoundCategory.BLOCKS, 1.0f, 1.0f);
        if (!world.field_72995_K) {
            world.func_180501_a(pos, state, 11);
            stack.func_77972_a(1, (EntityLivingBase)player);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public String getMaterialName() {
        return this.toolMaterial.toString();
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        Multimap multimap = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", 0.0, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", (double)(this.speed - 4.0f), 0));
        }
        return multimap;
    }
}

