/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.inventory.gui;

import java.io.IOException;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import ru.liahim.mist.capability.handler.IMistCapaHandler;
import ru.liahim.mist.capability.handler.ISkillCapaHandler;
import ru.liahim.mist.common.ClientProxy;
import ru.liahim.mist.util.RomanNumber;

@SideOnly(value=Side.CLIENT)
public class GuiSkills
extends GuiScreen {
    public static final ResourceLocation guiTextures = new ResourceLocation("mist:textures/gui/skills.png");
    private final EntityPlayer player;
    protected int xSize = 176;
    protected int ySize = 80;
    protected int barSize = 160;
    protected int hotbarCount = 0;
    protected int guiLeft;
    protected int guiTop;
    private static Page currentPage = Page.PAGES_ARRAY[0];
    private static final boolean renderPageTooltip = false;
    private static final int barsShift = 20;

    public GuiSkills(EntityPlayer player) {
        this.player = player;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        currentPage.initPage(this.player);
        for (Page page : Page.PAGES_ARRAY) {
            if (page.hotbarsCount <= this.hotbarCount) continue;
            this.hotbarCount = page.hotbarsCount;
        }
        this.ySize = this.hotbarCount * 20 + 40;
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize - 28) / 2;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.drawGuiContainerBackgroundLayer(partialTicks, mouseX, mouseY);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.drawGuiContainerForegroundLayer(mouseX, mouseY);
    }

    protected void drawGuiContainerBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        this.field_146297_k.func_110434_K().func_110577_a(guiTextures);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, this.xSize, 20);
        for (int i = 0; i < this.hotbarCount; ++i) {
            this.func_73729_b(this.guiLeft, this.guiTop + 20 + 20 * i, 0, 10, this.xSize, 20);
        }
        this.func_73729_b(this.guiLeft, this.guiTop + 20 + 20 * this.hotbarCount, 0, 60, this.xSize, 20);
        for (Page page : Page.PAGES_ARRAY) {
            boolean current = page.index == currentPage.index;
            int i = page.index == 0 ? 0 : 1;
            this.func_73729_b(this.guiLeft + page.index * 29, this.guiTop + this.ySize - 4, i * 28, current ? 130 : 98, 28, 32);
        }
        int shift = 24;
        for (int i = 0; i < currentPage.hotbarsCount; ++i) {
            boolean icon = currentPage.hasIcon(i);
            if (icon) {
                this.func_73729_b(this.guiLeft + 7, this.guiTop + shift + 6, this.xSize + i * 9, 0, 9, 10);
            }
            this.func_73729_b(this.guiLeft, this.guiTop + shift + 10, 0, icon ? 89 : 81, this.xSize, 4);
            currentPage.setBarColor(i);
            this.func_73729_b(this.guiLeft + (icon ? 21 : 8), this.guiTop + shift + 11, icon ? 21 : 8, icon ? 94 : 86, currentPage.getScaledBar(i, this.barSize - (icon ? 13 : 0)), 2);
            shift += 20;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    protected void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        String str = I18n.func_135052_a((String)("gui.mist." + currentPage.label), (Object[])new Object[0]);
        this.field_146289_q.func_78276_b(str, this.guiLeft + this.xSize / 2 - this.field_146289_q.func_78256_a(str) / 2, this.guiTop + 8, 0x404040);
        int shift = 24;
        for (int i = 0; i < currentPage.hotbarsCount; ++i) {
            boolean icon = currentPage.hasIcon(i);
            this.field_146289_q.func_78276_b(currentPage.getBarName(i), this.guiLeft + (icon ? 20 : 7), this.guiTop + shift, 0x404040);
            shift += 20;
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (mouseButton == 0) {
            int x = mouseX - this.guiLeft;
            int y = mouseY - this.guiTop;
            for (Page page : Page.PAGES_ARRAY) {
                if (!this.isMouseOverPage(page, x, y)) continue;
                return;
            }
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        if (state == 0) {
            int x = mouseX - this.guiLeft;
            int y = mouseY - this.guiTop;
            for (Page page : Page.PAGES_ARRAY) {
                if (page == null || !this.isMouseOverPage(page, x, y)) continue;
                this.setCurrentCreativeTab(page);
                return;
            }
        }
        super.func_146286_b(mouseX, mouseY, state);
    }

    private boolean isMouseOverPage(Page page, int x, int y) {
        int i = 29 * page.index;
        return y > this.ySize && y < this.ySize + 28 && x > 0 + i && x < 28 + i;
    }

    private void setCurrentCreativeTab(Page page) {
        currentPage = page;
        currentPage.initPage(this.player);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == ClientProxy.skillKey.func_151463_i()) {
            this.field_146297_k.func_147108_a(null);
        } else {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public static abstract class Page {
        public static Page[] PAGES_ARRAY = new Page[2];
        public static final Page SKILLS = new Page(0, "skills", ISkillCapaHandler.Skill.values().length){
            private ISkillCapaHandler capa;

            @Override
            public void initPage(EntityPlayer player) {
                this.capa = ISkillCapaHandler.getHandler(player);
            }

            @Override
            public int getScaledBar(int barIndex, int barSize) {
                ISkillCapaHandler.Skill skill = ISkillCapaHandler.Skill.values()[barIndex];
                return (int)(skill.getPosition(this.capa.getSkill(skill)) * (float)barSize);
            }

            @Override
            public String getBarName(int barIndex) {
                ISkillCapaHandler.Skill skill = ISkillCapaHandler.Skill.values()[barIndex];
                return I18n.func_135052_a((String)("gui.mist.skills." + skill.getName()), (Object[])new Object[0]) + ": " + RomanNumber.toRoman(skill.getLevel(this.capa.getSkill(skill)));
            }
        };
        public static final Page EFFECTS = new Page(1, "effects", 2){
            private IMistCapaHandler capa;

            @Override
            public void initPage(EntityPlayer player) {
                this.capa = IMistCapaHandler.getHandler(player);
            }

            @Override
            public int getScaledBar(int barIndex, int barSize) {
                if (barIndex == 0) {
                    return MathHelper.func_76123_f((float)((float)(this.capa.getToxic() * barSize) / 10000.0f));
                }
                if (barIndex == 1) {
                    return MathHelper.func_76123_f((float)((float)(this.capa.getPollution() * barSize) / 10000.0f));
                }
                return 0;
            }

            @Override
            public String getBarName(int barIndex) {
                if (barIndex == 0) {
                    return I18n.func_135052_a((String)"gui.mist.effects.toxic", (Object[])new Object[0]) + ": " + String.format("%.2f", Float.valueOf((float)this.capa.getToxic() / 100.0f)) + "%";
                }
                return I18n.func_135052_a((String)"gui.mist.effects.pollution", (Object[])new Object[0]) + ": " + String.format("%.2f", Float.valueOf((float)this.capa.getPollution() / 100.0f)) + "%";
            }

            @Override
            public boolean hasIcon(int barIndex) {
                return true;
            }

            @Override
            public void setBarColor(int barIndex) {
                if (barIndex == 1) {
                    GL11.glColor4f((float)0.15686275f, (float)0.8352941f, (float)0.36078432f, (float)1.0f);
                }
            }
        };
        private final int index;
        private final String label;
        private final int hotbarsCount;

        public Page(int index, String label, int hotbarsCount) {
            if (index >= PAGES_ARRAY.length) {
                Page[] tmp = new Page[index + 1];
                for (int x = 0; x < PAGES_ARRAY.length; ++x) {
                    tmp[x] = PAGES_ARRAY[x];
                }
                PAGES_ARRAY = tmp;
            }
            this.index = index;
            this.label = label;
            this.hotbarsCount = hotbarsCount;
            Page.PAGES_ARRAY[index] = this;
        }

        @SideOnly(value=Side.CLIENT)
        public int getIndex() {
            return this.index;
        }

        @SideOnly(value=Side.CLIENT)
        public String getLabel() {
            return this.label;
        }

        public void initPage(EntityPlayer player) {
        }

        public int getScaledBar(int barIndex, int barSize) {
            return 0;
        }

        public String getBarName(int barIndex) {
            return "";
        }

        public boolean hasIcon(int barIndex) {
            return false;
        }

        public void setBarColor(int barIndex) {
        }
    }
}

