/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.inventory.gui;

import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.inventory.container.ContainerMistFurnace;
import ru.liahim.mist.inventory.gui.GuiMistButton;
import ru.liahim.mist.network.PacketFurnaceClose;
import ru.liahim.mist.network.PacketHandler;
import ru.liahim.mist.tileentity.TileEntityMistFurnace;

@SideOnly(value=Side.CLIENT)
public class GuiMistFurnace
extends GuiContainer {
    private static final ResourceLocation FURNACE_GUI_TEXTURES = new ResourceLocation("mist", "textures/gui/container/furnace.png");
    private final InventoryPlayer playerInventory;
    private final TileEntityMistFurnace tileFurnace;
    private boolean close = false;
    private static final int[] xTempCoord = new int[]{56, 58, 62, 67, 74, 81, 96, 102, 106, 110, 111};
    private static final int[] yTempCoord = new int[]{38, 31, 25, 21, 18, 16, 18, 21, 25, 31, 38};
    private static final int[] xTexCoord = new int[]{1, 1, 1, 1, 1, 4, 15, 14, 13, 13, 12};
    private static final int[] yTexCoord = new int[]{203, 196, 188, 181, 174, 167, 174, 181, 188, 196, 203};
    private static final int[] xTempSize = new int[]{9, 8, 8, 7, 6, 14, 6, 7, 8, 8, 9};
    private static final int[] yTempSize = new int[]{5, 6, 7, 6, 6, 6, 6, 6, 7, 6, 5};

    public GuiMistFurnace(InventoryPlayer playerInv, TileEntityMistFurnace furnaceInv) {
        super((Container)new ContainerMistFurnace(playerInv, (IInventory)furnaceInv));
        this.playerInventory = playerInv;
        this.tileFurnace = furnaceInv;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiMistButton(0, this.field_147003_i + 70, this.field_147009_r + 64, 8, 7, 176, 15, "", FURNACE_GUI_TEXTURES));
        this.field_146292_n.add(new GuiMistButton(1, this.field_147003_i + 70, this.field_147009_r + 64, 36, 7, 176, 36, "", FURNACE_GUI_TEXTURES));
        this.close = TileEntityMistFurnace.isClose((IInventory)this.tileFurnace);
        this.updateButtons();
    }

    private void updateButtons() {
        ((GuiButton)this.field_146292_n.get((int)0)).field_146125_m = !this.close;
        ((GuiButton)this.field_146292_n.get((int)1)).field_146125_m = this.close;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String s = this.tileFurnace.func_145748_c_().func_150260_c();
        this.field_146289_q.func_78276_b(s, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(s) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(this.playerInventory.func_145748_c_().func_150260_c(), 8, this.field_147000_g - 96 + 2, 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int k;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(FURNACE_GUI_TEXTURES);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.func_73729_b(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.close != TileEntityMistFurnace.isClose((IInventory)this.tileFurnace)) {
            this.close = !this.close;
            this.updateButtons();
        }
        if (this.close) {
            this.func_73729_b(i + 70, j + 64, 176, 36, 36, 7);
        }
        if (TileEntityMistFurnace.isBurning((IInventory)this.tileFurnace, 0)) {
            k = this.getBurnScaled(13, 0);
            this.func_73729_b(i + 72, j + 29 + 12 - k, 176, 12 - k, 14, k + 1);
        }
        if (TileEntityMistFurnace.isBurning((IInventory)this.tileFurnace, 1)) {
            k = this.getBurnScaled(13, 1);
            this.func_73729_b(i + 89, j + 29 + 12 - k, 176, 12 - k, 14, k + 1);
        }
        int l = this.getCookProgressScaled(22, 0);
        this.func_73729_b(i + 67 - l, j + 47, 212 - l, 1, l, 12);
        l = this.getCookProgressScaled(22, 1);
        this.func_73729_b(i + 109, j + 47, 212, 1, l, 12);
        for (int k2 = 0; k2 < 11; ++k2) {
            int t = TileEntityMistFurnace.getTemp((IInventory)this.tileFurnace, k2) / 300;
            if (t <= 0) continue;
            if (t > 7) {
                t = 7;
            }
            this.func_73729_b(i + xTempCoord[k2], j + yTempCoord[k2], xTexCoord[k2] + t * 22, yTexCoord[k2], xTempSize[k2], yTempSize[k2]);
        }
    }

    private int getCookProgressScaled(int pixels, int index) {
        int cook = this.tileFurnace.func_174887_a_(index + 4);
        int total = this.tileFurnace.func_174887_a_(index + 6);
        int ash = this.tileFurnace.func_174887_a_(index + 8);
        return total != 0 && cook != 0 ? cook * pixels / total : (ash != 0 ? ash * pixels / 1200 : 0);
    }

    private int getBurnScaled(int pixels, int index) {
        int i = this.tileFurnace.func_174887_a_(index + 2);
        if (i == 0) {
            i = 200;
        }
        return this.tileFurnace.func_174887_a_(index) * pixels / i;
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        int i = TileEntityMistFurnace.getStatus((IInventory)this.tileFurnace);
        switch (button.field_146127_k) {
            case 0: {
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketFurnaceClose(this.tileFurnace.func_174877_v(), i));
                break;
            }
            case 1: {
                int signal = this.tileFurnace.func_145831_w().func_175687_A(this.tileFurnace.func_174877_v());
                if (signal != 0 && signal <= this.tileFurnace.getClientComparatorOutput((IInventory)this.tileFurnace)) break;
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketFurnaceClose(this.tileFurnace.func_174877_v(), i));
                break;
            }
        }
    }
}

