/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.inventory.gui;

import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import ru.liahim.mist.inventory.gui.GuiMistButton;
import ru.liahim.mist.network.PacketFirePitFillPot;
import ru.liahim.mist.network.PacketHandler;
import ru.liahim.mist.tileentity.TileEntityCampfire;

public class GuiCampfirePot
extends GuiScreen {
    private final EntityPlayer player;
    private final TileEntityCampfire te;
    private static final ResourceLocation BACKGROUND = new ResourceLocation("mist:textures/gui/container/pot.png");
    protected int xSize = 88;
    protected int ySize = 70;
    protected int guiLeft;
    protected int guiTop;
    private final int minVolume;
    private int volume;
    private FluidStack fluid;
    private final TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(FluidRegistry.WATER.getStill().toString());
    private int uni;

    public GuiCampfirePot(EntityPlayer player, TileEntityCampfire te) {
        this.player = player;
        this.te = te;
        this.minVolume = this.te.getVolum();
        this.volume = this.minVolume == 0 ? 4 : this.minVolume;
        IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)this.player.func_184614_ca());
        if (fluidHandler != null) {
            this.fluid = fluidHandler.drain(1000, false);
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiMistButton(1, this.guiLeft + 31, this.guiTop + 17, 26, 11, 48, 70, "", BACKGROUND));
        this.field_146292_n.add(new GuiMistButton(2, this.guiLeft + 31, this.guiTop + 52, 26, 11, 74, 70, "", BACKGROUND));
        this.field_146292_n.add(new GuiMistButton(3, this.guiLeft + 56, this.guiTop + 28, 24, 24, 24, 70, "", BACKGROUND));
        this.field_146292_n.add(new GuiMistButton(4, this.guiLeft + 8, this.guiTop + 28, 24, 24, 0, 70, "", BACKGROUND));
        if (this.minVolume == 0) {
            if (this.volume == 0) {
                ((GuiButton)this.field_146292_n.get((int)1)).field_146125_m = false;
            } else if (this.volume == 4) {
                ((GuiButton)this.field_146292_n.get((int)0)).field_146125_m = false;
            }
        } else {
            ((GuiButton)this.field_146292_n.get((int)1)).field_146125_m = false;
            if (this.minVolume == 4) {
                ((GuiButton)this.field_146292_n.get((int)0)).field_146125_m = false;
            }
        }
        this.uni = this.field_146289_q.func_82883_a() ? 0 : 1;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.drawSoup();
        this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND);
        this.func_73729_b(this.guiLeft + 32, this.guiTop + 28, 88, 0, 4, 24);
        String name = I18n.func_135052_a((String)"gui.mist.pot", (Object[])new Object[0]);
        this.field_146289_q.func_78276_b(name, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(name) / 2, this.guiTop + 5 + this.uni, 0x404040);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    public void func_146276_q_() {
        super.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        int i = Math.min(4 - this.minVolume, this.fluid.amount / 250);
        switch (button.field_146127_k) {
            case 1: {
                if (this.volume < this.minVolume + i) {
                    ++this.volume;
                }
                ((GuiButton)this.field_146292_n.get((int)1)).field_146125_m = true;
                ((GuiButton)this.field_146292_n.get((int)1)).field_146124_l = true;
                button.field_146124_l = false;
                if (this.volume != this.minVolume + i) break;
                button.field_146125_m = false;
                break;
            }
            case 2: {
                if (this.volume > 0 && this.volume > this.minVolume) {
                    --this.volume;
                }
                ((GuiButton)this.field_146292_n.get((int)0)).field_146125_m = true;
                ((GuiButton)this.field_146292_n.get((int)0)).field_146124_l = true;
                button.field_146124_l = false;
                if (this.volume != this.minVolume) break;
                button.field_146125_m = false;
                break;
            }
            case 3: {
                this.field_146297_k.func_147108_a((GuiScreen)null);
                this.field_146297_k.func_71381_h();
                if (this.volume == this.minVolume) break;
                boolean milk = this.fluid.getFluid().getName().equals("milk");
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketFirePitFillPot(this.te.func_174877_v(), this.volume, milk ? this.volume - this.minVolume : 0));
                break;
            }
            case 4: {
                this.field_146297_k.func_147108_a((GuiScreen)null);
                this.field_146297_k.func_71381_h();
                if (this.minVolume <= 0) break;
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketFirePitFillPot(this.te.func_174877_v(), 0, 0));
            }
        }
    }

    private void drawSoup() {
        this.field_146297_k.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        Gui.func_152125_a((int)(this.guiLeft + 32), (int)(this.guiTop + 52 - this.volume * 6), (float)this.sprite.func_130010_a(), (float)(this.sprite.func_110967_i() + 8 - this.volume * 2), (int)8, (int)(this.volume * 2), (int)24, (int)(this.volume * 6), (float)((float)this.sprite.func_130010_a() / this.sprite.func_94209_e()), (float)((float)this.sprite.func_110967_i() / this.sprite.func_94206_g()));
    }

    public boolean func_73868_f() {
        return false;
    }
}

