/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.init;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.api.item.MistItems;
import ru.liahim.mist.block.MistTreeSapling;
import ru.liahim.mist.init.recipe.RecipesAcidBuket;
import ru.liahim.mist.init.recipe.RecipesAcidCleaning;
import ru.liahim.mist.init.recipe.RecipesFilterCoal;
import ru.liahim.mist.init.recipe.RecipesFilterCoalBlock;
import ru.liahim.mist.init.recipe.RecipesFilterCoalMix;
import ru.liahim.mist.init.recipe.RecipesInnerSuit;
import ru.liahim.mist.init.recipe.RecipesMaskDyes;
import ru.liahim.mist.init.recipe.RecipesMistDirt;
import ru.liahim.mist.init.recipe.RecipesMistMapCloning;
import ru.liahim.mist.init.recipe.RecipesMistMapExtending;
import ru.liahim.mist.init.recipe.RecipesSaltyFood;
import ru.liahim.mist.init.recipe.RecipesUrnDyes;
import ru.liahim.mist.init.recipe.RecipesWood;
import ru.liahim.mist.item.ItemMistFoodOnStick;
import ru.liahim.mist.item.food.ItemMistMeat;
import ru.liahim.mist.item.food.ItemMistMushroom;

public class ModRecipes {
    public static ItemStack ACID_BUCKET = ItemStack.field_190927_a;

    public static void registerRecipes() {
        int i;
        ModRecipes.registerRecipe("acid_cleaning", new RecipesAcidCleaning());
        ModRecipes.registerRecipe("acid_bucket", new RecipesAcidBuket());
        ModRecipes.registerRecipe("filter_coal", new RecipesFilterCoal());
        ModRecipes.registerRecipe("filter_coal_block", new RecipesFilterCoalBlock());
        ModRecipes.registerRecipe("filter_coal_mix", new RecipesFilterCoalMix());
        ModRecipes.registerRecipe("mist_map_cloning", new RecipesMistMapCloning());
        ModRecipes.registerRecipe("mist_map_up_extending", (IRecipe)new RecipesMistMapExtending(MistItems.MAP_UP));
        ModRecipes.registerRecipe("mist_map_down_extending", (IRecipe)new RecipesMistMapExtending(MistItems.MAP_DOWN));
        ModRecipes.registerRecipe("mask_dye", new RecipesMaskDyes());
        ModRecipes.registerRecipe("urn_dye", new RecipesUrnDyes());
        ModRecipes.registerRecipe("mist_dirt", new RecipesMistDirt());
        ModRecipes.registerRecipe("inner_suit", new RecipesInnerSuit());
        ModRecipes.registerRecipe("salty_food", new RecipesSaltyFood());
        new RecipesWood().addRecipes();
        for (int i2 : ItemMistFoodOnStick.mushroomIndex) {
            ItemStack food = new ItemStack((Item)MistItems.MUSHROOMS_FOOD, 1, i2);
            ItemStack stick = new ItemStack(MistItems.FOOD_ON_STICK);
            stick.func_77982_d(new NBTTagCompound());
            stick.func_77978_p().func_74782_a("FoodOnStick", (NBTBase)food.func_77955_b(new NBTTagCompound()));
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("mist", "food_on_stick_" + ItemMistMushroom.MUSHROOMS[i2 / 16].getTypeName(i2 % 16)), (ResourceLocation)new ResourceLocation("mist", "food_on_stick"), (ItemStack)stick, (Object[])new Object[]{"R ", " M", Character.valueOf('R'), new ItemStack((Item)Items.field_151112_aM), Character.valueOf('M'), food});
        }
        GameRegistry.addSmelting((ItemStack)new ItemStack(MistItems.CLAY_BALL, 1, 0), (ItemStack)new ItemStack(Items.field_151118_aC), (float)0.3f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(MistItems.CLAY_BALL, 1, 1), (ItemStack)new ItemStack(Items.field_151118_aC), (float)0.3f);
        GameRegistry.addSmelting((ItemStack)new ItemStack((Block)MistBlocks.CLAY, 1, 0), (ItemStack)new ItemStack((Block)MistBlocks.CLAY, 1, 1), (float)0.0f);
        GameRegistry.addSmelting((ItemStack)new ItemStack((Block)MistBlocks.CLAY, 1, 8), (ItemStack)new ItemStack((Block)MistBlocks.CLAY, 1, 9), (float)0.0f);
        GameRegistry.addSmelting((ItemStack)new ItemStack((Block)MistBlocks.CLAY, 1, 1), (ItemStack)new ItemStack(Blocks.field_150405_ch), (float)0.35f);
        GameRegistry.addSmelting((ItemStack)new ItemStack((Block)MistBlocks.CLAY, 1, 9), (ItemStack)new ItemStack(Blocks.field_150405_ch), (float)0.35f);
        GameRegistry.addSmelting((Block)MistBlocks.FILTER_COAL_ORE, (ItemStack)new ItemStack(MistItems.FILTER_COAL), (float)1.0f);
        GameRegistry.addSmelting((Block)MistBlocks.BIO_SHALE_ORE, (ItemStack)new ItemStack(MistItems.BIO_SHALE), (float)0.1f);
        GameRegistry.addSmelting((Block)MistBlocks.SULFUR_ORE, (ItemStack)new ItemStack(MistItems.SULFUR), (float)0.1f);
        GameRegistry.addSmelting((Block)MistBlocks.SALTPETER_ORE, (ItemStack)new ItemStack(MistItems.SALTPETER), (float)0.1f);
        GameRegistry.addSmelting((Block)MistBlocks.IRON_ORE, (ItemStack)new ItemStack(Items.field_151042_j), (float)0.7f);
        GameRegistry.addSmelting((Block)MistBlocks.LAPIS_ORE, (ItemStack)new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.BLUE.func_176767_b()), (float)0.2f);
        GameRegistry.addSmelting((Block)MistBlocks.GOLD_ORE, (ItemStack)new ItemStack(Items.field_151043_k), (float)1.0f);
        GameRegistry.addSmelting((Block)MistBlocks.NIOBIUM_ORE, (ItemStack)new ItemStack(MistItems.NIOBIUM_INGOT), (float)0.7f);
        GameRegistry.addSmelting((Block)MistBlocks.COBBLESTONE, (ItemStack)new ItemStack(MistBlocks.STONE_POROUS), (float)0.1f);
        GameRegistry.addSmelting((Block)MistBlocks.SAND, (ItemStack)new ItemStack(Blocks.field_150359_w), (float)0.1f);
        GameRegistry.addSmelting((Block)MistBlocks.ACID_SAND, (ItemStack)new ItemStack(Blocks.field_150359_w), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack((Block)MistBlocks.PEAT, 1, 0), (ItemStack)new ItemStack((Block)MistBlocks.PEAT, 1, 1), (float)0.0f);
        GameRegistry.addSmelting((ItemStack)new ItemStack((Block)MistBlocks.SAPROPEL, 1, 0), (ItemStack)new ItemStack((Block)MistBlocks.SAPROPEL, 1, 1), (float)0.0f);
        for (i = 0; i < ItemMistMeat.MeatType.values().length; ++i) {
            GameRegistry.addSmelting((ItemStack)new ItemStack((Item)MistItems.MEAT_FOOD, 1, i), (ItemStack)new ItemStack((Item)MistItems.MEAT_COOK, 1, i), (float)0.0f);
        }
        for (i = 0; i < ItemMistMushroom.MUSHROOMS.length; ++i) {
            for (int j = 0; j < ItemMistMushroom.MUSHROOMS[i].getTypeProperty().func_177700_c().size(); ++j) {
                GameRegistry.addSmelting((ItemStack)new ItemStack((Item)MistItems.MUSHROOMS_FOOD, 1, j + i * 16), (ItemStack)new ItemStack((Item)MistItems.MUSHROOMS_COOK, 1, j + i * 16), (float)0.0f);
            }
        }
        GameRegistry.addSmelting((Item)MistItems.NIOBIUM_PICKAXE, (ItemStack)new ItemStack(MistItems.NIOBIUM_NUGGET), (float)0.1f);
        GameRegistry.addSmelting((Item)MistItems.NIOBIUM_SHOVEL, (ItemStack)new ItemStack(MistItems.NIOBIUM_NUGGET), (float)0.1f);
        GameRegistry.addSmelting((Item)MistItems.NIOBIUM_AXE, (ItemStack)new ItemStack(MistItems.NIOBIUM_NUGGET), (float)0.1f);
        GameRegistry.addSmelting((Item)MistItems.NIOBIUM_HOE, (ItemStack)new ItemStack(MistItems.NIOBIUM_NUGGET), (float)0.1f);
        GameRegistry.addSmelting((Item)MistItems.NIOBIUM_SWORD, (ItemStack)new ItemStack(MistItems.NIOBIUM_NUGGET), (float)0.1f);
        GameRegistry.addSmelting((Item)MistItems.NIOBIUM_HELMET, (ItemStack)new ItemStack(MistItems.NIOBIUM_NUGGET), (float)0.1f);
        GameRegistry.addSmelting((Item)MistItems.NIOBIUM_CHESTPLATE, (ItemStack)new ItemStack(MistItems.NIOBIUM_NUGGET), (float)0.1f);
        GameRegistry.addSmelting((Item)MistItems.NIOBIUM_LEGGINGS, (ItemStack)new ItemStack(MistItems.NIOBIUM_NUGGET), (float)0.1f);
        GameRegistry.addSmelting((Item)MistItems.NIOBIUM_BOOTS, (ItemStack)new ItemStack(MistItems.NIOBIUM_NUGGET), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(MistBlocks.URN, 1, 1), (ItemStack)new ItemStack(MistBlocks.URN, 1, 0), (float)0.1f);
        OreDictionary.registerOre((String)"oreGold", (Block)MistBlocks.GOLD_ORE);
        OreDictionary.registerOre((String)"oreIron", (Block)MistBlocks.IRON_ORE);
        OreDictionary.registerOre((String)"oreLapis", (Block)MistBlocks.LAPIS_ORE);
        OreDictionary.registerOre((String)"oreSulfur", (Block)MistBlocks.SULFUR_ORE);
        OreDictionary.registerOre((String)"blockSulfur", (Block)MistBlocks.SULFUR_BLOCK);
        OreDictionary.registerOre((String)"dustSulfur", (Item)MistItems.SULFUR);
        OreDictionary.registerOre((String)"oreSaltpeter", (ItemStack)new ItemStack(MistBlocks.SALTPETER_ORE, 1, 0));
        OreDictionary.registerOre((String)"oreSalt", (ItemStack)new ItemStack(MistBlocks.SALTPETER_ORE, 1, 1));
        OreDictionary.registerOre((String)"blockSaltpeter", (Block)MistBlocks.SALTPETER_BLOCK);
        OreDictionary.registerOre((String)"dustSaltpeter", (Item)MistItems.SALTPETER);
        OreDictionary.registerOre((String)"clayball", (Item)Items.field_151119_aD);
        OreDictionary.registerOre((String)"clayball", (ItemStack)new ItemStack(MistItems.CLAY_BALL, 1, 0));
        OreDictionary.registerOre((String)"clayball", (ItemStack)new ItemStack(MistItems.CLAY_BALL, 1, 1));
        OreDictionary.registerOre((String)"mulch", (Item)MistItems.MULCH);
        OreDictionary.registerOre((String)"tallow", (Item)MistItems.TALLOW);
        OreDictionary.registerOre((String)"latex", (Item)MistItems.LATEX);
        OreDictionary.registerOre((String)"rubber", (Item)MistItems.RUBBER);
        OreDictionary.registerOre((String)"feather", (Item)MistItems.WING);
        OreDictionary.registerOre((String)"oreNiobium", (Block)MistBlocks.NIOBIUM_ORE);
        OreDictionary.registerOre((String)"blockNiobium", (Block)MistBlocks.NIOBIUM_BLOCK);
        OreDictionary.registerOre((String)"ingotNiobium", (Item)MistItems.NIOBIUM_INGOT);
        OreDictionary.registerOre((String)"nuggetNiobium", (Item)MistItems.NIOBIUM_NUGGET);
        OreDictionary.registerOre((String)"sand", (Block)MistBlocks.SAND);
        OreDictionary.registerOre((String)"sand", (Block)MistBlocks.ACID_SAND);
        OreDictionary.registerOre((String)"gravel", (Block)MistBlocks.GRAVEL);
        OreDictionary.registerOre((String)"stone", (Block)MistBlocks.STONE_POROUS);
        OreDictionary.registerOre((String)"peat", (Block)MistBlocks.PEAT);
        OreDictionary.registerOre((String)"sapropel", (Block)MistBlocks.SAPROPEL);
        OreDictionary.registerOre((String)"dyeYellow", (ItemStack)new ItemStack(MistItems.DESERT_COTTON_SEED, 1, 0));
        OreDictionary.registerOre((String)"treeSapling", (ItemStack)new ItemStack(MistBlocks.TREE_SAPLING, 1, Short.MAX_VALUE));
        for (MistTreeSapling.EnumType type : MistTreeSapling.TYPE.func_177700_c()) {
            OreDictionary.registerOre((String)"treeLeaves", (ItemStack)new ItemStack((Block)type.getTree().getLeaves(), 1, Short.MAX_VALUE));
        }
    }

    public static void postRegisterRecipes() {
        ACID_BUCKET = FluidUtil.getFilledBucket((FluidStack)new FluidStack(MistBlocks.ACID, 0));
    }

    private static void registerRecipe(String name, IRecipe recipe) {
        ForgeRegistries.RECIPES.register((IForgeRegistryEntry)recipe.setRegistryName(new ResourceLocation("mist", name)));
    }
}

