/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.init;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.vecmath.Vector2f;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import ru.liahim.mist.api.item.MistItems;
import ru.liahim.mist.api.registry.MistRegistry;
import ru.liahim.mist.capability.handler.ISkillCapaHandler;
import ru.liahim.mist.common.Mist;
import ru.liahim.mist.common.MistTime;
import ru.liahim.mist.tileentity.TileEntityCampfire;
import ru.liahim.mist.world.generators.TombGen;

@Config(modid="mist", name="mist", category="")
public class ModConfig {
    @Config.Ignore
    private static final Map<ItemStack, Vector2f> stoneColors = new HashMap<ItemStack, Vector2f>();
    @Config.LangKey(value="config.mist.dimension")
    public static Dimension dimension = new Dimension();
    @Config.LangKey(value="config.mist.player")
    public static Player player = new Player();
    @Config.LangKey(value="config.mist.graphic")
    public static Graphic graphic = new Graphic();
    @Config.LangKey(value="config.mist.campfire")
    public static Campfire campfire = new Campfire();
    @Config.LangKey(value="config.mist.time")
    public static Time time = new Time();
    @Config.LangKey(value="config.mist.generation")
    public static Generation generation = new Generation();

    public static void init() {
    }

    public static void onConfigChange() {
        ConfigManager.sync((String)"mist", (Config.Type)Config.Type.INSTANCE);
        for (int i : ModConfig.dimension.dimBlackList) {
            Dimension.loadedDimBlackList.add(i);
        }
        MistTime.setMonthLength(ModConfig.time.dayInMonth);
        for (ISkillCapaHandler.Skill skill : ISkillCapaHandler.Skill.values()) {
            skill.updateSizes();
        }
        ModConfig.applyFirePitColors(false);
        ModConfig.applyStoneBreakers();
        ModConfig.applyFilterCoalBreakers();
        ModConfig.applyMobsForSkill();
        ModConfig.applyMobsBlackList();
        TombGen.updateChance();
        Mist.proxy.onConfigChange();
    }

    public static long getCustomSeed(long seed) {
        return seed;
    }

    public static void applyFirePitColors(boolean repeat) {
        if (!repeat) {
            stoneColors.clear();
            Pattern splitpattern = Pattern.compile(":");
            block6: for (int i = 0; i < ModConfig.campfire.stoneAndColors.length; ++i) {
                int color;
                int meta;
                int count;
                Item item;
                String[] pettern;
                block16: {
                    block15: {
                        String s = ModConfig.campfire.stoneAndColors[i];
                        pettern = splitpattern.split(s);
                        if (pettern.length != 5) {
                            Mist.logger.warn("Invalid set of parameters at stoneAndColors line " + (i + 1));
                            continue;
                        }
                        ResourceLocation res = new ResourceLocation(pettern[0], pettern[1]);
                        if (ForgeRegistries.ITEMS.containsKey(res)) {
                            item = (Item)ForgeRegistries.ITEMS.getValue(res);
                        } else if (ForgeRegistries.BLOCKS.containsKey(res)) {
                            item = Item.func_150898_a((Block)((Block)ForgeRegistries.BLOCKS.getValue(res)));
                        } else {
                            Mist.logger.warn("Cannot found item/block \"" + pettern[0] + ":" + pettern[1] + "\" from stoneAndColors line " + (i + 1));
                            continue;
                        }
                        try {
                            count = Integer.parseInt(pettern[2]);
                            if (count >= 1 && count <= 4) break block15;
                            MathHelper.func_76125_a((int)count, (int)1, (int)4);
                            Mist.logger.warn("Count \"" + pettern[2] + "\" out of valid range point at stoneAndColors line " + (i + 1) + ". Count will be changed to " + count);
                        }
                        catch (NumberFormatException e) {
                            Mist.logger.warn("Cannot parse Count \"" + pettern[2] + "\" to integer point at stoneAndColors line " + (i + 1));
                            continue;
                        }
                    }
                    try {
                        meta = Integer.parseInt(pettern[3]);
                        if (meta >= 0 && (meta <= 0 || item.func_77612_l() == 0) && (meta <= 15 || !(item instanceof ItemBlock))) break block16;
                        meta = 0;
                        Mist.logger.warn("Metadata \"" + pettern[3] + "\" out of valid range point at stoneAndColors line " + (i + 1) + ". Metadata will be changed to " + meta);
                    }
                    catch (NumberFormatException e) {
                        Mist.logger.warn("Cannot parse Metadata \"" + pettern[3] + "\" to integer point at stoneAndColors line " + (i + 1));
                        continue;
                    }
                }
                try {
                    color = Integer.parseInt(pettern[4], 16);
                }
                catch (NumberFormatException e) {
                    Mist.logger.warn("Cannot parse Color \"" + pettern[4] + "\" to integer point at stoneAndColors line " + (i + 1));
                    continue;
                }
                boolean check = false;
                for (ItemStack stones : stoneColors.keySet()) {
                    if (stones.func_77973_b() != item || stones.func_77952_i() != meta) continue;
                    check = true;
                    Mist.logger.warn("Item \"" + pettern[0] + ":" + pettern[1] + "\" with Metadata \"" + pettern[3] + "\" is already exist");
                    continue block6;
                }
                if (check) continue;
                stoneColors.put(new ItemStack(item, 1, meta), new Vector2f((float)count, (float)color));
            }
            if (stoneColors.isEmpty()) {
                stoneColors.put(new ItemStack(MistItems.ROCKS), new Vector2f(4.0f, 1.0204847E7f));
            }
        }
        TileEntityCampfire.putStoneAndColorList(stoneColors);
    }

    public static void applyStoneBreakers() {
        MistRegistry.mistStoneBreakers.clear();
        Pattern splitpattern = Pattern.compile(":");
        block6: for (int i = 0; i < ModConfig.dimension.stoneBreakers.length; ++i) {
            int basic;
            int upper;
            int porous;
            Item item;
            String[] pettern;
            block13: {
                block12: {
                    block11: {
                        String s = ModConfig.dimension.stoneBreakers[i];
                        pettern = splitpattern.split(s);
                        if (pettern.length != 5) {
                            Mist.logger.warn("Invalid set of parameters at stoneBreakers line " + (i + 1));
                            continue;
                        }
                        ResourceLocation res = new ResourceLocation(pettern[0], pettern[1]);
                        if (!ForgeRegistries.ITEMS.containsKey(res)) {
                            Mist.logger.warn("Cannot found item \"" + pettern[0] + ":" + pettern[1] + "\" from stoneBreakers line " + (i + 1));
                            continue;
                        }
                        item = (Item)ForgeRegistries.ITEMS.getValue(res);
                        try {
                            porous = Integer.parseInt(pettern[2]);
                            if (porous >= 0) break block11;
                            porous = 1;
                            Mist.logger.warn("Porous stone multiplier \"" + pettern[2] + "\" less than zero point at stoneBreakers line " + (i + 1) + ". Multiplier will be changed to " + porous);
                        }
                        catch (NumberFormatException e) {
                            Mist.logger.warn("Cannot parse porous stone multiplier \"" + pettern[2] + "\" to integer point at stoneBreakers line " + (i + 1));
                            continue;
                        }
                    }
                    try {
                        upper = Integer.parseInt(pettern[3]);
                        if (upper >= 0) break block12;
                        upper = 1;
                        Mist.logger.warn("Upper stone multiplier \"" + pettern[3] + "\" less than zero point at stoneBreakers line " + (i + 1) + ". Multiplier will be changed to " + upper);
                    }
                    catch (NumberFormatException e) {
                        Mist.logger.warn("Cannot parse upper stone multiplier \"" + pettern[3] + "\" to integer point at stoneBreakers line " + (i + 1));
                        continue;
                    }
                }
                try {
                    basic = Integer.parseInt(pettern[4]);
                    if (basic >= 0) break block13;
                    basic = 1;
                    Mist.logger.warn("Basic stone multiplier \"" + pettern[4] + "\" less than zero point at stoneBreakers line " + (i + 1) + ". Multiplier will be changed to " + basic);
                }
                catch (NumberFormatException e) {
                    Mist.logger.warn("Cannot parse basic stone multiplier \"" + pettern[4] + "\" to integer point at stoneBreakers line " + (i + 1));
                    continue;
                }
            }
            boolean check = false;
            for (Item tool : MistRegistry.mistStoneBreakers.keySet()) {
                if (tool != item) continue;
                check = true;
                Mist.logger.warn("Item \"" + pettern[0] + ":" + pettern[1] + "\" is already exist (stoneBreakers, line " + (i + 1) + ")");
                continue block6;
            }
            if (check) continue;
            MistRegistry.mistStoneBreakers.put(item, new int[]{porous, upper, basic});
        }
        if (MistRegistry.mistStoneBreakers.isEmpty()) {
            MistRegistry.mistStoneBreakers.put(MistItems.NIOBIUM_PICKAXE, new int[]{1, 8, 8});
        }
    }

    public static void applyFilterCoalBreakers() {
        MistRegistry.filterCoalBreakers.clear();
        Pattern splitpattern = Pattern.compile(":");
        for (int i = 0; i < ModConfig.dimension.filterCoalBreakers.length; ++i) {
            String s = ModConfig.dimension.filterCoalBreakers[i];
            String[] pettern = splitpattern.split(s);
            if (pettern.length != 2) {
                Mist.logger.warn("Invalid set of parameters at filterCoalBreakers line " + (i + 1));
                continue;
            }
            ResourceLocation res = new ResourceLocation(pettern[0], pettern[1]);
            if (!ForgeRegistries.ITEMS.containsKey(res)) {
                Mist.logger.warn("Cannot found item \"" + pettern[0] + ":" + pettern[1] + "\" from filterCoalBreakers line " + (i + 1));
                continue;
            }
            Item item = (Item)ForgeRegistries.ITEMS.getValue(res);
            boolean check = false;
            if (MistRegistry.filterCoalBreakers.contains(item)) {
                Mist.logger.warn("Item \"" + pettern[0] + ":" + pettern[1] + "\" is already exist (filterCoalBreakers, line " + (i + 1) + ")");
                continue;
            }
            MistRegistry.filterCoalBreakers.add(item);
        }
        if (MistRegistry.filterCoalBreakers.isEmpty()) {
            MistRegistry.filterCoalBreakers.add(MistItems.NIOBIUM_PICKAXE);
        }
    }

    public static void applyMobsForSkill() {
        MistRegistry.dimsForSkill.clear();
        MistRegistry.mobsForSkill.clear();
        Pattern splitpattern = Pattern.compile(":");
        for (int i = 0; i < ModConfig.player.mobsForSkill.length; ++i) {
            int point;
            String[] pettern;
            block9: {
                pettern = splitpattern.split(ModConfig.player.mobsForSkill[i]);
                if (pettern.length != 3) {
                    Mist.logger.warn("Invalid set of parameters at mobsForSkill line " + (i + 1));
                    continue;
                }
                if (!Loader.isModLoaded((String)pettern[0])) {
                    Mist.logger.warn("Cannot found the modId \"" + pettern[0] + "\" from mobsForSkill line " + (i + 1));
                    continue;
                }
                if (pettern[0].equals("mist")) {
                    Mist.logger.warn("Misty mobs are already participating in skill calculation (mobsForSkill, line " + (i + 1) + ")");
                    continue;
                }
                point = 0;
                try {
                    point = Integer.parseInt(pettern[2]);
                    if (point >= 0) break block9;
                    point = 1;
                    Mist.logger.warn("Mob skill points \"" + pettern[2] + "\" less than zero point at mobsForSkill line " + (i + 1) + ". Points will be changed to " + point);
                }
                catch (NumberFormatException e) {
                    Mist.logger.warn("Cannot parse the mob skill points \"" + pettern[2] + "\" to integer point at mobsForSkill line " + (i + 1));
                    continue;
                }
            }
            if (!pettern[1].equals("*")) {
                ResourceLocation res = new ResourceLocation(pettern[0], pettern[1]);
                if (!ForgeRegistries.ENTITIES.containsKey(res)) {
                    Mist.logger.warn("Cannot found the mob \"" + pettern[0] + ":" + pettern[1] + "\" from mobsForSkill line " + (i + 1));
                    continue;
                }
                if (MistRegistry.mobsForSkill.containsKey(res)) {
                    Mist.logger.warn("Mob \"" + pettern[0] + ":" + pettern[1] + "\" is already exist (mobsForSkill, line " + (i + 1) + ")");
                    continue;
                }
                MistRegistry.mobsForSkill.put(res, point);
                continue;
            }
            MistRegistry.dimsForSkill.put(pettern[0], point);
        }
    }

    public static void applyMobsBlackList() {
        MistRegistry.mobsDimsBlackList.clear();
        MistRegistry.mobsBlackList.clear();
        Pattern splitpattern = Pattern.compile(":");
        for (int i = 0; i < ModConfig.dimension.mobsBlackList.length; ++i) {
            String[] pettern = splitpattern.split(ModConfig.dimension.mobsBlackList[i]);
            if (pettern.length != 2) {
                Mist.logger.warn("Invalid set of parameters at mobsBlackList line " + (i + 1));
                continue;
            }
            if (!Loader.isModLoaded((String)pettern[0])) {
                Mist.logger.warn("Cannot found the modId \"" + pettern[0] + "\" from mobsBlackList line " + (i + 1));
                continue;
            }
            if (pettern[0].equals("mist")) {
                Mist.logger.warn("Misty mobs cannot add to the blacklist (mobsBlackList, line " + (i + 1) + ")");
                continue;
            }
            if (!pettern[1].equals("*")) {
                ResourceLocation res = new ResourceLocation(pettern[0], pettern[1]);
                if (!ForgeRegistries.ENTITIES.containsKey(res)) {
                    Mist.logger.warn("Cannot found the mob \"" + pettern[0] + ":" + pettern[1] + "\" from mobsBlackList line " + (i + 1));
                    continue;
                }
                if (MistRegistry.mobsBlackList.contains(res)) {
                    Mist.logger.warn("Mob \"" + pettern[0] + ":" + pettern[1] + "\" is already exist (mobsBlackList, line " + (i + 1) + ")");
                    continue;
                }
                MistRegistry.mobsBlackList.add(res);
                continue;
            }
            MistRegistry.mobsDimsBlackList.add(pettern[0]);
        }
    }

    public static class Generation {
        @Config.LangKey(value="config.mist.generation.basement")
        @Config.Comment(value={"Old basement generation chance (0 - never, 1 - each chunk)"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double basementGenerationChance = 0.2;
        @Config.LangKey(value="config.mist.generation.well")
        @Config.Comment(value={"Wells generation chance (0 - never, 1 - each chunk)"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double wellsGenerationChance = 0.002;
        @Config.LangKey(value="config.mist.generation.tomb_forest")
        @Config.Comment(value={"Mixed Forest Tomb generation chance (0 - never, 1 - each chunk)"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double forestTombGenerationChance = 0.02;
        @Config.LangKey(value="config.mist.generation.tomb_swamp")
        @Config.Comment(value={"Swampy Tomb generation chance (0 - never, 1 - each chunk)"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double swampTombGenerationChance = 0.007;
        @Config.LangKey(value="config.mist.generation.tomb_desert")
        @Config.Comment(value={"Desert and Savanna Tomb generation chance (0 - never, 1 - each chunk)"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double desertTombGenerationChance = 0.005;
        @Config.LangKey(value="config.mist.generation.tomb_snow")
        @Config.Comment(value={"Taiga Tomb generation chance (0 - never, 1 - each chunk)"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double snowTombGenerationChance = 0.015;
        @Config.LangKey(value="config.mist.generation.tomb_jungle")
        @Config.Comment(value={"Jungle Tomb generation chance (0 - never, 1 - each chunk)"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double jungleTombGenerationChance = 0.008;
        @Config.LangKey(value="config.mist.generation.tomb_cliff")
        @Config.Comment(value={"Cliff Tomb generation chance (0 - never, 1 - each chunk)"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double cliffTombGenerationChance = 0.15;
        @Config.LangKey(value="config.mist.generation.altar")
        @Config.Comment(value={"Altar generation chance (0 - never, 1 - each chunk)"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double altarGenerationChance = 0.005;
        @Config.LangKey(value="config.mist.generation.rare_urn")
        @Config.Comment(value={"Rare Urn generation chance (0 - never, 1 - each urn)"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double rareUrnGenerationChance = 0.1;
        @Config.LangKey(value="config.mist.generation.desert_fish")
        @Config.Comment(value={"Desert Fish generation chance (0 - never, 1 - each block)"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double desertFishGenRarity = 0.015;
    }

    public static class Time {
        @Config.LangKey(value="config.mist.time.day")
        @Config.Comment(value={"The number of days in a month"})
        @Config.RangeInt(min=2, max=16)
        public int dayInMonth = 4;
        @Config.LangKey(value="config.mist.time.cotton")
        @Config.Comment(value={"How many times a year will bloom desert cotton"})
        @Config.RangeInt(min=1, max=4)
        public int desertCottonBloomCount = 2;
    }

    public static class Campfire {
        @Config.LangKey(value="config.mist.campfire.stones")
        @Config.Comment(value={"The stones are available for the creation of the campfire base (ModID:Item:Required quantity:Metadata:Color)"})
        public String[] stoneAndColors = new String[]{"mist:rocks:4:0:9bb6af", "minecraft:cobblestone:1:0:bcbcbc", "minecraft:brick:4:0:c46c58", "minecraft:netherbrick:4:0:522932", "minecraft:flint:4:0:262626", "minecraft:dye:4:4:3052c1", "minecraft:prismarine_shard:4:0:92f0de"};
        @Config.LangKey(value="config.mist.campfire.effects")
        @Config.Comment(value={"Enable pottage effects display"})
        public boolean showSoupEffects = false;
    }

    public static class Graphic {
        @Config.Ignore
        public static boolean smoothFogTexture;
        @Config.Ignore
        public static boolean mipMapOptimization;
        @Config.LangKey(value="config.mist.graphic.fog")
        @Config.Comment(value={"Advanced fog renderer. Adds falling shadows to the fog"})
        public boolean advancedFogRenderer = true;
        @Config.LangKey(value="config.mist.graphic.fog_quality")
        @Config.Comment(value={"Fog render quality"})
        @Config.RangeInt(min=1, max=5)
        public int fogQuality = 5;

        static {
            mipMapOptimization = smoothFogTexture = Mist.proxy.hasOptifine();
        }
    }

    public static class Player {
        @Config.LangKey(value="config.mist.player.search")
        @Config.Comment(value={"Enable search bar on creative tab"})
        public boolean enableSearchBar = true;
        @Config.LangKey(value="config.mist.player.cut")
        @Config.Comment(value={"To what percent will the values of intoxication and chemical pollution be cut after the player's death"})
        @Config.RangeInt(min=0, max=100)
        public int effectsReduction = 50;
        @Config.LangKey(value="config.mist.player.bars")
        @Config.Comment(value={"Show effects progress bar on the main screen"})
        public boolean showEffectsBar = true;
        @Config.LangKey(value="config.mist.player.effects")
        @Config.Comment(value={"Show effects percentages on the main screen"})
        public boolean showEffectsPercent = false;
        @Config.LangKey(value="config.mist.player.soap")
        @Config.Comment(value={"Enable washing armor with soap"})
        public boolean soapWashingArmor = true;
        @Config.LangKey(value="config.mist.player.skill_factor")
        @Config.Comment(value={"Skill factor in order: Taming, Cutting, Mason. The lower the value, the faster the skills upgrade"})
        @Config.RangeDouble(min=0.02, max=10.0)
        public double[] skillFactor = new double[]{1.0, 1.0, 1.0};
        @Config.LangKey(value="config.mist.player.mobs_for_skill")
        @Config.Comment(value={"A list of creatures (not monsters) whose killing will increase the cutting skill (modId:mobName:points or modId:*:points for all mobs in the mod). For example: mist:mossling:1, mist:monk:2, mist:brachiodon:3"})
        public String[] mobsForSkill = new String[0];
    }

    public static class Dimension {
        @Config.RequiresMcRestart
        @Config.LangKey(value="config.mist.dimension.id")
        @Config.Comment(value={"What ID number to assign to the Misty World dimension. Change if you are having conflicts with another mod"})
        public int dimensionID = 69;
        @Config.LangKey(value="config.mist.dimension.stones")
        @Config.Comment(value={"Disable portal stone drop"})
        public boolean disableStoneDrop = false;
        @Config.LangKey(value="config.mist.dimension.trees")
        @Config.Comment(value={"Disable vanilla tree growth"})
        public boolean disableVanillaTreeGrowth = true;
        @Config.LangKey(value="config.mist.dimension.mycelium")
        @Config.Comment(value={"Can mycelium be harvested without a silk touch"})
        public boolean myceliumHarvesting = false;
        @Config.LangKey(value="config.mist.dimension.saplings")
        @Config.Comment(value={"Saplings drop chance. The final chance will be multiplied by the number of leaves attached to the cut branch"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double saplingsDropChance = 0.1;
        @Config.LangKey(value="config.mist.dimension.bonemeal")
        @Config.Comment(value={"Enable the use Bone Meal to accelerate tree growth"})
        public boolean enableUseBoneMeal = false;
        @Config.LangKey(value="config.mist.dimension.blacklist")
        @Config.Comment(value={"Black list of dimensions in which it is impossible to build a portal into a Misty World"})
        public int[] dimBlackList = new int[]{1};
        @Config.LangKey(value="config.mist.dimension.breakers")
        @Config.Comment(value={"Assigns the mining speed multiplier of the foggy stone to the item (ModID:Item:Porous:Upper:Basic). Please do not change this parameter! This may affect the game balance"})
        public String[] stoneBreakers = new String[]{"mist:niobium_pickaxe:1:8:8"};
        @Config.LangKey(value="config.mist.dimension.filter_coal_breakers")
        @Config.Comment(value={"List of tools that can mine filter coal ore. Please do not change this parameter! This may affect the game balance"})
        public String[] filterCoalBreakers = new String[]{"mist:niobium_pickaxe"};
        @Config.LangKey(value="config.mist.dimension.mod_blacklist")
        @Config.Comment(value={"Blacklist of mobs that can't spawn in a Misty World (modId:mobName or modId:* for all mobs in the mod). For example: minecraft:pig"})
        public String[] mobsBlackList = new String[0];
        @Config.LangKey(value="config.mist.dimension.cascad_lag")
        @Config.Comment(value={"Disable the message about cascading worldgen lag. Temporary measure until I find a solution to the problem"})
        public boolean disableCascadingLog = true;
        @Config.Ignore
        public static final ArrayList<Integer> loadedDimBlackList = new ArrayList();
    }
}

