/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.init;

import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import ru.liahim.mist.api.biome.MistBiomes;
import ru.liahim.mist.common.Mist;
import ru.liahim.mist.world.biome.BiomeMistBorderDown;
import ru.liahim.mist.world.biome.BiomeMistBorderUp;
import ru.liahim.mist.world.biome.BiomeMistDownCenter;
import ru.liahim.mist.world.biome.BiomeMistDownForest;
import ru.liahim.mist.world.biome.BiomeMistDownNormal;
import ru.liahim.mist.world.biome.BiomeMistDownSwamp;
import ru.liahim.mist.world.biome.BiomeMistUpColdBase;
import ru.liahim.mist.world.biome.BiomeMistUpDesert;
import ru.liahim.mist.world.biome.BiomeMistUpForest;
import ru.liahim.mist.world.biome.BiomeMistUpJungle;
import ru.liahim.mist.world.biome.BiomeMistUpJungleEdge;
import ru.liahim.mist.world.biome.BiomeMistUpLowland;
import ru.liahim.mist.world.biome.BiomeMistUpMarsh;
import ru.liahim.mist.world.biome.BiomeMistUpMeadow;
import ru.liahim.mist.world.biome.BiomeMistUpSavanna;
import ru.liahim.mist.world.biome.BiomeMistUpSwamp;
import ru.liahim.mist.world.biome.BiomeMistUpSwampyForest;
import ru.liahim.mist.world.biome.BiomeMistUpSwampyMeadow;

public class ModBiomes {
    private static boolean hasAssignedBiomeID = false;
    private static boolean hasBiomeIdConflicts = false;
    private static float upHeight = 3.6f;
    private static float downHeight = -1.7f;
    private static final float upTemp = 0.1f;
    private static final int waterColor = 14745518;
    private static final int waterColorLowland = 14281869;
    private static final int waterColorMarsh = 13818221;
    private static final int waterColorSwamp = 12825132;
    private static final int waterColorCold = 13818221;

    public static void registerBiomes() {
        Mist.logger.info("Start to initialize Biomes");
        MistBiomes.upMeadow = ModBiomes.registerBiome("up_meadow", new BiomeMistUpMeadow(new Biome.BiomeProperties("Meadow").func_185398_c(upHeight + 0.1f).func_185400_d(0.02f).func_185410_a(1.3000001f).func_185395_b(0.4f).func_185402_a(14745518)).setBiomeColor(12381533));
        MistBiomes.upForest = ModBiomes.registerBiome("up_forest", new BiomeMistUpForest(new Biome.BiomeProperties("Forest").func_185398_c(upHeight + 0.15f).func_185400_d(0.035f).func_185410_a(1.2f).func_185395_b(0.5f).func_185402_a(14745518), 4).setBiomeColor(7051538));
        MistBiomes.upDenseForest = ModBiomes.registerBiome("up_dense_forest", new BiomeMistUpForest(new Biome.BiomeProperties("Dense Forest").func_185398_c(upHeight + 0.15f).func_185400_d(0.05f).func_185410_a(1.1f).func_185395_b(0.6f).func_185402_a(14745518), 6).setBiomeColor(5534994));
        MistBiomes.upSavanna = ModBiomes.registerBiome("up_savanna", new BiomeMistUpSavanna(new Biome.BiomeProperties("Savanna").func_185398_c(upHeight + 0.1f).func_185400_d(0.04f).func_185410_a(1.6f).func_185395_b(0.2f).func_185396_a().func_185402_a(14745518)).setBiomeColor(13956708));
        MistBiomes.upDesert = ModBiomes.registerBiome("up_desert", new BiomeMistUpDesert(new Biome.BiomeProperties("Desert").func_185398_c(upHeight + 0.1f).func_185400_d(0.0f).func_185410_a(2.1f).func_185395_b(0.0f).func_185396_a().func_185402_a(14745518), false).setBiomeColor(15531884));
        MistBiomes.upDunes = ModBiomes.registerBiome("up_dunes", new BiomeMistUpDesert(new Biome.BiomeProperties("Dunes").func_185398_c(upHeight + 0.2f).func_185400_d(0.0f).func_185410_a(1.9f).func_185395_b(0.1f).func_185396_a().func_185402_a(14745518), true).setBiomeColor(15330112));
        MistBiomes.upSnowfields = ModBiomes.registerBiome("up_snowfields", new BiomeMistUpColdBase(new Biome.BiomeProperties("Snowfields").func_185398_c(upHeight + 0.1f).func_185400_d(0.02f).func_185410_a(0.1f).func_185395_b(0.0f).func_185411_b().func_185402_a(13818221), 0, 0.002f, false).setBiomeColor(0xD0D7D7));
        MistBiomes.upTaiga = ModBiomes.registerBiome("up_taiga", new BiomeMistUpColdBase(new Biome.BiomeProperties("Taiga").func_185398_c(upHeight + 0.1f).func_185400_d(0.03f).func_185410_a(0.1f).func_185395_b(0.2f).func_185411_b().func_185402_a(13818221), 2, 0.0f, true).setBiomeColor(7910550));
        MistBiomes.upHillyTaiga = ModBiomes.registerBiome("up_hilly_taiga", new BiomeMistUpColdBase(new Biome.BiomeProperties("Hilly Taiga").func_185398_c(upHeight + 0.2f).func_185400_d(0.07f).func_185410_a(0.1f).func_185395_b(0.3f).func_185411_b().func_185402_a(13818221), 3, 0.1f, true).setBiomeColor(12506581));
        MistBiomes.upSwamp = ModBiomes.registerBiome("up_swamp", new BiomeMistUpSwamp(new Biome.BiomeProperties("Swampland").func_185398_c(upHeight - 0.0f).func_185400_d(0.0f).func_185410_a(0.90000004f).func_185395_b(0.9f).func_185402_a(12825132)).setBiomeColor(5343544));
        MistBiomes.upSwampyMeadow = ModBiomes.registerBiome("up_swampy_meadow", new BiomeMistUpSwampyMeadow(new Biome.BiomeProperties("Swampy Meadow").func_185398_c(upHeight + 0.0f).func_185400_d(0.01f).func_185410_a(1.1f).func_185395_b(0.7f).func_185402_a(13818221)).setBiomeColor(13229961));
        MistBiomes.upSwampyForest = ModBiomes.registerBiome("up_swampy_forest", new BiomeMistUpSwampyForest(new Biome.BiomeProperties("Swampy Forest").func_185398_c(upHeight + 0.0f).func_185400_d(0.03f).func_185410_a(0.70000005f).func_185395_b(0.9f).func_185402_a(13818221)).setBiomeColor(4091688));
        MistBiomes.upJungle = ModBiomes.registerBiome("up_jungle", new BiomeMistUpJungle(new Biome.BiomeProperties("Jungle").func_185398_c(upHeight + 0.2f).func_185400_d(0.05f).func_185410_a(1.5f).func_185395_b(0.9f).func_185402_a(14745518), 3).setBiomeColor(1177088));
        MistBiomes.upJungleEdge = ModBiomes.registerBiome("up_jungle_edge", new BiomeMistUpJungleEdge(new Biome.BiomeProperties("Jungle Edge").func_185398_c(upHeight + 0.1f).func_185400_d(0.02f).func_185410_a(1.6f).func_185395_b(0.8f).func_185402_a(14745518), 3).setBiomeColor(9815353));
        MistBiomes.upJungleHills = ModBiomes.registerBiome("up_jungle_hills", new BiomeMistUpJungle(new Biome.BiomeProperties("Jungle Hills").func_185398_c(upHeight + 0.25f).func_185400_d(0.2f).func_185410_a(1.5f).func_185395_b(0.9f).func_185402_a(14745518), 3).setBiomeColor(8952082));
        MistBiomes.upLake = ModBiomes.registerBiome("up_lake", new BiomeMistUpMeadow(new Biome.BiomeProperties("Lake").func_185398_c(upHeight - 0.2f).func_185400_d(0.0f).func_185410_a(1.3000001f).func_185395_b(0.6f).func_185402_a(14745518)).setBiomeColor(4228334));
        MistBiomes.upLowland = ModBiomes.registerBiome("up_lowland", new BiomeMistUpLowland(new Biome.BiomeProperties("Lowland").func_185398_c(upHeight - 0.15f).func_185400_d(0.01f).func_185410_a(0.70000005f).func_185395_b(0.9f).func_185402_a(14745518)).setBiomeColor(4228283));
        MistBiomes.upColdLowland = ModBiomes.registerBiome("up_cold_lowland", new BiomeMistUpColdBase(new Biome.BiomeProperties("Cold Lowland").func_185398_c(upHeight - 0.15f).func_185400_d(0.01f).func_185410_a(-0.3f).func_185395_b(0.5f).func_185411_b().func_185402_a(13818221), -999, 0.0f, false).setBiomeColor(25855));
        MistBiomes.upMarsh = ModBiomes.registerBiome("up_marsh", new BiomeMistUpMarsh(new Biome.BiomeProperties("Marsh").func_185398_c(upHeight - 0.15f).func_185400_d(0.01f).func_185410_a(0.70000005f).func_185395_b(0.9f).func_185402_a(14281869), false).setBiomeColor(4228331));
        MistBiomes.borderUpPlains = ModBiomes.registerBiome("border_plains", new BiomeMistBorderUp(new Biome.BiomeProperties("Plains Border").func_185398_c(upHeight).func_185400_d(0.0f).func_185410_a(1.3000001f).func_185395_b(0.4f).func_185402_a(14745518), MistBiomes.upMeadow).setBiomeColor(12966048));
        MistBiomes.borderUpDesert = ModBiomes.registerBiome("border_desert", new BiomeMistBorderUp(new Biome.BiomeProperties("Desert Border").func_185398_c(upHeight).func_185400_d(0.0f).func_185410_a(1.6f).func_185395_b(0.2f).func_185396_a().func_185402_a(14745518), MistBiomes.upSavanna).setBiomeColor(14542500));
        MistBiomes.borderUpCold = ModBiomes.registerBiome("border_cold", new BiomeMistBorderUp(new Biome.BiomeProperties("Cold Border").func_185398_c(upHeight).func_185400_d(0.0f).func_185410_a(0.1f).func_185395_b(0.0f).func_185411_b().func_185402_a(14745518), MistBiomes.upSnowfields).setBiomeColor(13165799));
        MistBiomes.borderUpSwamp = ModBiomes.registerBiome("border_swamp", new BiomeMistBorderUp(new Biome.BiomeProperties("Swampland Border").func_185398_c(upHeight).func_185400_d(0.0f).func_185410_a(1.1f).func_185395_b(0.5f).func_185402_a(14745518), MistBiomes.upSwampyMeadow).setBiomeColor(11124127));
        MistBiomes.borderUpJungle = ModBiomes.registerBiome("border_jungle", new BiomeMistBorderUp(new Biome.BiomeProperties("Jungle Border").func_185398_c(upHeight + 0.0f).func_185400_d(0.0f).func_185410_a(1.6f).func_185395_b(0.7f).func_185402_a(14745518), MistBiomes.upJungleEdge).setBiomeColor(7175782));
        MistBiomes.borderDown = ModBiomes.registerBiome("border_down", new BiomeMistBorderDown(new Biome.BiomeProperties("Down Border").func_185398_c(downHeight + 0.3f).func_185400_d(0.05f).func_185410_a(1.5f).func_185395_b(0.5f).func_185402_a(14745518)).setBiomeColor(13284749));
        MistBiomes.separator = ModBiomes.registerBiome("separator", new BiomeMistBorderDown(new Biome.BiomeProperties("Border").func_185398_c(downHeight + 2.0f).func_185400_d(0.0f).func_185410_a(1.0f).func_185395_b(0.5f).func_185402_a(14745518)).setBiomeColor(0xFFFFFF));
        MistBiomes.down = ModBiomes.registerBiome("down", new BiomeMistDownNormal(new Biome.BiomeProperties("Down").func_185398_c(downHeight).func_185400_d(0.05f).func_185410_a(1.5f).func_185395_b(0.5f)).setBiomeColor(13216071));
        MistBiomes.downForest = ModBiomes.registerBiome("down_forest", new BiomeMistDownForest(new Biome.BiomeProperties("Down Forest").func_185398_c(downHeight + 0.2f).func_185400_d(0.05f).func_185410_a(1.3f).func_185395_b(0.7f)).setBiomeColor(11305522));
        MistBiomes.downSwamp = ModBiomes.registerBiome("down_swamp", new BiomeMistDownSwamp(new Biome.BiomeProperties("Down Swamp").func_185398_c(downHeight - 0.0f).func_185400_d(0.01f).func_185410_a(1.7f).func_185395_b(0.9f)).setBiomeColor(12817725));
        MistBiomes.downCenter = ModBiomes.registerBiome("down_center", new BiomeMistDownCenter(new Biome.BiomeProperties("Down Center").func_185398_c(downHeight + 0.1f).func_185400_d(0.05f).func_185410_a(1.9f).func_185395_b(0.1f)).setBiomeColor(10185487));
        ModBiomes.registerWithBiomeDictionary();
        Mist.logger.info("Finished initializing Biomes");
    }

    private static Biome registerBiome(String name, Biome biome) {
        ResourceLocation RL = new ResourceLocation("mist", name);
        biome.setRegistryName(RL);
        ForgeRegistries.BIOMES.register((IForgeRegistryEntry)biome);
        return (Biome)ForgeRegistries.BIOMES.getValue(RL);
    }

    public static void registerWithBiomeDictionary() {
        BiomeDictionary.addTypes((Biome)MistBiomes.upMeadow, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.PLAINS});
        BiomeDictionary.addTypes((Biome)MistBiomes.upForest, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST});
        BiomeDictionary.addTypes((Biome)MistBiomes.upDenseForest, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.WET});
        BiomeDictionary.addTypes((Biome)MistBiomes.upSavanna, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY});
        BiomeDictionary.addTypes((Biome)MistBiomes.upDesert, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SANDY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY});
        BiomeDictionary.addTypes((Biome)MistBiomes.upDunes, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SANDY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.HILLS});
        BiomeDictionary.addTypes((Biome)MistBiomes.upSnowfields, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.COLD, BiomeDictionary.Type.CONIFEROUS});
        BiomeDictionary.addTypes((Biome)MistBiomes.upTaiga, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.COLD, BiomeDictionary.Type.CONIFEROUS});
        BiomeDictionary.addTypes((Biome)MistBiomes.upHillyTaiga, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.COLD, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.HILLS});
        BiomeDictionary.addTypes((Biome)MistBiomes.upSwamp, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.WET});
        BiomeDictionary.addTypes((Biome)MistBiomes.upSwampyMeadow, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.WET});
        BiomeDictionary.addTypes((Biome)MistBiomes.upSwampyForest, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.WET});
        BiomeDictionary.addTypes((Biome)MistBiomes.upJungle, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.WET, BiomeDictionary.Type.LUSH});
        BiomeDictionary.addTypes((Biome)MistBiomes.upJungleEdge, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.WET});
        BiomeDictionary.addTypes((Biome)MistBiomes.upJungleHills, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.LUSH});
        BiomeDictionary.addTypes((Biome)MistBiomes.upLake, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.RIVER, BiomeDictionary.Type.WET});
        BiomeDictionary.addTypes((Biome)MistBiomes.upLowland, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.WET});
        BiomeDictionary.addTypes((Biome)MistBiomes.upColdLowland, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.RIVER, BiomeDictionary.Type.WET, BiomeDictionary.Type.COLD, BiomeDictionary.Type.SNOWY});
        BiomeDictionary.addTypes((Biome)MistBiomes.upMarsh, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.RIVER, BiomeDictionary.Type.WET});
        BiomeDictionary.addTypes((Biome)MistBiomes.borderUpPlains, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.WASTELAND});
        BiomeDictionary.addTypes((Biome)MistBiomes.borderUpDesert, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SANDY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.WASTELAND});
        BiomeDictionary.addTypes((Biome)MistBiomes.borderUpCold, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.COLD, BiomeDictionary.Type.WASTELAND});
        BiomeDictionary.addTypes((Biome)MistBiomes.borderUpSwamp, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.WET, BiomeDictionary.Type.WASTELAND});
        BiomeDictionary.addTypes((Biome)MistBiomes.borderUpJungle, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.WET, BiomeDictionary.Type.WASTELAND});
        BiomeDictionary.addTypes((Biome)MistBiomes.borderDown, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.DEAD, BiomeDictionary.Type.SPOOKY});
        BiomeDictionary.addTypes((Biome)MistBiomes.separator, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.DEAD, BiomeDictionary.Type.SPOOKY});
        BiomeDictionary.addTypes((Biome)MistBiomes.down, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.DEAD, BiomeDictionary.Type.SPOOKY});
        BiomeDictionary.addTypes((Biome)MistBiomes.downForest, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.DEAD, BiomeDictionary.Type.SPOOKY});
        BiomeDictionary.addTypes((Biome)MistBiomes.downSwamp, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.DEAD, BiomeDictionary.Type.SPOOKY});
        BiomeDictionary.addTypes((Biome)MistBiomes.downCenter, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.DEAD, BiomeDictionary.Type.SPOOKY});
    }
}

