/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.init;

import com.google.common.collect.Maps;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.api.item.MistItems;
import ru.liahim.mist.common.Mist;
import ru.liahim.mist.item.food.ItemMistSoup;
import ru.liahim.mist.util.ItemStackMapKey;

@SideOnly(value=Side.CLIENT)
public class ItemColoring {
    private static int[][] data;
    private static int color;
    private static int red;
    private static int green;
    private static int blue;
    private static final HashMap<ItemStackMapKey, Integer> foodColorList;
    public static final IItemColor ITEM_ARMOR_COLORING;
    public static final IItemColor ITEM_SOUP_COLORING;
    public static final IItemColor ITEM_URN_COLORING;

    @SideOnly(value=Side.CLIENT)
    public static void createFoodColorList() {
        ItemModelMesher imm = Minecraft.func_71410_x().func_175599_af().func_175037_a();
        for (Item item : ForgeRegistries.ITEMS.getValuesCollection()) {
            if (!(item instanceof ItemFood) || item == MistItems.SOUP) continue;
            int damage = item.func_77645_m() ? 0 : 1000;
            for (int i = 0; i < damage; ++i) {
                int color;
                TextureAtlasSprite atlas = imm.func_178087_a(item, i);
                if (atlas == null || atlas.func_94215_i().equals("missingno") || (color = ItemColoring.getSmoothColor(atlas)) == 0) continue;
                foodColorList.put(new ItemStackMapKey(new ItemStack(item, 1, i)), color);
            }
        }
        Mist.logger.info("misty_world saved the smoothed food colors");
    }

    private static int getSmoothColor(TextureAtlasSprite atlas) {
        int count = 0;
        blue = 0;
        green = 0;
        red = 0;
        for (int i = 0; i < atlas.func_110970_k(); ++i) {
            data = atlas.func_147965_a(i);
            for (int x = 0; x < data.length; ++x) {
                for (int y = 0; y < data[x].length; ++y) {
                    color = data[x][y];
                    if ((color >> 24 & 0xFF) != 255) continue;
                    red += color >> 16 & 0xFF;
                    green += color >> 8 & 0xFF;
                    blue += color & 0xFF;
                    ++count;
                }
            }
        }
        if (count == 0) {
            return 0;
        }
        return 0xFF000000 | (red /= count) << 16 | (green /= count) << 8 | (blue /= count);
    }

    public static int getFoodColor(ItemStack stack) {
        ItemStackMapKey key = new ItemStackMapKey(stack);
        return foodColorList.containsKey(key) ? foodColorList.get(key) : 0;
    }

    static {
        foodColorList = Maps.newHashMap();
        ITEM_ARMOR_COLORING = new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                return stack.func_77973_b() instanceof ItemArmor && tintIndex == 0 ? ((ItemArmor)stack.func_77973_b()).func_82814_b(stack) : 0xFFFFFF;
            }
        };
        ITEM_SOUP_COLORING = new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                if (tintIndex > 0 && stack.func_77973_b() instanceof ItemMistSoup) {
                    ItemStack[] mainFood = ((ItemMistSoup)stack.func_77973_b()).getFoodColors(stack);
                    float[] percents = ((ItemMistSoup)stack.func_77973_b()).getFoodPercent(stack);
                    if (mainFood != null) {
                        int[] colors = new int[5];
                        int i = 0;
                        for (ItemStack food : mainFood) {
                            if (food.func_190926_b()) break;
                            colors[i] = ItemColoring.getFoodColor(food);
                            ++i;
                        }
                        if (i > 0) {
                            if (tintIndex <= i && colors[tintIndex - 1] != 0) {
                                return colors[tintIndex - 1];
                            }
                            float red = 0.0f;
                            float green = 0.0f;
                            float blue = 0.0f;
                            float count = 0.0f;
                            for (int f = 0; f < i; ++f) {
                                if (colors[f] == 0 || percents[f] == 0.0f) continue;
                                red += (float)(colors[f] >> 16 & 0xFF) / 255.0f * percents[f];
                                green += (float)(colors[f] >> 8 & 0xFF) / 255.0f * percents[f];
                                blue += (float)(colors[f] & 0xFF) / 255.0f * percents[f];
                                count += percents[f];
                            }
                            if (count > 0.0f) {
                                return (int)(((double)(red /= count) + 0.2) * 212.5) << 16 | (int)(((double)(green /= count) + 0.2) * 212.5) << 8 | (int)(((double)(blue /= count) + 0.2) * 212.5);
                            }
                        }
                    }
                }
                return 0xFFFFFF;
            }
        };
        ITEM_URN_COLORING = new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                ItemStack[] mainFood;
                if (tintIndex > 0 && stack.func_77973_b() instanceof ItemMistSoup && (mainFood = ((ItemMistSoup)stack.func_77973_b()).getFoodColors(stack)) != null) {
                    int[] colors = new int[5];
                    int i = 0;
                    for (ItemStack food : mainFood) {
                        if (food.func_190926_b()) break;
                        colors[i] = ItemColoring.getFoodColor(food);
                        ++i;
                    }
                    if (i > 0) {
                        float red = 0.0f;
                        float green = 0.0f;
                        float blue = 0.0f;
                        if (tintIndex <= i && colors[tintIndex - 1] != 0) {
                            return colors[tintIndex - 1];
                        }
                        int count = 0;
                        for (int f = 0; f < i; ++f) {
                            if (colors[f] == 0) continue;
                            red += (float)(colors[f] >> 16 & 0xFF) / 255.0f;
                            green += (float)(colors[f] >> 8 & 0xFF) / 255.0f;
                            blue += (float)(colors[f] & 0xFF) / 255.0f;
                            ++count;
                        }
                        if (count > 0) {
                            return (int)(((double)(red /= (float)count) + 0.2) * 212.5) << 16 | (int)(((double)(green /= (float)count) + 0.2) * 212.5) << 8 | (int)(((double)(blue /= (float)count) + 0.2) * 212.5);
                        }
                    }
                }
                return 0xFFFFFF;
            }
        };
    }
}

