/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.init;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.api.block.IColoredBlock;
import ru.liahim.mist.world.biome.BiomeMist;

@SideOnly(value=Side.CLIENT)
public class BlockColoring {
    public static final IBlockColor FOLIAGE_COLORING = new IBlockColor(){

        @SideOnly(value=Side.CLIENT)
        public int func_186720_a(IBlockState state, IBlockAccess world, BlockPos pos, int tintIndex) {
            return world != null && pos != null ? BiomeColorHelper.func_180287_b((IBlockAccess)world, (BlockPos)pos) : ColorizerFoliage.func_77468_c();
        }
    };
    public static final IBlockColor GRASS_COLORING_0 = new IBlockColor(){

        @SideOnly(value=Side.CLIENT)
        public int func_186720_a(IBlockState state, IBlockAccess world, BlockPos pos, int tintIndex) {
            return world != null && pos != null ? (tintIndex == 0 ? BiomeColorHelper.func_180286_a((IBlockAccess)world, (BlockPos)pos) : -1) : ColorizerGrass.func_77480_a((double)0.5, (double)1.0);
        }
    };
    public static final IBlockColor GRASS_COLORING_1 = new IBlockColor(){

        @SideOnly(value=Side.CLIENT)
        public int func_186720_a(IBlockState state, IBlockAccess world, BlockPos pos, int tintIndex) {
            return world != null && pos != null ? (tintIndex == 1 ? BiomeColorHelper.func_180286_a((IBlockAccess)world, (BlockPos)pos) : -1) : ColorizerGrass.func_77480_a((double)0.5, (double)1.0);
        }
    };
    public static final IBlockColor DOWN_GRASS_COLORING = new IBlockColor(){

        @SideOnly(value=Side.CLIENT)
        public int func_186720_a(IBlockState state, IBlockAccess world, BlockPos pos, int tintIndex) {
            return world != null && pos != null && tintIndex == 1 ? BlockColoring.getDownGrassColor(world, pos) : 0xC8C8C8;
        }
    };
    public static final IItemColor BLOCK_ITEM_COLORING = new IItemColor(){

        @SideOnly(value=Side.CLIENT)
        public int func_186726_a(ItemStack stack, int tintIndex) {
            if (stack.func_77973_b() instanceof ItemBlock) {
                IBlockState state = ((ItemBlock)stack.func_77973_b()).func_179223_d().func_176203_a(stack.func_77960_j());
                IBlockColor blockColor = ((IColoredBlock)state.func_177230_c()).getBlockColor();
                return blockColor == null ? 0xFFFFFF : blockColor.func_186720_a(state, null, null, tintIndex);
            }
            return 0xFFFFFF;
        }
    };

    public static int getDownGrassColor(IBlockAccess blockAccess, BlockPos pos) {
        int r = 0;
        int g = 0;
        int b = 0;
        int r0 = 175;
        int g0 = 205;
        int b0 = 200;
        int rt = 205;
        int gt = 200;
        int bt = 175;
        int rh = 200;
        int gh = 200;
        int bh = 200;
        for (BlockPos.MutableBlockPos checkPos : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-1, 0, -1), (BlockPos)pos.func_177982_a(1, 0, 1))) {
            Biome biome = blockAccess.func_180494_b((BlockPos)checkPos);
            if (biome instanceof BiomeMist && ((BiomeMist)biome).getDownGrassColor() >= 0) {
                int i = ((BiomeMist)biome).getDownGrassColor();
                r += i >> 16 & 0xFF;
                g += i >> 8 & 0xFF;
                b += i & 0xFF;
                continue;
            }
            float temp = MathHelper.func_76131_a((float)(biome.func_180626_a(pos) * 0.4f + 0.2f), (float)0.0f, (float)1.0f);
            float humi = MathHelper.func_76131_a((float)biome.func_76727_i(), (float)0.0f, (float)1.0f);
            float w = temp - humi;
            r = (int)((float)r + (((float)r0 + (float)(rt - r0) * temp) * (w + 1.0f) - ((float)r0 + (float)(rh - r0) * humi) * (w - 1.0f)) / 2.0f);
            g = (int)((float)g + (((float)g0 + (float)(gt - g0) * temp) * (w + 1.0f) - ((float)g0 + (float)(gh - g0) * humi) * (w - 1.0f)) / 2.0f);
            b = (int)((float)b + (((float)b0 + (float)(bt - b0) * temp) * (w + 1.0f) - ((float)b0 + (float)(bh - b0) * humi) * (w - 1.0f)) / 2.0f);
        }
        return r / 9 << 16 | g / 9 << 8 | b / 9;
    }
}

