/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.handlers;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemFlintAndSteel;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemSplashPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSpawnPosition;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntityFlowerPot;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerPickupXpEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.lang3.tuple.Pair;
import ru.liahim.mist.api.advancement.PortalType;
import ru.liahim.mist.api.block.IFarmland;
import ru.liahim.mist.api.block.IMistStone;
import ru.liahim.mist.api.block.IWettable;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.api.item.IMask;
import ru.liahim.mist.api.item.ISuit;
import ru.liahim.mist.api.item.MistItems;
import ru.liahim.mist.api.registry.IMistHarvest;
import ru.liahim.mist.api.registry.MistRegistry;
import ru.liahim.mist.block.MistBlockBranch;
import ru.liahim.mist.block.MistBlockSlab;
import ru.liahim.mist.block.MistBlockStairs;
import ru.liahim.mist.block.MistBlockStep;
import ru.liahim.mist.block.MistLooseRock;
import ru.liahim.mist.block.MistOreUpper;
import ru.liahim.mist.block.MistPortalStone;
import ru.liahim.mist.block.MistSoil;
import ru.liahim.mist.block.MistTreeTrunk;
import ru.liahim.mist.block.MistWoodBlock;
import ru.liahim.mist.block.gizmos.MistChest;
import ru.liahim.mist.block.gizmos.MistFlowerPot;
import ru.liahim.mist.capability.FoodCapability;
import ru.liahim.mist.capability.MistCapability;
import ru.liahim.mist.capability.SkillCapability;
import ru.liahim.mist.capability.handler.FoodHandler;
import ru.liahim.mist.capability.handler.IFoodHandler;
import ru.liahim.mist.capability.handler.IMistCapaHandler;
import ru.liahim.mist.capability.handler.ISkillCapaHandler;
import ru.liahim.mist.capability.handler.MistCapaHandler;
import ru.liahim.mist.capability.handler.SkillCapaHandler;
import ru.liahim.mist.common.Mist;
import ru.liahim.mist.common.MistTime;
import ru.liahim.mist.entity.ai.EntityAIEatMistGrass;
import ru.liahim.mist.init.ModAdvancements;
import ru.liahim.mist.init.ModConfig;
import ru.liahim.mist.init.ModItems;
import ru.liahim.mist.item.ItemMistMapDown;
import ru.liahim.mist.item.ItemMistMapUp;
import ru.liahim.mist.network.PacketHandler;
import ru.liahim.mist.network.PacketMaskSync;
import ru.liahim.mist.network.PacketMushroomSync;
import ru.liahim.mist.network.PacketSeedSync;
import ru.liahim.mist.network.PacketSkillSync;
import ru.liahim.mist.network.PacketSkySound;
import ru.liahim.mist.network.PacketTimeSync;
import ru.liahim.mist.network.PacketToxicFoodSync;
import ru.liahim.mist.network.PacketToxicSync;
import ru.liahim.mist.tileentity.TileEntityCampfire;
import ru.liahim.mist.util.PlayerLocationData;
import ru.liahim.mist.util.SoilHelper;
import ru.liahim.mist.util.TimeData;
import ru.liahim.mist.world.FogDamage;
import ru.liahim.mist.world.MistWorld;

public class ServerEventHandler {
    private static final HashMap<UUID, ItemStack> maskSync = Maps.newHashMap();
    private static final HashMap<UUID, Integer> mulchDelay = Maps.newHashMap();
    private static final HashMap<UUID, Integer> portDelay = Maps.newHashMap();
    private static final HashSet<UUID> milkCheck = Sets.newHashSet();
    public static Pair<BlockPos, EntityPlayer> breakPlayer = null;
    public static Pair<BlockPos, EntityPlayer> waterPlayer = null;
    private static long last_sky_sounds_time;
    private static long last_sky_boom_time;
    private static long sky_sounds_interval;
    private static long sky_boom_interval;
    private static int boom_count;
    private static int panic_Time;
    private static final int range1 = 64000;
    private static final int range2 = 6000;
    public static int ambientSoundsTimer;

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player;
        if (event.phase == TickEvent.Phase.START && event.side == Side.SERVER && (player = event.player) != null) {
            World world = player.field_70170_p;
            UUID uuid = player.func_110124_au();
            if (!portDelay.isEmpty() && portDelay.containsKey(uuid)) {
                int i = portDelay.get(uuid);
                if (i > 0) {
                    portDelay.replace(uuid, i - 1);
                } else {
                    if (player instanceof EntityPlayerMP) {
                        ((EntityPlayerMP)player).func_184846_L();
                    }
                    portDelay.remove(uuid);
                }
            }
            if (!maskSync.containsKey(uuid)) {
                maskSync.put(uuid, ItemStack.field_190927_a);
            }
            IMistCapaHandler maskHandler = IMistCapaHandler.getHandler(player);
            ItemStack stack = maskHandler.getMask();
            IMask mask = null;
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof IMask) {
                mask = (IMask)stack.func_77973_b();
                mask.onWornTick(stack, (EntityLivingBase)player);
            }
            if (maskHandler.isMaskChanged() || mask != null && mask.willAutoSync(stack, (EntityLivingBase)player) && !ItemStack.func_77989_b((ItemStack)stack, (ItemStack)maskSync.get(uuid))) {
                try {
                    if (maskHandler.isGlobalChanged()) {
                        PacketHandler.INSTANCE.sendToDimension((IMessage)new PacketMaskSync(player, stack), player.field_70170_p.field_73011_w.getDimension());
                    } else if (player instanceof EntityPlayerMP) {
                        PacketHandler.INSTANCE.sendTo((IMessage)new PacketMaskSync(player, stack), (EntityPlayerMP)player);
                    }
                    maskHandler.setMaskChanged(false, false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                maskSync.put(uuid, stack);
            }
            if (player.func_70608_bn()) {
                WorldServer otherWorld;
                if (world.field_73011_w.getDimension() == 0) {
                    if (player.func_70608_bn() && player.field_70173_aa % 90 == 0 && (otherWorld = DimensionManager.getWorld((int)Mist.getID())) != null && !otherWorld.field_73010_i.isEmpty() && !this.isAllPlayersAsleep((World)otherWorld)) {
                        player.field_71081_bT = player.func_180425_c().func_177977_b();
                        player.func_70999_a(true, false, false);
                        player.func_180469_a(player.field_71081_bT);
                    }
                } else if (world.field_73011_w.getDimension() == Mist.getID() && player.func_70608_bn() && player.field_70173_aa % 90 == 0 && (otherWorld = DimensionManager.getWorld((int)0)) != null && !otherWorld.field_73010_i.isEmpty() && !this.isAllPlayersAsleep((World)otherWorld)) {
                    player.field_71081_bT = player.func_180425_c().func_177977_b();
                    player.func_70999_a(true, false, false);
                    player.func_180469_a(player.field_71081_bT);
                }
            }
            if (!mulchDelay.isEmpty() && mulchDelay.containsKey(uuid)) {
                int i = mulchDelay.get(uuid);
                if (i > 0) {
                    mulchDelay.replace(uuid, i - 1);
                } else {
                    mulchDelay.remove(uuid);
                }
            }
        }
    }

    private boolean isAllPlayersAsleep(World world) {
        for (EntityPlayer entityplayer : world.field_73010_i) {
            if (entityplayer.func_175149_v() || entityplayer.func_70608_bn()) continue;
            return false;
        }
        return true;
    }

    private boolean isAllPlayersFullyAsleep(World world) {
        for (EntityPlayer entityplayer : world.field_73010_i) {
            if (entityplayer.func_175149_v() || entityplayer.func_71026_bH()) continue;
            return false;
        }
        return true;
    }

    @SubscribeEvent
    public void onPlayerTrySleep(PlayerSleepInBedEvent event) {
        if (event.getEntityPlayer().field_70170_p.field_73011_w.getDimension() == Mist.getID() && event.getPos().func_177956_o() < MistWorld.getFogMaxHight() + 4) {
            event.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentTranslation("tile.mist.bed.in_fog", new Object[0]));
            event.setResult(EntityPlayer.SleepResult.NOT_POSSIBLE_HERE);
        }
    }

    @SubscribeEvent
    public void onPlayerWakeUp(PlayerWakeUpEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        World world = player.field_70170_p;
        if (!world.field_72995_K && world.field_73011_w.getDimension() == Mist.getID() && player == world.field_73010_i.get(0)) {
            WorldServer normalWorld = DimensionManager.getWorld((int)0);
            boolean normalWorldEmpty = true;
            for (EntityPlayer entityplayer : normalWorld.field_73010_i) {
                if (!normalWorldEmpty || entityplayer.func_175149_v()) continue;
                normalWorldEmpty = false;
            }
            if (normalWorldEmpty && this.isAllPlayersFullyAsleep(world) && world.func_82736_K().func_82766_b("doDaylightCycle")) {
                long i = normalWorld.func_72912_H().func_76073_f() + 24000L;
                normalWorld.func_72912_H().func_76068_b(i - i % 24000L);
                normalWorld.field_73011_w.resetRainAndThunder();
                MistTime.wakeUp();
            }
        }
    }

    @SubscribeEvent
    public void breakSpeed(PlayerEvent.BreakSpeed event) {
        if (event.getState().func_177230_c() instanceof IMistStone) {
            ItemStack stack = event.getEntityPlayer().func_184614_ca();
            float speed = MistRegistry.getBreakingSpeed(stack, event.getState(), event.getOriginalSpeed());
            int skill = ISkillCapaHandler.Skill.getLevel(event.getEntityPlayer(), ISkillCapaHandler.Skill.MASON);
            event.setNewSpeed(speed *= (float)(1 + Math.max(skill - 1, 0)));
        } else if (event.getState().func_177230_c() instanceof MistTreeTrunk) {
            int size = (Integer)event.getState().func_177229_b((IProperty)MistTreeTrunk.SIZE);
            event.setNewSpeed((event.getOriginalSpeed() + 4.0f - (float)size) / 2.0f);
        } else if (event.getState().func_177230_c() instanceof MistSoil) {
            World world = event.getEntityPlayer().field_70170_p;
            IBlockState state = world.func_180495_p(event.getPos().func_177984_a());
            if (state.func_177230_c() instanceof MistTreeTrunk && ((MistTreeTrunk)state.func_177230_c()).getDir(state) == EnumFacing.UP) {
                event.setNewSpeed(Math.min(event.getOriginalSpeed(), event.getEntityPlayer().getDigSpeed(state, event.getPos().func_177984_a()) / 8.0f));
            }
        } else if (event.getState().func_177230_c() == MistBlocks.FLOATING_MAT && !event.getEntityPlayer().field_70122_E) {
            event.setNewSpeed(event.getOriginalSpeed() / 3.0f);
        }
    }

    @SubscribeEvent
    public void getStone(LivingExperienceDropEvent event) {
        if (!ModConfig.dimension.disableStoneDrop && event.getAttackingPlayer() != null) {
            World world = event.getAttackingPlayer().field_70170_p;
            if (!world.field_72995_K && world.field_73011_w.getDimension() != Mist.getID() && event.getEntityLiving() instanceof EntityEnderman && event.getAttackingPlayer() instanceof EntityPlayerMP) {
                EntityEnderman enderman = (EntityEnderman)event.getEntityLiving();
                EntityPlayerMP player = (EntityPlayerMP)event.getAttackingPlayer();
                if (world instanceof WorldServer && !player.func_192039_O().func_192747_a(((WorldServer)world).func_191952_z().func_192778_a(new ResourceLocation("mist", "story/full_set"))).func_192105_a()) {
                    this.dropStone(world, enderman);
                } else if (world.func_72911_I() && world.field_73012_v.nextInt(10) == 0) {
                    this.dropStone(world, enderman);
                }
            }
        }
    }

    protected void dropStone(World world, EntityEnderman enderman) {
        EntityItem itemPortalDown = new EntityItem(world, enderman.field_70165_t, enderman.field_70163_u, enderman.field_70161_v, new ItemStack(MistBlocks.PORTAL_BASE, 1, 2));
        EntityItem itemPortalUp = new EntityItem(world, enderman.field_70165_t, enderman.field_70163_u, enderman.field_70161_v, new ItemStack(MistBlocks.PORTAL_BASE, 1, 3));
        itemPortalDown.func_174867_a(10);
        itemPortalUp.func_174867_a(10);
        world.func_72838_d((Entity)itemPortalDown);
        world.func_72838_d((Entity)itemPortalUp);
    }

    @SubscribeEvent
    public void itemPickup(EntityItemPickupEvent event) {
        if (event.getEntityPlayer() != null && event.getEntityPlayer() instanceof EntityPlayerMP) {
            ModAdvancements.ITEM_PICKUP.trigger((EntityPlayerMP)event.getEntityPlayer(), event.getItem().func_92059_d());
        }
    }

    @SubscribeEvent
    public void itemCrafting(PlayerEvent.ItemCraftedEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            ModAdvancements.ITEM_CRAFTED.trigger((EntityPlayerMP)event.player, event.crafting);
        }
    }

    @SubscribeEvent
    public void itemSmelting(PlayerEvent.ItemSmeltedEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            ModAdvancements.ITEM_SMELTED.trigger((EntityPlayerMP)event.player, event.smelting);
        }
    }

    @SubscribeEvent
    public void placeBlock(BlockEvent.PlaceEvent event) {
        World world = event.getWorld();
        if (!world.field_72995_K) {
            Block block = event.getState().func_177230_c();
            if (!(ModConfig.Dimension.loadedDimBlackList.contains(world.field_73011_w.getDimension()) || block != Blocks.field_150340_R && block != MistBlocks.PORTAL_BASE)) {
                boolean check = false;
                BlockPos pos = event.getPos();
                BlockPos portalPos = BlockPos.field_177992_a;
                if (block == Blocks.field_150340_R) {
                    IBlockState up = world.func_180495_p(pos.func_177984_a());
                    IBlockState down = world.func_180495_p(pos.func_177977_b());
                    if (up.func_177230_c() == MistBlocks.PORTAL_BASE && ((Boolean)up.func_177229_b((IProperty)MistPortalStone.ISUP)).booleanValue() && down.func_177230_c() == MistBlocks.PORTAL_BASE && !((Boolean)down.func_177229_b((IProperty)MistPortalStone.ISUP)).booleanValue()) {
                        check = true;
                        portalPos = pos;
                    }
                } else {
                    boolean isUp = (Boolean)event.getState().func_177229_b((IProperty)MistPortalStone.ISUP);
                    portalPos = isUp ? pos.func_177977_b() : pos.func_177984_a();
                    BlockPos anotherBasePos = isUp ? pos.func_177979_c(2) : pos.func_177981_b(2);
                    IBlockState portalState = world.func_180495_p(portalPos);
                    IBlockState checkState = world.func_180495_p(anotherBasePos);
                    if (portalState.func_177230_c() == Blocks.field_150340_R && checkState.func_177230_c() == MistBlocks.PORTAL_BASE && (Boolean)checkState.func_177229_b((IProperty)MistPortalStone.ISUP) == !isUp) {
                        check = true;
                    }
                }
                if (check && event.getPlayer() != null && event.getPlayer() instanceof EntityPlayerMP) {
                    EntityPlayerMP playerMP = (EntityPlayerMP)event.getPlayer();
                    ModAdvancements.OPEN_PORTAL.trigger(playerMP, world, portalPos, PortalType.DIMENSION);
                }
            }
            if (block == Blocks.field_150433_aE || block == Blocks.field_150432_aD) {
                waterPlayer = Pair.of((Object)event.getPos(), (Object)event.getPlayer());
            }
        }
    }

    @SubscribeEvent
    public void blockHarvest(BlockEvent.HarvestDropsEvent event) {
        if (!event.getWorld().field_72995_K) {
            IBlockState soil;
            Block block = event.getState().func_177230_c();
            if (block == MistBlocks.FILTER_COAL_ORE) {
                if (event.getHarvester() != null) {
                    Item pickaxe = event.getHarvester().field_71071_by.func_70448_g().func_77973_b();
                    if (!MistRegistry.filterCoalBreakers.contains(pickaxe)) {
                        event.getDrops().clear();
                    }
                } else {
                    event.getDrops().clear();
                }
            } else if (block instanceof BlockCrops && ((BlockCrops)block).func_185525_y(event.getState()) && (soil = event.getWorld().func_180495_p(event.getPos().func_177977_b())).func_177230_c() instanceof IWettable) {
                Random rand = event.getWorld().field_73012_v;
                boolean norm = IMistHarvest.isSoilSuitable(event.getState().func_177230_c(), soil);
                Item crop = block.func_180660_a(event.getState(), rand, 0);
                ItemStack stack = ItemStack.field_190927_a;
                int count = 0;
                for (int j = 0; j < event.getDrops().size(); ++j) {
                    if (((ItemStack)event.getDrops().get(j)).func_77973_b() != crop) continue;
                    if (stack.func_190926_b()) {
                        stack = (ItemStack)event.getDrops().get(j);
                    }
                    ++count;
                }
                if (count > 0) {
                    int k = count;
                    if (norm && count == 1) {
                        count += rand.nextInt(2);
                    } else if (!norm && count > 1) {
                        count = count / 2 + (rand.nextInt(3) == 0 ? 1 : 0);
                    }
                    if (count != k) {
                        int j;
                        for (j = event.getDrops().size() - 1; j >= 0; --j) {
                            if (((ItemStack)event.getDrops().get(j)).func_77973_b() != crop) continue;
                            event.getDrops().remove(j);
                        }
                        for (j = 0; j < count; ++j) {
                            event.getDrops().add(stack);
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void breakBlock(BlockEvent.BreakEvent event) {
        if (!event.getWorld().field_72995_K) {
            if (event.getPlayer() != null && !event.getPlayer().func_184812_l_()) {
                if (event.getState().func_177230_c() instanceof MistOreUpper) {
                    Item pickaxe = event.getPlayer().field_71071_by.func_70448_g().func_77973_b();
                    if (pickaxe != MistItems.NIOBIUM_PICKAXE) {
                        event.setExpToDrop(0);
                    }
                } else if (event.getState().func_177230_c() instanceof MistTreeTrunk) {
                    event.setCanceled(((MistTreeTrunk)event.getState().func_177230_c()).dropSapling(event.getWorld(), event.getPos()));
                }
            }
            breakPlayer = Pair.of((Object)event.getPos(), (Object)event.getPlayer());
        }
    }

    @SubscribeEvent
    public void useItem(PlayerInteractEvent.RightClickItem event) {
        ItemStack stack = event.getItemStack();
        Item item = stack.func_77973_b();
        if (item == Items.field_151148_bJ) {
            EntityPlayer player = event.getEntityPlayer();
            if (player.field_70170_p.field_73011_w.getDimension() == Mist.getID()) {
                ItemStack mistMapUp = (float)player.func_180425_c().func_177956_o() > MistWorld.getFogHight(player.field_70170_p, 0.0f) - 6.0f ? ItemMistMapUp.setupNewMap(player.field_70170_p, player.field_70165_t, player.field_70161_v, (byte)0, true, false) : ItemMistMapDown.setupNewMap(player.field_70170_p, player.field_70165_t, player.field_70161_v, (byte)0, true, false);
                stack.func_190918_g(1);
                if (stack.func_190926_b()) {
                    player.func_184611_a(event.getHand(), mistMapUp);
                    event.setCancellationResult(EnumActionResult.SUCCESS);
                    event.setCanceled(true);
                } else {
                    if (!player.field_71071_by.func_70441_a(mistMapUp.func_77946_l())) {
                        player.func_71019_a(mistMapUp, false);
                    }
                    player.func_71029_a(StatList.func_188057_b((Item)item));
                    event.setCancellationResult(EnumActionResult.SUCCESS);
                    event.setCanceled(true);
                }
            }
        } else if (!(item == MistItems.GLASS_CONTAINER || item instanceof ItemSplashPotion || item.func_77661_b(stack) != EnumAction.EAT && item.func_77661_b(stack) != EnumAction.DRINK)) {
            IMistCapaHandler capa;
            EntityPlayer player = event.getEntityPlayer();
            ItemStack mask = player.func_184582_a(EntityEquipmentSlot.HEAD);
            if (!IMask.isMask(mask) && (capa = IMistCapaHandler.getHandler(player)) != null) {
                mask = capa.getMask();
            }
            if (!IMask.canEat(mask)) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("item.mist.respirator_close.tooltip", new Object[0]));
                event.setCancellationResult(EnumActionResult.SUCCESS);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void useBlock(PlayerInteractEvent.RightClickBlock event) {
        ItemStack stack = event.getItemStack();
        if (!stack.func_190926_b()) {
            World world = event.getWorld();
            BlockPos pos = event.getPos();
            Block block = world.func_180495_p(pos).func_177230_c();
            if (event.getEntityPlayer().func_70093_af()) {
                if (block == MistBlocks.CAMPFIRE || block == MistBlocks.CAMP_STICK) {
                    if (stack.func_77985_e()) {
                        event.setUseBlock(Event.Result.ALLOW);
                    }
                } else if (event.getFace() == EnumFacing.UP) {
                    if (world.func_180495_p(pos).func_185904_a().func_76222_j()) {
                        pos = pos.func_177977_b();
                    }
                    if (world.func_180495_p(pos.func_177984_a()).func_185904_a().func_76222_j()) {
                        Vec3d vec = event.getHitVec();
                        if (vec == null) {
                            vec = new Vec3d((Vec3i)pos);
                        }
                        if (MistRegistry.checkShiftPlacing(world, pos.func_177984_a(), stack, event.getEntityPlayer(), (float)vec.field_72450_a - (float)pos.func_177958_n(), (float)vec.field_72448_b - (float)pos.func_177956_o(), (float)vec.field_72449_c - (float)pos.func_177952_p(), world.func_180495_p(pos).func_193401_d((IBlockAccess)world, pos, EnumFacing.UP))) {
                            event.setCanceled(true);
                            event.setCancellationResult(EnumActionResult.SUCCESS);
                        }
                    }
                }
            } else if (block == Blocks.field_150457_bL) {
                if (MistFlowerPot.canBePotted(stack)) {
                    IBlockState pot = MistBlocks.FLOWER_POT.func_176223_P();
                    world.func_180501_a(pos, pot, 3);
                    TileEntityFlowerPot te = MistFlowerPot.getTileEntity(world, pos);
                    if (te != null) {
                        if (event.getEntityPlayer().field_71075_bZ.field_75098_d) {
                            ItemStack fl = stack.func_77946_l();
                            fl.func_190920_e(1);
                            te.func_190614_a(fl);
                        } else {
                            te.func_190614_a(stack.func_77979_a(1));
                        }
                        te.func_70296_d();
                        world.func_184138_a(pos, pot, pot, 3);
                    }
                    event.setCanceled(true);
                    event.setCancellationResult(EnumActionResult.SUCCESS);
                }
            } else if (block == MistBlocks.CAMPFIRE && (stack.func_77973_b() instanceof ItemFlintAndSteel || stack.func_77973_b() instanceof ItemFood)) {
                event.setUseItem(Event.Result.DENY);
            }
            if (stack.func_77973_b() instanceof ItemBucket && !event.getEntityPlayer().field_70170_p.field_72995_K) {
                BlockPos pos1 = event.getPos();
                if (!event.getWorld().func_180495_p(pos1).func_185904_a().func_76222_j()) {
                    pos1 = pos1.func_177972_a(event.getFace());
                }
                waterPlayer = Pair.of((Object)pos1, (Object)event.getEntityPlayer());
            }
        }
    }

    public static void setMulchDelay(UUID uuid, int delay) {
        if (mulchDelay.containsKey(uuid)) {
            mulchDelay.replace(uuid, delay);
        } else {
            mulchDelay.put(uuid, delay);
        }
    }

    public static boolean isMulchDelay(UUID uuid) {
        return mulchDelay.containsKey(uuid);
    }

    @SubscribeEvent
    public void clickBlock(PlayerInteractEvent.LeftClickBlock event) {
        if (!event.getWorld().field_72995_K && !event.getEntityPlayer().func_184812_l_()) {
            IBlockState state = event.getWorld().func_180495_p(event.getPos());
            if (state.func_177230_c() instanceof BlockCrops) {
                if (event.getEntityPlayer() != null) {
                    ServerEventHandler.setMulchDelay(event.getEntityPlayer().func_110124_au(), 5);
                }
            } else if (state.func_177230_c() instanceof IFarmland && ((Boolean)state.func_177229_b((IProperty)IFarmland.MULCH)).booleanValue() && event.getHitVec().field_72448_b - (double)event.getPos().func_177956_o() > 0.9375 && !ServerEventHandler.isMulchDelay(event.getEntityPlayer().func_110124_au())) {
                IFarmland.extractMulch(event.getWorld(), event.getPos(), state);
            }
        }
    }

    @SubscribeEvent
    public void attachCapabilitiesPlayer(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(new ResourceLocation("mist", "container"), (ICapabilityProvider)new MistCapability.Provider(new MistCapaHandler()));
            event.addCapability(new ResourceLocation("mist", "food_capa"), (ICapabilityProvider)new FoodCapability.Provider());
            event.addCapability(new ResourceLocation("mist", "skill_capa"), (ICapabilityProvider)new SkillCapability.Provider());
        }
    }

    @SubscribeEvent
    public void joinEntity(EntityJoinWorldEvent event) {
        if (!event.getWorld().field_72995_K) {
            if (event.getEntity() instanceof EntityPlayerMP) {
                EntityPlayerMP playerMP = (EntityPlayerMP)event.getEntity();
                if (event.getWorld().field_73011_w.getDimension() == Mist.getID()) {
                    PacketHandler.INSTANCE.sendTo((IMessage)new PacketSeedSync(event.getWorld().func_72905_C()), playerMP);
                }
                PacketHandler.INSTANCE.sendTo((IMessage)new PacketTimeSync(MistTime.getDay(), MistTime.getMonth(), MistTime.getYear(), MistTime.getTimeOffset()), playerMP);
                IMistCapaHandler maskHandler = IMistCapaHandler.getHandler((EntityPlayer)playerMP);
                maskHandler.setMaskChanged(true, false);
                for (EntityPlayer player : playerMP.func_130014_f_().field_73010_i) {
                    if (player.func_145782_y() == playerMP.func_145782_y()) continue;
                    IMistCapaHandler playerMasks = IMistCapaHandler.getHandler(player);
                    playerMasks.setMaskChanged(true, true);
                }
                maskSync.put(playerMP.func_110124_au(), ItemStack.field_190927_a);
                PacketHandler.INSTANCE.sendTo((IMessage)new PacketSkillSync(ISkillCapaHandler.getHandler((EntityPlayer)playerMP).getSkillsArray()), playerMP);
                IFoodHandler foodHandler = IFoodHandler.getHandler((EntityPlayer)playerMP);
                PacketHandler.INSTANCE.sendTo((IMessage)new PacketMushroomSync(foodHandler.getMushroomList(false), false), playerMP);
                PacketHandler.INSTANCE.sendTo((IMessage)new PacketMushroomSync(foodHandler.getMushroomList(true), true), playerMP);
                PacketHandler.INSTANCE.sendTo((IMessage)new PacketToxicFoodSync(foodHandler.getFoodStudyList()), playerMP);
                IMistCapaHandler capa = IMistCapaHandler.getHandler((EntityPlayer)playerMP);
                PacketHandler.INSTANCE.sendTo((IMessage)new PacketToxicSync(capa.getPollution(), MistCapaHandler.HurtType.POLLUTION.getID()), playerMP);
                PacketHandler.INSTANCE.sendTo((IMessage)new PacketToxicSync(capa.getToxic(), MistCapaHandler.HurtType.TOXIC.getID()), playerMP);
            } else if (event.getEntity() instanceof EntityLiving) {
                ResourceLocation res;
                if (event.getWorld().field_73011_w.getDimension() == Mist.getID() && ((res = EntityList.func_191301_a((Entity)event.getEntity())) != null && MistRegistry.mobsDimsBlackList.contains(res.func_110624_b()) || MistRegistry.mobsBlackList.contains(res))) {
                    event.setCanceled(true);
                }
                if (event.getEntity() instanceof EntitySheep) {
                    EntitySheep sheep = (EntitySheep)event.getEntity();
                    sheep.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIEatMistGrass((EntityLiving)sheep, false));
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDim(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.fromDim == Mist.getID() || event.toDim == Mist.getID()) {
            portDelay.put(event.player.func_110124_au(), 200);
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP && !event.player.field_70170_p.field_72995_K) {
            TileEntityCampfire.updateColorsToClient((EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public void onPlayerConnectedToServer(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        ModConfig.applyFirePitColors(true);
    }

    @SubscribeEvent
    public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        maskSync.remove(event.player.func_110124_au());
    }

    @SubscribeEvent
    public void cloneCapabilitiesEvent(PlayerEvent.Clone event) {
        Object clone;
        NBTTagCompound nbt;
        Object original;
        try {
            original = (MistCapaHandler)IMistCapaHandler.getHandler(event.getOriginal());
            nbt = ((MistCapaHandler)original).serializeNBT();
            clone = (MistCapaHandler)IMistCapaHandler.getHandler(event.getEntityPlayer());
            ((MistCapaHandler)clone).deserializeNBT(nbt);
        }
        catch (Exception e) {
            Mist.logger.error("Could not clone player [" + event.getOriginal().func_70005_c_() + "] mask when changing dimensions");
        }
        try {
            original = (FoodHandler)IFoodHandler.getHandler(event.getOriginal());
            nbt = ((FoodHandler)original).serializeNBT();
            clone = (FoodHandler)IFoodHandler.getHandler(event.getEntityPlayer());
            ((FoodHandler)clone).deserializeNBT(nbt);
        }
        catch (Exception e) {
            Mist.logger.error("Could not clone player [" + event.getOriginal().func_70005_c_() + "] food study list when changing dimensions");
        }
        try {
            original = (SkillCapaHandler)ISkillCapaHandler.getHandler(event.getOriginal());
            nbt = ((SkillCapaHandler)original).serializeNBT();
            clone = (SkillCapaHandler)ISkillCapaHandler.getHandler(event.getEntityPlayer());
            ((SkillCapaHandler)clone).deserializeNBT(nbt);
        }
        catch (Exception e) {
            Mist.logger.error("Could not clone player [" + event.getOriginal().func_70005_c_() + "] skills list when changing dimensions");
        }
    }

    @SubscribeEvent
    public void playerAttacked(LivingAttackEvent event) {
        EntityPlayerMP player;
        if (!(event.getEntityLiving().field_70170_p.field_72995_K || !(event.getEntityLiving() instanceof EntityPlayerMP) || (player = (EntityPlayerMP)event.getEntityLiving()).func_184812_l_() || event.getSource().func_76363_c() && event.getSource() != MistWorld.DISSOLUTION)) {
            float damage;
            boolean asid = event.getSource() == MistWorld.DISSOLUTION;
            float f = damage = asid ? Math.min(event.getAmount(), 2.0f) / 4.0f : event.getAmount() / 4.0f;
            if (damage > 0.0f) {
                ItemStack armor;
                if (damage < 1.0f) {
                    damage = 1.0f;
                }
                if (asid) {
                    for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
                        ItemArmor.ArmorMaterial material;
                        if (slot.func_188453_a() != EntityEquipmentSlot.Type.ARMOR || !((armor = player.func_184582_a(slot)).func_77973_b() instanceof ItemArmor) || IMask.isMask(armor) || (material = ((ItemArmor)armor.func_77973_b()).func_82812_d()) == ItemArmor.ArmorMaterial.GOLD || material == ModItems.NIOBIUM_ARMOR || material == ModItems.RUBBER_MATERIAL) continue;
                        armor.func_77972_a((int)damage, (EntityLivingBase)player);
                        if (armor.func_190916_E() != 0) continue;
                        player.func_184201_a(slot, ItemStack.field_190927_a);
                    }
                } else if (event.getSource() != MistWorld.IN_FOG) {
                    for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
                        if (slot.func_188453_a() != EntityEquipmentSlot.Type.ARMOR) continue;
                        armor = player.func_184582_a(slot);
                        if (armor.func_77973_b() instanceof ISuit) {
                            armor.func_77972_a((int)damage, (EntityLivingBase)player);
                            if (armor.func_190916_E() != 0) continue;
                            player.func_184201_a(slot, ItemStack.field_190927_a);
                            continue;
                        }
                        NBTTagCompound tag = armor.func_179543_a("MistInnerSuit");
                        if (tag == null) continue;
                        ItemStack suit = new ItemStack(tag);
                        suit.func_77972_a((int)damage, (EntityLivingBase)player);
                        if (suit.func_190916_E() == 0) {
                            armor.func_190919_e("MistInnerSuit");
                            continue;
                        }
                        tag = suit.serializeNBT();
                        armor.func_77978_p().func_74782_a("MistInnerSuit", (NBTBase)tag);
                    }
                }
                if (player.func_70681_au().nextBoolean()) {
                    ItemStack mask = player.func_184582_a(EntityEquipmentSlot.HEAD);
                    boolean maskSlot = false;
                    if (!IMask.isMask(mask)) {
                        mask = IMistCapaHandler.getHandler((EntityPlayer)player).getMask();
                        maskSlot = true;
                    }
                    if (IMask.isMask(mask)) {
                        ItemStack filter;
                        boolean drop = false;
                        mask.func_77972_a((int)damage, (EntityLivingBase)player);
                        if (maskSlot) {
                            IMistCapaHandler maskHandler = IMistCapaHandler.getHandler((EntityPlayer)player);
                            if (maskHandler.getMask().func_190916_E() == 0) {
                                maskHandler.setStackInSlot(0, ItemStack.field_190927_a);
                                drop = true;
                            }
                        } else if (mask.func_190916_E() == 0) {
                            player.func_184201_a(EntityEquipmentSlot.HEAD, ItemStack.field_190927_a);
                            drop = true;
                        }
                        if (drop && !player.field_70170_p.field_72995_K && (filter = IMask.getFilter(mask)).func_77984_f()) {
                            player.func_70099_a(filter, 1.0f);
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void playerDeath(PlayerDropsEvent event) {
        World world = event.getEntity().field_70170_p;
        if (event.getEntity() instanceof EntityPlayer && !world.field_72995_K) {
            IMistCapaHandler capa = IMistCapaHandler.getHandler(event.getEntityPlayer());
            if (!capa.getMask().func_190926_b() && !event.getEntity().field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
                event.getEntityPlayer().func_70099_a(capa.getMask(), 1.0f);
                capa.setStackInSlot(0, ItemStack.field_190927_a);
            }
            if (world.field_73011_w.getDimension() == Mist.getID() && event.getEntityPlayer() instanceof EntityPlayerMP) {
                ServerEventHandler.setSpawnPos((EntityPlayerMP)event.getEntityPlayer());
            }
        }
    }

    public static void setSpawnPos(EntityPlayerMP player) {
        IBlockState state = null;
        BlockPos pos = player.getBedLocation(Mist.getID());
        if (pos != null) {
            state = DimensionManager.getWorld((int)Mist.getID()).func_180495_p(pos);
        }
        if (!(pos != null && state.func_177230_c().isBed(state, (IBlockAccess)player.field_70170_p, pos, (Entity)player) || (pos = PlayerLocationData.get(player.field_70170_p).getSpawnPos((EntityPlayer)player)) == null)) {
            player.setSpawnChunk(pos, true, Mist.getID());
            player.field_71135_a.func_147359_a((Packet)new SPacketSpawnPosition(pos));
        }
    }

    @SubscribeEvent
    public void playerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        EntityPlayer player = event.player;
        IMistCapaHandler capa = IMistCapaHandler.getHandler(player);
        int i = ModConfig.player.effectsReduction * 100;
        if (capa.getToxic() > i) {
            capa.setToxic(i);
        }
        if (capa.getPollution() > i) {
            capa.setPollution(i);
        }
    }

    @SubscribeEvent
    public void entityItemDead(ItemExpireEvent event) {
        BlockPos pos;
        World world = event.getEntity().field_70170_p;
        Item item = event.getEntityItem().func_92059_d().func_77973_b();
        if (item == MistItems.ROCKS || item == Items.field_151145_ak && world.field_73011_w.getDimension() == Mist.getID()) {
            BlockPos pos2 = event.getEntity().func_180425_c();
            if (world.func_180495_p(pos2).func_185904_a().func_76222_j() && world.isSideSolid(pos2.func_177977_b(), EnumFacing.UP)) {
                if (item == MistItems.ROCKS) {
                    world.func_175656_a(pos2, MistBlocks.LOOSE_ROCK.func_176223_P());
                } else {
                    world.func_175656_a(pos2, MistBlocks.LOOSE_ROCK.func_176223_P().func_177226_a((IProperty)MistLooseRock.TYPE, (Comparable)Integer.valueOf(1)));
                }
            }
        } else if (item == MistItems.REMAINS && world.func_180495_p(pos = event.getEntity().func_180425_c()).func_185904_a().func_76222_j() && world.isSideSolid(pos.func_177977_b(), EnumFacing.UP)) {
            world.func_175656_a(pos, MistBlocks.REMAINS.func_176223_P());
        }
    }

    public static void setSoundsTime(long sky_last, long sky_interval, long boom_last, long boom_interval) {
        last_sky_sounds_time = sky_last;
        sky_sounds_interval = sky_interval;
        last_sky_boom_time = boom_last;
        sky_boom_interval = boom_interval;
    }

    @SubscribeEvent
    public void onServerWorldTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            WorldServer world = DimensionManager.getWorld((int)0);
            MistTime.updateTime(world);
            if (waterPlayer != null) {
                waterPlayer = null;
            }
            if (breakPlayer != null) {
                breakPlayer = null;
            }
            if (sky_sounds_interval < 0L) {
                TimeData data = TimeData.get((World)world);
                data.getSoundsTime();
                if (sky_sounds_interval == 0L) {
                    sky_sounds_interval = 64000 + world.field_73012_v.nextInt(64000);
                    last_sky_sounds_time = world.func_82737_E();
                }
                if (sky_boom_interval == 0L) {
                    sky_boom_interval = 6000 + world.field_73012_v.nextInt(18000);
                    last_sky_boom_time = world.func_82737_E();
                }
                data.setSoundsTime(last_sky_sounds_time, sky_sounds_interval, last_sky_boom_time, sky_boom_interval);
            }
            if (world.func_82737_E() - last_sky_sounds_time >= sky_sounds_interval) {
                PacketHandler.INSTANCE.sendToDimension((IMessage)new PacketSkySound(PacketSkySound.SkySoundType.AMBIENT, 4.0f), Mist.getID());
                sky_sounds_interval = 64000 + world.field_73012_v.nextInt(64000);
                last_sky_sounds_time = world.func_82737_E();
                panic_Time = 600;
                TimeData.get((World)world).setSoundsTime(last_sky_sounds_time, sky_sounds_interval, last_sky_boom_time, sky_boom_interval);
            }
            if (world.func_82737_E() - last_sky_boom_time >= sky_boom_interval) {
                PacketHandler.INSTANCE.sendToDimension((IMessage)new PacketSkySound(PacketSkySound.SkySoundType.BOOM, 3.0f + world.field_73012_v.nextFloat() * 3.0f), Mist.getID());
                if (boom_count > 0 || world.field_73012_v.nextBoolean()) {
                    boom_count = boom_count > 0 ? --boom_count : world.field_73012_v.nextInt(world.field_73012_v.nextInt(7) + 1);
                    sky_boom_interval = 20 + world.field_73012_v.nextInt(world.field_73012_v.nextInt(200) + 1);
                } else {
                    sky_boom_interval = 6000 + world.field_73012_v.nextInt(18000);
                }
                last_sky_boom_time = world.func_82737_E();
                TimeData.get((World)world).setSoundsTime(last_sky_sounds_time, sky_sounds_interval, last_sky_boom_time, sky_boom_interval);
            }
            if (panic_Time > 0 && --panic_Time % 100 == 99) {
                ambientSoundsTimer = 500;
                WorldServer mist = DimensionManager.getWorld((int)Mist.getID());
                if (mist != null) {
                    for (Entity entity : mist.field_72996_f) {
                        if (!(entity instanceof EntityLivingBase)) continue;
                        ((EntityLivingBase)entity).func_70604_c((EntityLivingBase)entity);
                    }
                }
            }
            if (world.func_72896_J() && ambientSoundsTimer < 200) {
                ambientSoundsTimer = 300;
            }
            if (ambientSoundsTimer > 0) {
                --ambientSoundsTimer;
            }
        }
    }

    @SubscribeEvent
    public void onMobsDeath(LivingDeathEvent event) {
        ResourceLocation res;
        Entity mob;
        Entity entity = event.getSource().func_76346_g();
        if (entity instanceof EntityPlayer && !((EntityPlayer)entity).field_71075_bZ.field_75098_d && (mob = event.getEntity()) instanceof EntityLiving && !(mob instanceof IMob) && (res = EntityList.func_191301_a((Entity)mob)) != null) {
            int point = 0;
            if (MistRegistry.dimsForSkill.containsKey(res.func_110624_b())) {
                point = MistRegistry.dimsForSkill.get(res.func_110624_b());
            }
            if (MistRegistry.mobsForSkill.containsKey(res)) {
                point = MistRegistry.mobsForSkill.get(res);
            }
            if (point > 0) {
                ISkillCapaHandler.getHandler((EntityPlayer)entity).addSkill(ISkillCapaHandler.Skill.CUTTING, point);
            }
        }
    }

    @SubscribeEvent
    public void getXPOrb(PlayerPickupXpEvent event) {
        IMistCapaHandler maskHandler;
        ItemStack mask;
        if (!event.getEntityPlayer().field_70170_p.field_72995_K && !(mask = (maskHandler = IMistCapaHandler.getHandler(event.getEntityPlayer())).getMask()).func_190926_b() && mask.func_77951_h() && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185296_A, (ItemStack)mask) > 0) {
            event.getEntityPlayer().field_71090_bL = 2;
            event.getOrb().field_70170_p.func_184148_a(null, event.getEntityPlayer().field_70165_t, event.getEntityPlayer().field_70163_u, event.getEntityPlayer().field_70161_v, SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.1f, 0.5f * ((event.getEntityPlayer().func_70681_au().nextFloat() - event.getEntityPlayer().func_70681_au().nextFloat()) * 0.7f + 1.8f));
            event.getEntityPlayer().func_71001_a((Entity)event.getOrb(), 1);
            List iterable = Enchantments.field_185296_A.func_185260_a((EntityLivingBase)event.getEntityPlayer());
            ArrayList list = Lists.newArrayList();
            if (iterable != null) {
                for (ItemStack itemstack : iterable) {
                    if (itemstack.func_190926_b() || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185296_A, (ItemStack)itemstack) <= 0) continue;
                    list.add(itemstack);
                }
            }
            list.add(mask);
            ItemStack itemstack = (ItemStack)list.get(event.getEntityPlayer().func_70681_au().nextInt(list.size()));
            if (!itemstack.func_190926_b() && itemstack.func_77951_h()) {
                int i = Math.min(event.getOrb().field_70530_e * 2, itemstack.func_77952_i());
                event.getOrb().field_70530_e -= i / 2;
                itemstack.func_77964_b(itemstack.func_77952_i() - i);
            }
            if (event.getOrb().field_70530_e > 0) {
                event.getEntityPlayer().func_71023_q(event.getOrb().field_70530_e);
            }
            event.getOrb().func_70106_y();
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void fogDamage(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        FogDamage.calculateFogDamage(entity);
    }

    @SubscribeEvent
    public void itemUseStart(LivingEntityUseItemEvent.Start event) {
        if (!event.getEntity().field_70170_p.field_72995_K && event.getItem().func_77973_b() == Items.field_151117_aB && event.getEntityLiving() instanceof EntityPlayer) {
            milkCheck.add(event.getEntityLiving().func_110124_au());
        }
    }

    @SubscribeEvent
    public void itemUseStop(LivingEntityUseItemEvent.Stop event) {
        if (!event.getEntity().field_70170_p.field_72995_K && milkCheck.contains(event.getEntityLiving().func_110124_au())) {
            milkCheck.remove(event.getEntityLiving().func_110124_au());
        }
    }

    @SubscribeEvent
    public void itemUseFinish(LivingEntityUseItemEvent.Finish event) {
        ItemStack stack;
        Item item;
        if (!event.getEntity().field_70170_p.field_72995_K && event.getEntityLiving() instanceof EntityPlayer && ((item = (stack = event.getItem()).func_77973_b()).func_77661_b(stack) == EnumAction.EAT || item.func_77661_b(stack) == EnumAction.DRINK)) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            boolean fog = MistWorld.isPosInFog(player.field_70170_p, (float)player.field_70163_u + player.eyeHeight);
            IMistCapaHandler capa = IMistCapaHandler.getHandler(player);
            if (capa != null) {
                if (milkCheck.contains(player.func_110124_au())) {
                    if (!fog) {
                        capa.addToxic(-20);
                        milkCheck.remove(event.getEntityLiving().func_110124_au());
                    }
                } else if (fog && item != MistItems.GLASS_CONTAINER) {
                    capa.addToxic(32);
                }
            }
        }
    }

    @SubscribeEvent
    public void createFluidSource(BlockEvent.CreateFluidSourceEvent event) {
        if (!event.getWorld().field_72995_K) {
            if (event.getState().func_177230_c() == Blocks.field_150358_i) {
                if (MistWorld.isPosInFog(event.getWorld(), event.getPos().func_177981_b(8))) {
                    event.setResult(Event.Result.DENY);
                }
            } else if (event.getState().func_177230_c() == MistBlocks.ACID_BLOCK) {
                if (MistWorld.isPosInFog(event.getWorld(), event.getPos().func_177981_b(8))) {
                    event.setResult(Event.Result.ALLOW);
                } else {
                    event.setResult(Event.Result.DENY);
                }
            }
        }
    }

    @SubscribeEvent
    public void burningTime(FurnaceFuelBurnTimeEvent event) {
        int i = this.getBurnTime(event.getItemStack());
        if (i > 0) {
            event.setBurnTime(i);
        }
    }

    private int getBurnTime(ItemStack fuel) {
        Item item = fuel.func_77973_b();
        if (item instanceof ItemBlock && Block.func_149634_a((Item)item) != Blocks.field_150350_a) {
            Block block = Block.func_149634_a((Item)item);
            if (block instanceof MistWoodBlock) {
                int meta = fuel.func_77952_i();
                if (meta == 0 || meta == 3) {
                    return 640;
                }
                if (meta == 4) {
                    return 620;
                }
                return 600;
            }
            if (block instanceof MistBlockStairs && block.func_176223_P().func_185904_a() == Material.field_151575_d) {
                return 450;
            }
            if (block instanceof MistBlockSlab && block.func_176223_P().func_185904_a() == Material.field_151575_d) {
                return 300;
            }
            if (block instanceof MistBlockStep && block.func_176223_P().func_185904_a() == Material.field_151575_d) {
                return 150;
            }
            if (block instanceof MistBlockBranch && block.func_176223_P().func_185904_a() == Material.field_151575_d) {
                int meta = fuel.func_77952_i();
                if (meta == 0) {
                    return 120;
                }
                if (meta == 3) {
                    return 100;
                }
                if (meta == 6) {
                    return 170;
                }
                if (meta == 9) {
                    return 150;
                }
            }
            if (block == MistBlocks.FILTER_COAL_BLOCK) {
                return (16 - fuel.func_77952_i()) * 1000;
            }
            if (block == MistBlocks.BIO_SHALE_BLOCK) {
                return 16000;
            }
            if (block == MistBlocks.PEAT && fuel.func_77952_i() == 1) {
                return 2400;
            }
            if (block == MistBlocks.SAPROPEL && fuel.func_77952_i() == 1) {
                return 1200;
            }
            if (block == MistBlocks.MULCH_BLOCK) {
                return 180;
            }
        }
        if (item == MistItems.FILTER_COAL) {
            return Math.max(1, 1600 * (fuel.func_77958_k() - fuel.func_77952_i()) / fuel.func_77958_k());
        }
        if (item == MistItems.BIO_SHALE) {
            return 1600;
        }
        if (item == MistItems.MULCH) {
            return 20;
        }
        return -1;
    }

    @SubscribeEvent
    public void useHoeEvent(UseHoeEvent event) {
        BlockPos pos;
        World world = event.getWorld();
        IBlockState state = world.func_180495_p(pos = event.getPos());
        if (state.func_177230_c() instanceof MistSoil && !(state.func_177230_c() instanceof IFarmland) && world.func_175623_d(pos.func_177984_a())) {
            world.func_184133_a(event.getEntityPlayer(), pos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (!world.field_72995_K) {
                world.func_175656_a(pos, ((MistSoil)state.func_177230_c()).getFarmState(state));
            }
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public void cropGrow(BlockEvent.CropGrowEvent.Pre event) {
        if (!event.getWorld().field_72995_K && event.getState().func_177230_c() instanceof BlockCrops) {
            if (MistWorld.isPosInFog(event.getWorld(), event.getPos())) {
                event.getWorld().func_175655_b(event.getPos(), false);
                event.setResult(Event.Result.DENY);
            } else {
                IBlockState soil = event.getWorld().func_180495_p(event.getPos().func_177977_b());
                if (soil.func_177230_c() instanceof MistSoil) {
                    if (((Boolean)soil.func_177229_b((IProperty)IWettable.WET)).booleanValue() && SoilHelper.getHumus(soil) > 0) {
                        if (IMistHarvest.isSoilSuitable(event.getState().func_177230_c(), soil)) {
                            event.setResult(Event.Result.DEFAULT);
                        } else if (event.getWorld().field_73012_v.nextBoolean()) {
                            event.setResult(Event.Result.DEFAULT);
                        } else {
                            event.setResult(Event.Result.DENY);
                        }
                    } else {
                        event.setResult(Event.Result.DENY);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void cropGrow(BlockEvent.CropGrowEvent.Post event) {
        IBlockState soil;
        if (!event.getWorld().field_72995_K && event.getState().func_177230_c() instanceof BlockCrops && (soil = event.getWorld().func_180495_p(event.getPos().func_177977_b())).func_177230_c() instanceof MistSoil && SoilHelper.getHumus(soil) > 0 && ((BlockCrops)event.getState().func_177230_c()).func_185525_y(event.getState())) {
            SoilHelper.setSoil(event.getWorld(), event.getPos().func_177977_b(), soil, SoilHelper.getHumus(soil) - 1, true, 2);
        }
    }

    @SubscribeEvent
    public void bonemealEvent(BonemealEvent event) {
        if (event.getBlock().func_177230_c() instanceof BlockCrops) {
            IBlockState soil = event.getWorld().func_180495_p(event.getPos().func_177977_b());
            int humus = SoilHelper.getHumus(soil);
            if (soil.func_177230_c() instanceof MistSoil) {
                if (((Boolean)soil.func_177229_b((IProperty)IWettable.WET)).booleanValue() && humus > 0) {
                    SoilHelper.setSoil(event.getWorld(), event.getPos().func_177977_b(), soil, humus - 1, true, 2);
                } else {
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public void harvestCheck(PlayerEvent.HarvestCheck event) {
        if (event.getTargetBlock().func_177230_c() instanceof MistChest) {
            event.setCanHarvest(true);
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("mist")) {
            ModConfig.onConfigChange();
        }
    }

    @SubscribeEvent
    public void loadWorld(WorldEvent.Load event) {
        TimeData.get(event.getWorld()).loadTime();
    }

    @SubscribeEvent
    public void onChunkLoad(ChunkEvent.Load event) {
        if (event.getWorld().field_73011_w.getDimension() == Mist.getID()) {
            MistWorld.seasonalTest(event.getChunk());
        }
    }

    @SubscribeEvent
    public void onMissingSoundsMapping(RegistryEvent.MissingMappings<SoundEvent> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            switch (mapping.key.toString()) {
                case "mist:mist_up_music": {
                    mapping.remap(ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("mist", "mist_up_day_music")));
                }
            }
        }
    }

    static {
        sky_sounds_interval = -1L;
        sky_boom_interval = -1L;
        ambientSoundsTimer = 0;
    }
}

