/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.handlers;

import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.common.Mist;
import ru.liahim.mist.init.ModConfig;
import ru.liahim.mist.shader.ShaderProgram;
import ru.liahim.mist.util.FogTexture;
import ru.liahim.mist.world.MistWorld;

public class FogRenderer {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static final ResourceLocation locationFogPng = new ResourceLocation("mist:textures/environment/fog.png");
    private static final ResourceLocation CLOUDS_TEXTURES = new ResourceLocation("textures/environment/clouds.png");
    public static float fogHeight = MistWorld.getFogMaxHight() + 4;
    public static float depth;
    public static float density;
    public static float red;
    public static float green;
    public static float blue;
    public static float cel;
    private boolean inBlock;
    private int prevPlayerTick;
    private int cloudTickCounter;
    private boolean aboveClouds;
    private float roof;
    private static int planeCount;
    private static float layerRange;
    private static float colorRange;
    private static float alpha;
    private static int viewX;
    private static int viewY;
    private static int viewZ;
    private static boolean shadowInit;
    private static float shadowMultiplier;

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void renderEvent(TickEvent.RenderTickEvent e) {
        Entity entity;
        if (e.phase == TickEvent.Phase.START && e.side == Side.CLIENT && (entity = mc.func_175606_aa()) != null) {
            World world = entity.field_70170_p;
            if (world.field_72995_K && world.field_73011_w.getDimension() == Mist.getID()) {
                float f = MathHelper.func_76134_b((float)(world.func_72826_c(e.renderTickTime) * ((float)Math.PI * 2))) * 2.0f + 0.5f;
                cel = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
                this.roof += (this.getRoof(world, new BlockPos(entity).func_177984_a().func_177982_a((int)(-(Math.sin(Math.toRadians(entity.field_70177_z)) * 4.0)), 0, (int)(Math.cos(Math.toRadians(entity.field_70177_z)) * 4.0))) - this.roof) * 0.1f;
                fogHeight = MistWorld.getFogHight(world, e.renderTickTime) + 4.0f;
                depth = (float)((double)fogHeight - entity.func_174824_e((float)e.renderTickTime).field_72448_b);
                if (this.prevPlayerTick != entity.field_70173_aa) {
                    ++this.cloudTickCounter;
                    this.prevPlayerTick = entity.field_70173_aa;
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void fogDensity(EntityViewRenderEvent.FogDensity e) {
        Entity entity = e.getEntity();
        World world = entity.field_70170_p;
        if (world.field_72995_K && world.field_73011_w.getDimension() == Mist.getID()) {
            float tick = (float)e.getRenderPartialTicks();
            float densityUp = Math.max(0.004f, 0.064f / (float)FogRenderer.mc.field_71474_y.field_151451_c) + world.func_72867_j(tick) * 0.005f + this.getMorningFog(world, tick);
            float densityBorder = 0.15f;
            float densityDown = 0.08f;
            float depth = FogRenderer.depth;
            if (depth < 0.0f) {
                density = densityUp;
                GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.EXP2);
            } else if (depth < 4.0f) {
                density = this.calculate(densityUp, densityBorder, densityUp, densityBorder, depth, 4.0f);
                GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.EXP);
            } else if (depth < 8.0f) {
                density = this.calculate(densityBorder, densityDown, densityDown, densityBorder, depth - 4.0f, 4.0f);
                GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.EXP);
            } else {
                density = densityDown;
                GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.EXP);
            }
            if (entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_70644_a(MobEffects.field_76440_q)) {
                float d1 = 0.3f;
                int i = ((EntityLivingBase)entity).func_70660_b(MobEffects.field_76440_q).func_76459_b();
                if (i < 20) {
                    d1 = density + (d1 - density) * (float)i / 20.0f;
                }
                density = d1;
            } else if (e.getState().func_185904_a() == Material.field_151586_h) {
                GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.EXP);
                density = entity instanceof EntityLivingBase ? (((EntityLivingBase)entity).func_70644_a(MobEffects.field_76427_o) ? Math.max(density, 0.01f) : Math.max(density, 0.1f - (float)EnchantmentHelper.func_185292_c((EntityLivingBase)((EntityLivingBase)entity)) * 0.03f)) : 0.1f;
            } else if (e.getState().func_185904_a() == Material.field_151587_i) {
                GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.EXP);
                density = 2.0f;
            }
            e.setDensity(density);
            e.setCanceled(true);
        }
    }

    private float getMorningFog(World world, float tick) {
        float i = (float)((world.func_72820_D() + 23000L) % 24000L) + tick;
        i = Math.abs(21000.0f - i);
        i = 3000.0f - MathHelper.func_76131_a((float)i, (float)0.0f, (float)3000.0f);
        return i / 600000.0f;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void fogColor(EntityViewRenderEvent.FogColors e) {
        Entity entity = e.getEntity();
        World world = entity.field_70170_p;
        if (world.field_72995_K && world.field_73011_w.getDimension() == Mist.getID()) {
            if (e.getState().func_185904_a() != Material.field_151586_h && e.getState().func_185904_a() != Material.field_151587_i) {
                float b;
                float r;
                float tick = (float)e.getRenderPartialTicks();
                float depth = FogRenderer.depth;
                if (depth < 0.0f) {
                    Vec3d colUp = this.getFogUpColor(world, tick);
                    red = (float)colUp.field_72450_a;
                    green = (float)colUp.field_72448_b;
                    blue = (float)colUp.field_72449_c;
                } else if (depth < 4.0f) {
                    Vec3d colUp = this.getFogUpColor(world, tick);
                    Vec3d colBorder = this.getFogBorderColor(world, tick);
                    float rUp = (float)colUp.field_72450_a;
                    float gUp = (float)colUp.field_72448_b;
                    float bUp = (float)colUp.field_72449_c;
                    float rBorder = (float)colBorder.field_72450_a;
                    float gBorder = (float)colBorder.field_72448_b;
                    float bBorder = (float)colBorder.field_72449_c;
                    r = this.calculate(rUp, rBorder, Math.min(rUp, rBorder), Math.max(rUp, rBorder), depth, 4.0f);
                    float g = this.calculate(gUp, gBorder, Math.min(gUp, gBorder), Math.max(gUp, gBorder), depth, 4.0f);
                    b = this.calculate(bUp, bBorder, Math.min(bUp, bBorder), Math.max(bUp, bBorder), depth, 4.0f);
                    red = r;
                    green = g;
                    blue = b;
                } else if (depth < 8.0f) {
                    Vec3d colBorder = this.getFogBorderColor(world, tick);
                    Vec3d colDown = this.getFogDownColor(world, tick);
                    float rBorder = (float)colBorder.field_72450_a;
                    float gBorder = (float)colBorder.field_72448_b;
                    float bBorder = (float)colBorder.field_72449_c;
                    float rDown = (float)colDown.field_72450_a;
                    float gDown = (float)colDown.field_72448_b;
                    float bDown = (float)colDown.field_72449_c;
                    r = this.calculate(rBorder, rDown, Math.min(rBorder, rDown), Math.max(rBorder, rDown), depth - 4.0f, 4.0f);
                    float g = this.calculate(gBorder, gDown, Math.min(gBorder, gDown), Math.max(gBorder, gDown), depth - 4.0f, 4.0f);
                    b = this.calculate(bBorder, bDown, Math.min(bBorder, bDown), Math.max(bBorder, bDown), depth - 4.0f, 4.0f);
                    red = r;
                    green = g;
                    blue = b;
                } else {
                    Vec3d colDown = this.getFogDownColor(world, tick);
                    red = (float)colDown.field_72450_a;
                    green = (float)colDown.field_72448_b;
                    blue = (float)colDown.field_72449_c;
                }
                double d1 = (entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * e.getRenderPartialTicks()) * world.field_73011_w.func_76565_k();
                if (entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_70644_a(MobEffects.field_76440_q)) {
                    int i = ((EntityLivingBase)entity).func_70660_b(MobEffects.field_76440_q).func_76459_b();
                    d1 = i < 20 ? (d1 *= (double)(1.0f - (float)i / 20.0f)) : 0.0;
                }
                if (d1 < 1.0) {
                    if (d1 < 0.0) {
                        d1 = 0.0;
                    }
                    d1 *= d1;
                    red = (float)((double)red * d1);
                    green = (float)((double)green * d1);
                    blue = (float)((double)blue * d1);
                }
                if (FogRenderer.mc.field_71474_y.field_74337_g) {
                    float fr = (red * 30.0f + green * 59.0f + blue * 11.0f) / 100.0f;
                    float fg = (red * 30.0f + green * 70.0f) / 100.0f;
                    float fb = (red * 30.0f + blue * 70.0f) / 100.0f;
                    red = fr;
                    green = fg;
                    blue = fb;
                }
            } else if (e.getState().func_185904_a() == Material.field_151586_h) {
                float wb = 0.0f;
                if (entity instanceof EntityLivingBase && depth < 0.0f) {
                    wb = (float)EnchantmentHelper.func_185292_c((EntityLivingBase)((EntityLivingBase)entity)) * 0.2f;
                    if (((EntityLivingBase)entity).func_70644_a(MobEffects.field_76427_o)) {
                        wb = wb * 0.3f + 0.6f;
                    }
                }
                red = 0.02f + wb;
                green = 0.02f + wb;
                blue = 0.2f + wb;
            } else if (e.getState().func_185904_a() == Material.field_151587_i) {
                red = 0.6f;
                green = 0.1f;
                blue = 0.0f;
            }
            e.setRed(red);
            e.setGreen(green);
            e.setBlue(blue);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private Vec3d getFogUpColor(World world, float partialTicks, float cel) {
        float thunder;
        Entity entity = mc.func_175606_aa();
        float d = 0.25f + 0.75f * (float)FogRenderer.mc.field_71474_y.field_151451_c / 32.0f;
        d = 1.0f - (float)Math.pow(d, 0.25);
        Vec3d vec3d = world.func_72833_a(entity, partialTicks);
        float f1 = (float)vec3d.field_72450_a;
        float f2 = (float)vec3d.field_72448_b;
        float f3 = (float)vec3d.field_72449_c;
        float r = 0.627451f;
        float g = 0.8235294f;
        float b = 0.8235294f;
        r *= cel * 0.82f + 0.18f;
        g *= cel * 0.79f + 0.21f;
        b *= cel * 0.81f + 0.19f;
        if (FogRenderer.mc.field_71474_y.field_151451_c >= 4) {
            float[] afloat;
            double d0 = MathHelper.func_76126_a((float)world.func_72929_e(partialTicks)) > 0.0f ? -1.0 : 1.0;
            Vec3d vec3d2 = new Vec3d(d0, 0.0, 0.0);
            float f = (float)entity.func_70676_i(partialTicks).func_72430_b(vec3d2);
            if (f < 0.0f) {
                f = 0.0f;
            }
            if (f > 0.0f && (afloat = world.field_73011_w.func_76560_a(world.func_72826_c(partialTicks), partialTicks)) != null) {
                r = r * (1.0f - (f *= afloat[3])) + afloat[0] * f;
                g = g * (1.0f - f) + afloat[1] * f;
                b = b * (1.0f - f) + afloat[2] * f;
            }
        }
        r += (f1 - r) * d;
        g += (f2 - g) * d;
        b += (f3 - b) * d;
        float rain = world.func_72867_j(partialTicks);
        if (rain > 0.0f) {
            float f4 = 1.0f - rain * 0.4f;
            float f5 = 1.0f - rain * 0.38f;
            r *= f4;
            g *= f4;
            b *= f5;
        }
        if ((thunder = world.func_72819_i(partialTicks)) > 0.0f) {
            float f6 = 1.0f - thunder * 0.58f;
            float f7 = 1.0f - thunder * 0.56f;
            r *= f6;
            g *= f6;
            b *= f7;
        }
        r *= 0.75f + 0.25f * this.roof;
        g *= 0.8f + 0.2f * this.roof;
        b *= 0.85f + 0.15f * this.roof;
        if (entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_70644_a(MobEffects.field_76439_r)) {
            float f8 = this.getNightVisionBrightness((EntityLivingBase)entity, partialTicks);
            float f9 = 1.0f / r;
            if (f9 > 1.0f / g) {
                f9 = 1.0f / g;
            }
            if (f9 > 1.0f / b) {
                f9 = 1.0f / b;
            }
            r = r * (1.0f - f8 * 0.5f) + r * f9 * f8 * 0.5f;
            g = g * (1.0f - f8 * 0.4f) + g * f9 * f8 * 0.4f;
            b = b * (1.0f - f8 * 0.65f) + b * f9 * f8 * 0.65f;
        }
        return new Vec3d((double)r, (double)g, (double)b);
    }

    @SideOnly(value=Side.CLIENT)
    private Vec3d getFogBorderColor(World world, float partialTicks, float cel) {
        float thunder;
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        r *= cel * 0.62f + 0.38f;
        g *= cel * 0.59f + 0.41f;
        b *= cel * 0.56f + 0.44f;
        float rain = world.func_72867_j(partialTicks);
        if (rain > 0.0f) {
            float f4 = 1.0f - rain * 0.45f * cel;
            float f5 = 1.0f - rain * 0.38f * cel;
            r *= f4;
            g *= f5;
            b *= f5;
        }
        if ((thunder = world.func_72819_i(partialTicks)) > 0.0f) {
            float f6 = 1.0f - thunder * 0.48f * cel;
            float f7 = 1.0f - thunder * 0.42f * cel;
            float f8 = 1.0f - thunder * 0.39f * cel;
            r *= f6;
            g *= f7;
            b *= f8;
        }
        r = r * this.roof + 0.5f * (1.0f - this.roof);
        g = g * this.roof + 0.6f * (1.0f - this.roof);
        b = b * this.roof + 0.7f * (1.0f - this.roof);
        Entity entity = mc.func_175606_aa();
        if (entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_70644_a(MobEffects.field_76439_r)) {
            float f8 = this.getNightVisionBrightness((EntityLivingBase)entity, partialTicks);
            float f9 = 1.0f / r;
            if (f9 > 1.0f / g) {
                f9 = 1.0f / g;
            }
            if (f9 > 1.0f / b) {
                f9 = 1.0f / b;
            }
            r = r * (1.0f - f8) + r * f9 * f8;
            g = g * (1.0f - f8 * 0.95f) + g * f9 * f8 * 0.95f;
            b = b * (1.0f - f8) + b * f9 * f8;
        }
        return new Vec3d((double)r, (double)g, (double)b);
    }

    @SideOnly(value=Side.CLIENT)
    private Vec3d getFogDownColor(World world, float partialTicks, float cel) {
        float thunder;
        float r = 0.63f;
        float g = 0.7f;
        float b = 0.67f;
        r *= cel * 0.75f + 0.25f;
        g *= cel * 0.7f + 0.3f;
        b *= cel * 0.65f + 0.35f;
        float rain = world.func_72867_j(partialTicks);
        if (rain > 0.0f) {
            float f4 = 1.0f - rain * 0.4f * cel;
            float f5 = 1.0f - rain * 0.35f * cel;
            r *= f4;
            g *= f5;
            b *= f5;
        }
        if ((thunder = world.func_72819_i(partialTicks)) > 0.0f) {
            float f6 = 1.0f - thunder * 0.5f * cel;
            float f7 = 1.0f - thunder * 0.45f * cel;
            float f8 = 1.0f - thunder * 0.4f * cel;
            r *= f6;
            g *= f7;
            b *= f8;
        }
        if (world.func_175658_ac() > 0) {
            float f10 = (float)world.func_175658_ac() - partialTicks;
            if (f10 > 1.0f) {
                f10 = 1.0f;
            }
            r = r * (1.0f - (f10 *= 0.25f)) + 0.8f * f10;
            g = g * (1.0f - f10) + 0.8f * f10;
            b = b * (1.0f - f10) + 1.0f * f10;
        }
        r = r * this.roof + 0.1f * (1.0f - this.roof);
        g = g * this.roof + 0.12f * (1.0f - this.roof);
        b = b * this.roof + 0.15f * (1.0f - this.roof);
        Entity entity = mc.func_175606_aa();
        if (entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_70644_a(MobEffects.field_76439_r)) {
            float f8 = this.getNightVisionBrightness((EntityLivingBase)entity, partialTicks);
            float f9 = 1.0f / r;
            if (f9 > 1.0f / g) {
                f9 = 1.0f / g;
            }
            if (f9 > 1.0f / b) {
                f9 = 1.0f / b;
            }
            r = r * (1.0f - f8 * (0.85f + 0.1f * this.roof)) + r * f9 * f8 * (0.85f + 0.1f * this.roof);
            g = g * (1.0f - f8 * 0.85f) + g * f9 * f8 * 0.85f;
            b = b * (1.0f - f8 * (1.0f - 0.1f * this.roof)) + b * f9 * f8 * (1.0f - 0.1f * this.roof);
        }
        return new Vec3d((double)r, (double)g, (double)b);
    }

    @SideOnly(value=Side.CLIENT)
    private Vec3d getFogLayerColor(World world, float partialTicks, float cel) {
        float f9;
        float f8;
        float thunder;
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        r *= cel * 0.85f + 0.15f;
        g *= cel * 0.82f + 0.18f;
        b *= cel * 0.8f + 0.2f;
        float rain = world.func_72867_j(partialTicks);
        if (rain > 0.0f) {
            float f4 = 1.0f - rain * 0.4f * cel;
            float f5 = 1.0f - rain * 0.38f * cel;
            float f6 = 1.0f - rain * 0.35f * cel;
            r *= f4;
            g *= f5;
            b *= f6;
        }
        if ((thunder = world.func_72819_i(partialTicks)) > 0.0f) {
            float f7 = 1.0f - thunder * 0.55f * cel;
            f8 = 1.0f - thunder * 0.5f * cel;
            f9 = 1.0f - thunder * 0.45f * cel;
            r *= f7;
            g *= f8;
            b *= f9;
        }
        r *= 0.75f + 0.25f * this.roof;
        g *= 0.8f + 0.2f * this.roof;
        b *= 0.85f + 0.15f * this.roof;
        Entity entity = mc.func_175606_aa();
        if (entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_70644_a(MobEffects.field_76439_r)) {
            f8 = this.getNightVisionBrightness((EntityLivingBase)entity, partialTicks);
            f9 = 1.0f / r;
            if (f9 > 1.0f / g) {
                f9 = 1.0f / g;
            }
            if (f9 > 1.0f / b) {
                f9 = 1.0f / b;
            }
            r = r * (1.0f - f8) + r * f9 * f8;
            g = g * (1.0f - f8) + g * f9 * f8;
            b = b * (1.0f - f8) + b * f9 * f8;
        }
        return new Vec3d((double)r, (double)g, (double)b);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void renderEvent(RenderWorldLastEvent e) {
        World world = FogRenderer.mc.field_71439_g.field_70170_p;
        if (world.field_72995_K && world.field_73011_w.getDimension() == Mist.getID()) {
            if (this.inBlock || this.aboveClouds) {
                if (this.inBlock) {
                    if (ModConfig.graphic.advancedFogRenderer) {
                        this.fogRender(e.getPartialTicks(), (WorldClient)world, mc);
                    } else {
                        this.fogRenderOld(e.getPartialTicks(), (WorldClient)world, mc);
                    }
                }
                this.renderCloudsCheck(e.getPartialTicks());
                GlStateManager.func_179106_n();
            }
            this.inBlock = true;
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void renderEvent(DrawBlockHighlightEvent e) {
        World world = FogRenderer.mc.field_71439_g.field_70170_p;
        if (world.field_72995_K && world.field_73011_w.getDimension() == Mist.getID()) {
            Entity entity = mc.func_175606_aa();
            e.getContext().func_72731_b((EntityPlayer)FogRenderer.mc.field_71439_g, FogRenderer.mc.field_71476_x, 0, e.getPartialTicks());
            if (ModConfig.graphic.advancedFogRenderer) {
                this.fogRender(e.getPartialTicks(), (WorldClient)world, mc);
            } else {
                this.fogRenderOld(e.getPartialTicks(), (WorldClient)world, mc);
            }
            if (entity.field_70163_u + (double)entity.func_70047_e() < (double)FogRenderer.mc.field_71441_e.field_73011_w.func_76571_f()) {
                GlStateManager.func_179141_d();
                this.renderCloudsCheck(e.getPartialTicks());
                GlStateManager.func_179118_c();
                this.aboveClouds = false;
            } else {
                this.aboveClouds = true;
            }
            this.inBlock = false;
        }
    }

    public static void updateFogQuality() {
        planeCount = (int)Math.pow(2.0, ModConfig.graphic.fogQuality + 1);
        layerRange = 4.0f / (float)planeCount;
        colorRange = 0.65f / (float)planeCount;
        alpha = Math.min(1.0f, 5.0f / (float)planeCount);
    }

    private void fogRender(float partialTicks, WorldClient world, Minecraft mc) {
        float f4;
        float f3;
        float f2;
        int temp;
        Entity entity = mc.func_175606_aa();
        float cameraHeight = mc.func_175606_aa().func_70047_e();
        float playerHeight = (float)(entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks);
        double playerX = entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)partialTicks;
        double playerZ = entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)partialTicks;
        int cX = MathHelper.func_76128_c((double)(playerX / 16.0));
        int cZ = MathHelper.func_76128_c((double)(playerZ / 16.0));
        int n = temp = depth < 4.0f ? MathHelper.func_76141_d((float)(fogHeight - 0.0025f)) : MathHelper.func_76123_f((float)(fogHeight - 9.0f + 0.0025f));
        if (FogTexture.chunkX != cX || FogTexture.chunkZ != cZ || FogTexture.fogHeight != temp) {
            FogTexture.chunkX = cX;
            FogTexture.chunkZ = cZ;
            FogTexture.fogHeight = temp;
            FogTexture.createFogTexture((World)world, cX, cZ);
        }
        if (FogTexture.offset != mc.field_71474_y.field_151451_c + 2) {
            FogTexture.offset = mc.field_71474_y.field_151451_c + 2;
            FogTexture.allocateTexture();
            FogTexture.createFogTexture((World)world, cX, cZ);
        }
        int r = FogTexture.offset * 16 + 8;
        int d = r * 2;
        playerX = playerX - (double)(cX * 16) - 8.0;
        playerZ = playerZ - (double)(cZ * 16) - 8.0;
        if (depth < 4.0f) {
            Vec3d vecLayer = this.getFogLayerColor((World)world, partialTicks);
            f2 = (float)vecLayer.field_72450_a;
            f3 = (float)vecLayer.field_72448_b;
            f4 = (float)vecLayer.field_72449_c;
        } else {
            Vec3d vecDown = this.getFogDownColor((World)world, partialTicks);
            f2 = (float)vecDown.field_72450_a;
            f3 = (float)vecDown.field_72448_b;
            f4 = (float)vecDown.field_72449_c;
        }
        float layerOffset = -0.0035f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        FogTexture.bindTexture();
        GlStateManager.func_179147_l();
        GlStateManager.func_179127_m();
        GlStateManager.func_179092_a((int)516, (float)0.0f);
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        ShaderProgram.useShader(ShaderProgram.fog);
        ShaderProgram.setUniform2f("center", (float)(playerX + 8.0 + (double)(FogTexture.offset * 16)) / (float)d, (float)(playerZ + 8.0 + (double)(FogTexture.offset * 16)) / (float)d);
        ShaderProgram.setUniform3f("main_color", f2, f3, f4);
        ShaderProgram.setUniform1f("fog_smooth", ModConfig.Graphic.smoothFogTexture ? 1.0f : 0.0f);
        for (int n2 = 0; n2 <= planeCount; ++n2) {
            float height = fogHeight - 4.0f - playerHeight + layerOffset;
            float colorOffset = 0.65f - (float)n2 * colorRange;
            ShaderProgram.setUniform1f("offset", colorOffset);
            if ((double)(height - cameraHeight) < -0.1) {
                vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                ShaderProgram.setUniform1f("alpha", alpha);
                ShaderProgram.setUniform1f("deep", fogHeight - 4.0f + layerOffset - (float)MathHelper.func_76141_d((float)(fogHeight - 0.0025f)));
                vertexbuffer.func_181662_b((double)(-r) - playerX, (double)height, (double)(-r) - playerZ).func_187315_a(0.0, 0.0).func_181675_d();
                vertexbuffer.func_181662_b((double)(-r) - playerX, (double)height, (double)r - playerZ).func_187315_a(0.0, 1.0).func_181675_d();
                vertexbuffer.func_181662_b((double)r - playerX, (double)height, (double)r - playerZ).func_187315_a(1.0, 1.0).func_181675_d();
                vertexbuffer.func_181662_b((double)r - playerX, (double)height, (double)(-r) - playerZ).func_187315_a(1.0, 0.0).func_181675_d();
                tessellator.func_78381_a();
            }
            if ((double)((height = fogHeight - 4.0f - playerHeight - layerOffset) - cameraHeight) > 0.1) {
                vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                ShaderProgram.setUniform1f("alpha", Math.min(1.0f, alpha + Math.max(0.0f, height / 100.0f)));
                ShaderProgram.setUniform1f("deep", (float)MathHelper.func_76123_f((float)(fogHeight - 8.0f + 0.0025f)) - fogHeight + 4.0f + layerOffset);
                vertexbuffer.func_181662_b((double)(-r) - playerX, (double)height, (double)(-r) - playerZ).func_187315_a(0.0, 0.0).func_181675_d();
                vertexbuffer.func_181662_b((double)r - playerX, (double)height, (double)(-r) - playerZ).func_187315_a(1.0, 0.0).func_181675_d();
                vertexbuffer.func_181662_b((double)r - playerX, (double)height, (double)r - playerZ).func_187315_a(1.0, 1.0).func_181675_d();
                vertexbuffer.func_181662_b((double)(-r) - playerX, (double)height, (double)r - playerZ).func_187315_a(0.0, 1.0).func_181675_d();
                tessellator.func_78381_a();
            }
            layerOffset += layerRange;
        }
        ShaderProgram.releaseShader();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179084_k();
    }

    private void fogRenderOld(float partialTicks, WorldClient world, Minecraft mc) {
        float f4;
        float f3;
        float f2;
        Entity entity = mc.func_175606_aa();
        float cameraHeight = mc.func_175606_aa().func_70047_e();
        float playerHeight = (float)(entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks);
        int i = 4;
        int r = (mc.field_71474_y.field_151451_c + 2) * 16;
        int e = r / i;
        int d = r * 2;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        mc.func_110434_K().func_110577_a(locationFogPng);
        GlStateManager.func_179147_l();
        GlStateManager.func_179127_m();
        GlStateManager.func_179092_a((int)516, (float)0.0f);
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        if (depth < 4.0f) {
            Vec3d vecLayer = this.getFogLayerColor((World)world, partialTicks);
            f2 = (float)vecLayer.field_72450_a;
            f3 = (float)vecLayer.field_72448_b;
            f4 = (float)vecLayer.field_72449_c;
        } else {
            Vec3d vecDown = this.getFogDownColor((World)world, partialTicks);
            f2 = (float)vecDown.field_72450_a;
            f3 = (float)vecDown.field_72448_b;
            f4 = (float)vecDown.field_72449_c;
        }
        float layerOffset = -0.0035f;
        for (int n = 0; n <= planeCount; ++n) {
            int z;
            int x;
            float alphaFin;
            float blue;
            float green;
            float red;
            float height = fogHeight - 4.0f - playerHeight + layerOffset;
            float colorOffset = 0.65f - (float)n * colorRange;
            if ((double)(height - cameraHeight) < -0.1) {
                vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                red = Math.min(1.0f, f2 + colorOffset);
                green = Math.min(1.0f, f3 + colorOffset);
                blue = Math.min(1.0f, f4 + colorOffset);
                alphaFin = alpha;
                for (x = -e * i; x < e * i; x += e) {
                    for (z = -e * i; z < e * i; z += e) {
                        vertexbuffer.func_181662_b((double)x, (double)height, (double)z).func_187315_a((double)((float)(r + z) / (float)d), (double)((float)(r - x) / (float)d)).func_181666_a(red, green, blue, alphaFin).func_181675_d();
                        vertexbuffer.func_181662_b((double)x, (double)height, (double)(z + e)).func_187315_a((double)((float)(r + z + e) / (float)d), (double)((float)(r - x) / (float)d)).func_181666_a(red, green, blue, alphaFin).func_181675_d();
                        vertexbuffer.func_181662_b((double)(x + e), (double)height, (double)(z + e)).func_187315_a((double)((float)(r + z + e) / (float)d), (double)((float)(r - x - e) / (float)d)).func_181666_a(red, green, blue, alphaFin).func_181675_d();
                        vertexbuffer.func_181662_b((double)(x + e), (double)height, (double)z).func_187315_a((double)((float)(r + z) / (float)d), (double)((float)(r - x - e) / (float)d)).func_181666_a(red, green, blue, alphaFin).func_181675_d();
                    }
                }
                tessellator.func_78381_a();
            }
            if ((double)((height = fogHeight - 4.0f - playerHeight - layerOffset) - cameraHeight) > 0.1) {
                vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                red = Math.min(1.0f, f2 + colorOffset);
                green = Math.min(1.0f, f3 + colorOffset);
                blue = Math.min(1.0f, f4 + colorOffset);
                alphaFin = Math.min(1.0f, alpha + Math.max(0.0f, height / 100.0f));
                for (x = -e * i; x < e * i; x += e) {
                    for (z = -e * i; z < e * i; z += e) {
                        vertexbuffer.func_181662_b((double)x, (double)height, (double)z).func_187315_a((double)((float)(r + z) / (float)d), (double)((float)(r - x) / (float)d)).func_181666_a(red, green, blue, alphaFin).func_181675_d();
                        vertexbuffer.func_181662_b((double)(x + e), (double)height, (double)z).func_187315_a((double)((float)(r + z) / (float)d), (double)((float)(r - x - e) / (float)d)).func_181666_a(red, green, blue, alphaFin).func_181675_d();
                        vertexbuffer.func_181662_b((double)(x + e), (double)height, (double)(z + e)).func_187315_a((double)((float)(r + z + e) / (float)d), (double)((float)(r - x - e) / (float)d)).func_181666_a(red, green, blue, alphaFin).func_181675_d();
                        vertexbuffer.func_181662_b((double)x, (double)height, (double)(z + e)).func_187315_a((double)((float)(r + z + e) / (float)d), (double)((float)(r - x) / (float)d)).func_181666_a(red, green, blue, alphaFin).func_181675_d();
                    }
                }
                tessellator.func_78381_a();
            }
            layerOffset += layerRange;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179084_k();
    }

    private void renderCloudsCheck(float partialTicks) {
        Entity entity = mc.func_175606_aa();
        if (FogRenderer.mc.field_71474_y.func_181147_e() != 0 && entity.field_70163_u + (double)entity.func_70047_e() > (double)(fogHeight - 4.0f)) {
            if (FogRenderer.mc.field_71474_y.field_74337_g) {
                this.renderClouds(partialTicks, EntityRenderer.field_78515_b);
            } else {
                this.renderClouds(partialTicks, 2);
            }
        }
    }

    private void renderClouds(float partialTicks, int pass) {
        if (FogRenderer.mc.field_71474_y.func_181147_e() == 2) {
            this.renderCloudsFancy(partialTicks, pass);
        } else {
            GlStateManager.func_179129_p();
            Entity entity = mc.func_175606_aa();
            float f = (float)(entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks);
            int i = 32;
            int j = 8;
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder vertexbuffer = tessellator.func_178180_c();
            FogRenderer.mc.field_71446_o.func_110577_a(CLOUDS_TEXTURES);
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            Vec3d vec3d = FogRenderer.mc.field_71441_e.func_72824_f(partialTicks);
            float f1 = (float)vec3d.field_72450_a;
            float f2 = (float)vec3d.field_72448_b;
            float f3 = (float)vec3d.field_72449_c;
            if (pass != 2) {
                float f4 = (f1 * 30.0f + f2 * 59.0f + f3 * 11.0f) / 100.0f;
                float f5 = (f1 * 30.0f + f2 * 70.0f) / 100.0f;
                float f6 = (f1 * 30.0f + f3 * 70.0f) / 100.0f;
                f1 = f4;
                f2 = f5;
                f3 = f6;
            }
            float f10 = 4.8828125E-4f;
            double d2 = (float)this.cloudTickCounter + partialTicks;
            double d0 = entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)partialTicks + d2 * (double)0.03f;
            double d1 = entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)partialTicks;
            int k = MathHelper.func_76128_c((double)(d0 / 2048.0));
            int l = MathHelper.func_76128_c((double)(d1 / 2048.0));
            float f7 = FogRenderer.mc.field_71441_e.field_73011_w.func_76571_f() - f + 0.33f;
            float f8 = (float)((d0 -= (double)(k * 2048)) * 4.8828125E-4);
            float f9 = (float)((d1 -= (double)(l * 2048)) * 4.8828125E-4);
            vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            for (int i1 = -256; i1 < 256; i1 += 32) {
                for (int j1 = -256; j1 < 256; j1 += 32) {
                    vertexbuffer.func_181662_b((double)(i1 + 0), (double)f7, (double)(j1 + 32)).func_187315_a((double)((float)(i1 + 0) * 4.8828125E-4f + f8), (double)((float)(j1 + 32) * 4.8828125E-4f + f9)).func_181666_a(f1, f2, f3, 0.8f).func_181675_d();
                    vertexbuffer.func_181662_b((double)(i1 + 32), (double)f7, (double)(j1 + 32)).func_187315_a((double)((float)(i1 + 32) * 4.8828125E-4f + f8), (double)((float)(j1 + 32) * 4.8828125E-4f + f9)).func_181666_a(f1, f2, f3, 0.8f).func_181675_d();
                    vertexbuffer.func_181662_b((double)(i1 + 32), (double)f7, (double)(j1 + 0)).func_187315_a((double)((float)(i1 + 32) * 4.8828125E-4f + f8), (double)((float)(j1 + 0) * 4.8828125E-4f + f9)).func_181666_a(f1, f2, f3, 0.8f).func_181675_d();
                    vertexbuffer.func_181662_b((double)(i1 + 0), (double)f7, (double)(j1 + 0)).func_187315_a((double)((float)(i1 + 0) * 4.8828125E-4f + f8), (double)((float)(j1 + 0) * 4.8828125E-4f + f9)).func_181666_a(f1, f2, f3, 0.8f).func_181675_d();
                }
            }
            tessellator.func_78381_a();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179084_k();
            GlStateManager.func_179089_o();
        }
    }

    private void renderCloudsFancy(float partialTicks, int pass) {
        GlStateManager.func_179129_p();
        Entity entity = mc.func_175606_aa();
        float f = (float)(entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        float f1 = 12.0f;
        float f2 = 4.0f;
        double d0 = (float)this.cloudTickCounter + partialTicks;
        double d1 = (entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)partialTicks + d0 * (double)0.03f) / 12.0;
        double d2 = (entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)partialTicks) / 12.0 + (double)0.33f;
        float f3 = FogRenderer.mc.field_71441_e.field_73011_w.func_76571_f() - f + 0.33f;
        int i = MathHelper.func_76128_c((double)(d1 / 2048.0));
        int j = MathHelper.func_76128_c((double)(d2 / 2048.0));
        d1 -= (double)(i * 2048);
        d2 -= (double)(j * 2048);
        FogRenderer.mc.field_71446_o.func_110577_a(CLOUDS_TEXTURES);
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        Vec3d vec3d = FogRenderer.mc.field_71441_e.func_72824_f(partialTicks);
        float f4 = (float)vec3d.field_72450_a;
        float f5 = (float)vec3d.field_72448_b;
        float f6 = (float)vec3d.field_72449_c;
        if (pass != 2) {
            float f7 = (f4 * 30.0f + f5 * 59.0f + f6 * 11.0f) / 100.0f;
            float f8 = (f4 * 30.0f + f5 * 70.0f) / 100.0f;
            float f9 = (f4 * 30.0f + f6 * 70.0f) / 100.0f;
            f4 = f7;
            f5 = f8;
            f6 = f9;
        }
        float f26 = f4 * 0.9f;
        float f27 = f5 * 0.9f;
        float f28 = f6 * 0.9f;
        float f10 = f4 * 0.7f;
        float f11 = f5 * 0.7f;
        float f12 = f6 * 0.7f;
        float f13 = f4 * 0.8f;
        float f14 = f5 * 0.8f;
        float f15 = f6 * 0.8f;
        float f16 = 0.00390625f;
        float f17 = (float)MathHelper.func_76128_c((double)d1) * 0.00390625f;
        float f18 = (float)MathHelper.func_76128_c((double)d2) * 0.00390625f;
        float f19 = (float)(d1 - (double)MathHelper.func_76128_c((double)d1));
        float f20 = (float)(d2 - (double)MathHelper.func_76128_c((double)d2));
        int k = 8;
        int l = 4;
        float f21 = 9.765625E-4f;
        GlStateManager.func_179152_a((float)12.0f, (float)1.0f, (float)12.0f);
        for (int i1 = 0; i1 < 2; ++i1) {
            if (i1 == 0) {
                GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            } else {
                switch (pass) {
                    case 0: {
                        GlStateManager.func_179135_a((boolean)false, (boolean)true, (boolean)true, (boolean)true);
                        break;
                    }
                    case 1: {
                        GlStateManager.func_179135_a((boolean)true, (boolean)false, (boolean)false, (boolean)true);
                        break;
                    }
                    case 2: {
                        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                    }
                }
            }
            for (int j1 = -3; j1 <= 4; ++j1) {
                for (int k1 = -3; k1 <= 4; ++k1) {
                    vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181712_l);
                    float f22 = j1 * 8;
                    float f23 = k1 * 8;
                    float f24 = f22 - f19;
                    float f25 = f23 - f20;
                    if (f3 > -5.0f) {
                        vertexbuffer.func_181662_b((double)(f24 + 0.0f), (double)(f3 + 0.0f), (double)(f25 + 8.0f)).func_187315_a((double)((f22 + 0.0f) * 0.00390625f + f17), (double)((f23 + 8.0f) * 0.00390625f + f18)).func_181666_a(f10, f11, f12, 0.8f).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
                        vertexbuffer.func_181662_b((double)(f24 + 8.0f), (double)(f3 + 0.0f), (double)(f25 + 8.0f)).func_187315_a((double)((f22 + 8.0f) * 0.00390625f + f17), (double)((f23 + 8.0f) * 0.00390625f + f18)).func_181666_a(f10, f11, f12, 0.8f).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
                        vertexbuffer.func_181662_b((double)(f24 + 8.0f), (double)(f3 + 0.0f), (double)(f25 + 0.0f)).func_187315_a((double)((f22 + 8.0f) * 0.00390625f + f17), (double)((f23 + 0.0f) * 0.00390625f + f18)).func_181666_a(f10, f11, f12, 0.8f).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
                        vertexbuffer.func_181662_b((double)(f24 + 0.0f), (double)(f3 + 0.0f), (double)(f25 + 0.0f)).func_187315_a((double)((f22 + 0.0f) * 0.00390625f + f17), (double)((f23 + 0.0f) * 0.00390625f + f18)).func_181666_a(f10, f11, f12, 0.8f).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
                    }
                    if (f3 <= 5.0f) {
                        vertexbuffer.func_181662_b((double)(f24 + 0.0f), (double)(f3 + 4.0f - 9.765625E-4f), (double)(f25 + 8.0f)).func_187315_a((double)((f22 + 0.0f) * 0.00390625f + f17), (double)((f23 + 8.0f) * 0.00390625f + f18)).func_181666_a(f4, f5, f6, 0.8f).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                        vertexbuffer.func_181662_b((double)(f24 + 8.0f), (double)(f3 + 4.0f - 9.765625E-4f), (double)(f25 + 8.0f)).func_187315_a((double)((f22 + 8.0f) * 0.00390625f + f17), (double)((f23 + 8.0f) * 0.00390625f + f18)).func_181666_a(f4, f5, f6, 0.8f).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                        vertexbuffer.func_181662_b((double)(f24 + 8.0f), (double)(f3 + 4.0f - 9.765625E-4f), (double)(f25 + 0.0f)).func_187315_a((double)((f22 + 8.0f) * 0.00390625f + f17), (double)((f23 + 0.0f) * 0.00390625f + f18)).func_181666_a(f4, f5, f6, 0.8f).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                        vertexbuffer.func_181662_b((double)(f24 + 0.0f), (double)(f3 + 4.0f - 9.765625E-4f), (double)(f25 + 0.0f)).func_187315_a((double)((f22 + 0.0f) * 0.00390625f + f17), (double)((f23 + 0.0f) * 0.00390625f + f18)).func_181666_a(f4, f5, f6, 0.8f).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                    }
                    if (j1 > -1) {
                        for (int l1 = 0; l1 < 8; ++l1) {
                            vertexbuffer.func_181662_b((double)(f24 + (float)l1 + 0.0f), (double)(f3 + 0.0f), (double)(f25 + 8.0f)).func_187315_a((double)((f22 + (float)l1 + 0.5f) * 0.00390625f + f17), (double)((f23 + 8.0f) * 0.00390625f + f18)).func_181666_a(f26, f27, f28, 0.8f).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
                            vertexbuffer.func_181662_b((double)(f24 + (float)l1 + 0.0f), (double)(f3 + 4.0f), (double)(f25 + 8.0f)).func_187315_a((double)((f22 + (float)l1 + 0.5f) * 0.00390625f + f17), (double)((f23 + 8.0f) * 0.00390625f + f18)).func_181666_a(f26, f27, f28, 0.8f).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
                            vertexbuffer.func_181662_b((double)(f24 + (float)l1 + 0.0f), (double)(f3 + 4.0f), (double)(f25 + 0.0f)).func_187315_a((double)((f22 + (float)l1 + 0.5f) * 0.00390625f + f17), (double)((f23 + 0.0f) * 0.00390625f + f18)).func_181666_a(f26, f27, f28, 0.8f).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
                            vertexbuffer.func_181662_b((double)(f24 + (float)l1 + 0.0f), (double)(f3 + 0.0f), (double)(f25 + 0.0f)).func_187315_a((double)((f22 + (float)l1 + 0.5f) * 0.00390625f + f17), (double)((f23 + 0.0f) * 0.00390625f + f18)).func_181666_a(f26, f27, f28, 0.8f).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
                        }
                    }
                    if (j1 <= 1) {
                        for (int i2 = 0; i2 < 8; ++i2) {
                            vertexbuffer.func_181662_b((double)(f24 + (float)i2 + 1.0f - 9.765625E-4f), (double)(f3 + 0.0f), (double)(f25 + 8.0f)).func_187315_a((double)((f22 + (float)i2 + 0.5f) * 0.00390625f + f17), (double)((f23 + 8.0f) * 0.00390625f + f18)).func_181666_a(f26, f27, f28, 0.8f).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
                            vertexbuffer.func_181662_b((double)(f24 + (float)i2 + 1.0f - 9.765625E-4f), (double)(f3 + 4.0f), (double)(f25 + 8.0f)).func_187315_a((double)((f22 + (float)i2 + 0.5f) * 0.00390625f + f17), (double)((f23 + 8.0f) * 0.00390625f + f18)).func_181666_a(f26, f27, f28, 0.8f).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
                            vertexbuffer.func_181662_b((double)(f24 + (float)i2 + 1.0f - 9.765625E-4f), (double)(f3 + 4.0f), (double)(f25 + 0.0f)).func_187315_a((double)((f22 + (float)i2 + 0.5f) * 0.00390625f + f17), (double)((f23 + 0.0f) * 0.00390625f + f18)).func_181666_a(f26, f27, f28, 0.8f).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
                            vertexbuffer.func_181662_b((double)(f24 + (float)i2 + 1.0f - 9.765625E-4f), (double)(f3 + 0.0f), (double)(f25 + 0.0f)).func_187315_a((double)((f22 + (float)i2 + 0.5f) * 0.00390625f + f17), (double)((f23 + 0.0f) * 0.00390625f + f18)).func_181666_a(f26, f27, f28, 0.8f).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
                        }
                    }
                    if (k1 > -1) {
                        for (int j2 = 0; j2 < 8; ++j2) {
                            vertexbuffer.func_181662_b((double)(f24 + 0.0f), (double)(f3 + 4.0f), (double)(f25 + (float)j2 + 0.0f)).func_187315_a((double)((f22 + 0.0f) * 0.00390625f + f17), (double)((f23 + (float)j2 + 0.5f) * 0.00390625f + f18)).func_181666_a(f13, f14, f15, 0.8f).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                            vertexbuffer.func_181662_b((double)(f24 + 8.0f), (double)(f3 + 4.0f), (double)(f25 + (float)j2 + 0.0f)).func_187315_a((double)((f22 + 8.0f) * 0.00390625f + f17), (double)((f23 + (float)j2 + 0.5f) * 0.00390625f + f18)).func_181666_a(f13, f14, f15, 0.8f).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                            vertexbuffer.func_181662_b((double)(f24 + 8.0f), (double)(f3 + 0.0f), (double)(f25 + (float)j2 + 0.0f)).func_187315_a((double)((f22 + 8.0f) * 0.00390625f + f17), (double)((f23 + (float)j2 + 0.5f) * 0.00390625f + f18)).func_181666_a(f13, f14, f15, 0.8f).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                            vertexbuffer.func_181662_b((double)(f24 + 0.0f), (double)(f3 + 0.0f), (double)(f25 + (float)j2 + 0.0f)).func_187315_a((double)((f22 + 0.0f) * 0.00390625f + f17), (double)((f23 + (float)j2 + 0.5f) * 0.00390625f + f18)).func_181666_a(f13, f14, f15, 0.8f).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                        }
                    }
                    if (k1 <= 1) {
                        for (int k2 = 0; k2 < 8; ++k2) {
                            vertexbuffer.func_181662_b((double)(f24 + 0.0f), (double)(f3 + 4.0f), (double)(f25 + (float)k2 + 1.0f - 9.765625E-4f)).func_187315_a((double)((f22 + 0.0f) * 0.00390625f + f17), (double)((f23 + (float)k2 + 0.5f) * 0.00390625f + f18)).func_181666_a(f13, f14, f15, 0.8f).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
                            vertexbuffer.func_181662_b((double)(f24 + 8.0f), (double)(f3 + 4.0f), (double)(f25 + (float)k2 + 1.0f - 9.765625E-4f)).func_187315_a((double)((f22 + 8.0f) * 0.00390625f + f17), (double)((f23 + (float)k2 + 0.5f) * 0.00390625f + f18)).func_181666_a(f13, f14, f15, 0.8f).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
                            vertexbuffer.func_181662_b((double)(f24 + 8.0f), (double)(f3 + 0.0f), (double)(f25 + (float)k2 + 1.0f - 9.765625E-4f)).func_187315_a((double)((f22 + 8.0f) * 0.00390625f + f17), (double)((f23 + (float)k2 + 0.5f) * 0.00390625f + f18)).func_181666_a(f13, f14, f15, 0.8f).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
                            vertexbuffer.func_181662_b((double)(f24 + 0.0f), (double)(f3 + 0.0f), (double)(f25 + (float)k2 + 1.0f - 9.765625E-4f)).func_187315_a((double)((f22 + 0.0f) * 0.00390625f + f17), (double)((f23 + (float)k2 + 0.5f) * 0.00390625f + f18)).func_181666_a(f13, f14, f15, 0.8f).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
                        }
                    }
                    tessellator.func_78381_a();
                }
            }
        }
        GlStateManager.func_179152_a((float)0.083333336f, (float)1.0f, (float)0.083333336f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179089_o();
    }

    private float getRoof(World world, BlockPos pos) {
        if (pos.func_177958_n() == viewX && pos.func_177956_o() == viewY && pos.func_177952_p() == viewZ && shadowInit) {
            return shadowMultiplier;
        }
        if (world.func_175726_f(pos).func_177410_o()) {
            shadowInit = true;
        }
        float i = 0.0f;
        int count = 1;
        int r = 6;
        for (int x = -r; x <= r; ++x) {
            for (int z = -r; z <= r; ++z) {
                if (world.func_175665_u(pos.func_177982_a(x, 0, z))) continue;
                ++count;
                i += (float)world.func_175642_b(EnumSkyBlock.SKY, pos.func_177982_a(x, 0, z));
            }
        }
        viewX = pos.func_177958_n();
        viewY = pos.func_177956_o();
        viewZ = pos.func_177952_p();
        shadowMultiplier = i / (float)count / 15.0f;
        return shadowMultiplier;
    }

    private float calculate(float up, float down, float min, float max, float depth, float layerHeight) {
        return MathHelper.func_76131_a((float)(up + (down - up) * depth / layerHeight), (float)min, (float)max);
    }

    private float getNightVisionBrightness(EntityLivingBase entitylivingbaseIn, float partialTicks) {
        int i = entitylivingbaseIn.func_70660_b(MobEffects.field_76439_r).func_76459_b();
        return i > 200 ? 1.0f : 0.7f + MathHelper.func_76126_a((float)(((float)i - partialTicks) * (float)Math.PI * 0.2f)) * 0.3f;
    }

    @SideOnly(value=Side.CLIENT)
    private Vec3d getFogUpColor(World world, float partialTicks) {
        return this.getFogUpColor(world, partialTicks, cel);
    }

    @SideOnly(value=Side.CLIENT)
    private Vec3d getFogBorderColor(World world, float partialTicks) {
        return this.getFogBorderColor(world, partialTicks, cel);
    }

    @SideOnly(value=Side.CLIENT)
    private Vec3d getFogDownColor(World world, float partialTicks) {
        return this.getFogDownColor(world, partialTicks, cel);
    }

    @SideOnly(value=Side.CLIENT)
    private Vec3d getFogLayerColor(World world, float partialTicks) {
        return this.getFogLayerColor(world, partialTicks, cel);
    }

    static {
        planeCount = (int)Math.pow(2.0, ModConfig.graphic.fogQuality + 1);
        layerRange = 4.0f / (float)planeCount;
        colorRange = 0.65f / (float)planeCount;
        alpha = Math.min(1.0f, 5.0f / (float)planeCount);
    }
}

