/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.entity.item;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.api.item.MistItems;

public class EntityMistPainting
extends EntityHanging
implements IEntityAdditionalSpawnData {
    public EnumArt art;

    public EntityMistPainting(World world) {
        super(world);
    }

    public EntityMistPainting(World world, BlockPos pos, EnumFacing facing, int meta) {
        super(world, pos);
        this.art = EnumArt.values()[meta];
        this.func_174859_a(facing);
    }

    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74778_a("Motive", this.art.title);
        super.func_70014_b(compound);
    }

    public void func_70037_a(NBTTagCompound compound) {
        String s = compound.func_74779_i("Motive");
        for (EnumArt enumart : EnumArt.values()) {
            if (!enumart.title.equals(s)) continue;
            this.art = enumart;
        }
        if (this.art == null) {
            this.art = EnumArt.CLIFF;
        }
        super.func_70037_a(compound);
    }

    public int func_82329_d() {
        return this.art.sizeX;
    }

    public int func_82330_g() {
        return this.art.sizeY;
    }

    public void func_110128_b(@Nullable Entity brokenEntity) {
        if (this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
            this.func_184185_a(SoundEvents.field_187691_dJ, 1.0f, 1.0f);
            if (brokenEntity instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)brokenEntity;
                if (entityplayer.field_71075_bZ.field_75098_d) {
                    return;
                }
            }
            this.func_70099_a(new ItemStack(MistItems.PAINTING, 1, this.art.ordinal()), 0.0f);
        }
    }

    public void func_184523_o() {
        this.func_184185_a(SoundEvents.field_187694_dK, 1.0f, 1.0f);
    }

    public void func_70012_b(double x, double y, double z, float yaw, float pitch) {
        this.func_70107_b(x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        BlockPos blockpos = this.field_174861_a.func_177963_a(x - this.field_70165_t, y - this.field_70163_u, z - this.field_70161_v);
        this.func_70107_b(blockpos.func_177958_n(), blockpos.func_177956_o(), blockpos.func_177952_p());
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.art.ordinal());
        buffer.writeInt(this.field_174861_a.func_177958_n());
        buffer.writeInt(this.field_174861_a.func_177956_o());
        buffer.writeInt(this.field_174861_a.func_177952_p());
        buffer.writeByte(this.func_174811_aO().func_176745_a());
    }

    public void readSpawnData(ByteBuf buffer) {
        this.art = EnumArt.values()[buffer.readInt()];
        this.field_174861_a = new BlockPos(buffer.readInt(), buffer.readInt(), buffer.readInt());
        this.func_174859_a(EnumFacing.func_82600_a((int)buffer.readByte()));
    }

    public static enum EnumArt {
        CLIFF("cliff", 16, 16, 0, 0),
        BUSHES("bushes", 16, 16, 16, 0),
        FOG_OCEAN("fog_ocean", 16, 16, 32, 0),
        MORNING("morning", 16, 16, 48, 0),
        WATERING_PLACE("watering_place", 16, 16, 64, 0),
        EARLY_SPRING("early_spring", 16, 16, 80, 0),
        HOT_DAY("hot_day", 16, 16, 96, 0),
        ETUDE("etude", 16, 16, 112, 0),
        OAKS("oaks", 32, 16, 0, 32),
        SOMEWHERE("somewhere", 32, 16, 32, 32),
        EDGE("edge", 32, 16, 64, 32),
        SWAMP("swamp", 16, 32, 0, 64),
        MEADOW("meadow", 16, 16, 128, 0),
        FALL("fall", 16, 32, 16, 64),
        POPLARS("poplars", 16, 16, 144, 0),
        WANDERER("wanderer", 16, 32, 32, 64);

        public static final int MAX_NAME_LENGTH;
        public final String title;
        public final int sizeX;
        public final int sizeY;
        public final int offsetX;
        public final int offsetY;

        private EnumArt(String titleIn, int width, int height, int textureU, int textureV) {
            this.title = titleIn;
            this.sizeX = width;
            this.sizeY = height;
            this.offsetX = textureU;
            this.offsetY = textureV;
        }

        static {
            MAX_NAME_LENGTH = "SkullAndRoses".length();
        }
    }
}

