/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.entity.ai;

import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNavigateGround;
import ru.liahim.mist.entity.EntityAnimalMist;

public class EntityAITemptTamed
extends EntityAIBase {
    private final EntityAnimalMist temptedEntity;
    private final double speed;
    private final double tamedSpeed;
    private final double distance;
    private double targetX;
    private double targetY;
    private double targetZ;
    private double pitch;
    private double yaw;
    private EntityPlayer temptingPlayer;
    private int delayTemptCounter;
    private boolean isRunning;
    private final Set<ItemStack> temptStacks;
    private final boolean scaredByPlayerMovement;

    public EntityAITemptTamed(EntityAnimalMist temptedEntity, double speed, double tamedSpeed, ItemStack temptStacks, boolean scaredByPlayerMovement) {
        this(temptedEntity, speed, tamedSpeed, scaredByPlayerMovement, Sets.newHashSet((Object[])new ItemStack[]{temptStacks}));
    }

    public EntityAITemptTamed(EntityAnimalMist temptedEntity, double speed, double tamedSpeed, boolean scaredByPlayerMovement, Set<ItemStack> temptStacks) {
        this(temptedEntity, speed, tamedSpeed, scaredByPlayerMovement, temptStacks, 10.0);
    }

    public EntityAITemptTamed(EntityAnimalMist temptedEntity, double speed, double tamedSpeed, boolean scaredByPlayerMovement, Set<ItemStack> temptStacks, double distance) {
        this.temptedEntity = temptedEntity;
        this.speed = speed;
        this.tamedSpeed = tamedSpeed;
        this.distance = distance;
        this.temptStacks = temptStacks;
        this.scaredByPlayerMovement = scaredByPlayerMovement;
        this.func_75248_a(3);
        if (!(temptedEntity.func_70661_as() instanceof PathNavigateGround)) {
            throw new IllegalArgumentException("Unsupported mob type for TemptGoal");
        }
    }

    public boolean func_75250_a() {
        if (!this.temptedEntity.canBeTempted()) {
            return false;
        }
        if (this.delayTemptCounter > 0) {
            --this.delayTemptCounter;
            return false;
        }
        this.temptingPlayer = this.temptedEntity.field_70170_p.func_72890_a((Entity)this.temptedEntity, this.distance);
        if (this.temptingPlayer == null) {
            return false;
        }
        return this.temptedEntity.canBeTemptedByEntity(this.temptingPlayer) && (this.isTempting(this.temptingPlayer.func_184614_ca()) || this.isTempting(this.temptingPlayer.func_184592_cb())) && this.temptedEntity.childCheck();
    }

    public boolean isTempting(ItemStack stack) {
        for (ItemStack st : this.temptStacks) {
            if (stack.func_77973_b() != st.func_77973_b() || stack.func_77952_i() != st.func_77952_i()) continue;
            return true;
        }
        return false;
    }

    public boolean func_75253_b() {
        if (this.scaredByPlayerMovement && !this.temptedEntity.isTamedByEntity(this.temptingPlayer)) {
            if (this.temptedEntity.func_70068_e((Entity)this.temptingPlayer) < 36.0) {
                if (this.temptingPlayer.func_70092_e(this.targetX, this.targetY, this.targetZ) > 0.01) {
                    return false;
                }
                if (Math.abs((double)this.temptingPlayer.field_70125_A - this.pitch) > 5.0 || Math.abs((double)this.temptingPlayer.field_70177_z - this.yaw) > 5.0) {
                    return false;
                }
            } else {
                this.targetX = this.temptingPlayer.field_70165_t;
                this.targetY = this.temptingPlayer.field_70163_u;
                this.targetZ = this.temptingPlayer.field_70161_v;
            }
            this.pitch = this.temptingPlayer.field_70125_A;
            this.yaw = this.temptingPlayer.field_70177_z;
        }
        return this.func_75250_a();
    }

    public void func_75249_e() {
        this.targetX = this.temptingPlayer.field_70165_t;
        this.targetY = this.temptingPlayer.field_70163_u;
        this.targetZ = this.temptingPlayer.field_70161_v;
        this.isRunning = true;
    }

    public void func_75251_c() {
        this.temptingPlayer = null;
        this.temptedEntity.func_70661_as().func_75499_g();
        this.delayTemptCounter = 100;
        this.isRunning = false;
    }

    public void func_75246_d() {
        this.temptedEntity.func_70671_ap().func_75651_a((Entity)this.temptingPlayer, (float)(this.temptedEntity.func_184649_cE() + 20), (float)this.temptedEntity.func_70646_bf());
        if (this.temptedEntity.func_70068_e((Entity)this.temptingPlayer) < 6.25) {
            this.temptedEntity.func_70661_as().func_75499_g();
        } else {
            this.temptedEntity.func_70661_as().func_75497_a((Entity)this.temptingPlayer, this.temptedEntity.func_70909_n() ? this.tamedSpeed : this.speed);
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }
}

