/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.entity.ai;

import java.util.Comparator;
import java.util.Iterator;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.pathfinding.Path;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import ru.liahim.mist.api.entity.IMyceliumFinder;
import ru.liahim.mist.block.upperplant.MistMushroom;
import ru.liahim.mist.init.ModAdvancements;

public class EntityAIFindMycelium
extends EntityAIBase {
    EntityCreature entity;
    EntityPlayer player;
    double speed;
    int range;
    private IBlockState lastMushroom;
    private IBlockState mushroom;
    protected BlockPos pos;
    private int delayCounter;

    public EntityAIFindMycelium(EntityCreature entity, int range, double speed) {
        this.entity = entity;
        this.range = range;
        this.speed = speed;
    }

    public void setMushroom(IBlockState state, EntityPlayer player) {
        this.mushroom = state;
        this.player = player;
    }

    public boolean func_75250_a() {
        if (this.mushroom != null) {
            this.pos = this.getTargetPos(this.mushroom);
            if (this.pos == null) {
                if (this.entity instanceof IMyceliumFinder) {
                    ((IMyceliumFinder)this.entity).playNotFindSound();
                }
                this.reset();
            }
        }
        return this.pos != null;
    }

    private BlockPos getTargetPos(IBlockState mushroom) {
        Iterator itr = this.entity.field_70170_p.field_147482_g.stream().filter(te -> MistMushroom.isPair(mushroom, te)).sorted(Comparator.comparingDouble(te -> this.entity.func_180425_c().func_177951_i((Vec3i)te.func_174877_v()))).iterator();
        return itr.hasNext() ? ((TileEntity)itr.next()).func_174877_v() : null;
    }

    public void func_75249_e() {
        boolean finder = this.entity instanceof IMyceliumFinder;
        int i = finder ? ((IMyceliumFinder)this.entity).getFindingRange() : this.range;
        ChunkCache chunkcache = new ChunkCache(this.entity.field_70170_p, this.entity.func_180425_c().func_177982_a(-i, -i, -i), this.entity.func_180425_c().func_177982_a(i, i, i), 0);
        Path path = this.entity.func_70661_as().field_179681_j.func_186336_a((IBlockAccess)chunkcache, (EntityLiving)this.entity, this.pos, (float)this.range);
        if (path == null) {
            if (finder) {
                ((IMyceliumFinder)this.entity).playNotFindSound();
            }
            this.reset();
        }
        this.entity.func_70661_as().func_75484_a(path, this.speed);
        if (this.delayCounter <= 0 || this.lastMushroom == null || this.mushroom != this.lastMushroom) {
            this.delayCounter = 50;
            this.lastMushroom = this.mushroom;
        }
    }

    public boolean func_75253_b() {
        return this.pos != null && (double)this.pos.func_177958_n() != Math.floor(this.entity.field_70165_t) && (double)this.pos.func_177952_p() != Math.floor(this.entity.field_70161_v) && MistMushroom.isPair(this.mushroom, this.entity.field_70170_p.func_175625_s(this.pos)) && !this.entity.func_70661_as().func_75500_f();
    }

    public void func_75251_c() {
        if (--this.delayCounter <= 0) {
            this.reset();
        }
    }

    private void reset() {
        if (this.pos != null && this.entity.func_180425_c().func_177951_i((Vec3i)this.pos) < 25.0 && this.player instanceof EntityPlayerMP) {
            ModAdvancements.MYCELIUM.trigger((EntityPlayerMP)this.player, this.player.field_70170_p, this.pos, this.mushroom);
        }
        this.mushroom = null;
        this.lastMushroom = null;
        this.pos = null;
        this.delayCounter = 0;
    }
}

