/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.entity.ai;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockStateMatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIEatGrass;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import ru.liahim.mist.block.MistGrass;
import ru.liahim.mist.util.FacingHelper;

public class EntityAIEatMistGrass
extends EntityAIEatGrass {
    private static final Predicate<IBlockState> IS_TALL_GRASS = BlockStateMatcher.func_177638_a((Block)Blocks.field_150329_H).func_177637_a((IProperty)BlockTallGrass.field_176497_a, Predicates.equalTo((Object)BlockTallGrass.EnumType.GRASS));
    private static final Predicate<IBlockState> IS_SNOW = BlockStateMatcher.func_177638_a((Block)Blocks.field_150431_aC).func_177637_a((IProperty)BlockSnow.field_176315_a, Predicates.equalTo((Object)1));
    private final EntityLiving eater;
    private final World world;
    private final boolean offset;
    private final boolean destroyGrass;
    int sheepTimer;

    public EntityAIEatMistGrass(EntityLiving grassEaterEntity, boolean offset, boolean destroyGrass) {
        super(grassEaterEntity);
        this.eater = grassEaterEntity;
        this.world = grassEaterEntity.field_70170_p;
        this.offset = offset;
        this.destroyGrass = destroyGrass;
        this.func_75248_a(7);
    }

    public EntityAIEatMistGrass(EntityLiving grassEaterEntity, boolean offset) {
        this(grassEaterEntity, offset, true);
    }

    public boolean func_75250_a() {
        if (this.eater.func_70681_au().nextInt(this.eater.func_70631_g_() ? 100 : 1000) != 0 || this.isMoving()) {
            return false;
        }
        BlockPos pos = new BlockPos(this.eater.field_70165_t, this.eater.field_70163_u, this.eater.field_70161_v);
        if (!this.eater.func_70631_g_() && this.offset) {
            pos = FacingHelper.getAngelOffset(this.eater.field_70759_as, pos);
        }
        if (IS_TALL_GRASS.apply((Object)this.world.func_180495_p(pos))) {
            return true;
        }
        IBlockState state = this.world.func_180495_p(pos.func_177977_b());
        return state.func_177230_c() instanceof MistGrass && (Boolean)state.func_177229_b((IProperty)MistGrass.GROWTH) != false;
    }

    private boolean isMoving() {
        if (this.eater.func_184207_aI()) {
            EntityLivingBase passenger = (EntityLivingBase)this.eater.func_184179_bs();
            return passenger.field_191988_bg != 0.0f || passenger.field_70702_br != 0.0f;
        }
        return false;
    }

    public void func_75249_e() {
        this.sheepTimer = 40;
        this.world.func_72960_a((Entity)this.eater, (byte)10);
        this.eater.func_70661_as().func_75499_g();
    }

    public void func_75251_c() {
        this.sheepTimer = 0;
    }

    public boolean func_75253_b() {
        return this.sheepTimer > 0;
    }

    public int func_151499_f() {
        return this.sheepTimer;
    }

    public void func_75246_d() {
        this.sheepTimer = Math.max(0, this.sheepTimer - 1);
        if (this.sheepTimer == 4) {
            BlockPos pos = new BlockPos(this.eater.field_70165_t, this.eater.field_70163_u, this.eater.field_70161_v);
            if (!this.eater.func_70631_g_() && this.offset) {
                pos = FacingHelper.getAngelOffset(this.eater.field_70759_as, pos);
            }
            if (IS_TALL_GRASS.apply((Object)this.world.func_180495_p(pos))) {
                if (this.destroyGrass && ForgeEventFactory.getMobGriefingEvent((World)this.world, (Entity)this.eater)) {
                    this.world.func_175655_b(pos, false);
                }
                this.eater.func_70615_aA();
            } else {
                IBlockState state = this.world.func_180495_p(pos = pos.func_177977_b());
                if (state.func_177230_c() instanceof MistGrass && ((Boolean)state.func_177229_b((IProperty)MistGrass.GROWTH)).booleanValue()) {
                    if (this.destroyGrass && ForgeEventFactory.getMobGriefingEvent((World)this.world, (Entity)this.eater)) {
                        if (IS_SNOW.apply((Object)this.world.func_180495_p(pos.func_177984_a()))) {
                            this.world.func_175655_b(pos.func_177984_a(), false);
                        }
                        this.world.func_175718_b(2001, pos, Block.func_149682_b((Block)state.func_177230_c()));
                        this.world.func_180501_a(pos, state.func_177226_a((IProperty)MistGrass.GROWTH, (Comparable)Boolean.valueOf(false)), 2);
                    }
                    this.eater.func_70615_aA();
                }
            }
        }
    }
}

