/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.entity;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.api.loottable.LootTables;
import ru.liahim.mist.api.sound.MistSounds;
import ru.liahim.mist.common.MistTime;
import ru.liahim.mist.entity.AbstractMistChestMount;
import ru.liahim.mist.entity.EntityAlbino;
import ru.liahim.mist.entity.EntityAnimalMist;
import ru.liahim.mist.entity.ai.EntityAIEatMistGrass;
import ru.liahim.mist.entity.ai.EntityAIFollowGender;
import ru.liahim.mist.entity.ai.EntityAIFollowParentGender;
import ru.liahim.mist.entity.ai.EntityAIMateGender;
import ru.liahim.mist.entity.ai.EntityAITemptTamed;

public class EntityWulder
extends AbstractMistChestMount
implements IShearable {
    private static final DataParameter<Integer> MILK_TIME = EntityDataManager.func_187226_a(EntityWulder.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> WOOL_TIME = EntityDataManager.func_187226_a(EntityWulder.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> HORN_TYPE = EntityDataManager.func_187226_a(EntityWulder.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> SHEARED = EntityDataManager.func_187226_a(EntityWulder.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final Set<ItemStack> TEMPTATION_STACKS = Sets.newHashSet((Object[])new ItemStack[]{new ItemStack(MistBlocks.TREE_SAPLING, 1, 7)});
    private static long pregnantTime = MistTime.getDayInMonth() * 36000;
    private EntityAIEatMistGrass aiEatGrass;
    private int milkTimer;
    private int woolTimer;
    private int eatTimer;
    private int[] hornArray = new int[]{0, 0, 0, 0, 0, 0};
    protected boolean canGallop = true;

    public EntityWulder(World world) {
        super(world);
        this.func_70105_a(1.825f, 1.9375f);
    }

    public double func_70042_X() {
        return this.isSheared() ? 1.825 : 1.9375;
    }

    protected void func_184651_r() {
        this.aiTempt = new EntityAITemptTamed((EntityAnimalMist)this, 0.6, 1.0, true, TEMPTATION_STACKS);
        this.aiEatGrass = new EntityAIEatMistGrass((EntityLiving)this, true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.4));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMateGender(this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.aiTempt);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowParentGender(this, 1.5));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFollowGender(this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityPlayer.class, 8.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)this.aiEatGrass);
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
    }

    @Override
    protected void func_70619_bc() {
        if (this.milkTimer > 0) {
            --this.milkTimer;
            if (this.milkTimer == 0) {
                this.updateMilkTimer();
            }
        }
        if (this.woolTimer > 0) {
            --this.woolTimer;
            if (this.woolTimer == 0) {
                this.setSheared(false);
                this.updateWoolTimer();
            }
        }
        this.eatTimer = this.aiEatGrass.func_151499_f();
        super.func_70619_bc();
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K && this.eatTimer > 0) {
            --this.eatTimer;
        }
    }

    @Override
    protected long getPregnantTime() {
        return pregnantTime;
    }

    @Override
    public int getChildCount() {
        return this.field_70146_Z.nextInt(this.field_70146_Z.nextInt(2) + 1) + 1;
    }

    @Override
    public boolean initFemale() {
        return this.field_70146_Z.nextInt(3) != 0;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HORN_TYPE, (Object)-1);
        this.field_70180_af.func_187214_a(SHEARED, (Object)false);
        this.field_70180_af.func_187214_a(MILK_TIME, (Object)0);
        this.field_70180_af.func_187214_a(WOOL_TIME, (Object)0);
    }

    public void setSheared(boolean sheared) {
        this.field_70180_af.func_187227_b(SHEARED, (Object)sheared);
    }

    public boolean isSheared() {
        return (Boolean)this.field_70180_af.func_187225_a(SHEARED);
    }

    public void setHornType(int type) {
        this.field_70180_af.func_187227_b(HORN_TYPE, (Object)type);
    }

    public int getHornType() {
        return (Integer)this.field_70180_af.func_187225_a(HORN_TYPE);
    }

    public void deserializeHornArray() {
        int i = this.getHornType();
        this.hornArray[0] = i >> 10;
        this.hornArray[1] = i >> 8 & 3;
        this.hornArray[2] = i >> 6 & 3;
        this.hornArray[3] = i >> 4 & 3;
        this.hornArray[4] = i >> 2 & 3;
        this.hornArray[5] = i & 3;
    }

    @Override
    public void func_184206_a(DataParameter<?> key) {
        if (MILK_TIME.equals(key) && this.field_70170_p.field_72995_K) {
            this.milkTimer = (Integer)this.field_70180_af.func_187225_a(MILK_TIME);
        }
        if (WOOL_TIME.equals(key) && this.field_70170_p.field_72995_K) {
            this.woolTimer = (Integer)this.field_70180_af.func_187225_a(WOOL_TIME);
        }
        if (HORN_TYPE.equals(key) && this.field_70170_p.field_72995_K) {
            this.deserializeHornArray();
        }
        super.func_184206_a(key);
    }

    private void updateMilkTimer() {
        this.field_70180_af.func_187227_b(MILK_TIME, (Object)this.milkTimer);
    }

    private void updateWoolTimer() {
        this.field_70180_af.func_187227_b(WOOL_TIME, (Object)this.woolTimer);
    }

    public int func_70627_aG() {
        return 400;
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("MilkTime", this.milkTimer);
        compound.func_74768_a("WoolTime", this.woolTimer);
        compound.func_74757_a("Sheared", this.isSheared());
        compound.func_74768_a("HornType", this.getHornType());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.milkTimer = compound.func_74762_e("MilkTime");
        this.woolTimer = compound.func_74762_e("WoolTime");
        this.setSheared(compound.func_74767_n("Sheared"));
        this.setHornType(compound.func_74762_e("HornType"));
        this.updateMilkTimer();
        this.updateWoolTimer();
    }

    protected SoundEvent func_184639_G() {
        return MistSounds.ENTITY_WULDER_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damage) {
        return MistSounds.ENTITY_WULDER_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return MistSounds.ENTITY_WULDER_DEATH;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (this.field_70756_c > 0L && !player.field_71075_bZ.field_75098_d) {
            return true;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == Items.field_151063_bx) {
            return super.func_184645_a(player, hand);
        }
        if (!this.func_70909_n() && !player.field_71075_bZ.field_75098_d) return this.tamedProcess(player, stack);
        if (player.func_70093_af()) {
            if (this.func_70631_g_()) return false;
            this.openGUI(player);
            return true;
        }
        if (this.func_70877_b(stack)) {
            if (!(this.func_110143_aJ() < this.func_110138_aP())) return super.func_184645_a(player, hand);
            this.func_175505_a(player, stack);
            this.func_70691_i(5.0f);
            return this.tamedProcess(player, stack);
        } else {
            if (stack.func_77973_b() == Items.field_151133_ar && this.milkTimer == 0 && this.isFemale() && !player.field_71075_bZ.field_75098_d && !this.func_70631_g_()) {
                player.func_184185_a(SoundEvents.field_187564_an, 1.0f, 1.0f);
                stack.func_190918_g(1);
                if (stack.func_190926_b()) {
                    player.func_184611_a(hand, new ItemStack(Items.field_151117_aB));
                } else if (!player.field_71071_by.func_70441_a(new ItemStack(Items.field_151117_aB))) {
                    player.func_71019_a(new ItemStack(Items.field_151117_aB), false);
                }
                this.milkTimer = this.isAlbino() ? 24000 : 30000;
                this.updateMilkTimer();
                return true;
            }
            if (stack.func_77973_b() == Items.field_151057_cb) {
                stack.func_111282_a(player, (EntityLivingBase)this, hand);
                return true;
            }
            if (!this.hasChest() && Block.func_149634_a((Item)stack.func_77973_b()) instanceof BlockChest) {
                this.setChested(true);
                this.playChestEquipSound();
                this.initHorseChest();
                this.horseChest.func_70299_a(1, stack.func_77979_a(1));
                if (!stack.func_190926_b()) return true;
                player.func_184611_a(hand, ItemStack.field_190927_a);
                return true;
            }
            if (this.isSaddled() && !this.func_184207_aI() && this.isRiddingItem(player.func_184614_ca()) && this.isRiddingItem(player.func_184592_cb())) {
                this.startRiding(player);
                return true;
            }
            if (stack.func_77973_b() != Items.field_151141_av || !this.func_70909_n() || this.isSaddled() || this.func_70631_g_()) return false;
            this.horseChest.func_70299_a(0, stack.func_77979_a(1));
            if (stack.func_190926_b()) {
                player.func_184611_a(hand, ItemStack.field_190927_a);
            }
            this.updateHorseSlots();
            return true;
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        boolean flag = super.func_70097_a(source, amount);
        Entity entity = source.func_76346_g();
        if (flag && entity != null && entity instanceof EntityPlayer && !((EntityPlayer)entity).field_71075_bZ.field_75098_d) {
            if (this.func_110143_aJ() <= 0.0f) {
                this.closePanic(EntityWulder.class, (EntityPlayer)entity, this.field_70146_Z.nextInt(8000) + 8000);
            } else {
                this.closePanic(EntityWulder.class, (EntityPlayer)entity, this.field_70146_Z.nextInt(250) + 250);
            }
            this.setRevengeTime(this.field_70146_Z.nextInt((int)(500.0f * amount) + 1) + (int)(250.0f * amount) + 250);
        }
        return flag;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTables.WULDER_LOOT;
    }

    @Override
    protected int getSkillPoint() {
        return 2;
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K && !this.isSheared()) {
            this.dropWool(cause, this.isAlbino() ? 0 : 12);
        }
    }

    protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, DamageSource source) {
        if (this.field_70146_Z.nextInt(4) == 0) {
            this.func_70099_a((ItemStack)TEMPTATION_STACKS.toArray()[this.field_70146_Z.nextInt(TEMPTATION_STACKS.size())], 0.0f);
        }
        super.func_184610_a(wasRecentlyHit, lootingModifier, source);
    }

    public float func_70047_e() {
        return this.func_70631_g_() ? this.field_70131_O : 1.5f;
    }

    @Override
    public boolean childCheck() {
        List list = this.field_70170_p.func_72872_a(((Object)((Object)this)).getClass(), this.func_174813_aQ().func_72314_b(8.0, 4.0, 8.0));
        for (EntityWulder entity : list) {
            if (!entity.func_70631_g_() || entity.canBeTempted() && entity.func_70909_n()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected EntityAlbino getChild() {
        return new EntityWulder(this.field_70170_p);
    }

    public boolean func_70877_b(ItemStack stack) {
        for (ItemStack st : TEMPTATION_STACKS) {
            if (stack.func_77973_b() != st.func_77973_b() || stack.func_77952_i() != st.func_77952_i()) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        if (this.getHornType() < 0) {
            this.setHornType(this.inicializeHorn());
        }
        super.func_180482_a(difficulty, livingdata);
        if (livingdata instanceof GroupData) {
            if (((GroupData)livingdata).init) {
                this.setFemale(false);
                ((GroupData)livingdata).init = false;
            } else {
                this.setFemale(true);
            }
        } else {
            livingdata = new GroupData();
        }
        return livingdata;
    }

    private int inicializeHorn() {
        int yL;
        int zL;
        int hL;
        if (this.isFemale()) {
            return -1;
        }
        int hR = hL = this.field_70146_Z.nextInt(5) / 2;
        if (this.field_70146_Z.nextInt(8) == 0) {
            hR = this.field_70146_Z.nextInt(5) / 2;
        }
        int temp = hL;
        if (hR < 2 && this.field_70146_Z.nextInt(32) == 0) {
            hL = 3;
        }
        if (temp < 2 && this.field_70146_Z.nextInt(32) == 0) {
            hR = 3;
        }
        if ((zL = this.field_70146_Z.nextInt(this.field_70146_Z.nextInt(3) + 1)) == 1) {
            zL = 2;
        } else if (zL == 2) {
            zL = 1;
        }
        int zR = zL;
        if (this.field_70146_Z.nextInt(4) == 0) {
            zR = this.field_70146_Z.nextInt(this.field_70146_Z.nextInt(3) + 1);
            if (zR == 1) {
                zR = 2;
            } else if (zR == 2) {
                zR = 1;
            }
        }
        if ((yL = this.field_70146_Z.nextInt(this.field_70146_Z.nextInt(3) + 1)) == 1) {
            yL = 0;
        } else if (yL == 0) {
            yL = 1;
        }
        int yR = yL;
        if (this.field_70146_Z.nextInt(4) == 0) {
            yR = this.field_70146_Z.nextInt(this.field_70146_Z.nextInt(3) + 1);
            if (yR == 1) {
                yR = 0;
            } else if (yR == 0) {
                yR = 1;
            }
        }
        return hL << 10 | zL << 8 | yL << 6 | hR << 4 | zR << 2 | yR;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.eatTimer = 40;
        } else {
            super.func_70103_a(id);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getYEatFactor(float partialTickTime) {
        if (this.eatTimer <= 0) {
            return 1.0f;
        }
        if (this.eatTimer >= 4 && this.eatTimer <= 36) {
            return 0.0f;
        }
        return this.eatTimer < 4 ? ((float)(4 - this.eatTimer) + partialTickTime) / 4.0f : ((float)this.eatTimer - partialTickTime - 36.0f) / 4.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getXEatFactor(float partialTickTime) {
        if (this.eatTimer > 4 && this.eatTimer <= 36) {
            float f = ((float)(this.eatTimer - 4) - partialTickTime) / 4.0f;
            return MathHelper.func_76126_a((float)((float)Math.PI * f));
        }
        return 0.0f;
    }

    public void func_70615_aA() {
        if (this.func_70631_g_()) {
            this.func_110195_a(60);
        }
        this.milkTimer = Math.max(1, this.milkTimer - 1000);
        this.woolTimer = Math.max(1, this.woolTimer - 1000);
        this.func_70691_i(5.0f);
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return this.func_70909_n() && this.woolTimer == 0 && !this.isSheared() && !this.func_70631_g_();
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        this.setSheared(true);
        this.woolTimer = this.isAlbino() ? 30000 : 36000;
        this.updateWoolTimer();
        int i = 1 + this.field_70146_Z.nextInt(fortune + 2);
        int meta = this.isAlbino() ? 0 : 12;
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (int j = 0; j < i; ++j) {
            ret.add(new ItemStack(Item.func_150898_a((Block)Blocks.field_150325_L), 1, meta));
        }
        this.func_184185_a(SoundEvents.field_187763_eJ, 1.0f, 1.0f);
        return ret;
    }

    @Override
    public int getTameLevel() {
        return 3;
    }

    @SideOnly(value=Side.CLIENT)
    public int[] getHornArray() {
        return this.hornArray;
    }

    static class GroupData
    implements IEntityLivingData {
        public boolean init = true;

        private GroupData() {
        }
    }
}

