/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.entity;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.api.entity.IMatWalkable;
import ru.liahim.mist.api.loottable.LootTables;
import ru.liahim.mist.api.sound.MistSounds;
import ru.liahim.mist.entity.EntityMobMist;
import ru.liahim.mist.entity.ai.EntityAIEatFloatingMat;
import ru.liahim.mist.entity.ai.EntityAIEatMistGrass;

public class EntitySwampCrab
extends EntityMobMist
implements IMatWalkable {
    private static final DataParameter<Byte> COLOR_TYPE = EntityDataManager.func_187226_a(EntitySwampCrab.class, (DataSerializer)DataSerializers.field_187191_a);
    private EntityAIEatMistGrass aiEatGrass;
    private EntityAIEatFloatingMat aiEatMat;
    private int eatTimer;

    public EntitySwampCrab(World world) {
        super(world);
        this.func_70105_a(0.75f, 0.25f);
    }

    protected void func_184651_r() {
        this.aiEatGrass = new EntityAIEatMistGrass((EntityLiving)this, false, false);
        this.aiEatMat = new EntityAIEatFloatingMat((EntityLiving)this, false);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AISpiderAttack(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.aiEatGrass);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.aiEatMat);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    public float func_70047_e() {
        return 0.25f;
    }

    public boolean func_70648_aU() {
        return true;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(COLOR_TYPE, (Object)0);
    }

    public void setColorType(int color) {
        this.field_70180_af.func_187227_b(COLOR_TYPE, (Object)((byte)color));
    }

    public byte getColorType() {
        return (Byte)this.field_70180_af.func_187225_a(COLOR_TYPE);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74774_a("ColorType", this.getColorType());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setColorType(compound.func_74771_c("ColorType"));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(12.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    protected SoundEvent func_184639_G() {
        return MistSounds.ENTITY_SWAMP_CRAB_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return MistSounds.ENTITY_SWAMP_CRAB_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return MistSounds.ENTITY_SWAMP_CRAB_DEATH;
    }

    protected void func_180429_a(BlockPos pos, Block block) {
        this.func_184185_a(MistSounds.ENTITY_SWAMP_CRAB_STEP, 0.3f, 1.0f);
    }

    protected float func_70647_i() {
        return (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f + 1.0f;
    }

    protected float func_70599_aP() {
        return 0.7f;
    }

    public int func_70627_aG() {
        return 160;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTables.SWAMP_CRAB_LOOT;
    }

    protected void func_70619_bc() {
        this.eatTimer = this.aiEatGrass.func_151499_f();
        if (this.eatTimer == 0) {
            this.eatTimer = this.aiEatMat.func_151499_f();
        }
        super.func_70619_bc();
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.eatTimer > 0) {
            if (!this.field_70170_p.field_72995_K && this.eatTimer % 10 == 0) {
                this.func_184185_a(MistSounds.ENTITY_SWAMP_CRAB_STEP, 0.2f, 1.0f);
            }
            --this.eatTimer;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.eatTimer = 40;
        } else {
            super.func_70103_a(id);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getEatFactor(float partialTickTime) {
        if (this.eatTimer > 4 && this.eatTimer <= 36) {
            float f = ((float)(this.eatTimer - 4) - partialTickTime) / 1.7f;
            return MathHelper.func_76126_a((float)((float)Math.PI * f));
        }
        return 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getEyeFactor(float partialTickTime) {
        if (this.eatTimer <= 0) {
            return 1.0f;
        }
        if (this.eatTimer >= 4 && this.eatTimer <= 36) {
            return 0.0f;
        }
        return this.eatTimer < 4 ? ((float)(4 - this.eatTimer) + partialTickTime) / 4.0f : ((float)this.eatTimer - partialTickTime - 36.0f) / 4.0f;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    public boolean func_70687_e(PotionEffect potioneffect) {
        return potioneffect.func_188419_a() == MobEffects.field_76436_u ? false : super.func_70687_e(potioneffect);
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        Potion potion;
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.setColorType(this.field_70146_Z.nextInt(5));
        if (livingdata == null) {
            livingdata = new GroupData();
            if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD && this.field_70170_p.field_73012_v.nextFloat() < 0.1f * difficulty.func_180170_c()) {
                ((GroupData)livingdata).setRandomEffect(this.field_70170_p.field_73012_v);
            }
        }
        if (livingdata instanceof GroupData && (potion = ((GroupData)livingdata).effect) != null) {
            this.func_70690_d(new PotionEffect(potion, Integer.MAX_VALUE));
        }
        return livingdata;
    }

    public static class GroupData
    implements IEntityLivingData {
        public Potion effect;

        public void setRandomEffect(Random rand) {
            int i = rand.nextInt(4);
            if (i <= 1) {
                this.effect = MobEffects.field_76424_c;
            } else if (i <= 2) {
                this.effect = MobEffects.field_76420_g;
            } else if (i <= 3) {
                this.effect = MobEffects.field_76428_l;
            }
        }
    }

    static class AISpiderAttack
    extends EntityAIAttackMelee {
        public AISpiderAttack(EntitySwampCrab spider) {
            super((EntityCreature)spider, 1.3, true);
        }

        public boolean func_75253_b() {
            if (this.field_75441_b.func_70681_au().nextInt(100) == 0) {
                this.field_75441_b.func_70624_b((EntityLivingBase)null);
                return false;
            }
            return super.func_75253_b();
        }

        protected double func_179512_a(EntityLivingBase attackTarget) {
            return 2.0f + attackTarget.field_70130_N;
        }
    }
}

